/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client;

import java.util.HashMap;
import java.util.Map;

public class ItemConfigHelper {
    private final String SWILDCARD = "*";
    private final int WILDCARD = -1;
    private Map<ItemData, Integer> dataMap = new HashMap<ItemData, Integer>();

    public ItemConfigHelper(String configLine, int defaultValue) {
        for (String s : configLine.split(",")) {
            try {
                String[] duo = s.split("=");
                ItemData item = this.fromString(duo[0]);
                if (item.startID != 0) {
                    this.dataMap.put(item, duo.length > 1 ? Integer.parseInt(duo[1]) : defaultValue);
                    continue;
                }
                System.out.println("Failed to match String [" + s + "] to a Block or Item, skipping.");
            }
            catch (Exception e) {
                System.err.println("Error, String [" + s + "] is not a valid Entry, skipping.");
                e.printStackTrace();
            }
        }
    }

    public int retrieveValue(int id, int meta) {
        for (ItemData item : this.dataMap.keySet()) {
            if (!item.matches(id, meta)) continue;
            return this.dataMap.get(item);
        }
        return -1;
    }

    private ItemData fromString(String s) {
        int sm;
        int eid;
        String[] strings = s.split("-");
        int len = strings.length;
        int sid = this.tryFindingItemID(strings[0]);
        int n = eid = len > 3 ? this.tryFindingItemID(strings[1]) : sid;
        int n2 = len > 1 ? this.catchWildcard(strings[len > 3 ? 2 : 1]) : (sm = -1);
        int em = len > 2 ? this.catchWildcard(strings[len > 3 ? 3 : 2]) : sm;
        return new ItemData(sid, eid, sm, em);
    }

    private int tryFindingItemID(String s) {
        try {
            return this.catchWildcard(s);
        }
        catch (NumberFormatException e) {
            for (yc yc2 : yc.g) {
                if (yc2 == null || !yc2.a().equals(s)) continue;
                return yc2.cv;
            }
            for (yc yc3 : aqz.s) {
                if (yc3 == null || !yc3.a().equals(s)) continue;
                return yc3.cF;
            }
            return 0;
        }
    }

    private int catchWildcard(String s) {
        if (s.equals("*")) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    private class ItemData
    implements Comparable<ItemData> {
        final int startID;
        final int endID;
        final int startMeta;
        final int endMeta;

        public ItemData(int sid, int eid, int sm, int em) {
            this.startID = sid;
            this.endID = eid;
            this.startMeta = sm;
            this.endMeta = em;
        }

        public String toString() {
            return String.format("%d-%d-%d-%d", this.startID, this.endID, this.startMeta, this.endMeta);
        }

        public boolean matches(int id, int meta) {
            return this.isContained(this.startID, this.endID, id) && this.isContained(this.startMeta, this.endMeta, meta);
        }

        private boolean isContained(int s, int e, int i) {
            return !(s != -1 && i < s || e != -1 && i > e);
        }

        @Override
        public int compareTo(ItemData i) {
            return this.startID < i.startID ? -1 : (this.startID > i.startID ? 1 : 0);
        }

        public boolean equals(Object o) {
            if (o instanceof ItemData) {
                ItemData i = (ItemData)o;
                return i.startID == this.startID && i.endID == this.endID && i.startMeta == this.startMeta && i.endMeta == this.endMeta;
            }
            return false;
        }

        public int hashCode() {
            return this.startID + this.endID + this.startMeta + this.endMeta;
        }
    }
}

