/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.util;

import acs.tabbychat.core.ChatChannel;
import acs.tabbychat.core.GuiChatTC;
import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.TCChatLine;
import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ITCSettingsGUI;
import acs.tabbychat.settings.ChannelDelimEnum;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.NotificationSoundEnum;
import acs.tabbychat.settings.TimeStampEnum;
import acs.tabbychat.threads.BackgroundChatThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;

public class TabbyChatUtils {
    private static Calendar logDay = Calendar.getInstance();
    private static File logDir = new File(atv.w().x, "TabbyChatLogs");
    private static File logFile;
    private static SimpleDateFormat logNameFormat;
    public static String version;

    public static void chatGuiTick(atv mc) {
        if (mc.n == null) {
            return;
        }
        if (!(mc.n instanceof auw)) {
            return;
        }
        if (mc.n.getClass() == GuiChatTC.class) {
            return;
        }
        String inputBuffer = "";
        try {
            int ind = 0;
            for (Field fields : auw.class.getDeclaredFields()) {
                if (fields.getType() != String.class) continue;
                if (ind == 1) {
                    fields.setAccessible(true);
                    inputBuffer = (String)fields.get(mc.n);
                    break;
                }
                ++ind;
            }
        }
        catch (Exception e) {
            TabbyChat.printException("Unable to display chat interface", e);
        }
        mc.a((awe)new GuiChatTC(inputBuffer));
    }

    public static String chatLinesToString(List<TCChatLine> lines) {
        StringBuilder result = new StringBuilder(500);
        for (TCChatLine line : lines) {
            result.append(line.a()).append("\n");
        }
        return result.toString().trim();
    }

    public static bdm getServerData() {
        atv mc = atv.w();
        bdm serverData = null;
        for (Field field : atv.class.getDeclaredFields()) {
            if (field.getType() != bdm.class) continue;
            field.setAccessible(true);
            try {
                serverData = (bdm)field.get(mc);
            }
            catch (Exception e) {
                TabbyChat.printException("Unable to find server information", e);
            }
            break;
        }
        return serverData;
    }

    public static File getServerDir() {
        String ip = TabbyChatUtils.getServerIp();
        if (ip.contains(":")) {
            ip = ip.replaceAll(":", "(") + ")";
        }
        return new File(ITCSettingsGUI.tabbyChatDir, ip);
    }

    public static String getServerIp() {
        String ip = atv.w().B() ? "singleplayer" : (TabbyChatUtils.getServerData() == null ? "unknown" : TabbyChatUtils.getServerData().b);
        return ip;
    }

    public static File getTabbyChatDir() {
        return new File(atv.w().x, "config" + File.separatorChar + "tabbychat");
    }

    public static void hookIntoChat(GuiNewChatTC _gnc) {
        if (((Object)((Object)atv.w().r.b())).getClass() != GuiNewChatTC.class) {
            try {
                Class<avj> IngameGui = avj.class;
                Field persistantGuiField = IngameGui.getDeclaredFields()[6];
                persistantGuiField.setAccessible(true);
                persistantGuiField.set(atv.w().r, (Object)_gnc);
                int tmp = 0;
                for (Field fields : auu.class.getDeclaredFields()) {
                    if (fields.getType() != List.class) continue;
                    fields.setAccessible(true);
                    if (tmp == 0) {
                        _gnc.b = (List)fields.get((Object)_gnc);
                    } else if (tmp == 1) {
                        _gnc.backupLines = (List)fields.get((Object)_gnc);
                    } else if (tmp == 2) {
                        _gnc.c = (List)fields.get((Object)_gnc);
                        break;
                    }
                    ++tmp;
                }
            }
            catch (Exception e) {
                TabbyChat.printException("Error loading chat hook.", e);
            }
        }
    }

    public static boolean is(avk _gui, String className) {
        try {
            return _gui.getClass().getSimpleName().contains(className);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String join(String[] arr, String glue) {
        if (arr.length < 1) {
            return "";
        }
        if (arr.length == 1) {
            return arr[0];
        }
        StringBuilder bucket = new StringBuilder();
        for (String s : Arrays.copyOf(arr, arr.length - 1)) {
            bucket.append(s);
            bucket.append(glue);
        }
        bucket.append(arr[arr.length - 1]);
        return bucket.toString();
    }

    public static void logChat(String theChat) {
        Calendar tmpcal = Calendar.getInstance();
        if (logFile == null || tmpcal.get(6) != logDay.get(6)) {
            logDay = tmpcal;
            logFile = new File(logDir, logNameFormat.format(logDay.getTime()).toString());
        }
        if (!logFile.exists()) {
            try {
                logDir.mkdirs();
                logFile.createNewFile();
            }
            catch (Exception e) {
                TabbyChat.printErr("Cannot create log file : '" + e.getLocalizedMessage() + "' : " + e.toString());
                return;
            }
        }
        try {
            FileOutputStream logStream = new FileOutputStream(logFile, true);
            PrintStream logPrint = new PrintStream(logStream);
            logPrint.println(theChat);
            logPrint.close();
        }
        catch (Exception e) {
            TabbyChat.printErr("Cannot write to log file : '" + e.getLocalizedMessage() + "' : " + e.toString());
            return;
        }
    }

    public static Float median(float val1, float val2, float val3) {
        if (val1 < val2 && val1 < val3) {
            return Float.valueOf(Math.min(val2, val3));
        }
        if (val1 > val2 && val1 > val3) {
            return Float.valueOf(Math.max(val2, val3));
        }
        return Float.valueOf(val1);
    }

    public static ColorCodeEnum parseColor(Object _input) {
        if (_input == null) {
            return null;
        }
        String input = _input.toString();
        try {
            return ColorCodeEnum.valueOf(input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static ChannelDelimEnum parseDelimiters(Object _input) {
        if (_input == null) {
            return null;
        }
        String input = _input.toString();
        try {
            return ChannelDelimEnum.valueOf(input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Float parseFloat(Object _input, float min, float max) {
        Float result;
        if (_input == null) {
            return (Float)_input;
        }
        String input = _input.toString();
        try {
            result = Float.valueOf(input);
            result = Float.valueOf(Math.max(min, result.floatValue()));
            result = Float.valueOf(Math.min(max, result.floatValue()));
        }
        catch (NumberFormatException e) {
            result = null;
        }
        return result;
    }

    public static FormatCodeEnum parseFormat(Object _input) {
        if (_input == null) {
            return null;
        }
        String input = _input.toString();
        try {
            return FormatCodeEnum.valueOf(input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Integer parseInteger(String _input, int min, int max, int fallback) {
        Integer result;
        try {
            result = Integer.parseInt(_input);
            result = Math.max(min, result);
            result = Math.min(max, result);
        }
        catch (NumberFormatException e) {
            result = fallback;
        }
        return result;
    }

    public static int parseInteger(String _input) {
        NumberFormat formatter = NumberFormat.getInstance();
        boolean state = formatter.isParseIntegerOnly();
        formatter.setParseIntegerOnly(true);
        ParsePosition pos = new ParsePosition(0);
        int result = formatter.parse(_input, pos).intValue();
        formatter.setParseIntegerOnly(state);
        if (_input.length() == pos.getIndex()) {
            return result;
        }
        return -1;
    }

    public static NotificationSoundEnum parseSound(Object _input) {
        if (_input == null) {
            return NotificationSoundEnum.ORB;
        }
        String input = _input.toString();
        try {
            return NotificationSoundEnum.valueOf(input);
        }
        catch (IllegalArgumentException e) {
            return NotificationSoundEnum.ORB;
        }
    }

    public static String parseString(Object _input) {
        if (_input == null) {
            return " ";
        }
        return _input.toString();
    }

    public static TimeStampEnum parseTimestamp(Object _input) {
        if (_input == null) {
            return null;
        }
        String input = _input.toString();
        try {
            return TimeStampEnum.valueOf(input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static List<TCChatLine> stringToChatLines(int stamp, String line, int id, boolean status) {
        List<String> lineSplit = Arrays.asList(line.split("\n"));
        ArrayList<TCChatLine> result = new ArrayList<TCChatLine>(lineSplit.size());
        boolean first = true;
        for (String split : lineSplit) {
            if (first) {
                result.add(new TCChatLine(stamp, split, id, status));
                first = false;
                continue;
            }
            result.add(new TCChatLine(stamp, " " + split, id, status));
        }
        return result;
    }

    public static LinkedHashMap<String, ChatChannel> swapChannels(LinkedHashMap<String, ChatChannel> currentMap, int _left, int _right) {
        if (_left == _right) {
            return currentMap;
        }
        if (_left > _right) {
            int _tmp = _left;
            _left = _right;
            _right = _tmp;
        }
        if (_right >= currentMap.size()) {
            return currentMap;
        }
        String[] arrayCopy = new String[currentMap.size()];
        arrayCopy = currentMap.keySet().toArray(arrayCopy);
        String tmp = arrayCopy[_left];
        arrayCopy[_left] = arrayCopy[_right];
        arrayCopy[_right] = tmp;
        int n = arrayCopy.length;
        LinkedHashMap<String, ChatChannel> returnMap = new LinkedHashMap<String, ChatChannel>(n);
        for (int i = 0; i < n; ++i) {
            returnMap.put(arrayCopy[i], currentMap.get(arrayCopy[i]));
        }
        return returnMap;
    }

    public static void writeLargeChat(String toSend) {
        BackgroundChatThread sendProc;
        List<String> actives = TabbyChat.getInstance().getActive();
        if (!TabbyChat.getInstance().enabled() || actives.size() != 1) {
            sendProc = new BackgroundChatThread(toSend);
        } else {
            ChatChannel active = TabbyChat.getInstance().channelMap.get(actives.get(0));
            String tabPrefix = active.cmdPrefix;
            boolean hiddenPrefix = active.hidePrefix;
            sendProc = tabPrefix != null && tabPrefix.length() > 0 ? (!hiddenPrefix ? new BackgroundChatThread(toSend, tabPrefix) : (!toSend.startsWith("/") ? new BackgroundChatThread(tabPrefix + " " + toSend, tabPrefix) : new BackgroundChatThread(toSend))) : new BackgroundChatThread(toSend);
        }
        sendProc.start();
    }

    private TabbyChatUtils() {
    }

    static {
        logNameFormat = new SimpleDateFormat("'TabbyChatLog_'MM-dd-yyyy'.txt'");
        version = "1.9.02";
    }
}

