/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.settings.TimeStampEnum;
import java.awt.Point;
import org.lwjgl.input.Mouse;

public class ChatScrollBar {
    private static atv mc;
    private static GuiNewChatTC gnc;
    private static float mouseLoc;
    private static int scrollBarCenter;
    private static int barBottomY;
    private static int barTopY;
    private static int barX;
    private static int barMinY;
    private static int barMaxY;
    private static int lastY;
    protected static int barHeight;
    protected static int barWidth;
    private static boolean scrolling;

    public ChatScrollBar() {
        mc = atv.w();
        if (TabbyChat.generalSettings.timeStampEnable.getValue().booleanValue()) {
            String maxTime = ((TimeStampEnum)TabbyChat.generalSettings.timeStampStyle.getValue()).maxTime;
            boolean oldVal = ChatScrollBar.mc.l.a();
            if (TabbyChat.advancedSettings.forceUnicode.getValue().booleanValue()) {
                ChatScrollBar.mc.l.a(true);
            }
            ChatScrollBar.mc.l.a(oldVal);
        }
    }

    public static void handleMouse() {
        Point cursor = ChatBox.scaleMouseCoords(Mouse.getEventX(), Mouse.getEventY());
        if (Mouse.getEventButton() == 0 && Mouse.isButtonDown((int)0)) {
            int offsetX = barX + ChatBox.current.x;
            int offsetY = ChatBox.current.y;
            scrolling = cursor.x - offsetX > 0 && cursor.x - offsetX <= barWidth && cursor.y <= barMaxY + offsetY && cursor.y >= barMinY + offsetY;
        } else if (!Mouse.isButtonDown((int)0)) {
            scrolling = false;
        }
        if (Math.abs(cursor.y - lastY) > 1 && scrolling) {
            ChatScrollBar.scrollBarMouseDrag(cursor.y);
        }
    }

    private static void update() {
        int maxlines = gnc.getHeightSetting() / 9;
        int clines = Math.min(gnc.GetChatSize(), maxlines);
        barHeight = ls.d((float)(5.0f * gnc.getScaleSetting()));
        barWidth = ls.d((float)(5.0f * gnc.getScaleSetting()));
        barX = ChatBox.current.width - barWidth - 2;
        barBottomY = 0;
        if (ChatBox.anchoredTop) {
            barBottomY = ChatBox.current.height - ChatBox.tabTrayHeight;
            barTopY = 0;
        } else {
            barBottomY = 0;
            barTopY = -ChatBox.current.height + ChatBox.tabTrayHeight;
        }
        barMaxY = barBottomY - barHeight / 2 - 1;
        barMinY = barTopY + barHeight / 2 + 1;
        scrollBarCenter = !ChatBox.anchoredTop ? Math.round(mouseLoc * (float)barMinY + (1.0f - mouseLoc) * (float)barMaxY) : Math.round(mouseLoc * (float)barMaxY + (1.0f - mouseLoc) * (float)barMinY);
    }

    public static void drawScrollBar() {
        ChatScrollBar.update();
        int minX = barX + 1;
        int maxlines = gnc.getHeightSetting() / 9;
        float chatOpacity = TabbyChat.mc.u.r * 0.9f + 0.1f;
        int currentOpacity = (int)(180.0f * chatOpacity);
        GuiNewChatTC.a((int)barX, (int)barTopY, (int)(barX + barWidth + 2), (int)barBottomY, (int)(currentOpacity << 24));
        if (gnc.GetChatSize() > maxlines) {
            GuiNewChatTC.a((int)minX, (int)(scrollBarCenter - barHeight / 2), (int)(minX + barWidth), (int)(scrollBarCenter + barHeight / 2), (int)(0xFFFFFF + (currentOpacity / 2 << 24)));
            GuiNewChatTC.a((int)(minX + 1), (int)(scrollBarCenter - barHeight / 2 - 1), (int)(minX + barWidth - 1), (int)(scrollBarCenter + barHeight / 2 + 1), (int)(0xFFFFFF + (currentOpacity / 2 << 24)));
        }
    }

    public static void scrollBarMouseWheel() {
        ChatScrollBar.update();
        int maxlines = gnc.getHeightSetting() / 9;
        int blines = gnc.GetChatSize();
        mouseLoc = blines > maxlines ? (float)gnc.chatLinesTraveled() / (float)(blines - maxlines) : 0.0f;
        scrollBarCenter = !ChatBox.anchoredTop ? Math.round(mouseLoc * (float)barMinY + (1.0f - mouseLoc) * (float)barMaxY) : Math.round(mouseLoc * (float)barMaxY + (1.0f - mouseLoc) * (float)barMinY);
    }

    public static void scrollBarMouseDrag(int _absY) {
        float moveInc;
        int maxlines = gnc.getHeightSetting() / 9;
        int blines = gnc.GetChatSize();
        if (blines <= maxlines) {
            mouseLoc = 0.0f;
            return;
        }
        int adjBarMin = barMinY + ChatBox.current.y;
        int adjBarMax = barMaxY + ChatBox.current.y;
        mouseLoc = _absY < adjBarMin ? (ChatBox.anchoredTop ? 0.0f : 1.0f) : (_absY > adjBarMax ? (ChatBox.anchoredTop ? 1.0f : 0.0f) : (!ChatBox.anchoredTop ? Math.abs((float)(adjBarMax - _absY)) / (float)(adjBarMax - adjBarMin) : Math.abs((float)(adjBarMin - _absY)) / (float)(adjBarMax - adjBarMin)));
        int moveLines = (int)(mouseLoc / (moveInc = 1.0f / (float)(blines - maxlines)));
        if (moveLines > blines - maxlines) {
            moveLines = blines - maxlines;
        }
        gnc.setVisChatLines(moveLines);
        mouseLoc = moveInc * (float)moveLines;
        scrollBarCenter = !ChatBox.anchoredTop ? Math.round(mouseLoc * (float)(barMinY - barMaxY) + (float)barMaxY) : Math.round(mouseLoc * (float)(barMaxY - barMinY) + (float)barMinY);
        lastY = _absY;
    }

    public static void setOffset(int _x, int _y) {
        int maxlines = gnc.getHeightSetting() / 9;
        int clines = gnc.GetChatSize() < maxlines ? gnc.GetChatSize() : maxlines;
        barX = 324 + _x;
        barMinY = ChatScrollBar.mc.n.h - ((clines - 1) * 9 + 8) - 35 + _y;
        barTopY = barMinY + barHeight / 2 + _y;
        barMaxY = ChatScrollBar.mc.n.h - 45 + _y;
        barBottomY = barMaxY - barHeight / 2 + _y;
    }

    static {
        gnc = GuiNewChatTC.getInstance();
        mouseLoc = 0.0f;
        scrollBarCenter = 0;
        barBottomY = 0;
        barTopY = 0;
        barX = 326;
        barMinY = 0;
        barMaxY = 0;
        lastY = 0;
        barHeight = 5;
        barWidth = 5;
        scrolling = false;
    }
}

