/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.settings;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.NotificationSoundEnum;
import acs.tabbychat.util.TabbyChatUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class TCChatFilter {
    public boolean inverseMatch = false;
    public boolean caseSensitive = false;
    public boolean highlightBool = false;
    public boolean audioNotificationBool = false;
    public boolean sendToTabBool = false;
    public boolean sendToAllTabs = false;
    public boolean removeMatches = false;
    public ColorCodeEnum highlightColor = ColorCodeEnum.YELLOW;
    public FormatCodeEnum highlightFormat = FormatCodeEnum.BOLD;
    public NotificationSoundEnum audioNotificationSound = NotificationSoundEnum.ORB;
    public String sendToTabName = "";
    public String expressionString = ".*";
    public Pattern expressionPattern = Pattern.compile(this.expressionString);
    private static final Pattern allFormatCodes = Pattern.compile("(?i)(\\u00A7[0-9A-FK-OR])+");
    public String filterName;
    private String lastMatch = "";
    private String tabName = null;

    public TCChatFilter(String name) {
        this.filterName = name;
    }

    public TCChatFilter(TCChatFilter orig) {
        this(orig.filterName);
        this.copyFrom(orig);
    }

    public boolean applyFilterToDirtyChat(String input) {
        TreeMap<Integer, String> oldCodes = new TreeMap<Integer, String>();
        HashMap<Integer, String> newCodes = new HashMap<Integer, String>();
        StringBuilder result = new StringBuilder().append(input);
        Matcher findFormatCodes = allFormatCodes.matcher(input);
        int start = 0;
        int trimmed = 0;
        while (findFormatCodes.find()) {
            start = findFormatCodes.start();
            int end = findFormatCodes.end();
            oldCodes.put(start - trimmed, findFormatCodes.group());
            result.delete(start - trimmed, end - trimmed);
            trimmed += end - start;
        }
        String prefix = "";
        String suffix = "";
        if (this.highlightBool) {
            suffix = "\u00a7r";
            prefix = this.highlightColor.toCode() + this.highlightFormat.toCode();
        }
        Matcher findFilterMatches = this.expressionPattern.matcher(result.toString());
        boolean foundMatch = false;
        block1: while (findFilterMatches.find()) {
            foundMatch = true;
            if (!this.highlightBool) break;
            start = findFilterMatches.start();
            newCodes.put(start, prefix);
            int end = findFilterMatches.end();
            Map.Entry newSuffix = oldCodes.lowerEntry(end);
            if (newSuffix == null) {
                newCodes.put(end, suffix);
                continue;
            }
            newCodes.put(end, (String)newSuffix.getValue());
            while (newSuffix.getKey() >= start) {
                oldCodes.put(newSuffix.getKey(), "");
                if ((newSuffix = oldCodes.lowerEntry(newSuffix.getKey())) != null) continue;
                continue block1;
            }
        }
        if (this.sendToTabBool && !this.sendToAllTabs) {
            if (this.inverseMatch) {
                this.tabName = this.sendToTabName;
            } else if (this.sendToTabName.startsWith("%")) {
                int group = TabbyChatUtils.parseInteger(this.sendToTabName.substring(1));
                if (foundMatch && group >= 0 && findFilterMatches.groupCount() >= group) {
                    this.tabName = findFilterMatches.group(group);
                    if (this.tabName == null) {
                        this.tabName = this.filterName;
                    }
                } else {
                    this.tabName = this.filterName;
                }
            } else {
                this.tabName = this.sendToTabName;
            }
        } else {
            this.tabName = null;
        }
        if (this.highlightBool) {
            oldCodes.putAll(newCodes);
            Map.Entry ptr = oldCodes.pollLastEntry();
            while (ptr != null) {
                result.insert((int)((Integer)ptr.getKey()), (String)ptr.getValue());
                ptr = oldCodes.pollLastEntry();
            }
            this.lastMatch = result.toString();
        } else {
            this.lastMatch = input;
        }
        if (!foundMatch && this.inverseMatch) {
            return true;
        }
        return foundMatch && !this.inverseMatch;
    }

    public void audioNotification() {
        atv.w().v.a(this.audioNotificationSound.file(), 1.0f, 1.0f);
    }

    public void compilePattern() {
        try {
            this.expressionPattern = this.caseSensitive ? Pattern.compile(this.expressionString) : Pattern.compile(this.expressionString, 2);
        }
        catch (PatternSyntaxException e) {
            TabbyChat.printMessageToChat("Invalid expression entered for filter '" + this.filterName + "', resetting to default.");
            this.expressionString = ".*";
            this.expressionPattern = Pattern.compile(this.expressionString);
        }
    }

    public void compilePattern(String newExpression) {
        this.expressionString = newExpression;
        this.compilePattern();
    }

    public void copyFrom(TCChatFilter orig) {
        this.filterName = orig.filterName;
        this.inverseMatch = orig.inverseMatch;
        this.caseSensitive = orig.caseSensitive;
        this.highlightBool = orig.highlightBool;
        this.audioNotificationBool = orig.audioNotificationBool;
        this.sendToTabBool = orig.sendToTabBool;
        this.sendToAllTabs = orig.sendToAllTabs;
        this.removeMatches = orig.removeMatches;
        this.highlightColor = orig.highlightColor;
        this.highlightFormat = orig.highlightFormat;
        this.audioNotificationSound = orig.audioNotificationSound;
        this.sendToTabName = orig.sendToTabName;
        this.expressionString = orig.expressionString;
        this.compilePattern();
    }

    public String getLastMatchPretty() {
        String tmp = this.lastMatch;
        this.lastMatch = "";
        return tmp;
    }

    public Properties getProperties() {
        Properties myProps = new Properties();
        myProps.put("filterName", this.filterName);
        myProps.put("inverseMatch", (Object)this.inverseMatch);
        myProps.put("caseSensitive", (Object)this.caseSensitive);
        myProps.put("highlightBool", (Object)this.highlightBool);
        myProps.put("audioNotificationBool", (Object)this.audioNotificationBool);
        myProps.put("sendToTabBool", (Object)this.sendToTabBool);
        myProps.put("sendToAllTabs", (Object)this.sendToAllTabs);
        myProps.put("removeMatches", (Object)this.removeMatches);
        myProps.put("highlightColor", this.highlightColor.name());
        myProps.put("highlightFormat", this.highlightFormat.name());
        myProps.put("audioNotificationSound", this.audioNotificationSound.name());
        myProps.put("sendToTabName", this.sendToTabName);
        myProps.put("expressionString", this.expressionString);
        return myProps;
    }

    public String getTabName() {
        String tmp = this.tabName;
        this.tabName = null;
        return tmp;
    }
}

