/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.TCSettingsGUI;
import acs.tabbychat.settings.ChannelDelimEnum;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.TCSettingBool;
import acs.tabbychat.settings.TCSettingEnum;
import acs.tabbychat.settings.TCSettingTextBox;
import acs.tabbychat.util.TabbyChatUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class TCSettingsServer
extends TCSettingsGUI {
    private static final int AUTO_CHANNEL_SEARCH_ID = 9201;
    private static final int CHATCHANNEL_DELIMS_ID = 9202;
    private static final int DELIM_COLOR_BOOL_ID = 9203;
    private static final int DELIM_COLOR_ENUM_ID = 9204;
    private static final int DELIM_FORMAT_BOOL_ID = 9205;
    private static final int DELIM_FORMAT_ENUM_ID = 9206;
    private static final int DEFAULT_CHANNELS_ID = 9207;
    private static final int IGNORED_CHANNELS_ID = 9208;
    private static final int AUTO_PM_SEARCH_ID = 9209;
    public TCSettingBool autoChannelSearch;
    public TCSettingBool autoPMSearch;
    public TCSettingEnum delimiterChars;
    public TCSettingBool delimColorBool;
    public TCSettingEnum delimColorCode;
    public TCSettingBool delimFormatBool;
    public TCSettingEnum delimFormatCode;
    public TCSettingTextBox defaultChannels;
    public TCSettingTextBox ignoredChannels;
    public List<String> defaultChanList;
    public List<String> ignoredChanList;
    public String serverIP;

    public TCSettingsServer(TabbyChat _tc) {
        super(_tc);
        this.propertyPrefix = "settings.server";
        this.autoChannelSearch = new TCSettingBool(true, "autoChannelSearch", this.propertyPrefix, 9201);
        this.autoPMSearch = new TCSettingBool(true, "autoPMSearch", this.propertyPrefix, 9209);
        this.delimiterChars = new TCSettingEnum((Object)ChannelDelimEnum.BRACKETS, "delimiterChars", this.propertyPrefix, 9202);
        this.delimColorBool = new TCSettingBool(false, "delimColorBool", this.propertyPrefix, 9203, FormatCodeEnum.ITALIC);
        this.delimColorCode = new TCSettingEnum((Object)ColorCodeEnum.DEFAULT, "delimColorCode", "", 9204);
        this.delimFormatBool = new TCSettingBool(false, "delimFormatBool", this.propertyPrefix, 9205, FormatCodeEnum.ITALIC);
        this.delimFormatCode = new TCSettingEnum((Object)FormatCodeEnum.DEFAULT, "delimFormatCode", "", 9206);
        this.defaultChannels = new TCSettingTextBox("", "defaultChannels", this.propertyPrefix, 9207);
        this.ignoredChannels = new TCSettingTextBox("", "ignoredChannels", this.propertyPrefix, 9208);
        this.defaultChanList = new ArrayList<String>();
        this.ignoredChanList = new ArrayList<String>();
        this.serverIP = "";
        this.name = TabbyChat.translator.getString("settings.server.name");
        this.settingsFile = new File(TabbyChatUtils.getServerDir(), "settings.cfg");
        this.bgcolor = 1725355587;
        this.defaultChannels.setCharLimit(300);
        this.ignoredChannels.setCharLimit(300);
        this.defineDrawableSettings();
    }

    @Override
    public void defineDrawableSettings() {
        this.i.add(this.autoChannelSearch);
        this.i.add(this.autoPMSearch);
        this.i.add(this.delimiterChars);
        this.i.add(this.delimColorBool);
        this.i.add(this.delimColorCode);
        this.i.add(this.delimFormatBool);
        this.i.add(this.delimFormatCode);
        this.i.add(this.defaultChannels);
        this.i.add(this.ignoredChannels);
    }

    @Override
    public void initDrawableSettings() {
        int effRight = (this.g + 300) / 2;
        int col1x = (this.g - 300) / 2 + 55;
        int buttonColor = (this.bgcolor & 0xFFFFFF) + -16777216;
        this.autoChannelSearch.setButtonLoc(col1x, this.rowY(1));
        this.autoChannelSearch.setLabelLoc(col1x + 19);
        this.autoChannelSearch.buttonColor = buttonColor;
        this.autoPMSearch.setButtonLoc(col1x, this.rowY(2));
        this.autoPMSearch.setLabelLoc(col1x + 19);
        this.autoPMSearch.buttonColor = buttonColor;
        this.delimiterChars.setLabelLoc(col1x);
        this.delimiterChars.setButtonLoc(col1x + 20 + TCSettingsServer.f.l.a(this.delimiterChars.description), this.rowY(3));
        this.delimiterChars.setButtonDims(80, 11);
        this.delimColorBool.setButtonLoc(col1x + 20, this.rowY(4));
        this.delimColorBool.setLabelLoc(col1x + 49);
        this.delimColorBool.buttonColor = buttonColor;
        this.delimColorCode.setButtonLoc(effRight - 70, this.rowY(4));
        this.delimColorCode.setButtonDims(70, 11);
        this.delimFormatBool.setButtonLoc(col1x + 20, this.rowY(5));
        this.delimFormatBool.setLabelLoc(col1x + 39);
        this.delimFormatBool.buttonColor = buttonColor;
        this.delimFormatCode.setButtonLoc(this.delimColorCode.d, this.rowY(5));
        this.delimFormatCode.setButtonDims(70, 11);
        this.defaultChannels.setLabelLoc(col1x);
        this.defaultChannels.setButtonLoc(col1x + 5 + TCSettingsServer.f.l.a(this.defaultChannels.description), this.rowY(6));
        this.defaultChannels.setButtonDims(effRight - this.defaultChannels.d, 11);
        this.ignoredChannels.setLabelLoc(col1x);
        this.ignoredChannels.setButtonLoc(col1x + 5 + TCSettingsServer.f.l.a(this.ignoredChannels.description), this.rowY(7));
        this.ignoredChannels.setButtonDims(effRight - this.ignoredChannels.d, 11);
    }

    @Override
    public Properties loadSettingsFile() {
        if (this.settingsFile != null) {
            super.loadSettingsFile();
            this.defaultChanList = Arrays.asList(Pattern.compile("[ ]?,[ ]?").split(this.defaultChannels.getValue()));
            this.ignoredChanList = Arrays.asList(Pattern.compile("[ ]?,[ ]?").split(this.ignoredChannels.getValue()));
        }
        return null;
    }

    @Override
    public void storeTempVars() {
        super.storeTempVars();
        this.defaultChanList = Arrays.asList(Pattern.compile("[ ]?,[ ]?").split(this.defaultChannels.getValue()));
        this.ignoredChanList = Arrays.asList(Pattern.compile("[ ]?,[ ]?").split(this.ignoredChannels.getValue()));
    }

    public void updateForServer() {
        this.serverIP = TabbyChatUtils.getServerIp();
        this.settingsFile = new File(TabbyChatUtils.getServerDir(), "settings.cfg");
    }

    @Override
    public void validateButtonStates() {
        this.delimColorBool.h = this.autoChannelSearch.getTempValue();
        this.delimFormatBool.h = this.autoChannelSearch.getTempValue();
        this.delimColorCode.h = this.delimColorBool.getTempValue() != false && this.autoChannelSearch.getTempValue() != false;
        this.delimFormatCode.h = this.delimFormatBool.getTempValue() != false && this.autoChannelSearch.getTempValue() != false;
        this.delimiterChars.h = this.autoChannelSearch.getTempValue();
    }
}

