/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.TCSettingsGUI;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.TCSettingBool;
import acs.tabbychat.settings.TCSettingEnum;
import acs.tabbychat.settings.TimeStampEnum;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Properties;

public class TCSettingsGeneral
extends TCSettingsGUI {
    public SimpleDateFormat timeStamp = new SimpleDateFormat();
    private static final int TABBYCHAT_ENABLE_ID = 9101;
    private static final int SAVE_CHATLOG_ID = 9102;
    private static final int TIMESTAMP_ENABLE_ID = 9103;
    private static final int TIMESTAMP_STYLE_ID = 9104;
    private static final int GROUP_SPAM_ID = 9105;
    private static final int UNREAD_FLASHING_ID = 9106;
    private static final int TIMESTAMP_COLOR_ID = 9107;
    public TCSettingBool tabbyChatEnable;
    public TCSettingBool saveChatLog;
    public TCSettingBool timeStampEnable;
    public TCSettingEnum timeStampStyle;
    public TCSettingEnum timeStampColor;
    public TCSettingBool groupSpam;
    public TCSettingBool unreadFlashing;

    public TCSettingsGeneral(TabbyChat _tc) {
        super(_tc);
        this.propertyPrefix = "settings.general";
        this.tabbyChatEnable = new TCSettingBool(true, "tabbyChatEnable", this.propertyPrefix, 9101);
        this.saveChatLog = new TCSettingBool(false, "saveChatLog", this.propertyPrefix, 9102);
        this.timeStampEnable = new TCSettingBool(false, "timeStampEnable", this.propertyPrefix, 9103);
        this.timeStampStyle = new TCSettingEnum((Object)TimeStampEnum.MILITARY, "timeStampStyle", this.propertyPrefix, 9104, FormatCodeEnum.ITALIC);
        this.timeStampColor = new TCSettingEnum((Object)ColorCodeEnum.DEFAULT, "timeStampColor", this.propertyPrefix, 9107, FormatCodeEnum.ITALIC);
        this.groupSpam = new TCSettingBool(false, "groupSpam", this.propertyPrefix, 9105);
        this.unreadFlashing = new TCSettingBool(true, "unreadFlashing", this.propertyPrefix, 9106);
        this.name = TabbyChat.translator.getString("settings.general.name");
        this.settingsFile = new File(tabbyChatDir, "general.cfg");
        this.bgcolor = 1715962558;
        this.defineDrawableSettings();
    }

    @Override
    public void a(aut button) {
        switch (button.g) {
            case 9101: {
                if (tc.enabled()) {
                    tc.disable();
                    break;
                }
                tc.enable();
            }
        }
        super.a(button);
    }

    private void applyTimestampPattern() {
        if (((ColorCodeEnum)this.timeStampColor.getValue()).toCode().length() > 0) {
            StringBuilder tsPattern = new StringBuilder();
            tsPattern.append("'").append(((ColorCodeEnum)this.timeStampColor.getValue()).toCode()).append("'");
            tsPattern.append(((TimeStampEnum)this.timeStampStyle.getValue()).toCode());
            tsPattern.append("'\u00a7r'");
            this.timeStamp.applyPattern(tsPattern.toString());
        } else {
            this.timeStamp.applyPattern(((TimeStampEnum)this.timeStampStyle.getValue()).toCode());
        }
    }

    @Override
    public void defineDrawableSettings() {
        this.i.add(this.tabbyChatEnable);
        this.i.add(this.saveChatLog);
        this.i.add(this.timeStampEnable);
        this.i.add(this.timeStampStyle);
        this.i.add(this.timeStampColor);
        this.i.add(this.groupSpam);
        this.i.add(this.unreadFlashing);
    }

    @Override
    public void initDrawableSettings() {
        int effRight = (this.g + 300) / 2;
        int col1x = (this.g - 300) / 2 + 55;
        int buttonColor = (this.bgcolor & 0xFFFFFF) + -16777216;
        this.tabbyChatEnable.setButtonLoc(col1x, this.rowY(1));
        this.tabbyChatEnable.setLabelLoc(col1x + 19);
        this.tabbyChatEnable.buttonColor = buttonColor;
        this.saveChatLog.setButtonLoc(col1x, this.rowY(2));
        this.saveChatLog.setLabelLoc(col1x + 19);
        this.saveChatLog.buttonColor = buttonColor;
        this.timeStampEnable.setButtonLoc(col1x, this.rowY(3));
        this.timeStampEnable.setLabelLoc(col1x + 19);
        this.timeStampEnable.buttonColor = buttonColor;
        this.timeStampStyle.setButtonDims(80, 11);
        this.timeStampStyle.setButtonLoc(effRight - 80, this.rowY(4));
        this.timeStampStyle.setLabelLoc(this.timeStampStyle.d - 10 - TCSettingsGeneral.f.l.a(this.timeStampStyle.description));
        this.timeStampColor.setButtonDims(80, 11);
        this.timeStampColor.setButtonLoc(effRight - 80, this.rowY(5));
        this.timeStampColor.setLabelLoc(this.timeStampColor.d - 10 - TCSettingsGeneral.f.l.a(this.timeStampColor.description));
        this.groupSpam.setButtonLoc(col1x, this.rowY(6));
        this.groupSpam.setLabelLoc(col1x + 19);
        this.groupSpam.buttonColor = buttonColor;
        this.unreadFlashing.setButtonLoc(col1x, this.rowY(7));
        this.unreadFlashing.setLabelLoc(col1x + 19);
        this.unreadFlashing.buttonColor = buttonColor;
    }

    @Override
    public Properties loadSettingsFile() {
        super.loadSettingsFile();
        this.applyTimestampPattern();
        return null;
    }

    @Override
    public void storeTempVars() {
        super.storeTempVars();
        this.applyTimestampPattern();
    }

    @Override
    public void validateButtonStates() {
        this.timeStampColor.h = this.timeStampEnable.getTempValue();
    }
}

