/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.PrefsButton;
import acs.tabbychat.gui.TCSettingsGUI;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.ITCSetting;
import acs.tabbychat.settings.NotificationSoundEnum;
import acs.tabbychat.settings.TCChatFilter;
import acs.tabbychat.settings.TCSettingBool;
import acs.tabbychat.settings.TCSettingEnum;
import acs.tabbychat.settings.TCSettingTextBox;
import acs.tabbychat.util.TabbyChatUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class TCSettingsFilters
extends TCSettingsGUI {
    protected int curFilterId = 0;
    private static final int INVERSE_MATCH_ID = 9301;
    private static final int CASE_SENSE_ID = 9302;
    private static final int HIGHLIGHT_BOOL_ID = 9303;
    private static final int HIGHLIGHT_COLOR_ID = 9304;
    private static final int HIGHLIGHT_FORMAT_ID = 9305;
    private static final int AUDIO_NOTIFICATION_BOOL_ID = 9306;
    private static final int AUDIO_NOTIFICATION_ENUM_ID = 9307;
    private static final int PREV_ID = 9308;
    private static final int NEXT_ID = 9309;
    private static final int FILTER_NAME_ID = 9310;
    private static final int SEND_TO_TAB_BOOL_ID = 9311;
    private static final int SEND_TO_TAB_NAME_ID = 9312;
    private static final int SEND_TO_ALL_TABS_ID = 9313;
    private static final int REMOVE_MATCHES_ID = 9314;
    private static final int EXPRESSION_ID = 9315;
    private static final int ADD_ID = 9316;
    private static final int DEL_ID = 9317;
    public TCSettingBool inverseMatch;
    public TCSettingBool caseSensitive;
    public TCSettingBool highlightBool;
    public TCSettingEnum highlightColor;
    public TCSettingEnum highlightFormat;
    public TCSettingBool audioNotificationBool;
    public TCSettingEnum audioNotificationSound;
    public TCSettingTextBox filterName;
    public TCSettingBool sendToTabBool;
    public TCSettingTextBox sendToTabName;
    public TCSettingBool sendToAllTabs;
    public TCSettingBool removeMatches;
    public TCSettingTextBox expressionString;
    public TreeMap<Integer, TCChatFilter> filterMap;
    protected TreeMap<Integer, TCChatFilter> tempFilterMap;

    public TCSettingsFilters(TabbyChat _tc) {
        super(_tc);
        this.propertyPrefix = "settings.filters";
        this.inverseMatch = new TCSettingBool(false, "inverseMatch", this.propertyPrefix, 9301);
        this.caseSensitive = new TCSettingBool(false, "caseSensitive", this.propertyPrefix, 9302);
        this.highlightBool = new TCSettingBool(true, "highlightBool", this.propertyPrefix, 9303);
        this.highlightColor = new TCSettingEnum((Object)ColorCodeEnum.YELLOW, "highlightColor", this.propertyPrefix, 9304, FormatCodeEnum.ITALIC);
        this.highlightFormat = new TCSettingEnum((Object)FormatCodeEnum.BOLD, "highlightFormat", this.propertyPrefix, 9305, FormatCodeEnum.ITALIC);
        this.audioNotificationBool = new TCSettingBool(false, "audioNotificationBool", this.propertyPrefix, 9306);
        this.audioNotificationSound = new TCSettingEnum((Object)NotificationSoundEnum.ORB, "audioNotificationSound", this.propertyPrefix, 9307, FormatCodeEnum.ITALIC);
        this.filterName = new TCSettingTextBox("New", "filterName", this.propertyPrefix, 9310);
        this.sendToTabBool = new TCSettingBool(false, "sendToTabBool", this.propertyPrefix, 9311);
        this.sendToTabName = new TCSettingTextBox("", "sendToTabName", this.propertyPrefix, 9312);
        this.sendToAllTabs = new TCSettingBool(false, "sendToAllTabs", this.propertyPrefix, 9313);
        this.removeMatches = new TCSettingBool(false, "removeMatches", this.propertyPrefix, 9314);
        this.expressionString = new TCSettingTextBox(".*", "expressionString", this.propertyPrefix, 9315);
        this.filterMap = new TreeMap();
        this.tempFilterMap = new TreeMap();
        this.name = TabbyChat.translator.getString("settings.filters.name");
        this.settingsFile = new File(TabbyChatUtils.getServerDir(), "filters.cfg");
        this.bgcolor = 1713938216;
        this.filterName.setCharLimit(50);
        this.sendToTabName.setCharLimit(20);
        this.expressionString.setCharLimit(600);
        this.defineDrawableSettings();
    }

    @Override
    public void a(aut button) {
        this.storeTempFilter();
        switch (button.g) {
            case 9316: {
                this.curFilterId = this.tempFilterMap.size() == 0 ? 1 : this.tempFilterMap.lastKey() + 1;
                this.tempFilterMap.put(this.curFilterId, new TCChatFilter("New" + this.curFilterId));
                this.displayCurrentFilter();
                break;
            }
            case 9317: {
                this.tempFilterMap.remove(this.curFilterId);
                if (this.displayNextFilter()) break;
                this.displayPreviousFilter();
                break;
            }
            case 9308: {
                if (this.tempFilterMap.size() <= 0 || this.displayPreviousFilter()) break;
                this.curFilterId = this.tempFilterMap.lastKey();
                this.displayCurrentFilter();
                break;
            }
            case 9309: {
                if (this.tempFilterMap.size() <= 0 || this.displayNextFilter()) break;
                this.curFilterId = this.tempFilterMap.firstKey();
                this.displayCurrentFilter();
            }
        }
        super.a(button);
    }

    private void clearDisplay() {
        for (Object drawable : this.i) {
            if (!(drawable instanceof ITCSetting)) continue;
            ((ITCSetting)drawable).clear();
        }
    }

    @Override
    public void defineDrawableSettings() {
        this.i.add(this.filterName);
        this.i.add(this.sendToTabBool);
        this.i.add(this.sendToAllTabs);
        this.i.add(this.sendToTabName);
        this.i.add(this.removeMatches);
        this.i.add(this.highlightBool);
        this.i.add(this.highlightColor);
        this.i.add(this.highlightFormat);
        this.i.add(this.audioNotificationBool);
        this.i.add(this.audioNotificationSound);
        this.i.add(this.inverseMatch);
        this.i.add(this.caseSensitive);
        this.i.add(this.expressionString);
    }

    private boolean displayCurrentFilter() {
        if (!this.tempFilterMap.containsKey(this.curFilterId)) {
            this.clearDisplay();
            return false;
        }
        Properties displayMe = this.tempFilterMap.get(this.curFilterId).getProperties();
        for (Object drawable : this.i) {
            if (!(drawable instanceof ITCSetting)) continue;
            ITCSetting tcDrawable = (ITCSetting)drawable;
            if (tcDrawable.getType().equals("enum")) {
                ((TCSettingEnum)tcDrawable).setTempValueFromProps(displayMe);
                continue;
            }
            tcDrawable.setTempValue(displayMe.get(tcDrawable.getProperty()));
        }
        return true;
    }

    private boolean displayNextFilter() {
        Map.Entry<Integer, TCChatFilter> next = this.tempFilterMap.higherEntry(this.curFilterId);
        if (next == null) {
            this.clearDisplay();
            return false;
        }
        Properties displayMe = next.getValue().getProperties();
        for (Object drawable : this.i) {
            if (!(drawable instanceof ITCSetting)) continue;
            ITCSetting tcDrawable = (ITCSetting)drawable;
            if (tcDrawable.getType().equals("enum")) {
                ((TCSettingEnum)tcDrawable).setTempValueFromProps(displayMe);
                continue;
            }
            tcDrawable.setTempValue(displayMe.get(tcDrawable.getProperty()));
        }
        this.curFilterId = next.getKey();
        return true;
    }

    private boolean displayPreviousFilter() {
        Map.Entry<Integer, TCChatFilter> next = this.tempFilterMap.lowerEntry(this.curFilterId);
        if (next == null) {
            this.clearDisplay();
            return false;
        }
        Properties displayMe = next.getValue().getProperties();
        for (Object drawable : this.i) {
            if (!(drawable instanceof ITCSetting)) continue;
            ITCSetting tcDrawable = (ITCSetting)drawable;
            if (tcDrawable.getType().equals("enum")) {
                ((TCSettingEnum)tcDrawable).setTempValueFromProps(displayMe);
                continue;
            }
            tcDrawable.setTempValue(displayMe.get(tcDrawable.getProperty()));
        }
        this.curFilterId = next.getKey();
        return true;
    }

    @Override
    public void initDrawableSettings() {
        int effRight = (this.g + 300) / 2;
        int col1x = (this.g - 300) / 2 + 55;
        int buttonColor = (this.bgcolor & 0xFFFFFF) + -16777216;
        PrefsButton newButton = new PrefsButton(9316, col1x, (this.h + 180) / 2 - 14, 45, 14, TabbyChat.translator.getString("settings.new"));
        PrefsButton delButton = new PrefsButton(9317, col1x + 50, (this.h + 180) / 2 - 14, 45, 14, TabbyChat.translator.getString("settings.delete"));
        newButton.bgcolor = this.bgcolor;
        delButton.bgcolor = this.bgcolor;
        this.i.add(newButton);
        this.i.add(delButton);
        this.filterName.setButtonDims(100, 11);
        this.filterName.setLabelLoc(col1x);
        this.filterName.setButtonLoc(col1x + 33 + TCSettingsFilters.f.l.a(this.filterName.description), this.rowY(1));
        PrefsButton prevButton = new PrefsButton(9308, this.filterName.d - 23, this.rowY(1), 20, 14, "<<");
        PrefsButton nextButton = new PrefsButton(9309, this.filterName.d + 103, this.rowY(1), 20, 14, ">>");
        this.i.add(prevButton);
        this.i.add(nextButton);
        this.sendToTabBool.setButtonLoc(col1x, this.rowY(2));
        this.sendToTabBool.setLabelLoc(col1x + 19);
        this.sendToTabBool.buttonColor = buttonColor;
        this.sendToAllTabs.setButtonLoc(col1x + 20, this.rowY(3));
        this.sendToAllTabs.setLabelLoc(col1x + 39);
        this.sendToAllTabs.buttonColor = buttonColor;
        this.sendToTabName.setLabelLoc(effRight - TCSettingsFilters.f.l.a(this.sendToTabName.description) - 55);
        this.sendToTabName.setButtonLoc(effRight - 50, this.rowY(3));
        this.sendToTabName.setButtonDims(50, 11);
        this.removeMatches.setButtonLoc(col1x, this.rowY(4));
        this.removeMatches.setLabelLoc(col1x + 19);
        this.removeMatches.buttonColor = buttonColor;
        this.highlightBool.setButtonLoc(col1x, this.rowY(5));
        this.highlightBool.setLabelLoc(col1x + 19);
        this.highlightBool.buttonColor = buttonColor;
        this.highlightColor.setButtonDims(70, 11);
        this.highlightColor.setButtonLoc(col1x + 15 + TCSettingsFilters.f.l.a(this.highlightColor.description), this.rowY(6));
        this.highlightColor.setLabelLoc(col1x + 10);
        this.highlightFormat.setButtonDims(60, 11);
        this.highlightFormat.setButtonLoc(effRight - 60, this.rowY(6));
        this.highlightFormat.setLabelLoc(this.highlightFormat.d - 5 - TCSettingsFilters.f.l.a(this.highlightFormat.description));
        this.audioNotificationBool.setButtonLoc(col1x, this.rowY(7));
        this.audioNotificationBool.setLabelLoc(col1x + 19);
        this.audioNotificationBool.buttonColor = buttonColor;
        this.audioNotificationSound.setButtonDims(60, 11);
        this.audioNotificationSound.setButtonLoc(effRight - 60, this.rowY(7));
        this.audioNotificationSound.setLabelLoc(this.audioNotificationSound.d - 5 - TCSettingsFilters.f.l.a(this.audioNotificationSound.description));
        this.inverseMatch.setButtonLoc(col1x, this.rowY(8));
        this.inverseMatch.setLabelLoc(col1x + 19);
        this.inverseMatch.buttonColor = buttonColor;
        this.caseSensitive.setLabelLoc(effRight - TCSettingsFilters.f.l.a(this.caseSensitive.description));
        this.caseSensitive.setButtonLoc(effRight - TCSettingsFilters.f.l.a(this.caseSensitive.description) - 19, this.rowY(8));
        this.caseSensitive.buttonColor = buttonColor;
        this.expressionString.setLabelLoc(col1x);
        this.expressionString.setButtonLoc(col1x + 5 + TCSettingsFilters.f.l.a(this.expressionString.description), this.rowY(9));
        this.expressionString.setButtonDims(effRight - this.expressionString.d, 11);
        this.resetTempVars();
        this.displayCurrentFilter();
    }

    @Override
    public Properties loadSettingsFile() {
        this.filterMap.clear();
        if (this.settingsFile == null) {
            return null;
        }
        Properties settingsTable = super.loadSettingsFile();
        int loadId = 1;
        String loadName = settingsTable.getProperty(loadId + ".filterName");
        while (loadName != null) {
            TCChatFilter loaded = new TCChatFilter(loadName);
            loaded.inverseMatch = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".inverseMatch"));
            loaded.caseSensitive = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".caseSensitive"));
            loaded.highlightBool = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".highlightBool"));
            loaded.highlightColor = ColorCodeEnum.cleanValueOf(settingsTable.getProperty(loadId + ".highlightColor"));
            loaded.highlightFormat = FormatCodeEnum.cleanValueOf(settingsTable.getProperty(loadId + ".highlightFormat"));
            loaded.audioNotificationBool = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".audioNotificationBool"));
            loaded.audioNotificationSound = TabbyChatUtils.parseSound(settingsTable.getProperty(loadId + ".audioNotificationSound"));
            loaded.sendToTabBool = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".sendToTabBool"));
            loaded.sendToTabName = TabbyChatUtils.parseString(settingsTable.getProperty(loadId + ".sendToTabName"));
            loaded.sendToAllTabs = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".sendToAllTabs"));
            loaded.removeMatches = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".removeMatches"));
            loaded.compilePattern(TabbyChatUtils.parseString(settingsTable.getProperty(loadId + ".expressionString")));
            this.filterMap.put(loadId, loaded);
            loadName = settingsTable.getProperty(++loadId + ".filterName");
        }
        this.resetTempVars();
        return null;
    }

    @Override
    public void a(int par1, int par2, int par3) {
        if (this.audioNotificationSound.hovered(par1, par2).booleanValue()) {
            this.audioNotificationSound.mouseClicked(par1, par2, par3);
            TCSettingsFilters.f.v.a(((NotificationSoundEnum)this.audioNotificationSound.getTempValue()).file(), 1.0f, 1.0f);
        } else {
            super.a(par1, par2, par3);
        }
    }

    @Override
    public void resetTempVars() {
        this.tempFilterMap.clear();
        Map.Entry<Integer, TCChatFilter> realFilter = this.filterMap.firstEntry();
        if (realFilter != null) {
            this.curFilterId = realFilter.getKey();
        }
        while (realFilter != null) {
            this.tempFilterMap.put(realFilter.getKey(), new TCChatFilter(realFilter.getValue()));
            realFilter = this.filterMap.higherEntry(realFilter.getKey());
        }
    }

    @Override
    public void saveSettingsFile() {
        Properties settingsTable = new Properties();
        int saveId = 1;
        Map.Entry<Integer, TCChatFilter> saveFilter = this.filterMap.firstEntry();
        while (saveFilter != null) {
            settingsTable.put(saveId + ".filterName", saveFilter.getValue().filterName);
            settingsTable.put(saveId + ".inverseMatch", Boolean.toString(saveFilter.getValue().inverseMatch));
            settingsTable.put(saveId + ".caseSensitive", Boolean.toString(saveFilter.getValue().caseSensitive));
            settingsTable.put(saveId + ".highlightBool", Boolean.toString(saveFilter.getValue().highlightBool));
            settingsTable.put(saveId + ".audioNotificationBool", Boolean.toString(saveFilter.getValue().audioNotificationBool));
            settingsTable.put(saveId + ".sendToTabBool", Boolean.toString(saveFilter.getValue().sendToTabBool));
            settingsTable.put(saveId + ".sendToAllTabs", Boolean.toString(saveFilter.getValue().sendToAllTabs));
            settingsTable.put(saveId + ".removeMatches", Boolean.toString(saveFilter.getValue().removeMatches));
            settingsTable.put(saveId + ".highlightColor", saveFilter.getValue().highlightColor.name());
            settingsTable.put(saveId + ".highlightFormat", saveFilter.getValue().highlightFormat.name());
            settingsTable.put(saveId + ".audioNotificationSound", saveFilter.getValue().audioNotificationSound.name());
            settingsTable.put(saveId + ".sendToTabName", saveFilter.getValue().sendToTabName);
            settingsTable.put(saveId + ".expressionString", saveFilter.getValue().expressionString);
            ++saveId;
            saveFilter = this.filterMap.higherEntry(saveFilter.getKey());
        }
        ArrayList tmpList = new ArrayList(this.i);
        this.i.clear();
        super.saveSettingsFile(settingsTable);
        this.i = tmpList;
    }

    private void storeTempFilter() {
        if (this.tempFilterMap.containsKey(this.curFilterId)) {
            TCChatFilter storeMe = this.tempFilterMap.get(this.curFilterId);
            storeMe.filterName = this.filterName.getTempValue();
            storeMe.inverseMatch = this.inverseMatch.getTempValue();
            storeMe.caseSensitive = this.caseSensitive.getTempValue();
            storeMe.highlightBool = this.highlightBool.getTempValue();
            storeMe.highlightColor = ColorCodeEnum.valueOf(this.highlightColor.getTempValue().name());
            storeMe.highlightFormat = FormatCodeEnum.valueOf(this.highlightFormat.getTempValue().name());
            storeMe.audioNotificationBool = this.audioNotificationBool.getTempValue();
            storeMe.audioNotificationSound = NotificationSoundEnum.valueOf(this.audioNotificationSound.getTempValue().name());
            storeMe.sendToTabBool = this.sendToTabBool.getTempValue();
            storeMe.sendToAllTabs = this.sendToAllTabs.getTempValue();
            storeMe.sendToTabName = this.sendToTabName.getTempValue();
            storeMe.removeMatches = this.removeMatches.getTempValue();
            storeMe.expressionString = this.expressionString.getTempValue();
        }
    }

    @Override
    public void storeTempVars() {
        this.filterMap.clear();
        Map.Entry<Integer, TCChatFilter> tempFilter = this.tempFilterMap.firstEntry();
        while (tempFilter != null) {
            this.filterMap.put(tempFilter.getKey(), new TCChatFilter(tempFilter.getValue()));
            tempFilter = this.tempFilterMap.higherEntry(tempFilter.getKey());
        }
    }

    public void updateForServer() {
        this.settingsFile = new File(TabbyChatUtils.getServerDir(), "filters.cfg");
    }

    @Override
    public void validateButtonStates() {
        this.inverseMatch.h = this.highlightBool.getTempValue() == false;
        this.caseSensitive.h = true;
        this.highlightBool.h = this.removeMatches.getTempValue() == false && this.inverseMatch.getTempValue() == false;
        this.audioNotificationBool.h = this.removeMatches.getTempValue() == false;
        this.removeMatches.h = this.sendToTabBool.getTempValue() == false && this.highlightBool.getTempValue() == false && this.audioNotificationBool.getTempValue() == false;
        this.sendToTabBool.h = this.removeMatches.getTempValue() == false;
        this.highlightColor.h = this.highlightBool.getTempValue();
        this.highlightFormat.h = this.highlightBool.getTempValue();
        this.audioNotificationSound.h = this.audioNotificationBool.getTempValue();
        this.sendToAllTabs.h = this.sendToTabBool.getTempValue();
        for (int i = 0; i < this.i.size(); ++i) {
            if (!ITCSetting.class.isInstance(this.i.get(i))) continue;
            ITCSetting tmp = (ITCSetting)this.i.get(i);
            if (this.tempFilterMap.size() == 0) {
                tmp.disable();
                continue;
            }
            if (tmp.getType() == "textbox") {
                tmp.enable();
                continue;
            }
            if (tmp.getType() != "bool") continue;
            ((TCSettingBool)tmp).setTempValue(((TCSettingBool)tmp).getTempValue() != false && tmp.enabled());
        }
        this.sendToTabName.setEnabled(this.sendToTabBool.getTempValue() != false && this.sendToAllTabs.getTempValue() == false);
    }
}

