/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.gui.TCSettingsGUI;
import acs.tabbychat.settings.TCSettingBool;
import acs.tabbychat.settings.TCSettingSlider;
import acs.tabbychat.settings.TCSettingTextBox;
import acs.tabbychat.util.TabbyChatUtils;
import java.io.File;
import java.util.Properties;

public class TCSettingsAdvanced
extends TCSettingsGUI {
    private static final int CHAT_SCROLL_HISTORY_ID = 9401;
    private static final int MAXLENGTH_CHANNEL_NAME_ID = 9402;
    private static final int MULTICHAT_DELAY_ID = 9403;
    private static final int CHATBOX_UNFOC_HEIGHT_ID = 9406;
    private static final int CHAT_FADE_TICKS_ID = 9408;
    private static final int FORCE_UNICODE_ID = 9409;
    public TCSettingTextBox chatScrollHistory;
    public TCSettingTextBox maxLengthChannelName;
    public TCSettingTextBox multiChatDelay;
    public TCSettingSlider chatBoxUnfocHeight;
    public TCSettingSlider chatFadeTicks;
    public TCSettingBool forceUnicode;

    public TCSettingsAdvanced(TabbyChat _tc) {
        super(_tc);
        this.propertyPrefix = "settings.advanced";
        this.chatScrollHistory = new TCSettingTextBox("100", "chatScrollHistory", this.propertyPrefix, 9401);
        this.maxLengthChannelName = new TCSettingTextBox("10", "maxLengthChannelName", this.propertyPrefix, 9402);
        this.multiChatDelay = new TCSettingTextBox("500", "multiChatDelay", this.propertyPrefix, 9403);
        this.chatBoxUnfocHeight = new TCSettingSlider(Float.valueOf(50.0f), "chatBoxUnfocHeight", this.propertyPrefix, 9406, 20.0f, 100.0f);
        this.chatFadeTicks = new TCSettingSlider(Float.valueOf(200.0f), "chatFadeTicks", this.propertyPrefix, 9408, 10.0f, 2000.0f);
        this.forceUnicode = new TCSettingBool(false, "forceUnicode", this.propertyPrefix, 9409);
        this.name = TabbyChat.translator.getString("settings.advanced.name");
        this.settingsFile = new File(tabbyChatDir, "advanced.cfg");
        this.bgcolor = 1719676564;
        this.chatScrollHistory.setCharLimit(3);
        this.maxLengthChannelName.setCharLimit(2);
        this.multiChatDelay.setCharLimit(4);
        this.defineDrawableSettings();
    }

    @Override
    public void defineDrawableSettings() {
        this.i.add(this.chatScrollHistory);
        this.i.add(this.maxLengthChannelName);
        this.i.add(this.multiChatDelay);
        this.i.add(this.chatBoxUnfocHeight);
        this.i.add(this.chatFadeTicks);
        this.i.add(this.forceUnicode);
    }

    @Override
    public void initDrawableSettings() {
        int col1x = (this.g - 300) / 2 + 55;
        int buttonColor = (this.bgcolor & 0xFFFFFF) + -16777216;
        this.chatScrollHistory.setLabelLoc(col1x);
        this.chatScrollHistory.setButtonLoc(col1x + 5 + TCSettingsAdvanced.f.l.a(this.chatScrollHistory.description), this.rowY(1));
        this.chatScrollHistory.setButtonDims(30, 11);
        this.maxLengthChannelName.setLabelLoc(col1x);
        this.maxLengthChannelName.setButtonLoc(col1x + 5 + TCSettingsAdvanced.f.l.a(this.maxLengthChannelName.description), this.rowY(2));
        this.maxLengthChannelName.setButtonDims(20, 11);
        this.multiChatDelay.setLabelLoc(col1x);
        this.multiChatDelay.setButtonLoc(col1x + 5 + TCSettingsAdvanced.f.l.a(this.multiChatDelay.description), this.rowY(3));
        this.multiChatDelay.setButtonDims(40, 11);
        this.chatBoxUnfocHeight.setLabelLoc(col1x);
        this.chatBoxUnfocHeight.setButtonLoc(col1x + 5 + TCSettingsAdvanced.f.l.a(this.chatBoxUnfocHeight.description), this.rowY(4));
        this.chatBoxUnfocHeight.buttonColor = buttonColor;
        this.chatFadeTicks.setLabelLoc(col1x);
        this.chatFadeTicks.setButtonLoc(col1x + 5 + TCSettingsAdvanced.f.l.a(this.chatFadeTicks.description), this.rowY(5));
        this.chatFadeTicks.buttonColor = buttonColor;
        this.chatFadeTicks.units = "";
        this.forceUnicode.setButtonLoc(col1x, this.rowY(6));
        this.forceUnicode.setLabelLoc(col1x + 19);
        this.forceUnicode.buttonColor = buttonColor;
    }

    @Override
    public Properties loadSettingsFile() {
        Properties result = super.loadSettingsFile();
        ChatBox.current.x = TabbyChatUtils.parseInteger(result.getProperty("chatbox.x"), ChatBox.absMinX, 10000, ChatBox.absMinX);
        ChatBox.current.y = TabbyChatUtils.parseInteger(result.getProperty("chatbox.y"), -10000, ChatBox.absMinY, ChatBox.absMinY);
        ChatBox.current.width = TabbyChatUtils.parseInteger(result.getProperty("chatbox.width"), ChatBox.absMinW, 10000, 320);
        ChatBox.current.height = TabbyChatUtils.parseInteger(result.getProperty("chatbox.height"), ChatBox.absMinH, 10000, 180);
        ChatBox.anchoredTop = Boolean.parseBoolean(result.getProperty("chatbox.anchoredtop"));
        ChatBox.pinned = Boolean.parseBoolean(result.getProperty("pinchatinterface"));
        return null;
    }

    @Override
    public void saveSettingsFile() {
        Properties settingsTable = new Properties();
        settingsTable.put("chatbox.x", Integer.toString(ChatBox.current.x));
        settingsTable.put("chatbox.y", Integer.toString(ChatBox.current.y));
        settingsTable.put("chatbox.width", Integer.toString(ChatBox.current.width));
        settingsTable.put("chatbox.height", Integer.toString(ChatBox.current.height));
        settingsTable.put("chatbox.anchoredtop", Boolean.toString(ChatBox.anchoredTop));
        settingsTable.put("pinchatinterface", Boolean.toString(ChatBox.pinned));
        super.saveSettingsFile(settingsTable);
    }
}

