/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.ChatChannel;
import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ChatButton;
import acs.tabbychat.gui.ChatScrollBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedHashMap;
import org.lwjgl.input.Mouse;

public class ChatBox {
    public static Rectangle current = new Rectangle(0, -36, 320, 180);
    public static Rectangle desired = new Rectangle(current);
    protected static int absMinX = 0;
    protected static int absMinY = -36;
    protected static int absMinW = 200;
    protected static int absMinH = 24;
    private static int tabHeight = 14;
    protected static int tabTrayHeight = 14;
    private static int chatHeight = 165;
    public static int unfocusedHeight = 160;
    public static boolean dragging = false;
    private static Point dragStart = new Point(0, 0);
    public static boolean resizing = false;
    public static boolean anchoredTop = false;
    public static boolean pinned = false;
    private static GuiNewChatTC gnc = GuiNewChatTC.getInstance();

    public static void addRowToTray() {
        float sf = gnc.getScaleSetting();
        int sh = ls.d((float)((float)(ChatBox.gnc.sr.b() + ChatBox.current.y) / sf - (float)ChatBox.current.y));
        tabTrayHeight += tabHeight;
        if (ChatBox.current.height + tabHeight - absMinY > sh) {
            ChatBox.current.y = anchoredTop ? -sh + 1 : -sh + 1 + ChatBox.current.height;
            ChatBox.current.height = sh + absMinY - 3;
        } else if (!anchoredTop && ChatBox.current.y - ChatBox.current.height - tabHeight - 1 < -sh) {
            ChatBox.current.y = -sh + ChatBox.current.height + 1;
            ChatBox.current.height += tabHeight;
        } else if (anchoredTop && ChatBox.current.y + ChatBox.current.height + tabHeight > absMinY) {
            ChatBox.current.height += tabHeight;
            ChatBox.current.y = absMinY - ChatBox.current.height;
        } else {
            ChatBox.current.height += tabHeight;
        }
    }

    public static void drawChatBoxBorder(avk overlay, boolean chatOpen, int opacity) {
        int pinColor;
        int borderColor = 0 + (2 * opacity / 3 << 24);
        int trayColor = 0 + (opacity / 3 << 24);
        int highlightColor = 0xFFFFA0 + (2 * opacity / 3 << 24);
        int handleColor = ChatBox.resizeHovered() ? highlightColor : borderColor;
        int n = pinColor = ChatBox.pinHovered() ? highlightColor : borderColor;
        if (chatOpen) {
            if (!anchoredTop) {
                avk.a((int)-1, (int)(-ChatBox.current.height - 1), (int)(ChatBox.current.width + 1), (int)(-ChatBox.current.height), (int)borderColor);
                avk.a((int)-1, (int)(-ChatBox.current.height), (int)0, (int)0, (int)borderColor);
                avk.a((int)ChatBox.current.width, (int)(-ChatBox.current.height), (int)(ChatBox.current.width + 1), (int)0, (int)borderColor);
                avk.a((int)-1, (int)0, (int)(ChatBox.current.width + 1), (int)1, (int)borderColor);
                avk.a((int)0, (int)(-ChatBox.current.height + tabTrayHeight), (int)ChatBox.current.width, (int)(-ChatBox.current.height + tabTrayHeight + 1), (int)borderColor);
                avk.a((int)0, (int)(-ChatBox.current.height), (int)ChatBox.current.width, (int)(-ChatBox.current.height + tabTrayHeight), (int)trayColor);
                avk.a((int)0, (int)(-ChatBox.current.height + tabTrayHeight + 1), (int)(ChatBox.current.width - ChatScrollBar.barWidth - 2), (int)(-chatHeight), (int)(opacity / 2 << 24));
                avk.a((int)(ChatBox.current.width - 7), (int)(-ChatBox.current.height + 2), (int)(ChatBox.current.width - 2), (int)(-ChatBox.current.height + 3), (int)handleColor);
                avk.a((int)(ChatBox.current.width - 3), (int)(-ChatBox.current.height + 3), (int)(ChatBox.current.width - 2), (int)(-ChatBox.current.height + 7), (int)handleColor);
                avk.a((int)(ChatBox.current.width - 14), (int)(-ChatBox.current.height + 2), (int)(ChatBox.current.width - 9), (int)(-ChatBox.current.height + 7), (int)pinColor);
                if (pinned) {
                    avk.a((int)(ChatBox.current.width - 13), (int)(-ChatBox.current.height + 3), (int)(ChatBox.current.width - 10), (int)(-ChatBox.current.height + 6), (int)highlightColor);
                }
            } else {
                avk.a((int)-1, (int)-1, (int)(ChatBox.current.width + 1), (int)0, (int)borderColor);
                avk.a((int)-1, (int)0, (int)0, (int)ChatBox.current.height, (int)borderColor);
                avk.a((int)ChatBox.current.width, (int)0, (int)(ChatBox.current.width + 1), (int)ChatBox.current.height, (int)borderColor);
                avk.a((int)-1, (int)ChatBox.current.height, (int)(ChatBox.current.width + 1), (int)(ChatBox.current.height + 1), (int)borderColor);
                avk.a((int)0, (int)(ChatBox.current.height - tabTrayHeight), (int)ChatBox.current.width, (int)(ChatBox.current.height - tabTrayHeight - 1), (int)borderColor);
                avk.a((int)0, (int)ChatBox.current.height, (int)ChatBox.current.width, (int)(ChatBox.current.height - tabTrayHeight), (int)trayColor);
                avk.a((int)0, (int)(ChatBox.current.height - tabTrayHeight - 1), (int)(ChatBox.current.width - ChatScrollBar.barWidth - 2), (int)chatHeight, (int)(opacity / 2 << 24));
                avk.a((int)(ChatBox.current.width - 7), (int)(ChatBox.current.height - 2), (int)(ChatBox.current.width - 2), (int)(ChatBox.current.height - 3), (int)handleColor);
                avk.a((int)(ChatBox.current.width - 3), (int)(ChatBox.current.height - 3), (int)(ChatBox.current.width - 2), (int)(ChatBox.current.height - 7), (int)handleColor);
                avk.a((int)(ChatBox.current.width - 14), (int)(ChatBox.current.height - 2), (int)(ChatBox.current.width - 9), (int)(ChatBox.current.height - 7), (int)pinColor);
                if (pinned) {
                    avk.a((int)(ChatBox.current.width - 13), (int)(ChatBox.current.height - 3), (int)(ChatBox.current.width - 10), (int)(ChatBox.current.height - 6), (int)highlightColor);
                }
            }
        } else if (unfocusedHeight > 0) {
            if (!anchoredTop) {
                avk.a((int)-1, (int)(-unfocusedHeight - 1), (int)(ChatBox.current.width + 1), (int)(-unfocusedHeight), (int)borderColor);
                avk.a((int)-1, (int)(-unfocusedHeight), (int)0, (int)0, (int)borderColor);
                avk.a((int)ChatBox.current.width, (int)(-unfocusedHeight), (int)(ChatBox.current.width + 1), (int)0, (int)borderColor);
                avk.a((int)-1, (int)0, (int)(ChatBox.current.width + 1), (int)1, (int)borderColor);
                avk.a((int)(ChatBox.current.width - ChatScrollBar.barWidth - 2), (int)(-unfocusedHeight), (int)ChatBox.current.width, (int)0, (int)(opacity / 2 << 24));
            } else {
                avk.a((int)-1, (int)unfocusedHeight, (int)(ChatBox.current.width + 1), (int)(unfocusedHeight + 1), (int)borderColor);
                avk.a((int)-1, (int)unfocusedHeight, (int)0, (int)0, (int)borderColor);
                avk.a((int)ChatBox.current.width, (int)unfocusedHeight, (int)(ChatBox.current.width + 1), (int)0, (int)borderColor);
                avk.a((int)-1, (int)0, (int)(ChatBox.current.width + 1), (int)-1, (int)borderColor);
                avk.a((int)(ChatBox.current.width - ChatScrollBar.barWidth - 2), (int)unfocusedHeight, (int)ChatBox.current.width, (int)0, (int)(opacity / 2 << 24));
            }
        }
    }

    public static void enforceScreenBoundary(Rectangle newBounds) {
        float scaleSetting = gnc.getScaleSetting();
        int scaledWidth = Math.round((float)(ChatBox.gnc.sr.a() - ChatBox.current.x) / scaleSetting + (float)ChatBox.current.x);
        int scaledHeight = Math.round((float)(ChatBox.gnc.sr.b() + ChatBox.current.y) / scaleSetting - (float)ChatBox.current.y);
        current.setBounds(newBounds);
        if (ChatBox.gnc.sr.b() < -ChatBox.current.y) {
            scaledHeight = ChatBox.gnc.sr.b();
        }
        if (ChatBox.gnc.sr.a() < ChatBox.current.x) {
            scaledWidth = ChatBox.gnc.sr.a();
        }
        if (ChatBox.current.height < absMinH) {
            ChatBox.current.height = absMinH;
        }
        if (ChatBox.current.width < absMinW) {
            ChatBox.current.width = absMinW;
        }
        if (ChatBox.current.height > scaledHeight - 2) {
            ChatBox.current.height = scaledHeight - 2;
            ChatBox.current.y = anchoredTop ? -scaledHeight + 1 : -scaledHeight + ChatBox.current.height + 1;
        }
        if (ChatBox.current.width > scaledWidth - 2) {
            ChatBox.current.width = scaledWidth - 2;
            ChatBox.current.x = 0;
        }
        if (ChatBox.current.x < absMinX + 1) {
            ChatBox.current.x = absMinX + 1;
        }
        if (ChatBox.current.x + ChatBox.current.width + 1 > scaledWidth) {
            if (resizing) {
                ChatBox.current.width = scaledWidth - ChatBox.current.x - 1;
            } else {
                ChatBox.current.x = scaledWidth - ChatBox.current.width - 1;
            }
        }
        if (anchoredTop) {
            if (ChatBox.current.y - 1 < -scaledHeight) {
                ChatBox.current.y = -scaledHeight + 1;
            } else if (ChatBox.current.y + ChatBox.current.height + 1 > absMinY) {
                if (resizing) {
                    ChatBox.current.height = absMinY - ChatBox.current.y - 1;
                } else {
                    ChatBox.current.y = absMinY - ChatBox.current.height - 1;
                }
            }
        } else if (ChatBox.current.y + 1 > absMinY) {
            ChatBox.current.y = absMinY - 1;
        } else if (ChatBox.current.y - ChatBox.current.height - 1 < -scaledHeight) {
            if (resizing) {
                ChatBox.current.height = scaledHeight + ChatBox.current.y - 1;
            } else {
                ChatBox.current.y = ChatBox.current.height + 1 - scaledHeight;
            }
        }
    }

    public static int getChatHeight() {
        return ChatBox.current.height - tabTrayHeight - 1;
    }

    public static int getChatWidth() {
        return ChatBox.current.width - ChatScrollBar.barWidth - 2;
    }

    public static int getUnfocusedHeight() {
        return unfocusedHeight;
    }

    public static void handleMouseDrag(int _curX, int _curY) {
        if (!dragging) {
            return;
        }
        Point click = ChatBox.scaleMouseCoords(_curX, _curY, true);
        if (Math.abs(click.x - ChatBox.dragStart.x) < 3 && Math.abs(click.y - ChatBox.dragStart.y) < 3) {
            return;
        }
        float scaleSetting = gnc.getScaleSetting();
        int scaledHeight = Math.round((float)(ChatBox.gnc.sr.b() + ChatBox.current.y) / scaleSetting - (float)ChatBox.current.y);
        ChatBox.desired.x = ChatBox.current.x + click.x - ChatBox.dragStart.x;
        ChatBox.desired.y = ChatBox.current.y + click.y - ChatBox.dragStart.y;
        if (ChatBox.desired.y - ChatBox.current.height < -scaledHeight + 1 && !anchoredTop) {
            anchoredTop = true;
            dragging = false;
            ChatBox.desired.y -= ChatBox.current.height;
        } else if (ChatBox.desired.y + ChatBox.current.height + 1 > absMinY && anchoredTop) {
            anchoredTop = false;
            dragging = false;
            ChatBox.desired.y += ChatBox.current.height;
        }
        desired.setSize(ChatBox.current.width, ChatBox.current.height);
        ChatBox.enforceScreenBoundary(desired);
        dragStart = click;
    }

    public static void handleMouseResize(int _curX, int _curY) {
        if (!resizing) {
            return;
        }
        Point click = ChatBox.scaleMouseCoords(_curX, _curY, true);
        if (Math.abs(click.x - ChatBox.dragStart.x) < 3 && Math.abs(click.y - ChatBox.dragStart.y) < 3) {
            return;
        }
        ChatBox.desired.width = ChatBox.current.width + click.x - ChatBox.dragStart.x;
        ChatBox.desired.x = ChatBox.current.x;
        ChatBox.desired.y = ChatBox.current.y;
        ChatBox.desired.height = !anchoredTop ? ChatBox.current.height - click.y + ChatBox.dragStart.y : ChatBox.current.height + click.y - ChatBox.dragStart.y;
        ChatBox.enforceScreenBoundary(desired);
        dragStart = click;
    }

    public static boolean pinHovered() {
        Point cursor = ChatBox.scaleMouseCoords(Mouse.getX(), Mouse.getY());
        if (cursor == null) {
            return false;
        }
        int rX = ChatBox.current.x + ChatBox.current.width - 15;
        int rY = anchoredTop ? ChatBox.current.y + ChatBox.current.height - 8 : ChatBox.current.y - ChatBox.current.height;
        return cursor.x > rX && cursor.x < rX + 6 && cursor.y > rY && cursor.y < rY + 8;
    }

    public static boolean resizeHovered() {
        Point cursor = ChatBox.scaleMouseCoords(Mouse.getX(), Mouse.getY());
        if (cursor == null) {
            return false;
        }
        int rX = ChatBox.current.x + ChatBox.current.width - 8;
        int rY = anchoredTop ? ChatBox.current.y + ChatBox.current.height - 8 : ChatBox.current.y - ChatBox.current.height;
        return cursor.x > rX && cursor.x < rX + 8 && cursor.y > rY && cursor.y < rY + 8;
    }

    public static void setChatSize(int height) {
        chatHeight = height;
    }

    public static void setUnfocusedHeight(int uHeight) {
        unfocusedHeight = Math.min(uHeight, (int)(TabbyChat.advancedSettings.chatBoxUnfocHeight.getValue().floatValue() * (float)ChatBox.getChatHeight() / 100.0f));
    }

    public static void startDragging(int atX, int atY) {
        dragging = true;
        resizing = false;
        dragStart = ChatBox.scaleMouseCoords(atX, atY, true);
    }

    public static void startResizing(int atX, int atY) {
        dragging = false;
        resizing = true;
        dragStart = ChatBox.scaleMouseCoords(atX, atY, true);
    }

    public static boolean tabTrayHovered(int mx, int my) {
        boolean chatOpen = gnc.e();
        awe theScreen = TabbyChat.mc.n;
        if (!chatOpen || theScreen == null) {
            return false;
        }
        Point click = ChatBox.scaleMouseCoords(mx, my);
        if (!anchoredTop) {
            return click.x > ChatBox.current.x && click.x < ChatBox.current.x + ChatBox.current.width && click.y > ChatBox.current.y - ChatBox.current.height && click.y < ChatBox.current.y - ChatBox.current.height + tabTrayHeight;
        }
        return click.x > ChatBox.current.x && click.x < ChatBox.current.x + ChatBox.current.width && click.y > ChatBox.current.y + ChatBox.current.height - tabTrayHeight && click.y < ChatBox.current.y + ChatBox.current.height;
    }

    public static Point scaleMouseCoords(int _x, int _y) {
        return ChatBox.scaleMouseCoords(_x, _y, false);
    }

    public static Point scaleMouseCoords(int _x, int _y, boolean forGuiScreen) {
        atv mc = atv.w();
        awe theScreen = mc.n;
        if (theScreen == null) {
            return null;
        }
        _x = _x * theScreen.g / mc.d;
        float chatScale = gnc.getScaleSetting();
        _x = Math.round((float)(_x - ChatBox.current.x) / chatScale) + ChatBox.current.x;
        if (!forGuiScreen) {
            _y = -_y * theScreen.h / mc.e;
            _y = Math.round((float)(_y - ChatBox.current.y) / chatScale) + ChatBox.current.y;
        } else {
            _y = _y * theScreen.h / mc.e;
            _y = Math.round((float)(_y + ChatBox.current.y) / chatScale) - ChatBox.current.y;
            _y = theScreen.h - _y;
        }
        return new Point(_x, _y);
    }

    public static void updateTabs(LinkedHashMap<String, ChatChannel> chanObjs) {
        int tabWidth = 0;
        int tabX = ChatBox.current.x;
        int tabY = ChatBox.gnc.sr.b() + ChatBox.current.y + (anchoredTop ? ChatBox.current.height - tabTrayHeight : -ChatBox.current.height);
        int tabDx = 0;
        int rows = 0;
        int moveY = tabTrayHeight - tabHeight;
        tabTrayHeight = tabHeight;
        ChatBox.current.height -= moveY;
        for (ChatChannel chan : chanObjs.values()) {
            tabWidth = TabbyChat.mc.l.a(chan.getAlias() + "<>") + 8;
            if (tabDx + tabWidth > ChatBox.current.width - 6 && tabWidth < ChatBox.current.width - 6) {
                if (tabHeight * (++rows + 1) > tabTrayHeight) {
                    ChatBox.addRowToTray();
                }
                tabDx = 0;
                if (!anchoredTop) {
                    for (ChatChannel chan2 : chanObjs.values()) {
                        if (chan2 == chan) break;
                        chan2.tab.e += tabHeight;
                    }
                }
            }
            if (chan.tab == null) {
                chan.setButtonObj(new ChatButton(chan.getID(), tabX + tabDx, ChatBox.gnc.sr.b() + ChatBox.current.y, tabWidth, tabHeight, chan.getDisplayTitle()));
            } else {
                chan.tab.g = chan.getID();
                chan.tab.d = tabX + tabDx;
                chan.tab.e = tabY;
                if (anchoredTop) {
                    chan.tab.e += tabHeight * rows;
                }
                chan.tab.width(tabWidth);
                chan.tab.height(tabHeight);
                chan.tab.f = chan.getDisplayTitle();
            }
            tabDx += tabWidth + 1;
        }
    }
}

