/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.core;

import acs.tabbychat.core.ChatChannel;
import acs.tabbychat.core.GuiChatTC;
import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.TCChatLine;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.gui.TCSettingsAdvanced;
import acs.tabbychat.gui.TCSettingsFilters;
import acs.tabbychat.gui.TCSettingsGeneral;
import acs.tabbychat.gui.TCSettingsServer;
import acs.tabbychat.lang.TCTranslate;
import acs.tabbychat.settings.ChannelDelimEnum;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.TCChatFilter;
import acs.tabbychat.threads.BackgroundUpdateCheck;
import acs.tabbychat.util.TabbyChatUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TabbyChat {
    private volatile List<TCChatLine> lastChat = new ArrayList<TCChatLine>();
    private static boolean firstRun = true;
    public static boolean liteLoaded = false;
    public static boolean modLoaded = false;
    private static boolean updateChecked = false;
    private static String mcversion = new bdm((String)"", (String)"").g;
    public static boolean defaultUnicode;
    public static String version;
    public static atv mc;
    public static TCTranslate translator;
    public static TCSettingsGeneral generalSettings;
    public static TCSettingsServer serverSettings;
    public static TCSettingsFilters filterSettings;
    public static TCSettingsAdvanced advancedSettings;
    public LinkedHashMap<String, ChatChannel> channelMap = new LinkedHashMap();
    private static File chanDataFile;
    protected Calendar cal = Calendar.getInstance();
    protected Semaphore serverDataLock = new Semaphore(0, true);
    private Pattern chatChannelPatternClean = Pattern.compile("^\\[([\\p{L}0-9_]{1,10})\\]");
    private Pattern chatChannelPatternDirty = Pattern.compile("^\\[([\\p{L}0-9_]{1,10})\\]");
    private Pattern chatPMfromMePattern = null;
    private Pattern chatPMtoMePattern = null;
    private final ReentrantReadWriteLock lastChatLock = new ReentrantReadWriteLock(true);
    private final Lock lastChatReadLock = this.lastChatLock.readLock();
    private final Lock lastChatWriteLock = this.lastChatLock.writeLock();
    private static GuiNewChatTC gnc;
    private static TabbyChat instance;

    public static TabbyChat getInstance() {
        return instance;
    }

    public static TabbyChat getInstance(GuiNewChatTC gncInstance) {
        if (instance == null) {
            instance = new TabbyChat(gncInstance);
        }
        return instance;
    }

    public static String getNewestVersion() {
        String updateURL = liteLoaded ? "http://tabbychat.port0.org/tabbychat/current_version.php?type=LL&mc=" + mcversion : "http://tabbychat.port0.org/tabbychat/current_version.php?mc=" + mcversion;
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(updateURL).openConnection();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String newestVersion = buffer.readLine();
            buffer.close();
            return newestVersion;
        }
        catch (Throwable e) {
            TabbyChat.printErr("Unable to check for TabbyChat update.");
            return version;
        }
    }

    public static void printErr(String err) {
        System.err.println("[TabbyChat] " + err);
        mc.an().b("[TABBYCHAT] " + err);
    }

    public static void printException(String err, Exception e) {
        System.err.println("[TabbyChat] " + err);
        mc.an().b("[TABBYCHAT] " + err, (Throwable)e);
    }

    public static void printMessageToChat(String msg) {
        if (instance == null) {
            return;
        }
        if (!TabbyChat.instance.channelMap.containsKey("TabbyChat")) {
            TabbyChat.instance.channelMap.put("TabbyChat", new ChatChannel("TabbyChat"));
        }
        boolean firstLine = true;
        List split = TabbyChat.mc.l.c(msg, ChatBox.current.width);
        for (String splitMsg : split) {
            if (firstLine) {
                instance.addToChannel("TabbyChat", new TCChatLine(TabbyChat.mc.r.c(), splitMsg, 0, true), false);
            } else {
                instance.addToChannel("TabbyChat", new TCChatLine(TabbyChat.mc.r.c(), " " + splitMsg, 0, true), false);
            }
            firstLine = false;
        }
    }

    private TabbyChat(GuiNewChatTC gncInstance) {
        mc = atv.w();
        gnc = gncInstance;
        translator = new TCTranslate(TabbyChat.mc.u.an);
        generalSettings = new TCSettingsGeneral(this);
        serverSettings = new TCSettingsServer(this);
        filterSettings = new TCSettingsFilters(this);
        advancedSettings = new TCSettingsAdvanced(this);
        generalSettings.loadSettingsFile();
        advancedSettings.loadSettingsFile();
        defaultUnicode = TabbyChat.mc.l.a();
    }

    public void activateIndex(int ind) {
        List<String> actives = this.getActive();
        if (actives.size() == 1) {
            int i = 1;
            for (ChatChannel chan : this.channelMap.values()) {
                if (i == ind) {
                    if (TabbyChat.mc.n instanceof GuiChatTC) {
                        ((GuiChatTC)TabbyChat.mc.n).checkCommandPrefixChange(this.channelMap.get(actives.get(0)), chan);
                    }
                    this.resetDisplayedChat();
                    return;
                }
                ++i;
            }
        }
    }

    public void activateNext() {
        List<String> actives = this.getActive();
        if (actives.size() == 1) {
            Iterator<ChatChannel> iter = this.channelMap.values().iterator();
            ChatChannel chan = iter.next();
            while (iter.hasNext()) {
                if (chan.getTitle().equals(actives.get(0))) {
                    if (TabbyChat.mc.n instanceof GuiChatTC) {
                        ((GuiChatTC)TabbyChat.mc.n).checkCommandPrefixChange(chan, iter.next());
                    }
                    this.resetDisplayedChat();
                    return;
                }
                chan = iter.next();
            }
            if (chan.getTitle().equals(actives.get(0))) {
                iter = this.channelMap.values().iterator();
                if (iter.hasNext() && TabbyChat.mc.n instanceof GuiChatTC) {
                    ((GuiChatTC)TabbyChat.mc.n).checkCommandPrefixChange(chan, iter.next());
                }
                this.resetDisplayedChat();
            }
        }
    }

    public void activatePrev() {
        List<String> actives = this.getActive();
        if (actives.size() == 1) {
            ChatChannel chan;
            ListIterator<ChatChannel> iter = new ArrayList<ChatChannel>(this.channelMap.values()).listIterator(this.channelMap.size());
            ChatChannel last = chan = iter.previous();
            while (iter.hasPrevious()) {
                if (chan.getTitle().equals(actives.get(0))) {
                    if (TabbyChat.mc.n instanceof GuiChatTC) {
                        ((GuiChatTC)TabbyChat.mc.n).checkCommandPrefixChange(chan, iter.previous());
                    }
                    this.resetDisplayedChat();
                    return;
                }
                chan = iter.previous();
            }
            if (chan.getTitle().equals(actives.get(0))) {
                chan.active = false;
                iter = new ArrayList<ChatChannel>(this.channelMap.values()).listIterator(this.channelMap.size());
                if (iter.hasPrevious() && TabbyChat.mc.n instanceof GuiChatTC) {
                    ((GuiChatTC)TabbyChat.mc.n).checkCommandPrefixChange(chan, iter.previous());
                }
                this.resetDisplayedChat();
            }
        }
    }

    private void addOptionalTimeStamp(List<TCChatLine> orig) {
        for (TCChatLine line : orig) {
            line.timeStamp = this.getTimeStamp();
        }
    }

    public void addToChannel(String _name, List<TCChatLine> thisChat, boolean visible) {
        block3: {
            block2: {
                ChatChannel theChan = this.channelMap.get(_name);
                if (theChan == null || !TabbyChat.generalSettings.groupSpam.getValue().booleanValue()) break block2;
                this.spamCheck(theChan, thisChat);
                if (theChan.hasSpam) break block3;
                for (TCChatLine cl : thisChat) {
                    this.addToChannel(_name, cl, visible);
                }
                break block3;
            }
            for (TCChatLine cl : thisChat) {
                this.addToChannel(_name, cl, visible);
            }
        }
    }

    public void addToChannel(String name, TCChatLine thisChat, boolean visible) {
        if (TabbyChat.serverSettings.ignoredChanList.contains(name)) {
            return;
        }
        ChatChannel theChan = this.channelMap.get(name);
        if (theChan == null) {
            if (this.channelMap.size() >= 20) {
                return;
            }
            theChan = new ChatChannel(name);
            this.channelMap.put(name, theChan);
            if (TabbyChat.mc.n instanceof GuiChatTC) {
                ((GuiChatTC)TabbyChat.mc.n).addChannelLive(theChan);
            }
        }
        theChan.addChat(thisChat, visible);
        theChan.trimLog();
    }

    public boolean channelExists(String name) {
        return this.channelMap.get(name) != null;
    }

    public void checkServer() {
        if (!updateChecked) {
            updateChecked = true;
            BackgroundUpdateCheck buc = new BackgroundUpdateCheck();
            buc.start();
        }
        if (!TabbyChat.serverSettings.serverIP.equals(TabbyChatUtils.getServerIp())) {
            this.storeChannelData();
            this.channelMap.clear();
            if (this.enabled()) {
                this.enable();
                this.resetDisplayedChat();
            } else {
                this.disable();
            }
        }
    }

    public void createNewChannel(String name) {
        if (this.channelExists(name)) {
            return;
        }
        if (name == null || name.length() <= 0 || this.channelMap.size() >= 20) {
            return;
        }
        this.channelMap.put(name, new ChatChannel(name));
    }

    public void disable() {
        this.channelMap.clear();
        this.channelMap.put("*", new ChatChannel("*"));
    }

    public void enable() {
        if (!this.channelMap.containsKey("*")) {
            this.channelMap.put("*", new ChatChannel("*"));
            this.channelMap.get((Object)"*").active = true;
        }
        if (firstRun) {
            firstRun = false;
            return;
        }
        this.serverDataLock.tryAcquire();
        this.updateChanDataPath(false);
        serverSettings.updateForServer();
        filterSettings.updateForServer();
        this.reloadServerData();
        this.reloadSettingsData(false);
        if (TabbyChat.serverSettings.serverIP.length() > 0) {
            this.loadPMPatterns();
        }
        this.serverDataLock.release();
        if (TabbyChat.generalSettings.saveChatLog.getValue().booleanValue() && TabbyChat.serverSettings.serverIP != null) {
            TabbyChatUtils.logChat("\nBEGIN CHAT LOGGING FOR " + TabbyChat.serverSettings.serverIP + " -- " + new SimpleDateFormat().format(Calendar.getInstance().getTime()));
        }
    }

    public boolean enabled() {
        return TabbyChat.generalSettings.tabbyChatEnable.getValue();
    }

    protected void finalize() {
        this.storeChannelData();
    }

    public List<String> getActive() {
        int n = this.channelMap.size();
        ArrayList<String> actives = new ArrayList<String>(n);
        for (ChatChannel chan : this.channelMap.values()) {
            if (!chan.active) continue;
            actives.add(chan.getTitle());
        }
        return actives;
    }

    private String getCleanTimeStamp() {
        return ma.a((String)this.getTimeStamp());
    }

    private String getTimeStamp() {
        return TabbyChat.generalSettings.timeStamp.format(Calendar.getInstance().getTime());
    }

    protected void loadChannelData() {
        LinkedHashMap importData = null;
        if (!chanDataFile.exists()) {
            return;
        }
        FileInputStream cFileStream = null;
        BufferedInputStream cBuffStream = null;
        ObjectInputStream cObjStream = null;
        try {
            cFileStream = new FileInputStream(chanDataFile);
            cBuffStream = new BufferedInputStream(cFileStream);
            cObjStream = new ObjectInputStream(cBuffStream);
            importData = (LinkedHashMap)cObjStream.readObject();
            cObjStream.close();
            cBuffStream.close();
        }
        catch (Exception e) {
            TabbyChat.printErr("Unable to read channel data file : '" + e.getLocalizedMessage() + "' : " + e.toString());
            return;
        }
        if (importData == null) {
            return;
        }
        int oldIDs = 0;
        try {
            for (Map.Entry chan : importData.entrySet()) {
                if (((String)chan.getKey()).contentEquals("TabbyChat")) continue;
                ChatChannel _new = null;
                if (!this.channelMap.containsKey(chan.getKey())) {
                    _new = new ChatChannel((String)chan.getKey());
                    _new.chanID = ((ChatChannel)chan.getValue()).chanID;
                    this.channelMap.put(_new.getTitle(), _new);
                } else {
                    _new = this.channelMap.get(chan.getKey());
                }
                _new.setAlias(((ChatChannel)chan.getValue()).getAlias());
                _new.active = ((ChatChannel)chan.getValue()).active;
                _new.notificationsOn = ((ChatChannel)chan.getValue()).notificationsOn;
                _new.hidePrefix = ((ChatChannel)chan.getValue()).hidePrefix;
                _new.cmdPrefix = ((ChatChannel)chan.getValue()).cmdPrefix;
                this.addToChannel((String)chan.getKey(), new TCChatLine(-1, "-- chat history from " + new SimpleDateFormat().format(chanDataFile.lastModified()), 0, true), true);
                _new.importOldChat((ChatChannel)chan.getValue());
                ++oldIDs;
            }
        }
        catch (ClassCastException e) {
            TabbyChat.printMessageToChat("Unable to load channel history data due to upgrade (sorry!)");
        }
        ChatChannel.nextID = 3600 + oldIDs;
        this.resetDisplayedChat();
    }

    protected void loadPatterns() {
        ChannelDelimEnum delims = (ChannelDelimEnum)TabbyChat.serverSettings.delimiterChars.getValue();
        String colCode = "";
        String fmtCode = "";
        if (TabbyChat.serverSettings.delimColorBool.getValue().booleanValue()) {
            colCode = ((ColorCodeEnum)TabbyChat.serverSettings.delimColorCode.getValue()).toCode();
        }
        if (TabbyChat.serverSettings.delimFormatBool.getValue().booleanValue()) {
            fmtCode = ((FormatCodeEnum)TabbyChat.serverSettings.delimFormatCode.getValue()).toCode();
        }
        String frmt = colCode + fmtCode;
        if (((ColorCodeEnum)TabbyChat.serverSettings.delimColorCode.getValue()).toString().equals("White")) {
            frmt = "(" + colCode + ")?" + fmtCode;
        } else if (frmt.length() > 7) {
            frmt = "[" + frmt + "]{2}";
        }
        if (frmt.length() > 0) {
            frmt = "(?i:" + frmt + ")";
        }
        if (frmt.length() == 0) {
            frmt = "(?i:\u00a7[0-9A-FK-OR])*";
        }
        this.chatChannelPatternDirty = Pattern.compile("^(\u00a7r)?" + frmt + "\\" + delims.open() + "([\\p{L}0-9_\u00a7]+)\\" + delims.close());
        this.chatChannelPatternClean = Pattern.compile("^\\" + delims.open() + "([\\p{L}0-9_]{1," + TabbyChat.advancedSettings.maxLengthChannelName.getValue() + "})\\" + delims.close());
    }

    protected void loadPMPatterns() {
        StringBuilder toMePM = new StringBuilder();
        StringBuilder fromMePM = new StringBuilder();
        toMePM.append("^\\[([\\p{L}\\p{N}_]{3,16})[ ]?\\-\\>[ ]?me\\]");
        fromMePM.append("^\\[me[ ]?\\-\\>[ ]?([\\p{L}\\p{N}_]{3,16})\\]");
        toMePM.append("|^From ([\\p{L}\\p{N}_]{3,16})[ ]?:");
        fromMePM.append("|^To ([\\p{L}\\p{N}_]{3,16})[ ]?:");
        toMePM.append("|^([\\p{L}\\p{N}_]{3,16}) whispers to you:");
        fromMePM.append("|^You whisper to ([\\p{L}\\p{N}_]{3,16}):");
        if (TabbyChat.mc.h != null && TabbyChat.mc.h.an() != null) {
            String me = TabbyChat.mc.h.an();
            toMePM.append("|^\\[([\\p{L}\\p{N}_]{3,16})[ ]?\\-\\>[ ]?").append(me).append("\\]");
            fromMePM.append("|^\\[").append(me).append("[ ]?\\-\\>[ ]?([\\p{L}\\p{N}_]{3,16})\\]");
        }
        this.chatPMtoMePattern = Pattern.compile(toMePM.toString());
        this.chatPMfromMePattern = Pattern.compile(fromMePM.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollForUnread(avk _gui, int _tick) {
        int _opacity = 0;
        int tickdiff = 50;
        this.lastChatReadLock.lock();
        try {
            if (this.lastChat != null && this.lastChat.size() > 0) {
                tickdiff = _tick - this.lastChat.get(0).b();
            }
        }
        finally {
            this.lastChatReadLock.unlock();
        }
        if (tickdiff < 50) {
            float var6 = TabbyChat.mc.u.r * 0.9f + 0.1f;
            double var10 = (double)tickdiff / 50.0;
            var10 = 1.0 - var10;
            if ((var10 *= 10.0) < 0.0) {
                var10 = 0.0;
            }
            if (var10 > 1.0) {
                var10 = 1.0;
            }
            var10 *= var10;
            _opacity = (int)(255.0 * var10);
            if ((_opacity = (int)((float)_opacity * var6)) <= 3) {
                return;
            }
            ChatBox.updateTabs(this.channelMap);
            for (ChatChannel chan : this.channelMap.values()) {
                if (!chan.unread || !chan.notificationsOn) continue;
                chan.unreadNotify(_gui, _opacity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChat(List<TCChatLine> theChat) {
        if (this.serverDataLock.availablePermits() == 0) {
            this.serverDataLock.acquireUninterruptibly();
            this.serverDataLock.release();
        }
        if (theChat.isEmpty()) {
            return;
        }
        ArrayList<String> toTabs = new ArrayList<String>(20);
        ArrayList<String> filterTabs = new ArrayList<String>(20);
        String channelTab = null;
        String pmTab = null;
        toTabs.add("*");
        String raw = TabbyChatUtils.chatLinesToString(theChat);
        String filtered = this.processChatForFilters(raw, filterTabs);
        String cleaned = ma.a((String)raw);
        if (TabbyChat.generalSettings.saveChatLog.getValue().booleanValue()) {
            TabbyChatUtils.logChat(this.getCleanTimeStamp() + cleaned);
        }
        if (filtered != null) {
            if (TabbyChat.serverSettings.autoChannelSearch.getValue().booleanValue()) {
                channelTab = this.processChatForChannels(cleaned, raw);
            }
            if (channelTab == null) {
                if (TabbyChat.serverSettings.autoPMSearch.getValue().booleanValue()) {
                    pmTab = this.processChatForPMs(cleaned);
                }
            } else {
                toTabs.add(channelTab);
            }
            toTabs.addAll(filterTabs);
        } else {
            filtered = raw;
        }
        List<TCChatLine> resultChatLine = TabbyChatUtils.stringToChatLines(theChat.get(0).b(), filtered, theChat.get(0).c(), theChat.get((int)0).statusMsg);
        this.addOptionalTimeStamp(resultChatLine);
        HashSet tabSet = new HashSet(toTabs);
        List<String> activeTabs = this.getActive();
        boolean visible = false;
        if (pmTab != null) {
            if (!this.channelMap.containsKey(pmTab)) {
                ChatChannel pm = new ChatChannel(pmTab);
                pm.cmdPrefix = "/msg " + pmTab;
                this.channelMap.put(pmTab, pm);
                this.addToChannel(pmTab, resultChatLine, false);
                if (TabbyChat.mc.n instanceof GuiChatTC) {
                    ((GuiChatTC)TabbyChat.mc.n).addChannelLive(pm);
                }
            } else if (this.channelMap.containsKey(pmTab)) {
                if (activeTabs.contains(pmTab)) {
                    visible = true;
                }
                this.addToChannel(pmTab, resultChatLine, visible);
            }
        }
        if (!visible) {
            Set tabUnion = (Set)tabSet.clone();
            tabUnion.retainAll(activeTabs);
            if (tabUnion.size() > 0) {
                visible = true;
            }
        }
        for (String tab : tabSet) {
            this.addToChannel(tab, resultChatLine, visible);
        }
        this.lastChatWriteLock.lock();
        try {
            this.lastChat = TabbyChat.generalSettings.groupSpam.getValue().booleanValue() && activeTabs.size() > 0 ? (toTabs.contains(activeTabs.get(0)) ? this.channelMap.get(activeTabs.get(0)).getChatLogSublistCopy(0, resultChatLine.size()) : resultChatLine) : resultChatLine;
        }
        finally {
            this.lastChatWriteLock.unlock();
        }
        this.lastChatReadLock.lock();
        try {
            if (visible) {
                if (TabbyChat.generalSettings.groupSpam.getValue().booleanValue() && this.channelMap.get((Object)activeTabs.get((int)0)).hasSpam) {
                    gnc.setChatLines(0, new ArrayList<TCChatLine>(this.lastChat));
                } else {
                    gnc.addChatLines(0, new ArrayList<TCChatLine>(this.lastChat));
                }
            }
        }
        finally {
            this.lastChatReadLock.unlock();
        }
    }

    private String processChatForChannels(String clean, String raw) {
        boolean dirtyCheck;
        Matcher findChannelClean = this.chatChannelPatternClean.matcher(clean);
        Matcher findChannelDirty = this.chatChannelPatternDirty.matcher(raw);
        boolean bl = dirtyCheck = TabbyChat.serverSettings.delimColorBool.getValue() == false && TabbyChat.serverSettings.delimFormatBool.getValue() == false ? true : findChannelDirty.find();
        if (findChannelClean.find() && dirtyCheck) {
            return findChannelClean.group(1);
        }
        return null;
    }

    private String processChatForFilters(String chat, List<String> destinations) {
        boolean skip = false;
        Map.Entry<Integer, TCChatFilter> iFilter = TabbyChat.filterSettings.filterMap.firstEntry();
        while (iFilter != null) {
            if (iFilter.getValue().applyFilterToDirtyChat(chat)) {
                if (iFilter.getValue().removeMatches) {
                    destinations.clear();
                    skip = true;
                    break;
                }
                chat = iFilter.getValue().getLastMatchPretty();
                if (iFilter.getValue().sendToTabBool) {
                    if (iFilter.getValue().sendToAllTabs) {
                        for (ChatChannel chan : this.channelMap.values()) {
                            destinations.add(chan.getTitle());
                        }
                        continue;
                    }
                    String destTab = iFilter.getValue().getTabName();
                    if (destTab != null && destTab.length() > 0 && !destinations.contains(destTab)) {
                        destinations.add(destTab);
                    }
                }
                if (iFilter.getValue().audioNotificationBool) {
                    iFilter.getValue().audioNotification();
                }
            }
            iFilter = TabbyChat.filterSettings.filterMap.higherEntry(iFilter.getKey());
        }
        if (!skip) {
            return chat;
        }
        return null;
    }

    private String processChatForPMs(String chat) {
        block2: {
            Matcher findPMfromMe;
            block3: {
                if (this.chatPMtoMePattern == null) break block2;
                Matcher findPMtoMe = this.chatPMtoMePattern.matcher(chat);
                if (!findPMtoMe.find()) break block3;
                for (int i = 1; i <= findPMtoMe.groupCount(); ++i) {
                    if (findPMtoMe.group(i) == null) continue;
                    return findPMtoMe.group(i);
                }
                break block2;
            }
            if (this.chatPMfromMePattern == null || !(findPMfromMe = this.chatPMfromMePattern.matcher(chat)).find()) break block2;
            for (int i = 1; i <= findPMfromMe.groupCount(); ++i) {
                if (findPMfromMe.group(i) == null) continue;
                return findPMfromMe.group(i);
            }
        }
        return null;
    }

    private void reloadServerData() {
        serverSettings.loadSettingsFile();
        filterSettings.loadSettingsFile();
        this.loadChannelData();
    }

    public void reloadSettingsData(boolean withSave) {
        this.updateDefaults();
        this.loadPatterns();
        this.updateFilters();
        if (withSave) {
            this.storeChannelData();
        }
    }

    public void removeTab(String _name) {
        this.channelMap.remove(_name);
    }

    public void resetDisplayedChat() {
        gnc.clearChatLines();
        List<String> actives = this.getActive();
        if (actives.size() < 1) {
            return;
        }
        gnc.addChatLines(this.channelMap.get(actives.get(0)));
        int n = actives.size();
        for (int i = 1; i < n; ++i) {
            gnc.mergeChatLines(this.channelMap.get(actives.get(i)));
        }
    }

    private void spamCheck(ChatChannel theChan, List<TCChatLine> lastChat) {
        int i;
        String oldChat = "";
        String newChat = "";
        if (theChan.getChatLogSize() < lastChat.size() || lastChat.size() == 0) {
            theChan.hasSpam = false;
            theChan.spamCount = 1;
            return;
        }
        int _size = lastChat.size();
        for (i = 0; i < _size; ++i) {
            if (lastChat.get(i).a() == null || theChan.getChatLine(i).a() == null) continue;
            newChat = newChat + lastChat.get(i).a();
            oldChat = theChan.getChatLine(i).a() + oldChat;
        }
        if (theChan.hasSpam) {
            oldChat = oldChat.substring(0, oldChat.length() - 4 - Integer.toString(theChan.spamCount).length());
        }
        if (oldChat.equals(newChat)) {
            theChan.hasSpam = true;
            ++theChan.spamCount;
            for (i = 1; i < _size; ++i) {
                TCChatLine line = new TCChatLine(lastChat.get(0).b(), lastChat.get(lastChat.size() - i - 1).a(), lastChat.get(0).c());
                line.timeStamp = this.getTimeStamp();
                theChan.setChatLogLine(i, line);
            }
            TCChatLine line = new TCChatLine(lastChat.get(0).b(), lastChat.get(lastChat.size() - 1).a() + " [" + theChan.spamCount + "x]", lastChat.get(0).c());
            line.timeStamp = this.getTimeStamp();
            theChan.setChatLogLine(0, line);
        } else {
            theChan.hasSpam = false;
            theChan.spamCount = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeChannelData() {
        if (chanDataFile == null) {
            return;
        }
        if (!chanDataFile.getParentFile().exists()) {
            chanDataFile.getParentFile().mkdirs();
        }
        FileOutputStream cFileStream = null;
        FilterOutputStream cBuffStream = null;
        ObjectOutputStream cObjStream = null;
        try {
            cFileStream = new FileOutputStream(chanDataFile);
            cBuffStream = new BufferedOutputStream(cFileStream);
            cObjStream = new ObjectOutputStream(cBuffStream);
            cObjStream.writeObject(TabbyChat.instance.channelMap);
            cObjStream.flush();
        }
        catch (Exception e) {
            TabbyChat.printErr("Unable to write channel data to file : '" + e.getLocalizedMessage() + "' : " + e.toString());
        }
        finally {
            try {
                cObjStream.close();
                cBuffStream.close();
            }
            catch (Exception e) {}
        }
    }

    private void updateChanDataPath(boolean make) {
        String pName = "";
        if (TabbyChat.mc.h != null && TabbyChat.mc.h.an() != null) {
            pName = TabbyChat.mc.h.an();
        }
        File parentDir = TabbyChatUtils.getServerDir();
        if (make && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        chanDataFile = new File(parentDir, pName + "_chanData.ser");
    }

    protected void updateDefaults() {
        if (!TabbyChat.generalSettings.tabbyChatEnable.getValue().booleanValue()) {
            return;
        }
        ArrayList<String> dList = new ArrayList<String>(TabbyChat.serverSettings.defaultChanList);
        for (ChatChannel chan : this.channelMap.values()) {
            int ind = dList.indexOf(chan.getTitle());
            if (ind < 0) continue;
            dList.remove(ind);
        }
        for (String defChan : dList) {
            if (defChan.length() <= 0) continue;
            this.channelMap.put(defChan, new ChatChannel(defChan));
        }
    }

    protected void updateFilters() {
        if (!TabbyChat.generalSettings.tabbyChatEnable.getValue().booleanValue()) {
            return;
        }
        if (TabbyChat.filterSettings.filterMap.size() == 0) {
            return;
        }
        Map.Entry<Integer, TCChatFilter> iFilter = TabbyChat.filterSettings.filterMap.firstEntry();
        while (iFilter != null) {
            String newName = iFilter.getValue().sendToTabName;
            if (iFilter.getValue().sendToTabBool && !iFilter.getValue().sendToAllTabs && !this.channelMap.containsKey(newName) && !newName.startsWith("%")) {
                this.channelMap.put(newName, new ChatChannel(newName));
            }
            iFilter = TabbyChat.filterSettings.filterMap.higherEntry(iFilter.getKey());
        }
    }

    static {
        version = TabbyChatUtils.version;
        instance = null;
    }
}

