/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFWorld;

public class TFGenHugeCanopyTree
extends TFGenerator {
    private int treeBlock;
    private int treeMeta;
    private int branchMeta;
    private int leafBlock;
    private int leafMeta;
    private int rootBlock;
    private int rootMeta;

    public TFGenHugeCanopyTree() {
        this.treeBlock = TFBlocks.log.cF;
        this.treeMeta = 1;
        this.branchMeta = 13;
        this.leafBlock = TFBlocks.leaves.cF;
        this.leafMeta = 1;
        this.rootBlock = TFBlocks.root.cF;
        this.rootMeta = 0;
    }

    @Override
    public boolean a(abw world, Random random, int x, int y, int z2) {
        int blockUnder;
        int treeHeight = 35;
        if (random.nextInt(3) == 0) {
            treeHeight += random.nextInt(10);
            if (random.nextInt(8) == 0) {
                treeHeight += random.nextInt(10);
            }
        }
        if ((blockUnder = world.a(x, y - 1, z2)) != aqz.z.cF && blockUnder != aqz.A.cF || y >= TFWorld.MAXHEIGHT - treeHeight) {
            return false;
        }
        this.buildTrunk(world, x, y, z2, 0, treeHeight, 0.0, 0.0, true);
        int numBranches = 5 + random.nextInt(3);
        double offset = random.nextDouble();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(world, x, y, z2, treeHeight - 23 + (int)((double)b * 1.5), 17.0, 0.3 * (double)b + offset, 0.25);
        }
        int numRoots = 4 + random.nextInt(3);
        offset = random.nextDouble();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, x, y, z2, offset, b);
        }
        return true;
    }

    void buildBranch(abw world, int x, int y, int z2, int height, double length, double angle, double tilt) {
        int[] src = new int[]{x, y + height, z2};
        int[] dest = TFGenHugeCanopyTree.translate(src[0], src[1], src[2], length, angle, tilt);
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, this.branchMeta, true);
        this.drawBresehnam(world, src[0], src[1] - 1, src[2], dest[0], dest[1] - 1, dest[2], this.treeBlock, this.branchMeta, true);
        this.makeLeafNode(world, dest);
    }

    protected void makeLeafNode(abw world, int[] dest) {
        this.drawBresehnam(world, dest[0], dest[1], dest[2], dest[0] + 4, dest[1], dest[2] + 0, this.treeBlock, this.branchMeta, true);
        this.drawBresehnam(world, dest[0], dest[1], dest[2], dest[0] - 4, dest[1], dest[2] + 0, this.treeBlock, this.branchMeta, true);
        this.drawBresehnam(world, dest[0], dest[1], dest[2], dest[0] + 0, dest[1], dest[2] + 4, this.treeBlock, this.branchMeta, true);
        this.drawBresehnam(world, dest[0], dest[1], dest[2], dest[0] + 0, dest[1], dest[2] - 4, this.treeBlock, this.branchMeta, true);
        this.putBlockAndMetadata(world, dest[0] + 5, dest[1], dest[2] + 1, this.treeBlock, this.branchMeta, true);
        this.putBlockAndMetadata(world, dest[0] + 5, dest[1], dest[2] - 1, this.treeBlock, this.branchMeta, true);
        this.putBlockAndMetadata(world, dest[0] - 5, dest[1], dest[2] + 1, this.treeBlock, this.branchMeta, true);
        this.putBlockAndMetadata(world, dest[0] - 5, dest[1], dest[2] - 1, this.treeBlock, this.branchMeta, true);
        this.putBlockAndMetadata(world, dest[0] + 1, dest[1], dest[2] + 5, this.treeBlock, this.branchMeta, true);
        this.putBlockAndMetadata(world, dest[0] - 1, dest[1], dest[2] + 5, this.treeBlock, this.branchMeta, true);
        this.putBlockAndMetadata(world, dest[0] + 1, dest[1], dest[2] - 5, this.treeBlock, this.branchMeta, true);
        this.putBlockAndMetadata(world, dest[0] - 1, dest[1], dest[2] - 5, this.treeBlock, this.branchMeta, true);
        this.drawBresehnam(world, dest[0] + 1, dest[1], dest[2] + 0, dest[0] + 4, dest[1], dest[2] + 3, this.treeBlock, this.branchMeta, true);
        this.drawBresehnam(world, dest[0] - 1, dest[1], dest[2] + 0, dest[0] - 4, dest[1], dest[2] - 3, this.treeBlock, this.branchMeta, true);
        this.drawBresehnam(world, dest[0] + 0, dest[1], dest[2] + 1, dest[0] - 3, dest[1], dest[2] + 4, this.treeBlock, this.branchMeta, true);
        this.drawBresehnam(world, dest[0] + 0, dest[1], dest[2] - 1, dest[0] + 3, dest[1], dest[2] - 4, this.treeBlock, this.branchMeta, true);
        this.drawCircle(world, dest[0], dest[1] - 2, dest[2], 4, this.leafBlock, this.leafMeta, false);
        this.drawCircle(world, dest[0], dest[1] - 1, dest[2], 7, this.leafBlock, this.leafMeta, false);
        this.drawCircle(world, dest[0], dest[1], dest[2], 8, this.leafBlock, this.leafMeta, false);
        this.drawCircle(world, dest[0], dest[1] + 1, dest[2], 6, this.leafBlock, this.leafMeta, false);
        this.drawCircle(world, dest[0], dest[1] + 2, dest[2], 3, this.leafBlock, this.leafMeta, false);
    }

    void buildTrunk(abw world, int x, int y, int z2, int height, double length, double angle, double tilt, boolean firefly) {
        int[] src = new int[]{x, y + height, z2};
        int[] dest = TFGenHugeCanopyTree.translate(src[0], src[1], src[2], length, angle, tilt);
        for (int dy = -6; dy < 0; ++dy) {
            this.drawRootBlock(world, x, y + dy, z2);
            this.drawRootBlock(world, x + 1, y + dy, z2);
            this.drawRootBlock(world, x, y + dy, z2 + 1);
            this.drawRootBlock(world, x + 1, y + dy, z2 + 1);
        }
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, this.treeMeta, true);
        this.drawBresehnam(world, src[0] + 1, src[1], src[2], dest[0] + 1, dest[1], dest[2], this.treeBlock, this.treeMeta, true);
        this.drawBresehnam(world, src[0] + 1, src[1], src[2] + 1, dest[0] + 1, dest[1], dest[2] + 1, this.treeBlock, this.treeMeta, true);
        this.drawBresehnam(world, src[0], src[1], src[2] + 1, dest[0], dest[1], dest[2] + 1, this.treeBlock, this.treeMeta, true);
        this.makeLeafNode(world, dest);
    }

    private void drawRootBlock(abw world, int dx, int dy, int dz) {
        if (this.hasAirAround((acf)world, dx, dy, dz)) {
            this.a(world, dx, dy, dz, this.treeBlock, this.branchMeta);
        } else {
            this.a(world, dx, dy, dz, this.rootBlock, this.rootMeta);
        }
    }

    private void buildRoot(abw world, int x, int y, int z2, double offset, int b) {
        int[] dest = TFGenHugeCanopyTree.translate(x, y - b - 2, z2, 8.0, 0.278 * (double)b + offset, 0.8);
        this.drawRoot(world, x, y - b - 2, z2, dest[0], dest[1], dest[2]);
    }

    protected void drawRoot(abw world, int sx, int sy, int sz, int dx, int dy, int dz) {
        if (world.g(dx, dy, dz).a()) {
            this.drawBresehnam(world, sx, sy, sz, dx, dy, dz, this.rootBlock, this.rootMeta, true);
        } else {
            int[] lineArray = TFGenHugeCanopyTree.getBresehnamArray(sx, sy, sz, dx, dy, dz);
            for (int i = 0; i < lineArray.length; i += 3) {
                if (world.a(lineArray[i + 0], lineArray[i + 1], lineArray[i + 2]) <= 0 && !TFGenHugeCanopyTree.isNearSolid((acf)world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2])) continue;
                this.a(world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2], this.rootBlock, this.rootMeta);
            }
        }
    }
}

