/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.lichtower;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import twilightforest.TFTreasure;
import twilightforest.entity.TFCreatures;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.lichtower.ComponentTFTowerBeard;
import twilightforest.structures.lichtower.ComponentTFTowerBeardAttached;
import twilightforest.structures.lichtower.ComponentTFTowerBridge;
import twilightforest.structures.lichtower.ComponentTFTowerRoof;
import twilightforest.structures.lichtower.ComponentTFTowerRoofAttachedSlab;
import twilightforest.structures.lichtower.ComponentTFTowerRoofFence;
import twilightforest.structures.lichtower.ComponentTFTowerRoofGableForwards;
import twilightforest.structures.lichtower.ComponentTFTowerRoofPointyOverhang;
import twilightforest.structures.lichtower.ComponentTFTowerRoofSlab;
import twilightforest.structures.lichtower.ComponentTFTowerRoofSlabForwards;
import twilightforest.structures.lichtower.ComponentTFTowerRoofStairs;
import twilightforest.structures.lichtower.ComponentTFTowerRoofStairsOverhang;

public class ComponentTFTowerWing
extends StructureTFComponent {
    public int size;
    protected int height;
    protected Class roofType;
    protected ArrayList<t> openings = new ArrayList();
    protected int highestOpening;
    protected boolean[] openingTowards;

    protected ComponentTFTowerWing(int i, int x, int y, int z2, int pSize, int pHeight, int direction) {
        super(i);
        this.size = pSize;
        this.height = pHeight;
        this.setCoordBaseMode(direction);
        this.highestOpening = 0;
        this.openingTowards = new boolean[]{false, false, true, false};
        this.f = StructureTFComponent.getComponentToAddBoundingBox(x, y, z2, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, direction);
    }

    public void a(ait parent, List list, Random rand) {
        this.addOpening(0, 1, this.size / 2, 2);
        this.makeARoof(parent, list, rand);
        this.makeABeard(parent, list, rand);
        if (this.size > 4) {
            for (int i = 0; i < 4; ++i) {
                int[] dest;
                if (i == 2 || this.makeTowerWing(list, rand, 1, (dest = this.getValidOpening(rand, i))[0], dest[1], dest[2], this.size - 2, this.height - 4, i) || this.size <= 8 || this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], this.size - 4, this.height - 6, i)) continue;
                this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], this.size - 6, this.height - 12, i);
            }
        }
    }

    public boolean makeTowerWing(List list, Random rand, int index, int x, int y, int z2, int wingSize, int wingHeight, int rotation) {
        if (wingHeight < 6) {
            return false;
        }
        int direction = (this.getCoordBaseMode() + rotation) % 4;
        int[] dx = this.offsetTowerCoords(x, y, z2, wingSize, direction);
        if (rand.nextInt(6) == 0) {
            return this.makeBridge(list, rand, index, x, y, z2, wingSize, wingHeight, rotation);
        }
        ComponentTFTowerWing wing = new ComponentTFTowerWing(index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        ait intersect = ait.a((List)list, (agf)wing.f);
        if (intersect == null || intersect == this) {
            list.add(wing);
            wing.a(this, list, rand);
            this.addOpening(x, y, z2, rotation);
            return true;
        }
        if (rand.nextInt(3) > 0) {
            return this.makeBridge(list, rand, index, x, y, z2, wingSize, wingHeight, rotation);
        }
        return false;
    }

    protected boolean makeBridge(List list, Random rand, int index, int x, int y, int z2, int wingSize, int wingHeight, int rotation) {
        int direction = (this.getCoordBaseMode() + rotation) % 4;
        int[] dx = this.offsetTowerCoords(x, y, z2, 3, direction);
        if (wingSize == 3 && wingHeight > 10) {
            wingHeight = 6 + rand.nextInt(5);
        }
        ComponentTFTowerBridge bridge = new ComponentTFTowerBridge(index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        ait intersect = ait.a((List)list, (agf)bridge.f);
        if (intersect != null && intersect != this) {
            return false;
        }
        intersect = ait.a((List)list, (agf)bridge.getWingBB());
        if (intersect == null || intersect == this) {
            list.add(bridge);
            bridge.a(this, list, rand);
            this.addOpening(x, y, z2, rotation);
            return true;
        }
        return false;
    }

    public void addOpening(int dx, int dy, int dz, int direction) {
        this.openingTowards[direction] = true;
        if (dy > this.highestOpening) {
            this.highestOpening = dy;
        }
        this.openings.add(new t(dx, dy, dz));
    }

    public void makeABeard(ait parent, List list, Random rand) {
        boolean attached = parent.c().b < this.f.b;
        int index = this.d();
        ComponentTFTowerBeard beard = attached ? new ComponentTFTowerBeardAttached(index + 1, this) : new ComponentTFTowerBeard(index + 1, this);
        list.add(beard);
        beard.a(this, list, rand);
    }

    public void makeARoof(ait parent, List list, Random rand) {
        boolean attached;
        boolean bl2 = attached = parent.c().e > this.f.e;
        if (attached) {
            this.makeAttachedRoof(list, rand);
        } else {
            this.makeFreestandingRoof(list, rand);
        }
    }

    protected void makeAttachedRoof(List list, Random rand) {
        ComponentTFTowerRoof roof;
        int index = this.d();
        if (this.roofType == null && rand.nextInt(32) != 0) {
            this.tryToFitRoof(list, rand, new ComponentTFTowerRoofGableForwards(index + 1, this));
        }
        if (this.roofType == null && rand.nextInt(8) != 0) {
            this.tryToFitRoof(list, rand, new ComponentTFTowerRoofSlabForwards(index + 1, this));
        }
        if (this.roofType == null && rand.nextInt(32) != 0) {
            roof = new ComponentTFTowerRoofAttachedSlab(index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new ComponentTFTowerRoofFence(index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
    }

    protected void tryToFitRoof(List list, Random rand, ComponentTFTowerRoof roof) {
        if (roof.fits(this, list, rand)) {
            list.add(roof);
            roof.a(this, list, rand);
            this.roofType = ((Object)((Object)roof)).getClass();
        }
    }

    protected void makeFreestandingRoof(List list, Random rand) {
        ComponentTFTowerRoof roof;
        int index = this.d();
        if (this.roofType == null && rand.nextInt(8) != 0) {
            roof = new ComponentTFTowerRoofPointyOverhang(index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new ComponentTFTowerRoofStairsOverhang(index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new ComponentTFTowerRoofStairs(index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null && rand.nextInt(53) != 0) {
            roof = new ComponentTFTowerRoofSlab(index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new ComponentTFTowerRoofFence(index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
    }

    public boolean a(abw world, Random rand, agf sbb) {
        this.a(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, false, rand, StructureTFComponent.getStrongholdStones());
        this.a(world, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        this.nullifySkyLightForBoundingBox(world);
        if (this.highestOpening > 1) {
            this.makeStairs(world, rand, sbb);
        }
        this.decorateThisTower(world, rand, sbb);
        this.makeWindows(world, rand, sbb, this.size < 4);
        this.makeOpenings(world, sbb);
        return true;
    }

    protected void makeOpeningMarkers(abw world, Random rand, int numMarkers, agf sbb) {
        if (this.size > 4) {
            int[] spot;
            int i;
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, 0);
                this.a(world, aqz.ag.cF, 0, spot[0], spot[1], spot[2], sbb);
            }
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, 1);
                this.a(world, aqz.ag.cF, 1, spot[0], spot[1], spot[2], sbb);
            }
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, 2);
                this.a(world, aqz.ag.cF, 2, spot[0], spot[1], spot[2], sbb);
            }
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, 3);
                this.a(world, aqz.ag.cF, 3, spot[0], spot[1], spot[2], sbb);
            }
        }
    }

    protected void decorateThisTower(abw world, Random rand, agf sbb) {
        Random decoRNG = new Random(world.H() + (long)(this.f.a * 321534781 * (this.f.c * 756839)));
        if (this.size > 3) {
            if (this.isDeadEnd()) {
                this.decorateDeadEnd(world, decoRNG, sbb);
            } else {
                this.decorateStairTower(world, decoRNG, sbb);
            }
        }
    }

    protected void decorateDeadEnd(abw world, Random rand, agf sbb) {
        int floors = (this.height - 1) / 5;
        int floorHeight = this.height / floors;
        for (int i = 1; i < floors; ++i) {
            for (int x = 1; x < this.size - 1; ++x) {
                for (int z2 = 1; z2 < this.size - 1; ++z2) {
                    this.a(world, aqz.C.cF, 2, x, i * floorHeight, z2, sbb);
                }
            }
        }
        if (floors > 1) {
            int ladderDir = 3;
            int downLadderDir = -1;
            this.decorateFloor(world, rand, 0, 1, floorHeight, ladderDir, -1, sbb);
            for (int i = 1; i < floors - 1; ++i) {
                int bottom = 1 + floorHeight * i;
                int top = floorHeight * (i + 1);
                downLadderDir = ladderDir++;
                this.decorateFloor(world, rand, i, bottom, top, ladderDir %= 4, downLadderDir, sbb);
            }
            this.decorateFloor(world, rand, floors, 1 + floorHeight * (floors - 1), this.height - 1, -1, ladderDir, sbb);
        } else {
            this.decorateFloor(world, rand, 0, 1, this.height - 1, -1, -1, sbb);
        }
    }

    protected void decorateFloor(abw world, Random rand, int floor, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        int dy;
        int dz;
        int dx;
        int meta;
        if (ladderUpDir > -1) {
            meta = this.getLadderMeta(ladderUpDir);
            dx = this.getLadderX(ladderUpDir);
            dz = this.getLadderZ(ladderUpDir);
            for (dy = bottom; dy < top; ++dy) {
                this.a(world, aqz.aK.cF, meta, dx, dy, dz, sbb);
            }
        }
        if (ladderDownDir > -1) {
            meta = this.getLadderMeta(ladderDownDir);
            dx = this.getLadderX(ladderDownDir);
            dz = this.getLadderZ(ladderDownDir);
            for (dy = bottom - 1; dy < bottom + 2; ++dy) {
                this.a(world, aqz.aK.cF, meta, dx, dy, dz, sbb);
            }
        }
        if (rand.nextInt(7) == 0 && ladderDownDir == -1) {
            this.decorateWell(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(7) == 0 && ladderDownDir == -1) {
            this.decorateSkeletonRoom(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(6) == 0 && ladderDownDir == -1) {
            this.decorateZombieRoom(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(5) == 0 && ladderDownDir == -1) {
            this.decorateCactusRoom(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(4) == 0 && ladderDownDir > -1) {
            this.decorateTreasureChest(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(5) == 0) {
            this.decorateSpiderWebs(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(12) == 0 && ladderDownDir > -1) {
            this.decorateSolidRock(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(3) == 0) {
            this.decorateFullLibrary(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else {
            this.decorateLibrary(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        }
    }

    protected void decorateWell(abw world, Random rand, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        int waterOrLava;
        int cx;
        int cz = cx = this.size / 2;
        int cy = bottom;
        int n = waterOrLava = rand.nextInt(4) == 0 ? aqz.I.cF : aqz.G.cF;
        if (this.size > 5) {
            this.a(world, aqz.br.cF, 0, cx - 1, cy + 0, cz - 1, sbb);
            this.a(world, aqz.ap.cF, 5, cx - 1, cy + 1, cz - 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 0, cy + 0, cz - 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 1, cy + 0, cz - 1, sbb);
            this.a(world, aqz.ap.cF, 5, cx + 1, cy + 1, cz - 1, sbb);
            this.a(world, aqz.br.cF, 0, cx - 1, cy + 0, cz + 0, sbb);
            this.a(world, waterOrLava, 0, cx + 0, cy + 0, cz + 0, sbb);
            this.a(world, aqz.br.cF, 0, cx + 1, cy + 0, cz + 0, sbb);
            this.a(world, aqz.br.cF, 0, cx - 1, cy + 0, cz + 1, sbb);
            this.a(world, aqz.ap.cF, 5, cx - 1, cy + 1, cz + 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 0, cy + 0, cz + 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 1, cy + 0, cz + 1, sbb);
            this.a(world, aqz.ap.cF, 5, cx + 1, cy + 1, cz + 1, sbb);
        }
        this.a(world, waterOrLava, 0, cx + 0, cy - 1, cz + 0, sbb);
    }

    protected void decorateSkeletonRoom(abw world, Random rand, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        this.placeSpawnerAtCurrentPosition(world, rand, this.size / 2, bottom + 2, this.size / 2, "Skeleton", sbb);
        ArrayList<t> chainList = new ArrayList<t>();
        chainList.add(new t(this.size / 2, bottom + 2, this.size / 2));
        for (int i = 0; i < this.size + 2; ++i) {
            t chain = new t(2 + rand.nextInt(this.size - 4), this.height - 2, 2 + rand.nextInt(this.size - 4));
            if (this.chainCollides(chain, chainList)) continue;
            for (int dy = bottom; dy < top; ++dy) {
                this.a(world, aqz.bu.cF, 0, chain.a, dy, chain.c, sbb);
            }
            chainList.add(chain);
        }
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                if (dx != 1 && dx != this.size - 2 && dz != 1 && dz != this.size - 2 || this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir)) continue;
                this.a(world, aqz.ab.cF, 0, dx, top - 1, dz, sbb);
            }
        }
    }

    protected void decorateZombieRoom(abw world, Random rand, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        this.placeSpawnerAtCurrentPosition(world, rand, this.size / 2, bottom + 2, this.size / 2, "Zombie", sbb);
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                if (this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.nextInt(5) != 0) continue;
                this.a(world, aqz.ak.cF, 0, dx, bottom, dz, sbb);
            }
        }
        ArrayList<t> slabList = new ArrayList<t>();
        slabList.add(new t(this.size / 2, bottom + 2, this.size / 2));
        for (int i = 0; i < this.size - 1; ++i) {
            t slab = new t(2 + rand.nextInt(this.size - 4), this.height - 2, 2 + rand.nextInt(this.size - 4));
            if (this.chainCollides(slab, slabList)) continue;
            this.a(world, aqz.bu.cF, 0, slab.a, bottom + 0, slab.c, sbb);
            this.a(world, aqz.bT.cF, 2, slab.a, bottom + 1, slab.c, sbb);
            this.a(world, aqz.bh.cF, 0, slab.a, bottom + 2, slab.c, sbb);
            slabList.add(slab);
        }
    }

    protected void decorateCactusRoom(abw world, Random rand, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                this.a(world, aqz.J.cF, 0, dx, bottom - 1, dz, sbb);
                if (this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.nextInt(4) != 0) continue;
                this.a(world, aqz.ad.cF, 0, dx, bottom, dz, sbb);
            }
        }
        ArrayList<t> cactusList = new ArrayList<t>();
        cactusList.add(new t(this.size / 2, bottom + 2, this.size / 2));
        for (int i = 0; i < this.size + 12; ++i) {
            t cactus = new t(2 + rand.nextInt(this.size - 4), this.height - 2, 2 + rand.nextInt(this.size - 4));
            if (this.chainCollides(cactus, cactusList)) continue;
            for (int dy = bottom; dy < top; ++dy) {
                this.a(world, aqz.ba.cF, 0, cactus.a, dy, cactus.c, sbb);
            }
            cactusList.add(cactus);
        }
    }

    protected void decorateTreasureChest(abw world, Random rand, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        int cx;
        int cz = cx = this.size / 2;
        this.a(world, aqz.bC.cF, this.getStairMeta(1), cx + 0, bottom, cz - 1, sbb);
        this.a(world, aqz.bC.cF, this.getStairMeta(0), cx - 1, bottom, cz + 0, sbb);
        this.a(world, aqz.bC.cF, this.getStairMeta(2), cx + 1, bottom, cz + 0, sbb);
        this.a(world, aqz.bC.cF, this.getStairMeta(3), cx + 0, bottom, cz + 1, sbb);
        this.a(world, aqz.br.cF, 0, cx + 0, bottom, cz + 0, sbb);
        if (this.size > 5) {
            this.a(world, aqz.br.cF, 0, cx - 1, bottom, cz - 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 1, bottom, cz - 1, sbb);
            this.a(world, aqz.br.cF, 0, cx - 1, bottom, cz + 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 1, bottom, cz + 1, sbb);
        }
        this.a(world, aqz.bC.cF, this.getStairMeta(1) + 4, cx + 0, top - 1, cz - 1, sbb);
        this.a(world, aqz.bC.cF, this.getStairMeta(0) + 4, cx - 1, top - 1, cz + 0, sbb);
        this.a(world, aqz.bC.cF, this.getStairMeta(2) + 4, cx + 1, top - 1, cz + 0, sbb);
        this.a(world, aqz.bC.cF, this.getStairMeta(3) + 4, cx + 0, top - 1, cz + 1, sbb);
        this.a(world, aqz.br.cF, 0, cx + 0, top - 1, cz + 0, sbb);
        if (this.size > 5) {
            this.a(world, aqz.br.cF, 0, cx - 1, top - 1, cz - 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 1, top - 1, cz - 1, sbb);
            this.a(world, aqz.br.cF, 0, cx - 1, top - 1, cz + 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 1, top - 1, cz + 1, sbb);
        }
        if (this.size > 5) {
            for (int cy = bottom + 1; cy < top - 1; ++cy) {
                this.a(world, aqz.br.cF, 5, cx - 1, cy, cz - 1, sbb);
                this.a(world, aqz.br.cF, 5, cx + 1, cy, cz - 1, sbb);
                this.a(world, aqz.br.cF, 5, cx - 1, cy, cz + 1, sbb);
                this.a(world, aqz.br.cF, 5, cx + 1, cy, cz + 1, sbb);
            }
        }
        this.placeTreasureAtCurrentPosition(world, rand, cx + 0, bottom + 1, cz + 0, TFTreasure.tower_room, sbb);
        for (int i = 0; i < 4; ++i) {
        }
    }

    protected void decorateSpiderWebs(abw world, Random rand, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        for (int dy = bottom; dy < top; ++dy) {
            int chance = top - dy + 2;
            for (int dx = 1; dx <= this.size - 2; ++dx) {
                for (int dz = 1; dz <= this.size - 2; ++dz) {
                    if (this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.nextInt(chance) != 0) continue;
                    this.a(world, aqz.ab.cF, 0, dx, dy, dz, sbb);
                }
            }
        }
        if (rand.nextInt(5) == 0) {
            String spiderName;
            switch (rand.nextInt(4)) {
                case 3: {
                    spiderName = "CaveSpider";
                    break;
                }
                case 2: {
                    spiderName = TFCreatures.getSpawnerNameFor("Swarm Spider");
                    break;
                }
                case 1: {
                    spiderName = TFCreatures.getSpawnerNameFor("Hedge Spider");
                    break;
                }
                default: {
                    spiderName = "Spider";
                }
            }
            this.placeSpawnerAtCurrentPosition(world, rand, this.size / 2, bottom + 2, this.size / 2, spiderName, sbb);
        } else {
            this.decorateFurniture(world, rand, bottom, this.size - 2, sbb);
        }
    }

    protected void decorateFurniture(abw world, Random rand, int bottom, int freeSpace, agf sbb) {
        if (rand.nextInt(3) > 0) {
            this.a(world, aqz.be.cF, 0, this.size / 2, bottom, this.size / 2, sbb);
            this.a(world, aqz.aR.cF, 0, this.size / 2, bottom + 1, this.size / 2, sbb);
        }
        if (rand.nextInt(3) == 0 && freeSpace > 1) {
            this.a(world, aqz.cb.cF, this.getStairMeta(0), this.size / 2 + 1, bottom, this.size / 2, sbb);
        }
        if (rand.nextInt(3) == 0 && freeSpace > 1) {
            this.a(world, aqz.cb.cF, this.getStairMeta(1), this.size / 2, bottom, this.size / 2 + 1, sbb);
        }
        if (rand.nextInt(3) == 0 && freeSpace > 1) {
            this.a(world, aqz.cb.cF, this.getStairMeta(2), this.size / 2 - 1, bottom, this.size / 2, sbb);
        }
        if (rand.nextInt(3) == 0 && freeSpace > 1) {
            this.a(world, aqz.cb.cF, this.getStairMeta(3), this.size / 2, bottom, this.size / 2 - 1, sbb);
        }
    }

    protected void decorateSolidRock(abw world, Random rand, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        for (int dy = bottom; dy < top; ++dy) {
            for (int dx = 1; dx <= this.size - 2; ++dx) {
                for (int dz = 1; dz <= this.size - 2; ++dz) {
                    if (this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.nextInt(9) == 0) continue;
                    this.a(world, aqz.y.cF, 0, dx, dy, dz, sbb);
                }
            }
        }
    }

    protected void decorateLibrary(abw world, Random rand, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                for (int dy = bottom; dy < top - 1; ++dy) {
                    if (dx != 1 && dx != this.size - 2 && dz != 1 && dz != this.size - 2 || this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir)) continue;
                    this.a(world, aqz.as.cF, 0, dx, dy, dz, sbb);
                }
            }
        }
        if (rand.nextInt(2) == 0 && this.size > 5) {
            this.decorateLibraryTreasure(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        }
        if (rand.nextInt(2) == 0 && this.size > 5) {
            this.decorateFurniture(world, rand, bottom, this.size - 2, sbb);
        }
    }

    protected void decorateLibraryTreasure(abw world, Random rand, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        switch (rand.nextInt(4)) {
            default: {
                if (!this.isLadderPos(2, 1, ladderUpDir, ladderDownDir)) {
                    this.placeTreasureAtCurrentPosition(world, rand, 2, top - 2, 1, TFTreasure.tower_library, sbb);
                    break;
                }
            }
            case 1: {
                if (!this.isLadderPos(this.size - 2, 2, ladderUpDir, ladderDownDir)) {
                    this.placeTreasureAtCurrentPosition(world, rand, this.size - 2, top - 2, 2, TFTreasure.tower_library, sbb);
                    break;
                }
            }
            case 2: {
                if (!this.isLadderPos(this.size - 3, this.size - 2, ladderUpDir, ladderDownDir)) {
                    this.placeTreasureAtCurrentPosition(world, rand, this.size - 3, top - 2, this.size - 2, TFTreasure.tower_library, sbb);
                    break;
                }
            }
            case 3: {
                if (this.isLadderPos(1, this.size - 3, ladderUpDir, ladderDownDir)) break;
                this.placeTreasureAtCurrentPosition(world, rand, 1, top - 2, this.size - 3, TFTreasure.tower_library, sbb);
            }
        }
    }

    protected void decorateFullLibrary(abw world, Random rand, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                for (int dy = bottom; dy < top; ++dy) {
                    if (!(dx % 2 != 0 && (dz >= dx && dz <= this.size - dx - 1 || dz >= this.size - dx - 1 && dz <= dx)) && (dz % 2 == 0 || (dx < dz || dx > this.size - dz - 1) && (dx < this.size - dz - 1 || dx > dz)) || this.isWindowPos(dx, dy, dz) || this.isOpeningPos(dx, dy, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir)) continue;
                    this.a(world, aqz.as.cF, 0, dx, dy, dz, sbb);
                }
            }
        }
        if (rand.nextInt(2) == 0 && this.size > 5) {
            this.decorateLibraryTreasure(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        }
    }

    protected void decorateTrap(abw world, Random rand, int bottom, int top, int ladderUpDir, int ladderDownDir, agf sbb) {
        for (int dx = 2; dx <= this.size - 3; ++dx) {
            for (int dz = 2; dz <= this.size - 3; ++dz) {
                if (dx != 2 && dx != this.size - 3 && dz != 2 && dz != this.size - 3) continue;
                this.a(world, aqz.ar.cF, 0, dx, -1, dz, sbb);
            }
        }
        for (int dy = bottom - 2; dy < top - 2; ++dy) {
            this.a(world, aqz.ar.cF, 0, 1, dy, 1, sbb);
            this.a(world, aqz.ar.cF, 0, 1, dy, this.size - 2, sbb);
            this.a(world, aqz.ar.cF, 0, this.size - 2, dy, 1, sbb);
            this.a(world, aqz.ar.cF, 0, this.size - 2, dy, this.size - 2, sbb);
        }
    }

    protected boolean isWindowPos(int x, int z2) {
        if (x == 1 && z2 == this.size / 2) {
            return true;
        }
        if (x == this.size - 2 && z2 == this.size / 2) {
            return true;
        }
        if (x == this.size / 2 && z2 == 1) {
            return true;
        }
        return x == this.size / 2 && z2 == this.size - 2;
    }

    protected boolean isWindowPos(int x, int y, int z2) {
        int checkYDir = -1;
        if (x == 1 && z2 == this.size / 2) {
            checkYDir = 2;
        } else if (x == this.size - 2 && z2 == this.size / 2) {
            checkYDir = 0;
        } else if (x == this.size / 2 && z2 == 1) {
            checkYDir = 3;
        } else if (x == this.size / 2 && z2 == this.size - 2) {
            checkYDir = 1;
        }
        if (checkYDir > -1) {
            return !this.openingTowards[checkYDir] && (y == 2 || y == 3 || this.height > 8 && (y == this.height - 3 || y == this.height - 4));
        }
        return false;
    }

    protected boolean isOpeningPos(int x, int y, int z2) {
        for (t door : this.openings) {
            t inside = new t(door);
            if (inside.a == 0) {
                ++inside.a;
            } else if (inside.a == this.size - 1) {
                --inside.a;
            } else if (inside.c == 0) {
                ++inside.c;
            } else if (inside.c == this.size - 1) {
                --inside.c;
            }
            if (inside.a != x || inside.c != z2 || inside.b != y && inside.b + 1 != y) continue;
            return true;
        }
        return false;
    }

    protected boolean isLadderPos(int x, int z2, int ladderUpDir, int ladderDownDir) {
        if (x == this.getLadderX(ladderUpDir) && z2 == this.getLadderZ(ladderUpDir)) {
            return true;
        }
        return x == this.getLadderX(ladderDownDir) && z2 == this.getLadderZ(ladderDownDir);
    }

    protected int getLadderX(int ladderDir) {
        switch (ladderDir) {
            case 0: {
                return this.size - 2;
            }
            case 1: {
                return this.size / 2 + 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return this.size / 2 - 1;
            }
        }
        return this.size / 2;
    }

    protected int getLadderZ(int ladderDir) {
        switch (ladderDir) {
            case 0: {
                return this.size / 2 - 1;
            }
            case 1: {
                return this.size - 2;
            }
            case 2: {
                return this.size / 2 + 1;
            }
            case 3: {
                return 1;
            }
        }
        return this.size / 2;
    }

    protected void decorateStairTower(abw world, Random rand, agf sbb) {
        if (this.height - this.highestOpening > 8) {
            int base = this.highestOpening + 3;
            int floors = (this.height - base) / 5;
            int floorHeight = (this.height - base) / floors;
            for (int i = 0; i < floors; ++i) {
                for (int x = 1; x < this.size - 1; ++x) {
                    for (int z2 = 1; z2 < this.size - 1; ++z2) {
                        this.a(world, aqz.C.cF, 2, x, i * floorHeight + base, z2, sbb);
                    }
                }
            }
            int ladderDir = 3;
            int downLadderDir = -1;
            int meta = this.getLadderMeta(ladderDir);
            int dx = this.getLadderX(ladderDir);
            int dz = this.getLadderZ(ladderDir);
            for (int dy = 1; dy < 3; ++dy) {
                this.a(world, aqz.aK.cF, meta, dx, base - dy, dz, sbb);
            }
            for (int i = 0; i < floors - 1; ++i) {
                int bottom = base + 1 + floorHeight * i;
                int top = base + floorHeight * (i + 1);
                downLadderDir = ladderDir++;
                this.decorateFloor(world, rand, i, bottom, top, ladderDir %= 4, downLadderDir, sbb);
            }
            this.decorateFloor(world, rand, floors, base + 1 + floorHeight * (floors - 1), this.height - 1, -1, ladderDir, sbb);
            if (base > 8) {
                switch (rand.nextInt(4)) {
                    case 0: {
                        this.decorateChandelier(world, rand, base + 1, sbb);
                        break;
                    }
                    case 1: {
                        this.decorateHangingChains(world, rand, base + 1, sbb);
                        break;
                    }
                    case 2: {
                        this.decorateFloatingBooks(world, rand, base + 1, sbb);
                        break;
                    }
                    case 3: {
                        this.decorateFloatingVines(world, rand, base + 1, sbb);
                    }
                }
            }
        } else if (this.size > 5) {
            switch (rand.nextInt(4)) {
                case 0: {
                    this.decorateChandelier(world, rand, this.height, sbb);
                    break;
                }
                case 1: {
                    this.decorateHangingChains(world, rand, this.height, sbb);
                    break;
                }
                case 2: {
                    this.decorateFloatingBooks(world, rand, this.height, sbb);
                    break;
                }
                case 3: {
                    this.decorateFloatingVines(world, rand, this.height, sbb);
                }
            }
        } else if (this.size > 3) {
            switch (rand.nextInt(3)) {
                case 0: {
                    this.decorateHangingChains(world, rand, this.height, sbb);
                    break;
                }
                case 1: {
                    this.decorateFloatingBooks(world, rand, this.height, sbb);
                    break;
                }
                case 2: {
                    this.decorateFloatingVines(world, rand, this.height, sbb);
                }
            }
        }
        this.decorateStairFloor(world, rand, sbb);
    }

    protected void decorateStairFloor(abw world, Random rand, agf sbb) {
        if (this.size > 5) {
            if (rand.nextInt(3) == 0) {
                this.decorateStairWell(world, rand, sbb);
            } else if (rand.nextInt(3) > 0 || this.size >= 15) {
                this.decoratePlanter(world, rand, sbb);
            }
        }
    }

    protected void decorateChandelier(abw world, Random rand, int decoTop, agf sbb) {
        if (decoTop < 8 || this.size < 8) {
            return;
        }
        int cx = this.size / 2;
        int cy = decoTop - rand.nextInt(decoTop - 7) - 2;
        int cz = this.size / 2;
        this.a(world, aqz.be.cF, 0, cx + 0, cy + 0, cz + 0, sbb);
        this.a(world, aqz.be.cF, 0, cx - 1, cy + 0, cz + 0, sbb);
        this.a(world, aqz.be.cF, 0, cx + 1, cy + 0, cz + 0, sbb);
        this.a(world, aqz.be.cF, 0, cx + 0, cy + 0, cz - 1, sbb);
        this.a(world, aqz.be.cF, 0, cx + 0, cy + 0, cz + 1, sbb);
        this.a(world, aqz.be.cF, 0, cx + 0, cy + 1, cz + 0, sbb);
        this.a(world, aqz.av.cF, 0, cx - 1, cy + 1, cz + 0, sbb);
        this.a(world, aqz.av.cF, 0, cx + 1, cy + 1, cz + 0, sbb);
        this.a(world, aqz.av.cF, 0, cx + 0, cy + 1, cz - 1, sbb);
        this.a(world, aqz.av.cF, 0, cx + 0, cy + 1, cz + 1, sbb);
        for (int y = cy; y < decoTop - 1; ++y) {
            this.a(world, aqz.be.cF, 0, cx + 0, y, cz + 0, sbb);
        }
    }

    protected void decorateHangingChains(abw world, Random rand, int decoTop, agf sbb) {
        ArrayList<t> chainList = new ArrayList<t>();
        for (int i = 0; i < this.size + 2; ++i) {
            int filled = this.size < 15 ? 2 : 4;
            t chain = new t(filled + rand.nextInt(this.size - filled * 2), decoTop - 2, filled + rand.nextInt(this.size - filled * 2));
            if (this.chainCollides(chain, chainList)) continue;
            int length = 1 + rand.nextInt(decoTop - 7);
            this.decorateOneChain(world, rand, chain.a, decoTop, length, chain.c, sbb);
            chainList.add(chain);
        }
    }

    protected boolean chainCollides(t coords, List<t> list) {
        for (t existing : list) {
            if (coords.c == existing.c && Math.abs(coords.a - existing.a) <= 1) {
                return true;
            }
            if (coords.a != existing.a || Math.abs(coords.c - existing.c) > 1) continue;
            return true;
        }
        return false;
    }

    protected void decorateOneChain(abw world, Random rand, int dx, int decoTop, int length, int dz, agf sbb) {
        int ballMeta;
        int ballBlock;
        for (int y = 1; y <= length; ++y) {
            this.a(world, aqz.bu.cF, 0, dx, decoTop - y - 1, dz, sbb);
        }
        switch (rand.nextInt(10)) {
            case 0: {
                ballBlock = aqz.an.cF;
                ballMeta = 0;
                break;
            }
            case 1: {
                ballBlock = aqz.as.cF;
                ballMeta = 0;
                break;
            }
            case 2: {
                ballBlock = aqz.bg.cF;
                ballMeta = 0;
                break;
            }
            case 3: {
                ballBlock = aqz.bh.cF;
                ballMeta = 0;
                break;
            }
            case 4: {
                ballBlock = aqz.R.cF;
                ballMeta = 0;
                break;
            }
            case 5: {
                ballBlock = aqz.T.cF;
                ballMeta = 0;
                break;
            }
            case 6: {
                ballBlock = aqz.bq.cF;
                ballMeta = 2;
                break;
            }
            default: {
                ballBlock = aqz.bi.cF;
                ballMeta = 0;
            }
        }
        this.a(world, ballBlock, ballMeta, dx, decoTop - length - 2, dz, sbb);
    }

    protected void decorateFloatingBooks(abw world, Random rand, int decoTop, agf sbb) {
        ArrayList<t> shelfList = new ArrayList<t>();
        for (int i = 0; i < this.size + 2; ++i) {
            int top;
            int filled = this.size < 15 ? 2 : 4;
            t shelf = new t(filled + rand.nextInt(this.size - filled * 2), decoTop - 2, filled + rand.nextInt(this.size - filled * 2));
            if (this.chainCollides(shelf, shelfList)) continue;
            int bottom = 2 + rand.nextInt(decoTop - 7);
            for (int y = top = rand.nextInt(bottom - 1) + 2; y <= bottom; ++y) {
                this.a(world, aqz.as.cF, 0, shelf.a, decoTop - y, shelf.c, sbb);
            }
            shelfList.add(shelf);
        }
    }

    protected void decorateFloatingVines(abw world, Random rand, int decoTop, agf sbb) {
        ArrayList<t> mossList = new ArrayList<t>();
        for (int i = 0; i < this.size + 2; ++i) {
            int top;
            int filled = this.size < 15 ? 2 : 4;
            t moss = new t(filled + rand.nextInt(this.size - filled * 2), decoTop - 2, filled + rand.nextInt(this.size - filled * 2));
            if (this.chainCollides(moss, mossList)) continue;
            int bottom = 2 + rand.nextInt(decoTop - 7);
            for (int y = top = rand.nextInt(bottom - 1) + 2; y <= bottom; ++y) {
                this.a(world, aqz.at.cF, 0, moss.a, decoTop - y, moss.c, sbb);
                this.a(world, aqz.bz.cF, this.getVineMeta(2), moss.a + 1, decoTop - y, moss.c + 0, sbb);
                this.a(world, aqz.bz.cF, this.getVineMeta(0), moss.a - 1, decoTop - y, moss.c + 0, sbb);
                this.a(world, aqz.bz.cF, this.getVineMeta(3), moss.a + 0, decoTop - y, moss.c + 1, sbb);
                this.a(world, aqz.bz.cF, this.getVineMeta(1), moss.a + 0, decoTop - y, moss.c - 1, sbb);
            }
            mossList.add(moss);
        }
        for (int y = this.highestOpening + 3; y < decoTop - 1; ++y) {
            for (int x = 1; x < this.size - 1; ++x) {
                if (rand.nextInt(3) == 0) {
                    this.a(world, aqz.bz.cF, this.getVineMeta(3), x, y, 1, sbb);
                }
                if (rand.nextInt(3) != 0) continue;
                this.a(world, aqz.bz.cF, this.getVineMeta(1), x, y, this.size - 2, sbb);
            }
            for (int z2 = 1; z2 < this.size - 1; ++z2) {
                if (rand.nextInt(3) == 0) {
                    this.a(world, aqz.bz.cF, this.getVineMeta(2), 1, y, z2, sbb);
                }
                if (rand.nextInt(3) != 0) continue;
                this.a(world, aqz.bz.cF, this.getVineMeta(0), this.size - 2, y, z2, sbb);
            }
        }
    }

    protected int getVineMeta(int vineDir) {
        switch ((this.getCoordBaseMode() + vineDir) % 4) {
            case 0: {
                return 8;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    protected void decoratePlanter(abw world, Random rand, agf sbb) {
        int whatHappened;
        int wz;
        int wy;
        int wx;
        int planterMeta;
        int planterBlock;
        int cx;
        int cz = cx = this.size / 2;
        this.a(world, aqz.ap.cF, 0, cx + 0, 1, cz + 1, sbb);
        this.a(world, aqz.ap.cF, 0, cx + 0, 1, cz - 1, sbb);
        this.a(world, aqz.ap.cF, 0, cx + 1, 1, cz + 0, sbb);
        this.a(world, aqz.ap.cF, 0, cx - 1, 1, cz + 0, sbb);
        if (this.size > 7) {
            this.a(world, aqz.ao.cF, 0, cx - 1, 1, cz - 1, sbb);
            this.a(world, aqz.ao.cF, 0, cx + 1, 1, cz - 1, sbb);
            this.a(world, aqz.ao.cF, 0, cx + 1, 1, cz + 1, sbb);
            this.a(world, aqz.ao.cF, 0, cx - 1, 1, cz + 1, sbb);
        }
        this.a(world, aqz.z.cF, 0, cx + 0, 1, cz + 0, sbb);
        switch (rand.nextInt(6)) {
            case 0: {
                planterBlock = aqz.D.cF;
                planterMeta = 0;
                break;
            }
            case 1: {
                planterBlock = aqz.D.cF;
                planterMeta = 1;
                break;
            }
            case 2: {
                planterBlock = aqz.D.cF;
                planterMeta = 2;
                break;
            }
            case 3: {
                planterBlock = aqz.D.cF;
                planterMeta = 3;
                break;
            }
            case 4: {
                planterBlock = aqz.ak.cF;
                planterMeta = 0;
                break;
            }
            default: {
                planterBlock = aqz.al.cF;
                planterMeta = 0;
            }
        }
        this.a(world, planterBlock, planterMeta, cx + 0, 2, cz + 0, sbb);
        if (planterBlock == aqz.D.cF) {
            wx = this.a(cx, cz);
            wy = this.a(2);
            wz = this.b(cx, cz);
            ((aqi)aqz.D).d(world, wx, wy, wz, world.s);
        }
        if (planterBlock == aqz.ak.cF || planterBlock == aqz.al.cF) {
            wx = this.a(cx, cz);
            wy = this.a(2);
            wz = this.b(cx, cz);
            ((apj)aqz.s[planterBlock]).c(world, wx, wy, wz, world.s);
        }
        if ((whatHappened = this.a(world, cx + 0, 2, cz + 0, sbb)) == planterBlock || whatHappened == 0) {
            int potMeta = aoj.a((ye)new ye(planterBlock, 1, planterMeta));
            this.a(world, aqz.ch.cF, potMeta, cx + 0, 2, cz + 0, sbb);
        }
    }

    protected void decorateStairWell(abw world, Random rand, agf sbb) {
        int waterOrLava;
        int cx;
        int cz = cx = this.size / 2;
        int cy = 1;
        int n = waterOrLava = rand.nextInt(4) == 0 ? aqz.I.cF : aqz.G.cF;
        if (this.size > 7) {
            this.a(world, aqz.br.cF, 0, cx - 1, cy + 0, cz - 1, sbb);
            this.a(world, aqz.ap.cF, 5, cx - 1, cy + 1, cz - 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 0, cy + 0, cz - 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 1, cy + 0, cz - 1, sbb);
            this.a(world, aqz.ap.cF, 5, cx + 1, cy + 1, cz - 1, sbb);
            this.a(world, aqz.br.cF, 0, cx - 1, cy + 0, cz + 0, sbb);
            this.a(world, waterOrLava, 0, cx + 0, cy + 0, cz + 0, sbb);
            this.a(world, aqz.br.cF, 0, cx + 1, cy + 0, cz + 0, sbb);
            this.a(world, aqz.br.cF, 0, cx - 1, cy + 0, cz + 1, sbb);
            this.a(world, aqz.ap.cF, 5, cx - 1, cy + 1, cz + 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 0, cy + 0, cz + 1, sbb);
            this.a(world, aqz.br.cF, 0, cx + 1, cy + 0, cz + 1, sbb);
            this.a(world, aqz.ap.cF, 5, cx + 1, cy + 1, cz + 1, sbb);
        }
        this.a(world, waterOrLava, 0, cx + 0, cy - 1, cz + 0, sbb);
    }

    public boolean isDeadEnd() {
        return this.openings.size() == 1;
    }

    public boolean hasExitsOnAllWalls() {
        int exits = 0;
        for (int i = 0; i < 4; ++i) {
            exits += this.openingTowards[i] ? 1 : 0;
        }
        return exits == 4;
    }

    public boolean hasStairs() {
        return this.highestOpening > 1;
    }

    protected void makeOpenings(abw world, agf sbb) {
        for (t door : this.openings) {
            this.makeDoorOpening(world, door.a, door.b, door.c, sbb);
        }
    }

    protected void makeDoorOpening(abw world, int dx, int dy, int dz, agf sbb) {
        this.a(world, 0, 0, dx, dy + 0, dz, sbb);
        this.a(world, 0, 0, dx, dy + 1, dz, sbb);
        if (this.a(world, dx, dy + 2, dz, sbb) != 0) {
            this.a(world, aqz.ao.cF, 0, dx, dy + 2, dz, sbb);
        }
        if (dx == 0) {
            this.updateLight(world, dx - 1, dy + 0, dz);
            this.updateLight(world, dx - 1, dy + 1, dz);
        }
        if (dx == this.size - 1) {
            this.updateLight(world, dx + 1, dy + 0, dz);
            this.updateLight(world, dx + 1, dy + 1, dz);
        }
        if (dz == 0) {
            this.updateLight(world, dx, dy + 0, dz - 1);
            this.updateLight(world, dx, dy + 1, dz - 1);
        }
        if (dz == this.size - 1) {
            this.updateLight(world, dx, dy + 0, dz + 1);
            this.updateLight(world, dx, dy + 1, dz + 1);
        }
    }

    public void updateLight(abw world, int dx, int dy, int dz) {
        world.A(this.a(dx, dz), this.a(dy), this.b(dx, dz));
    }

    public int[] getValidOpening(Random rand, int direction) {
        int wLength = this.size - 2;
        int offset = 1;
        if (this.size == 15) {
            wLength = 11;
            offset = 2;
        }
        if (direction == 0 || direction == 2) {
            int rx = direction == 0 ? this.size - 1 : 0;
            int rz2 = offset + rand.nextInt(wLength);
            int ry2 = this.getYByStairs(rz2, rand, direction);
            return new int[]{rx, ry2, rz2};
        }
        if (direction == 1 || direction == 3) {
            int rx = offset + rand.nextInt(wLength);
            int rz3 = direction == 1 ? this.size - 1 : 0;
            int ry3 = this.getYByStairs(rx, rand, direction);
            return new int[]{rx, ry3, rz3};
        }
        return new int[]{0, 0, 0};
    }

    protected int getYByStairs(int rx, Random rand, int direction) {
        int rise = 1;
        int base = 0;
        if (this.size == 15) {
            rise = 10;
            int n = base = direction == 0 || direction == 2 ? 23 : 28;
        }
        if (this.size == 9) {
            rise = 6;
            int n = base = direction == 0 || direction == 2 ? 2 : 5;
        }
        if (this.size == 7) {
            rise = 4;
            int n = base = direction == 0 || direction == 2 ? 2 : 4;
        }
        if (this.size == 5) {
            rise = 4;
            switch (direction) {
                case 0: {
                    base = 3;
                    break;
                }
                case 1: {
                    base = 2;
                    break;
                }
                case 2: {
                    base = 5;
                    break;
                }
                case 3: {
                    base = 4;
                }
            }
        }
        int flights = (this.height - 6 - base) / rise + 1;
        if (base > 0 && flights > 0) {
            int flightChosen = rand.nextInt(flights);
            int dy = flightChosen * rise + base;
            dy = this.size == 15 ? (dy -= direction == 0 || direction == 3 ? (rx - 2) / 2 : (this.size - rx - 3) / 2) : (dy -= direction == 0 || direction == 3 ? (rx - 1) / 2 : (this.size - rx - 2) / 2);
            if (dy < 1) {
                dy = 1;
            }
            return dy;
        }
        return 0;
    }

    protected void makeWindows(abw world, Random rand, agf sbb, boolean real) {
        for (int i = 0; i < 4; ++i) {
            boolean realWindows = real && !this.openingTowards[i];
            this.makeWindowBlock(world, this.size - 1, 2, this.size / 2, i, sbb, realWindows);
            this.makeWindowBlock(world, this.size - 1, 3, this.size / 2, i, sbb, realWindows);
            this.makeWindowBase(world, this.size - 1, 1, this.size / 2, i, sbb);
            if (this.height <= 8) continue;
            this.makeWindowBlock(world, this.size - 1, this.height - 3, this.size / 2, i, sbb, realWindows);
            this.makeWindowBlock(world, this.size - 1, this.height - 4, this.size / 2, i, sbb, realWindows);
            this.makeWindowBase(world, this.size - 1, this.height - 5, this.size / 2, i, sbb);
        }
    }

    protected void makeWindowBlock(abw world, int x, int y, int z2, int rotation, agf sbb, boolean realWindows) {
        int temp = this.getCoordBaseMode();
        this.setCoordBaseMode((this.getCoordBaseMode() + rotation) % 4);
        int outside = this.a(world, x + 1, y, z2, sbb);
        int inside = this.a(world, x - 1, y, z2, sbb);
        if (realWindows && inside == 0 && outside == 0) {
            this.a(world, aqz.bv.cF, 0, x, y, z2, sbb);
        } else {
            this.a(world, aqz.B.cF, 0, x, y, z2, sbb);
        }
        this.setCoordBaseMode(temp);
    }

    protected void makeWindowBase(abw world, int x, int y, int z2, int rotation, agf sbb) {
        int temp = this.getCoordBaseMode();
        this.setCoordBaseMode((this.getCoordBaseMode() + rotation) % 4);
        this.a(world, aqz.ao.cF, 0, x, y, z2, sbb);
        this.setCoordBaseMode(temp);
    }

    protected boolean makeStairs(abw world, Random rand, agf sbb) {
        if (this.size == 15) {
            return this.makeStairs15(world, rand, sbb);
        }
        if (this.size == 9) {
            return this.makeStairs9(world, rand, sbb);
        }
        if (this.size == 7) {
            return this.makeStairs7(world, rand, sbb);
        }
        if (this.size == 5) {
            return this.makeStairs5(world, rand, sbb);
        }
        return false;
    }

    protected boolean makeStairs5(abw world, Random rand, agf sbb) {
        int rise = 1;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs5flight(world, rand, sbb, i * rise, 0 + i * 3, 2);
        }
        return true;
    }

    protected void makeStairs5flight(abw world, Random rand, agf sbb, int height, int rotation, int meta) {
        int temp = this.getCoordBaseMode();
        this.setCoordBaseMode((this.getCoordBaseMode() + rotation) % 4);
        int singleSlabBlock = meta == 0 ? aqz.ap.cF : aqz.bT.cF;
        int doubleSlabBlock = meta == 0 ? aqz.ao.cF : aqz.C.cF;
        this.a(world, singleSlabBlock, meta, 2, 1 + height, 3, sbb);
        this.a(world, doubleSlabBlock, meta, 3, 1 + height, 3, sbb);
        this.setCoordBaseMode(temp);
    }

    protected boolean makeStairs7(abw world, Random rand, agf sbb) {
        this.a(world, aqz.bT.cF, 2, 1, 1, 4, sbb);
        this.a(world, aqz.C.cF, 2, 1, 1, 5, sbb);
        this.a(world, aqz.ap.cF, 0, 5, 1, 2, sbb);
        this.a(world, aqz.ao.cF, 0, 5, 1, 1, sbb);
        int rise = 2;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs7flight(world, rand, sbb, 1 + i * rise, 0 + i * 3, 2);
            this.makeStairs7flight(world, rand, sbb, 1 + i * rise, 2 + i * 3, 0);
        }
        return true;
    }

    protected void makeStairs7flight(abw world, Random rand, agf sbb, int height, int rotation, int meta) {
        int temp = this.getCoordBaseMode();
        this.setCoordBaseMode((this.getCoordBaseMode() + rotation) % 4);
        int singleSlabBlock = meta == 0 ? aqz.ap.cF : aqz.bT.cF;
        int doubleSlabBlock = meta == 0 ? aqz.ao.cF : aqz.C.cF;
        this.a(world, singleSlabBlock, meta, 2, 1 + height, 5, sbb);
        this.a(world, doubleSlabBlock, meta, 3, 1 + height, 5, sbb);
        this.a(world, singleSlabBlock, meta, 4, 2 + height, 5, sbb);
        this.a(world, doubleSlabBlock, meta, 5, 2 + height, 5, sbb);
        this.setCoordBaseMode(temp);
    }

    protected boolean makeStairs9(abw world, Random rand, agf sbb) {
        this.a(world, aqz.bT.cF, 2, 1, 1, 6, sbb);
        this.a(world, aqz.C.cF, 2, 1, 1, 7, sbb);
        this.a(world, aqz.ap.cF, 0, 7, 1, 2, sbb);
        this.a(world, aqz.ao.cF, 0, 7, 1, 1, sbb);
        int rise = 3;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs9flight(world, rand, sbb, 1 + i * rise, 0 + i * 3, 2);
            this.makeStairs9flight(world, rand, sbb, 1 + i * rise, 2 + i * 3, 0);
        }
        return true;
    }

    protected void makeStairs9flight(abw world, Random rand, agf sbb, int height, int rotation, int meta) {
        int temp = this.getCoordBaseMode();
        this.setCoordBaseMode((this.getCoordBaseMode() + rotation) % 4);
        int singleSlabBlock = meta == 0 ? aqz.ap.cF : aqz.bT.cF;
        int doubleSlabBlock = meta == 0 ? aqz.ao.cF : aqz.C.cF;
        this.a(world, singleSlabBlock, meta, 2, 1 + height, 7, sbb);
        this.a(world, doubleSlabBlock, meta, 3, 1 + height, 7, sbb);
        this.a(world, singleSlabBlock, meta, 4, 2 + height, 7, sbb);
        this.a(world, doubleSlabBlock, meta, 5, 2 + height, 7, sbb);
        this.a(world, singleSlabBlock, meta, 6, 3 + height, 7, sbb);
        this.a(world, doubleSlabBlock, meta, 7, 3 + height, 7, sbb);
        this.setCoordBaseMode(temp);
    }

    protected boolean makeStairs15(abw world, Random rand, agf sbb) {
        this.a(world, aqz.bT.cF, 2, 1, 1, 9, sbb);
        this.a(world, aqz.bT.cF, 2, 2, 1, 9, sbb);
        this.a(world, aqz.C.cF, 2, 1, 1, 10, sbb);
        this.a(world, aqz.C.cF, 2, 2, 1, 10, sbb);
        this.a(world, aqz.bT.cF, 2, 1, 2, 11, sbb);
        this.a(world, aqz.bT.cF, 2, 2, 2, 11, sbb);
        this.a(world, aqz.C.cF, 2, 1, 2, 12, sbb);
        this.a(world, aqz.C.cF, 2, 2, 2, 12, sbb);
        this.a(world, aqz.C.cF, 2, 1, 2, 13, sbb);
        this.a(world, aqz.C.cF, 2, 2, 2, 13, sbb);
        this.a(world, aqz.C.cF, 2, 3, 2, 11, sbb);
        this.a(world, aqz.be.cF, 0, 3, 3, 11, sbb);
        this.a(world, aqz.be.cF, 0, 3, 4, 11, sbb);
        this.a(world, aqz.C.cF, 2, 3, 1, 10, sbb);
        this.a(world, aqz.be.cF, 0, 3, 2, 10, sbb);
        this.a(world, aqz.be.cF, 0, 3, 3, 10, sbb);
        this.a(world, aqz.C.cF, 2, 3, 1, 9, sbb);
        this.a(world, aqz.be.cF, 0, 3, 2, 9, sbb);
        this.a(world, aqz.ap.cF, 0, 13, 1, 5, sbb);
        this.a(world, aqz.ap.cF, 0, 12, 1, 5, sbb);
        this.a(world, aqz.ao.cF, 0, 13, 1, 4, sbb);
        this.a(world, aqz.ao.cF, 0, 12, 1, 4, sbb);
        this.a(world, aqz.ap.cF, 0, 13, 2, 3, sbb);
        this.a(world, aqz.ap.cF, 0, 12, 2, 3, sbb);
        this.a(world, aqz.ao.cF, 0, 13, 2, 2, sbb);
        this.a(world, aqz.ao.cF, 0, 12, 2, 2, sbb);
        this.a(world, aqz.ao.cF, 0, 13, 2, 1, sbb);
        this.a(world, aqz.ao.cF, 0, 12, 2, 1, sbb);
        this.a(world, aqz.ao.cF, 0, 11, 2, 3, sbb);
        this.a(world, aqz.be.cF, 0, 11, 3, 3, sbb);
        this.a(world, aqz.be.cF, 0, 11, 4, 3, sbb);
        this.a(world, aqz.ao.cF, 0, 11, 1, 4, sbb);
        this.a(world, aqz.be.cF, 0, 11, 2, 4, sbb);
        this.a(world, aqz.be.cF, 0, 11, 3, 4, sbb);
        this.a(world, aqz.ao.cF, 0, 11, 1, 5, sbb);
        this.a(world, aqz.be.cF, 0, 11, 2, 5, sbb);
        int rise = 5;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs15flight(world, rand, sbb, 2 + i * rise, 0 + i * 3, 2);
            this.makeStairs15flight(world, rand, sbb, 2 + i * rise, 2 + i * 3, 0);
        }
        return true;
    }

    protected void makeStairs15flight(abw world, Random rand, agf sbb, int height, int rotation, int meta) {
        int temp = this.getCoordBaseMode();
        this.setCoordBaseMode((this.getCoordBaseMode() + rotation) % 4);
        int singleSlabBlock = meta == 0 ? aqz.ap.cF : aqz.bT.cF;
        int doubleSlabBlock = meta == 0 ? aqz.ao.cF : aqz.C.cF;
        this.a(world, singleSlabBlock, meta, 3, 1 + height, 13, sbb);
        this.a(world, sbb, rand, 0.9f, 4, 1 + height, 13, doubleSlabBlock, meta);
        this.a(world, singleSlabBlock, meta, 5, 2 + height, 13, sbb);
        this.a(world, doubleSlabBlock, meta, 6, 2 + height, 13, sbb);
        this.a(world, singleSlabBlock, meta, 7, 3 + height, 13, sbb);
        this.a(world, doubleSlabBlock, meta, 8, 3 + height, 13, sbb);
        this.a(world, singleSlabBlock, meta, 9, 4 + height, 13, sbb);
        this.a(world, sbb, rand, 0.9f, 10, 4 + height, 13, doubleSlabBlock, meta);
        this.a(world, sbb, rand, 0.9f, 11, 5 + height, 13, singleSlabBlock, meta);
        this.a(world, doubleSlabBlock, meta, 12, 5 + height, 13, sbb);
        this.a(world, doubleSlabBlock, meta, 13, 5 + height, 13, sbb);
        this.a(world, sbb, rand, 0.9f, 3, 1 + height, 12, singleSlabBlock, meta);
        this.a(world, doubleSlabBlock, meta, 4, 1 + height, 12, sbb);
        this.a(world, singleSlabBlock, meta, 5, 2 + height, 12, sbb);
        this.a(world, doubleSlabBlock, meta, 6, 2 + height, 12, sbb);
        this.a(world, sbb, rand, 0.9f, 7, 3 + height, 12, singleSlabBlock, meta);
        this.a(world, doubleSlabBlock, meta, 8, 3 + height, 12, sbb);
        this.a(world, singleSlabBlock, meta, 9, 4 + height, 12, sbb);
        this.a(world, sbb, rand, 0.9f, 10, 4 + height, 12, doubleSlabBlock, meta);
        this.a(world, singleSlabBlock, meta, 11, 5 + height, 12, sbb);
        this.a(world, doubleSlabBlock, meta, 12, 5 + height, 12, sbb);
        this.a(world, doubleSlabBlock, meta, 13, 5 + height, 12, sbb);
        this.a(world, doubleSlabBlock, meta, 4, 1 + height, 11, sbb);
        this.a(world, doubleSlabBlock, meta, 5, 2 + height, 11, sbb);
        this.a(world, sbb, rand, 0.9f, 6, 2 + height, 11, doubleSlabBlock, meta);
        this.a(world, doubleSlabBlock, meta, 7, 3 + height, 11, sbb);
        this.a(world, sbb, rand, 0.9f, 8, 3 + height, 11, doubleSlabBlock, meta);
        this.a(world, doubleSlabBlock, meta, 9, 4 + height, 11, sbb);
        this.a(world, doubleSlabBlock, meta, 10, 4 + height, 11, sbb);
        this.a(world, doubleSlabBlock, meta, 11, 5 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 4, 2 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 5, 3 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 6, 3 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 7, 4 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 8, 4 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 9, 5 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 10, 5 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 11, 6 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 4, 3 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 6, 4 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 8, 5 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 10, 6 + height, 11, sbb);
        this.a(world, aqz.be.cF, 0, 11, 7 + height, 11, sbb);
        this.setCoordBaseMode(temp);
    }

    protected void generatePaintingsOnWall(abw world, Random rand, int howMany, int floorLevel, int direction, int minSize, agf sbb) {
        for (int i = 0; i < howMany; ++i) {
            t pCoords = this.getRandomWallSpot(rand, floorLevel, direction, sbb);
            ol painting = new ol(world, pCoords.a, pCoords.b, pCoords.c, direction);
            painting.e = this.getPaintingOfSize(rand, minSize);
            painting.a(direction);
            if (!this.checkPainting(world, painting, sbb)) continue;
            world.d((nn)painting);
        }
    }

    protected om getPaintingOfSize(Random rand, int minSize) {
        ArrayList<om> valid = new ArrayList<om>();
        for (om art : om.values()) {
            if (art.C < minSize && art.D < minSize) continue;
            valid.add(art);
        }
        if (valid.size() > 0) {
            return (om)valid.get(rand.nextInt(valid.size()));
        }
        return null;
    }

    protected boolean checkPainting(abw world, ol painting, agf sbb) {
        if (painting == null) {
            return false;
        }
        asx largerBox = painting.a == 0 || painting.a == 2 ? painting.E.b(1.0, 1.0, 0.06) : painting.E.b(0.06, 1.0, 1.0);
        if (world.a((nn)painting, largerBox).size() > 0) {
            return false;
        }
        List collidingEntities = world.b((nn)painting, largerBox);
        for (nn entityOnList : collidingEntities) {
            if (!(entityOnList instanceof oc)) continue;
            return false;
        }
        return true;
    }

    protected t getRandomWallSpot(Random rand, int floorLevel, int direction, agf sbb) {
        int minX = this.f.a + 2;
        int maxX = this.f.d - 2;
        int minY = this.f.b + floorLevel + 2;
        int maxY = this.f.e - 2;
        int minZ = this.f.c + 2;
        int maxZ = this.f.f - 2;
        if (direction == 0) {
            minZ = this.f.c;
            maxZ = this.f.c;
        }
        if (direction == 1) {
            maxX = this.f.d;
            minX = this.f.d;
        }
        if (direction == 2) {
            maxZ = this.f.f;
            minZ = this.f.f;
        }
        if (direction == 3) {
            minX = this.f.a;
            maxX = this.f.a;
        }
        for (int i = 0; i < 30; ++i) {
            int cz;
            int cy;
            int cx = minX + (maxX > minX ? rand.nextInt(maxX - minX) : 0);
            if (!sbb.b(cx, cy = minY + (maxY > minY ? rand.nextInt(maxY - minY) : 0), cz = minZ + (maxZ > minZ ? rand.nextInt(maxZ - minZ) : 0))) continue;
            return new t(cx, cy, cz);
        }
        return null;
    }
}

