/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.darktower;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import twilightforest.TFTreasure;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFCreatures;
import twilightforest.item.TFItems;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.StructureTFDecorator;
import twilightforest.structures.TFMaze;
import twilightforest.structures.darktower.ComponentTFDarkTowerBossBridge;
import twilightforest.structures.darktower.ComponentTFDarkTowerEntranceBridge;
import twilightforest.structures.darktower.ComponentTFDarkTowerMainBridge;
import twilightforest.structures.darktower.ComponentTFDarkTowerWing;
import twilightforest.structures.darktower.EnumDarkTowerDoor;
import twilightforest.structures.darktower.StructureDecoratorDarkTower;
import twilightforest.world.TFGenSmallRainboak;
import twilightforest.world.TFGenSmallTwilightOak;

public class ComponentTFDarkTowerMain
extends ComponentTFDarkTowerWing {
    private boolean placedKeys = false;

    public ComponentTFDarkTowerMain(abw world, Random rand, int index, int x, int y, int z2) {
        this(world, rand, index, x + 19, y, z2 + 19, 2);
    }

    public ComponentTFDarkTowerMain(abw world, Random rand, int index, int x, int y, int z2, int rotation) {
        super(index, x, y, z2, 19, 56 + rand.nextInt(32) / 5 * 5, rotation);
        if (this.f.e > 245) {
            int amtToLower = (this.f.e - 245) / 5 * 5 + 5;
            FMLLog.info((String)"[TwilightForest] Lowering Dark Tower max height by %d to be within world bounds", (Object[])new Object[]{amtToLower});
            this.height -= amtToLower;
            this.f.e -= amtToLower;
        }
        if (this.deco == null) {
            this.deco = new StructureDecoratorDarkTower();
        }
    }

    @Override
    public void a(ait parent, List list, Random rand) {
        int childHeight;
        int[] dest;
        int i;
        if (parent != null && parent instanceof StructureTFComponent) {
            this.deco = ((StructureTFComponent)parent).deco;
        }
        if (this.d() > 0) {
            this.addOpening(0, 1, this.size / 2, 2);
        }
        int mainDir = -1;
        if (this.d() < 2) {
            mainDir = rand.nextInt(4);
            for (i = 0; i < 4; ++i) {
                if (i == mainDir) continue;
                dest = this.getValidOpening(rand, i);
                childHeight = this.validateChildHeight(21 + rand.nextInt(10), 11);
                this.makeTowerWing(list, rand, this.d(), dest[0], dest[1], dest[2], 11, childHeight, i);
            }
        } else {
            for (i = 0; i < 4; ++i) {
                dest = this.getValidOpening(rand, i);
                this.makeBossTrapWing(list, rand, this.d(), dest[0], dest[1], dest[2], i);
            }
        }
        if (this.d() > 0) {
            for (i = 0; i < 4; ++i) {
                if (i == 2) continue;
                dest = this.getValidOpening(rand, i);
                dest[1] = 1;
                childHeight = this.validateChildHeight(21 + rand.nextInt(10), 11);
                this.makeTowerWing(list, rand, this.d(), dest[0], dest[1], dest[2], 11, childHeight, i);
            }
            this.makeABeard(parent, list, rand);
        } else {
            for (i = 0; i < 4; i += 2) {
                dest = this.getValidOpening(rand, i);
                dest[1] = 1;
                childHeight = this.validateChildHeight(10 + rand.nextInt(5), 9);
                this.makeEntranceTower(list, rand, 5, dest[0], dest[1], dest[2], 9, childHeight, i);
            }
        }
        if (mainDir > -1) {
            int[] dest2 = this.getValidOpening(rand, mainDir);
            this.makeNewLargeTower(list, rand, this.d() + 1, dest2[0], dest2[1], dest2[2], mainDir);
        }
        this.makeARoof(parent, list, rand);
        if (!this.placedKeys && this.d() < 2) {
            ArrayList<ComponentTFDarkTowerWing> possibleKeyTowers = new ArrayList<ComponentTFDarkTowerWing>();
            int smallTowers = 0;
            for (Object piece : list) {
                if (!(piece instanceof ComponentTFDarkTowerWing)) continue;
                ComponentTFDarkTowerWing wing = (ComponentTFDarkTowerWing)((Object)piece);
                if (wing.size != 9 || wing.d() != this.d()) continue;
                ++smallTowers;
                possibleKeyTowers.add(wing);
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                if (possibleKeyTowers.size() < 1) {
                    FMLLog.warning((String)"[TwilightForest] Dark forest tower could not find four small towers to place keys in.", (Object[])new Object[0]);
                    break;
                }
                int towerNum = rand.nextInt(possibleKeyTowers.size());
                ((ComponentTFDarkTowerWing)((Object)possibleKeyTowers.get(towerNum))).setKeyTower(true);
                possibleKeyTowers.remove(towerNum);
            }
            this.placedKeys = true;
        }
    }

    private boolean makeEntranceTower(List list, Random rand, int index, int x, int y, int z2, int childSize, int childHeight, int rotation) {
        int direction = (this.getCoordBaseMode() + rotation) % 4;
        int[] dx = this.offsetTowerCoords(x, y, z2, 5, direction);
        ComponentTFDarkTowerEntranceBridge bridge = new ComponentTFDarkTowerEntranceBridge(index, dx[0], dx[1], dx[2], childSize, childHeight, direction);
        list.add(bridge);
        bridge.a(this, list, rand);
        this.addOpening(x, y, z2, rotation);
        return true;
    }

    private boolean makeNewLargeTower(List list, Random rand, int index, int x, int y, int z2, int rotation) {
        int wingSize = 15;
        int wingHeight = 56;
        int direction = (this.getCoordBaseMode() + rotation) % 4;
        int[] dx = this.offsetTowerCoords(x, y, z2, 5, direction);
        ComponentTFDarkTowerMainBridge bridge = new ComponentTFDarkTowerMainBridge(index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.add(bridge);
        bridge.a(this, list, rand);
        this.addOpening(x, y, z2, rotation, EnumDarkTowerDoor.LOCKED);
        return true;
    }

    private boolean makeBossTrapWing(List list, Random rand, int index, int x, int y, int z2, int rotation) {
        int wingSize = 11;
        int wingHeight = 9;
        int direction = (this.getCoordBaseMode() + rotation) % 4;
        int[] dx = this.offsetTowerCoords(x, y, z2, 5, direction);
        ComponentTFDarkTowerBossBridge bridge = new ComponentTFDarkTowerBossBridge(index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.add(bridge);
        bridge.a(this, list, rand);
        this.addOpening(x, y, z2, rotation);
        return true;
    }

    @Override
    public void makeARoof(ait parent, List list, Random rand) {
        if (this.d() < 2) {
            super.makeARoof(parent, list, rand);
        }
    }

    @Override
    public boolean a(abw world, Random rand, agf sbb) {
        Random decoRNG = new Random(world.H() + (long)(this.f.a * 321534781) ^ (long)(this.f.c * 756839));
        this.makeEncasedWalls(world, rand, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        this.a(world, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        if (this.d() == 0) {
            for (int x = 0; x < this.size; ++x) {
                for (int z2 = 0; z2 < this.size; ++z2) {
                    this.b(world, this.deco.accentID, this.deco.accentMeta, x, -1, z2, sbb);
                }
            }
        }
        this.nullifySkyLightForBoundingBox(world);
        int totalFloors = this.height / 5;
        boolean beamMaze = decoRNG.nextBoolean();
        int centerFloors = beamMaze ? 4 : totalFloors / 2;
        int bottomFloors = (totalFloors - centerFloors) / 2;
        centerFloors = totalFloors - bottomFloors * 2;
        int topFloorsStartY = this.height - (bottomFloors * 5 + 1);
        this.addThreeQuarterFloors(world, decoRNG, sbb, 0, bottomFloors * 5);
        if (this.d() < 2) {
            this.addThreeQuarterFloors(world, decoRNG, sbb, topFloorsStartY, this.height - 1);
        } else {
            this.addThreeQuarterFloorsDecorateBoss(world, decoRNG, sbb, topFloorsStartY, this.height - 1);
            this.destroyTower(world, decoRNG, 12, this.height + 4, 3, 4, sbb);
            this.destroyTower(world, decoRNG, 3, this.height + 4, 12, 4, sbb);
            this.destroyTower(world, decoRNG, 3, this.height + 4, 3, 4, sbb);
            this.destroyTower(world, decoRNG, 12, this.height + 4, 12, 4, sbb);
            this.destroyTower(world, decoRNG, 8, this.height + 4, 8, 5, sbb);
            this.decorateBossSpawner(world, decoRNG, sbb, 0, this.height - 6);
        }
        if (beamMaze) {
            this.addTimberMaze(world, decoRNG, sbb, bottomFloors * 5, topFloorsStartY);
        } else {
            this.addBuilderPlatforms(world, decoRNG, sbb, bottomFloors * 5, topFloorsStartY);
        }
        this.makeOpenings(world, sbb);
        return true;
    }

    protected void addThreeQuarterFloors(abw world, Random decoRNG, agf sbb, int bottom, int top) {
        int spacing = 5;
        int rotation = (this.f.b + bottom) % 4;
        if (bottom == 0) {
            this.makeLargeStairsUp(world, sbb, rotation, 0);
            rotation += 3;
            this.makeBottomEntrance(world, decoRNG, sbb, rotation %= 4, bottom);
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            boolean isBottomFloor = y == bottom && bottom != spacing;
            boolean isTopFloor = y >= top - spacing;
            boolean isTowerTopFloor = y >= this.height - spacing - 2;
            this.makeThreeQuarterFloor(world, sbb, rotation, y, isBottomFloor, isTowerTopFloor);
            if (!isTopFloor) {
                this.makeLargeStairsUp(world, sbb, rotation, y);
            }
            if (!isTopFloor || isTowerTopFloor) {
                this.decorateFloor(world, decoRNG, sbb, rotation, y, isBottomFloor, isTopFloor);
            }
            rotation += 3;
            rotation %= 4;
        }
    }

    protected void addThreeQuarterFloorsDecorateBoss(abw world, Random decoRNG, agf sbb, int bottom, int top) {
        int spacing = 5;
        int rotation = (this.f.b + bottom) % 4;
        if (bottom == 0) {
            this.makeLargeStairsUp(world, sbb, rotation, 0);
            rotation += 3;
            rotation %= 4;
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            boolean isBottomFloor = y == bottom && bottom != spacing;
            boolean isTopFloor = y >= top - spacing;
            boolean isTowerTopFloor = y >= this.height - spacing - 2;
            this.makeThreeQuarterFloor(world, sbb, rotation, y, isBottomFloor, isTowerTopFloor);
            if (!isTopFloor) {
                this.makeLargeStairsUp(world, sbb, rotation, y);
                this.decorateExperiment(world, decoRNG, sbb, rotation, y);
            }
            rotation += 3;
            rotation %= 4;
        }
    }

    private void decorateFloor(abw world, Random decoRNG, agf sbb, int rotation, int y, boolean isBottom, boolean isTop) {
        if (isTop) {
            switch (decoRNG.nextInt(3)) {
                default: {
                    this.decorateAquarium(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 1: {
                    this.decorateBotanical(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 2: {
                    this.decorateNetherwart(world, decoRNG, sbb, rotation, y, isTop);
                    break;
                }
            }
        } else if (isBottom) {
            switch (decoRNG.nextInt(4)) {
                default: {
                    this.decorateAquarium(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 1: {
                    this.decorateBotanical(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 2: {
                    if (y + this.f.b > 64) {
                        this.decorateNetherwart(world, decoRNG, sbb, rotation, y, isTop);
                        break;
                    }
                }
                case 3: {
                    this.decorateForge(world, decoRNG, sbb, rotation, y);
                    break;
                }
            }
        } else {
            switch (decoRNG.nextInt(8)) {
                default: {
                    this.decorateReappearingMaze(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 2: {
                    this.decorateUnbuilderMaze(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 3: {
                    this.decorateAquarium(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 4: {
                    this.decorateBotanical(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 5: {
                    if (y + this.f.b > 64) {
                        this.decorateNetherwart(world, decoRNG, sbb, rotation, y, isTop);
                        break;
                    }
                }
                case 6: {
                    this.decorateLounge(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 7: {
                    this.decorateForge(world, decoRNG, sbb, rotation, y);
                }
            }
        }
    }

    protected void makeThreeQuarterFloor(abw world, agf sbb, int rotation, int y, boolean isBottom, boolean isTowerTopFloor) {
        int half = this.size / 2;
        this.fillBlocksRotated(world, sbb, half + 1, y, 1, this.size - 2, y, half + 1, this.deco.blockID, this.deco.blockMeta, rotation);
        this.fillBlocksRotated(world, sbb, 1, y, half + 1, this.size - 2, y, this.size - 2, this.deco.blockID, this.deco.blockMeta, rotation);
        int startZ = isBottom ? 1 : 3;
        this.fillBlocksRotated(world, sbb, 1, y, half, half, y, half, this.deco.accentID, this.deco.accentMeta, rotation);
        this.fillBlocksRotated(world, sbb, half, y, startZ, half, y, half, this.deco.accentID, this.deco.accentMeta, rotation);
        this.fillBlocksRotated(world, sbb, 1, y + 1, half, half, y + 1, half, this.deco.fenceID, this.deco.fenceMeta, rotation);
        this.fillBlocksRotated(world, sbb, half, y + 1, startZ, half, y + 1, half, this.deco.fenceID, this.deco.fenceMeta, rotation);
        if (isTowerTopFloor) {
            this.fillBlocksRotated(world, sbb, 1, y + 0, half - 2, 3, y + 0, half, this.deco.accentID, this.deco.accentMeta, rotation);
            this.fillBlocksRotated(world, sbb, 1, y + 1, half - 2, 3, y + 1, half, this.deco.fenceID, this.deco.fenceMeta, rotation);
            this.fillBlocksRotated(world, sbb, 1, y + 0, half - 1, 2, y + 0, half, this.deco.blockID, this.deco.blockMeta, rotation);
            this.fillBlocksRotated(world, sbb, 1, y + 1, half - 1, 2, y + 1, half, 0, 0, rotation);
        }
    }

    protected void makeLargeStairsUp(abw world, agf sbb, int rotation, int y) {
        for (int i = 0; i < 5; ++i) {
            int z2 = this.size / 2 - i + 4;
            int sy = y + i + 1;
            this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(3 + rotation), 1, sy, z2, rotation, sbb);
            this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(3 + rotation), 2, sy, z2, rotation, sbb);
            this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, 1, sy, z2 - 1, rotation, sbb);
            this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, 2, sy, z2 - 1, rotation, sbb);
            this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, 3, sy, z2 - 1, rotation, sbb);
            if (i > 0 && i < 4) {
                this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 3, sy, z2, rotation, sbb);
                this.placeBlockRotated(world, this.deco.fenceID, this.deco.fenceMeta, 3, sy + 1, z2, rotation, sbb);
                this.placeBlockRotated(world, this.deco.fenceID, this.deco.fenceMeta, 3, sy + 2, z2, rotation, sbb);
                continue;
            }
            if (i != 0) continue;
            this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(2 + rotation), 3, sy, z2, rotation, sbb);
        }
    }

    private void decorateReappearingMaze(abw world, Random decoRNG, agf sbb, int rotation, int y) {
        int mazeSize = 6;
        TFMaze maze = new TFMaze(mazeSize, mazeSize);
        maze.setSeed(world.H() + (long)(this.f.a * 90342903) + (long)(y * 90342903) ^ (long)this.f.c);
        for (int i = 0; i < 13; ++i) {
            maze.putRaw(i, 0, 5);
            maze.putRaw(i, 12, 5);
            maze.putRaw(0, i, 5);
            maze.putRaw(12, i, 5);
        }
        maze.doorRarity = 0.3f;
        switch (rotation) {
            case 0: {
                int x;
                for (x = 1; x < 6; ++x) {
                    for (int z2 = 1; z2 < 6; ++z2) {
                        maze.putRaw(x, z2, 5);
                    }
                }
                maze.putRaw(1, 6, 5);
                maze.putRaw(1, 7, 5);
                maze.putRaw(1, 8, 5);
                maze.putRaw(1, 9, 5);
                maze.putRaw(1, 10, 6);
                maze.putRaw(6, 1, 5);
                maze.putRaw(7, 1, 5);
                maze.putRaw(8, 1, 6);
                maze.generateRecursiveBacktracker(0, 5);
                break;
            }
            case 1: {
                int x;
                for (x = 7; x < 12; ++x) {
                    for (int z3 = 1; z3 < 6; ++z3) {
                        maze.putRaw(x, z3, 5);
                    }
                }
                maze.putRaw(6, 1, 5);
                maze.putRaw(5, 1, 5);
                maze.putRaw(4, 1, 5);
                maze.putRaw(3, 1, 5);
                maze.putRaw(2, 1, 6);
                maze.putRaw(11, 6, 5);
                maze.putRaw(11, 7, 5);
                maze.putRaw(11, 8, 6);
                maze.generateRecursiveBacktracker(0, 0);
                break;
            }
            case 2: {
                int x;
                for (x = 7; x < 12; ++x) {
                    for (int z4 = 7; z4 < 12; ++z4) {
                        maze.putRaw(x, z4, 5);
                    }
                }
                maze.putRaw(11, 6, 5);
                maze.putRaw(11, 5, 5);
                maze.putRaw(11, 4, 5);
                maze.putRaw(11, 3, 5);
                maze.putRaw(11, 2, 6);
                maze.putRaw(6, 11, 5);
                maze.putRaw(5, 11, 5);
                maze.putRaw(4, 11, 6);
                maze.generateRecursiveBacktracker(5, 0);
                break;
            }
            case 3: {
                int x;
                for (x = 1; x < 6; ++x) {
                    for (int z5 = 7; z5 < 12; ++z5) {
                        maze.putRaw(x, z5, 5);
                    }
                }
                maze.putRaw(6, 11, 5);
                maze.putRaw(7, 11, 5);
                maze.putRaw(8, 11, 5);
                maze.putRaw(9, 11, 5);
                maze.putRaw(10, 11, 6);
                maze.putRaw(1, 6, 5);
                maze.putRaw(1, 5, 5);
                maze.putRaw(1, 4, 6);
                maze.generateRecursiveBacktracker(5, 5);
            }
        }
        maze.wallBlockID = this.deco.blockID;
        maze.wallBlockMeta = this.deco.blockMeta;
        maze.headBlockID = this.deco.accentID;
        maze.headBlockMeta = this.deco.accentMeta;
        maze.pillarBlockID = this.deco.accentID;
        maze.pillarBlockMeta = this.deco.accentMeta;
        maze.doorBlockID = TFBlocks.towerDevice.cF;
        maze.doorBlockMeta = 0;
        maze.torchRarity = 0.0f;
        maze.tall = 3;
        maze.head = 1;
        maze.oddBias = 2;
        maze.copyToStructure(world, 0, y + 1, 0, this, sbb);
        this.decorateMazeDeadEnds(world, decoRNG, maze, y, rotation, sbb);
    }

    protected void decorateMazeDeadEnds(abw world, Random decoRNG, TFMaze maze, int y, int rotation, agf sbb) {
        for (int x = 0; x < maze.width; ++x) {
            for (int z2 = 0; z2 < maze.depth; ++z2) {
                if (!maze.isWall(x, z2, x - 1, z2) && maze.isWall(x, z2, x + 1, z2) && maze.isWall(x, z2, x, z2 - 1) && maze.isWall(x, z2, x, z2 + 1)) {
                    this.decorateDeadEnd(world, decoRNG, maze, x, y, z2, 3, rotation, sbb);
                }
                if (maze.isWall(x, z2, x - 1, z2) && !maze.isWall(x, z2, x + 1, z2) && maze.isWall(x, z2, x, z2 - 1) && maze.isWall(x, z2, x, z2 + 1)) {
                    this.decorateDeadEnd(world, decoRNG, maze, x, y, z2, 1, rotation, sbb);
                }
                if (maze.isWall(x, z2, x - 1, z2) && maze.isWall(x, z2, x + 1, z2) && !maze.isWall(x, z2, x, z2 - 1) && maze.isWall(x, z2, x, z2 + 1)) {
                    this.decorateDeadEnd(world, decoRNG, maze, x, y, z2, 0, rotation, sbb);
                }
                if (!maze.isWall(x, z2, x - 1, z2) || !maze.isWall(x, z2, x + 1, z2) || !maze.isWall(x, z2, x, z2 - 1) || maze.isWall(x, z2, x, z2 + 1)) continue;
                this.decorateDeadEnd(world, decoRNG, maze, x, y, z2, 2, rotation, sbb);
            }
        }
    }

    private void decorateDeadEnd(abw world, Random decoRNG, TFMaze maze, int mx, int y, int mz, int facing, int rotation, agf sbb) {
        int x = mx * 3 + 1;
        int z2 = mz * 3 + 1;
        switch (facing) {
            case 0: {
                this.a(world, this.deco.accentID, this.deco.accentMeta, x + 0, y + 1, z2 + 1, sbb);
                this.a(world, this.deco.accentID, this.deco.accentMeta, x + 1, y + 1, z2 + 1, sbb);
                this.a(world, aqz.az.cF, 0, x + 0, y + 2, z2 + 1, sbb);
                this.placeTreasureAtCurrentPosition(world, decoRNG, x + 1, y + 2, z2 + 1, TFTreasure.darktower_cache, sbb);
                break;
            }
            case 1: {
                this.a(world, this.deco.accentID, this.deco.accentMeta, x + 0, y + 1, z2 + 0, sbb);
                this.a(world, this.deco.accentID, this.deco.accentMeta, x + 0, y + 1, z2 + 1, sbb);
                this.a(world, aqz.az.cF, rotation, x + 0, y + 2, z2 + 0, sbb);
                this.placeTreasureAtCurrentPosition(world, decoRNG, x + 0, y + 2, z2 + 1, TFTreasure.darktower_cache, sbb);
                break;
            }
            case 2: {
                this.a(world, this.deco.accentID, this.deco.accentMeta, x + 0, y + 1, z2 + 0, sbb);
                this.a(world, this.deco.accentID, this.deco.accentMeta, x + 1, y + 1, z2 + 0, sbb);
                this.a(world, aqz.az.cF, rotation, x + 0, y + 2, z2 + 0, sbb);
                this.placeTreasureAtCurrentPosition(world, decoRNG, x + 1, y + 2, z2 + 0, TFTreasure.darktower_cache, sbb);
                break;
            }
            case 3: {
                this.a(world, this.deco.accentID, this.deco.accentMeta, x + 1, y + 1, z2 + 0, sbb);
                this.a(world, this.deco.accentID, this.deco.accentMeta, x + 1, y + 1, z2 + 1, sbb);
                this.a(world, aqz.az.cF, rotation, x + 1, y + 2, z2 + 0, sbb);
                this.placeTreasureAtCurrentPosition(world, decoRNG, x + 1, y + 2, z2 + 1, TFTreasure.darktower_cache, sbb);
            }
        }
    }

    private void decorateUnbuilderMaze(abw world, Random decoRNG, agf sbb, int rotation, int y) {
        for (int x = this.size / 2; x < this.size - 1; ++x) {
            for (int z2 = 3; z2 < this.size - 1; ++z2) {
                int py;
                if (x % 2 == 1 && z2 % 2 == 1) {
                    for (py = 1; py < 5; ++py) {
                        this.placeBlockRotated(world, this.deco.pillarID, this.deco.pillarMeta, x, y + py, z2, rotation, sbb);
                    }
                    continue;
                }
                if (x % 2 != 1 && z2 % 2 != 1) continue;
                for (py = 1; py < 5; ++py) {
                    this.placeBlockRotated(world, this.deco.fenceID, this.deco.fenceMeta, x, y + py, z2, rotation, sbb);
                }
                if (x == this.size / 2 || x == this.size - 2 || z2 == this.size - 2) continue;
                int ay = decoRNG.nextInt(4) + 1;
                this.placeBlockRotated(world, 0, 0, x, y + ay, z2, rotation, sbb);
                if (x <= this.size - 7) continue;
                ay = decoRNG.nextInt(3) + 1;
                this.placeBlockRotated(world, 0, 0, x, y + ay, z2, rotation, sbb);
            }
        }
        this.placeBlockRotated(world, TFBlocks.towerDevice.cF, 9, 15, y + 2, 7, rotation, sbb);
        this.placeBlockRotated(world, TFBlocks.towerDevice.cF, 9, 11, y + 3, 7, rotation, sbb);
        this.placeBlockRotated(world, TFBlocks.towerDevice.cF, 9, 15, y + 2, 13, rotation, sbb);
        this.placeBlockRotated(world, TFBlocks.towerDevice.cF, 9, 11, y + 3, 13, rotation, sbb);
        this.placeBlockRotated(world, TFBlocks.towerDevice.cF, 9, 5, y + 3, 13, rotation, sbb);
    }

    private void decorateLounge(abw world, Random decoRNG, agf sbb, int rotation, int y) {
        this.fillBlocksRotated(world, sbb, 17, y + 1, 1, 17, y + 4, 6, this.deco.pillarID, this.deco.pillarMeta, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 1, 17, y + 4, 1, this.deco.pillarID, this.deco.pillarMeta, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 2, 16, y + 1, 5, this.deco.blockID, this.deco.blockMeta, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 2, 12, y + 1, 6, this.deco.stairID, this.getStairMeta(0 + rotation), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 6, 16, y + 1, 6, this.deco.stairID, this.getStairMeta(3 + rotation), rotation);
        this.makeDispenserPillar(world, this.deco, 13, y, 1, this.getStairMeta(3 + rotation), rotation, sbb);
        this.makeDispenserPillar(world, this.deco, 15, y, 1, this.getStairMeta(3 + rotation), rotation, sbb);
        this.makeDispenserPillar(world, this.deco, 17, y, 3, this.getStairMeta(0 + rotation), rotation, sbb);
        this.makeDispenserPillar(world, this.deco, 17, y, 5, this.getStairMeta(0 + rotation), rotation, sbb);
        this.makeStonePillar(world, this.deco, 12, y, 1, this.getStairMeta(3 + rotation), rotation, sbb);
        this.makeStonePillar(world, this.deco, 17, y, 6, this.getStairMeta(0 + rotation), rotation, sbb);
        this.placeBlockRotated(world, aqz.bK.cF, 0, 13, y + 2, 5, rotation, sbb);
        this.placeBlockRotated(world, aqz.bL.cF, 3, 15, y + 2, 3, rotation, sbb);
        this.fillBlocksRotated(world, sbb, 10, y + 1, 17, 17, y + 4, 17, this.deco.blockID, this.deco.blockMeta, rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 10, 17, y + 4, 17, this.deco.blockID, this.deco.blockMeta, rotation);
        this.fillBlocksRotated(world, sbb, 11, y + 1, 17, 12, y + 4, 17, aqz.as.cF, 0, rotation);
        this.fillBlocksRotated(world, sbb, 14, y + 1, 17, 15, y + 4, 17, aqz.as.cF, 0, rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 11, 17, y + 4, 12, aqz.as.cF, 0, rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 14, 17, y + 4, 15, aqz.as.cF, 0, rotation);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(0 + rotation) + 4, 13, y + 1, 14, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(3 + rotation) + 4, 14, y + 1, 14, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(2 + rotation) + 4, 14, y + 1, 13, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(1 + rotation) + 4, 13, y + 1, 13, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(2 + rotation), 11, y + 1, 13, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(3 + rotation), 13, y + 1, 11, rotation, sbb);
        this.placeBlockRotated(world, aqz.bQ.cF, 0, 8, y + 3, 8, rotation, sbb);
        this.placeBlockRotated(world, aqz.aO.cF, decoRNG.nextBoolean() ? 0 : 7, 8, y + 2, 8, rotation, sbb);
        this.placeTreePlanter(world, decoRNG.nextInt(5), 6, y + 1, 12, rotation, sbb);
    }

    private void makeDispenserPillar(abw world, StructureTFDecorator forgeDeco, int x, int y, int z2, int stairMeta, int rotation, agf sbb) {
        this.placeBlockRotated(world, forgeDeco.stairID, stairMeta + 4, x, y + 2, z2, rotation, sbb);
        this.placeBlockRotated(world, aqz.U.cF, stairMeta + 4, x, y + 3, z2, rotation, sbb);
        this.placeBlockRotated(world, forgeDeco.stairID, stairMeta, x, y + 4, z2, rotation, sbb);
    }

    private void decorateBossSpawner(abw world, Random rand, agf sbb, int rotation, int y) {
        this.placeBlockRotated(world, TFBlocks.bossSpawner.cF, 3, 9, y + 4, 9, rotation, sbb);
    }

    private void decorateExperiment(abw world, Random decoRNG, agf sbb, int rotation, int y) {
        this.fillBlocksRotated(world, sbb, 17, y + 1, 1, 17, y + 4, 6, this.deco.pillarID, this.deco.pillarMeta, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 1, 17, y + 4, 1, this.deco.pillarID, this.deco.pillarMeta, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 2, 16, y + 1, 5, this.deco.blockID, this.deco.blockMeta, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 2, 12, y + 1, 6, this.deco.stairID, this.getStairMeta(0 + rotation), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 6, 16, y + 1, 6, this.deco.stairID, this.getStairMeta(3 + rotation), rotation);
        this.makeWoodPillar(world, this.deco, 13, y, 1, this.getStairMeta(3 + rotation), rotation, sbb);
        this.makeWoodPillar(world, this.deco, 15, y, 1, this.getStairMeta(3 + rotation), rotation, sbb);
        this.makeWoodPillar(world, this.deco, 17, y, 3, this.getStairMeta(0 + rotation), rotation, sbb);
        this.makeWoodPillar(world, this.deco, 17, y, 5, this.getStairMeta(0 + rotation), rotation, sbb);
        this.makeStonePillar(world, this.deco, 12, y, 1, this.getStairMeta(3 + rotation), rotation, sbb);
        this.makeStonePillar(world, this.deco, 17, y, 6, this.getStairMeta(0 + rotation), rotation, sbb);
        this.placeBlockRotated(world, aqz.aD.cF, 0, 14, y + 2, 4, rotation, sbb);
        this.placeItemFrameRotated(world, 13, y + 2, 1, rotation, 0, new ye(TFItems.borerEssence), sbb);
        this.placeItemFrameRotated(world, 14, y + 2, 1, rotation, 0, new ye(yc.aE), sbb);
        this.placeItemFrameRotated(world, 15, y + 2, 1, rotation, 0, new ye(TFItems.borerEssence), sbb);
        this.placeItemFrameRotated(world, 13, y + 3, 1, rotation, 0, new ye(yc.aE), sbb);
        this.placeItemFrameRotated(world, 14, y + 3, 1, rotation, 0, new ye(yc.br), sbb);
        this.placeItemFrameRotated(world, 15, y + 3, 1, rotation, 0, new ye(yc.aE), sbb);
        this.placeItemFrameRotated(world, 13, y + 4, 1, rotation, 0, new ye(TFItems.borerEssence), sbb);
        this.placeItemFrameRotated(world, 14, y + 4, 1, rotation, 0, new ye(yc.aE), sbb);
        this.placeItemFrameRotated(world, 15, y + 4, 1, rotation, 0, new ye(TFItems.borerEssence), sbb);
        this.placeItemFrameRotated(world, 17, y + 2, 3, rotation, 1, new ye(TFBlocks.towerWood, 1, 1), sbb);
        this.placeItemFrameRotated(world, 17, y + 2, 4, rotation, 1, new ye(TFBlocks.towerWood, 1, 0), sbb);
        this.placeItemFrameRotated(world, 17, y + 2, 5, rotation, 1, new ye(TFBlocks.towerWood, 1, 1), sbb);
        this.placeItemFrameRotated(world, 17, y + 3, 3, rotation, 1, new ye(TFBlocks.towerWood, 1, 0), sbb);
        this.placeItemFrameRotated(world, 17, y + 3, 4, rotation, 1, new ye(TFItems.carminite), sbb);
        this.placeItemFrameRotated(world, 17, y + 3, 5, rotation, 1, new ye(TFBlocks.towerWood, 1, 0), sbb);
        this.placeItemFrameRotated(world, 17, y + 4, 3, rotation, 1, new ye(TFBlocks.towerWood, 1, 1), sbb);
        this.placeItemFrameRotated(world, 17, y + 4, 4, rotation, 1, new ye(TFBlocks.towerWood, 1, 0), sbb);
        this.placeItemFrameRotated(world, 17, y + 4, 5, rotation, 1, new ye(TFBlocks.towerWood, 1, 1), sbb);
        if (y < this.height - 13) {
            this.placeBlockRotated(world, aqz.au.cF, 0, 13, y + 1, 13, rotation, sbb);
            this.placeBlockRotated(world, aqz.au.cF, 0, 15, y + 1, 13, rotation, sbb);
            this.placeBlockRotated(world, aqz.au.cF, 0, 13, y + 1, 15, rotation, sbb);
            this.placeBlockRotated(world, aqz.au.cF, 0, 15, y + 1, 15, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 13, y + 1, 14, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 14, y + 1, 13, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 15, y + 1, 14, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 14, y + 1, 15, rotation, sbb);
            this.placeBlockRotated(world, aqz.ct.cF, 0, 14, y + 1, 14, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 13, y + 2, 13, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 15, y + 2, 13, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 13, y + 2, 15, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 15, y + 2, 15, rotation, sbb);
            this.placeBlockRotated(world, TFBlocks.towerDevice.cF, 12, 14, y + 2, 14, rotation, sbb);
            this.placeBlockRotated(world, aqz.au.cF, 0, 13, y + 3, 13, rotation, sbb);
            this.placeBlockRotated(world, aqz.au.cF, 0, 15, y + 3, 13, rotation, sbb);
            this.placeBlockRotated(world, aqz.au.cF, 0, 13, y + 3, 15, rotation, sbb);
            this.placeBlockRotated(world, aqz.au.cF, 0, 15, y + 3, 15, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 13, y + 3, 14, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 14, y + 3, 13, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 15, y + 3, 14, rotation, sbb);
            this.placeBlockRotated(world, aqz.bg.cF, 0, 14, y + 3, 15, rotation, sbb);
            this.placeBlockRotated(world, aqz.ct.cF, 0, 14, y + 3, 14, rotation, sbb);
        }
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 14, y + 1, 17, rotation, sbb);
        this.placeBlockRotated(world, aqz.aO.cF, this.getLeverMeta(rotation, 4), 13, y + 1, 17, rotation, sbb);
        this.placeBlockRotated(world, aqz.ae.cF, 5 - this.getStairMeta(3 + rotation), 14, y + 2, 17, rotation, sbb);
        this.placeBlockRotated(world, aqz.ct.cF, 0, 14, y + 2, 16, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 17, y + 1, 14, rotation, sbb);
        this.placeBlockRotated(world, aqz.aO.cF, this.getLeverMeta(rotation, 2), 17, y + 1, 13, rotation, sbb);
        this.placeBlockRotated(world, aqz.ae.cF, 5 - this.getStairMeta(2 + rotation), 17, y + 2, 14, rotation, sbb);
        this.placeBlockRotated(world, aqz.ct.cF, 0, 16, y + 2, 14, rotation, sbb);
        this.placeBlockRotated(world, aqz.ct.cF, 0, 14, y + 2, 11, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 14, y + 1, 11, rotation, sbb);
        this.placeBlockRotated(world, aqz.aO.cF, this.getLeverMeta(rotation, 4) + 8, 13, y + 1, 11, rotation, sbb);
        this.placeBlockRotated(world, aqz.ae.cF, 5 - this.getStairMeta(1 + rotation), 14, y + 2, 10, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 14, y + 1, 9, rotation, sbb);
        this.placeBlockRotated(world, aqz.aO.cF, this.getLeverMeta(rotation, 4), 13, y + 1, 9, rotation, sbb);
        this.placeBlockRotated(world, aqz.aa.cF, 5 - this.getStairMeta(1 + rotation), 14, y + 2, 9, rotation, sbb);
        this.placeBlockRotated(world, aqz.ct.cF, 0, 11, y + 2, 14, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 11, y + 1, 14, rotation, sbb);
        this.placeBlockRotated(world, aqz.aO.cF, this.getLeverMeta(rotation, 2) + 8, 11, y + 1, 13, rotation, sbb);
        this.placeBlockRotated(world, aqz.ae.cF, 5 - this.getStairMeta(0 + rotation), 10, y + 2, 14, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 9, y + 1, 14, rotation, sbb);
        this.placeBlockRotated(world, aqz.aO.cF, this.getLeverMeta(rotation, 2), 9, y + 1, 13, rotation, sbb);
        this.placeBlockRotated(world, aqz.aa.cF, 5 - this.getStairMeta(0 + rotation), 9, y + 2, 14, rotation, sbb);
    }

    private void makeWoodPillar(abw world, StructureTFDecorator forgeDeco, int x, int y, int z2, int stairMeta, int rotation, agf sbb) {
        this.placeBlockRotated(world, TFBlocks.log.cF, 3, x, y + 2, z2, rotation, sbb);
        this.placeBlockRotated(world, TFBlocks.log.cF, 3, x, y + 3, z2, rotation, sbb);
        this.placeBlockRotated(world, TFBlocks.log.cF, 3, x, y + 4, z2, rotation, sbb);
    }

    private void placeItemFrameRotated(abw world, int x, int y, int z2, int rotation, int direction, ye itemStack, agf sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffsetAsIfRotated(x, z2, rotation);
        if (sbb.b(dx, dy = this.a(y), dz = this.getZWithOffsetAsIfRotated(x, z2, rotation))) {
            od frame = new od(world, dx, dy, dz, (this.getCoordBaseMode() + direction + rotation) % 4);
            if (itemStack != null) {
                frame.a(itemStack);
            }
            world.d((nn)frame);
        }
    }

    private void decorateAquarium(abw world, Random decoRNG, agf sbb, int rotation, int y) {
        this.makePillarFrame(world, sbb, this.deco, rotation, 12, y, 3, 4, 4, 13, false);
        this.fillBlocksRotated(world, sbb, 13, y + 4, 4, 14, y + 4, 14, aqz.F.cF, 0, rotation);
        this.makePillarFrame(world, sbb, this.deco, rotation, 6, y, 12, 4, 4, 4, false);
        this.fillBlocksRotated(world, sbb, 6, y + 5, 12, 9, y + 5, 15, this.deco.accentID, this.deco.accentMeta, rotation);
        this.fillBlocksRotated(world, sbb, 7, y + 4, 13, 8, y + 5, 14, aqz.F.cF, 0, rotation);
    }

    private void decorateForge(abw world, Random decoRNG, agf sbb, int rotation, int y) {
        StructureTFDecorator forgeDeco = this.deco;
        this.fillBlocksRotated(world, sbb, 17, y + 1, 1, 17, y + 4, 6, forgeDeco.pillarID, forgeDeco.pillarMeta, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 1, 17, y + 4, 1, forgeDeco.pillarID, forgeDeco.pillarMeta, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 17, 17, y + 4, 17, forgeDeco.pillarID, forgeDeco.pillarMeta, rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 12, 17, y + 4, 17, forgeDeco.pillarID, forgeDeco.pillarMeta, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 2, 16, y + 1, 5, forgeDeco.blockID, forgeDeco.blockMeta, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 2, 12, y + 1, 6, forgeDeco.stairID, this.getStairMeta(0 + rotation), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 6, 16, y + 1, 6, forgeDeco.stairID, this.getStairMeta(3 + rotation), rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 13, 16, y + 1, 16, forgeDeco.blockID, forgeDeco.blockMeta, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 12, 12, y + 1, 16, forgeDeco.stairID, this.getStairMeta(0 + rotation), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 12, 16, y + 1, 12, forgeDeco.stairID, this.getStairMeta(1 + rotation), rotation);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 13, y, 1, this.getStairMeta(3 + rotation), rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 15, y, 1, this.getStairMeta(3 + rotation), rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 17, y, 3, this.getStairMeta(0 + rotation), rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 17, y, 5, this.getStairMeta(0 + rotation), rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 13, y, 17, this.getStairMeta(1 + rotation), rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 15, y, 17, this.getStairMeta(1 + rotation), rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 17, y, 13, this.getStairMeta(0 + rotation), rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 17, y, 15, this.getStairMeta(0 + rotation), rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 12, y, 1, this.getStairMeta(3 + rotation), rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 17, y, 6, this.getStairMeta(0 + rotation), rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 12, y, 17, this.getStairMeta(1 + rotation), rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 17, y, 12, this.getStairMeta(0 + rotation), rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 17, y, 9, this.getStairMeta(0 + rotation), rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 9, y, 17, this.getStairMeta(1 + rotation), rotation, sbb);
        this.placeBlockRotated(world, aqz.cm.cF, decoRNG.nextInt(16), 13, y + 2, 5, rotation, sbb);
        this.placeBlockRotated(world, aqz.cm.cF, decoRNG.nextInt(16), 13, y + 2, 13, rotation, sbb);
        this.makeFirePit(world, forgeDeco, 6, y + 1, 12, rotation, sbb);
    }

    private void makeFurnacePillar(abw world, StructureTFDecorator forgeDeco, Random rand, int x, int y, int z2, int stairMeta, int rotation, agf sbb) {
        int dz;
        int dy;
        int dx;
        int amount;
        this.placeBlockRotated(world, forgeDeco.stairID, stairMeta + 4, x, y + 2, z2, rotation, sbb);
        this.placeBlockRotated(world, aqz.aG.cF, stairMeta + 4, x, y + 3, z2, rotation, sbb);
        int n = amount = rand.nextBoolean() ? rand.nextInt(5) + 4 : 0;
        if (amount > 0 && sbb.b(dx = this.getXWithOffsetAsIfRotated(x, z2, rotation), dy = this.a(y + 3), dz = this.getZWithOffsetAsIfRotated(x, z2, rotation)) && world.a(dx, dy, dz) == aqz.aG.cF) {
            mo inv = (mo)world.r(dx, dy, dz);
            inv.a(1, new ye(yc.o, amount, 1));
        }
        this.placeBlockRotated(world, forgeDeco.stairID, stairMeta, x, y + 4, z2, rotation, sbb);
    }

    private void makeStonePillar(abw world, StructureTFDecorator forgeDeco, int x, int y, int z2, int stairMeta, int rotation, agf sbb) {
        for (int py = 1; py <= 4; ++py) {
            this.placeBlockRotated(world, forgeDeco.pillarID, forgeDeco.pillarMeta, x, y + py, z2, rotation, sbb);
        }
        int sx = this.getXWithOffsetAsIfRotated(x, z2, rotation);
        int sy = this.a(y + 1);
        int sz = this.getZWithOffsetAsIfRotated(x, z2, rotation);
        switch (stairMeta) {
            case 0: {
                --sx;
                break;
            }
            case 1: {
                ++sx;
                break;
            }
            case 2: {
                --sz;
                break;
            }
            case 3: {
                ++sz;
            }
        }
        if (sbb.b(sx, sy, sz)) {
            world.f(sx, sy + 0, sz, forgeDeco.stairID, stairMeta, 0);
            world.f(sx, sy + 3, sz, forgeDeco.stairID, stairMeta + 4, 0);
        }
    }

    private void makeFirePit(abw world, StructureTFDecorator myDeco, int x, int y, int z2, int rotation, agf sbb) {
        this.placeBlockRotated(world, myDeco.pillarID, myDeco.pillarMeta, x + 1, y, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, myDeco.pillarID, myDeco.pillarMeta, x + 1, y, z2 - 1, rotation, sbb);
        this.placeBlockRotated(world, myDeco.pillarID, myDeco.pillarMeta, x - 1, y, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, myDeco.pillarID, myDeco.pillarMeta, x - 1, y, z2 - 1, rotation, sbb);
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(0 + rotation), x - 1, y, z2 + 0, rotation, sbb);
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(2 + rotation), x + 1, y, z2 + 0, rotation, sbb);
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(3 + rotation), x + 0, y, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(1 + rotation), x + 0, y, z2 - 1, rotation, sbb);
        this.placeBlockRotated(world, aqz.bg.cF, 0, x, y, z2, rotation, sbb);
        this.placeBlockRotated(world, aqz.aw.cF, 0, x, y + 1, z2, rotation, sbb);
    }

    private void decorateNetherwart(abw world, Random decoRNG, agf sbb, int rotation, int y, boolean isTop) {
        StructureTFDecorator netherDeco = this.deco;
        this.makePillarFrame(world, sbb, netherDeco, rotation, 12, y, 9, 4, 4, 7, true);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 10, 14, y + 1, 14, aqz.bh.cF, 0, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 2, 10, 14, y + 2, 14, aqz.bI.cF, 0, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 4, 10, 14, y + 4, 14, aqz.bh.cF, 0, rotation);
        this.makePillarFrame(world, sbb, netherDeco, rotation, 5, y, 12, 3, isTop ? 4 : 9, 3, true);
        this.placeBlockRotated(world, netherDeco.blockID, netherDeco.blockMeta, 6, y + 1, 13, rotation, sbb);
        this.placeBlockRotated(world, netherDeco.blockID, netherDeco.blockMeta, 6, y + (isTop ? 4 : 9), 13, rotation, sbb);
        this.placeSpawnerRotated(world, 6, y + 3, 13, rotation, "Blaze", sbb);
        this.destroyTower(world, decoRNG, 12, y, 3, 2, sbb);
    }

    private void decorateBotanical(abw world, Random decoRNG, agf sbb, int rotation, int y) {
        this.makePillarFrame(world, sbb, this.deco, rotation, 12, y, 12, 4, 4, 4, true);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 13, 14, y + 1, 14, this.deco.blockID, this.deco.blockMeta, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 4, 13, 14, y + 4, 14, this.deco.blockID, this.deco.blockMeta, rotation);
        this.placeRandomPlant(world, decoRNG, 13, y + 2, 13, rotation, sbb);
        this.placeRandomPlant(world, decoRNG, 13, y + 2, 14, rotation, sbb);
        this.placeRandomPlant(world, decoRNG, 14, y + 2, 13, rotation, sbb);
        this.placeRandomPlant(world, decoRNG, 14, y + 2, 14, rotation, sbb);
        for (int py = 1; py <= 4; ++py) {
            this.placeBlockRotated(world, this.deco.pillarID, this.deco.pillarMeta, 12, y + py, 4, rotation, sbb);
            this.placeBlockRotated(world, this.deco.pillarID, this.deco.pillarMeta, 15, y + py, 4, rotation, sbb);
        }
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(2 + rotation) + 4, 13, y + 1, 4, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(0 + rotation) + 4, 14, y + 1, 4, rotation, sbb);
        this.placeTreasureRotated(world, 13, y + 2, 4, rotation, TFTreasure.basement, sbb);
        this.placeBlockRotated(world, aqz.aD.cF, 0, 14, y + 2, 4, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(2 + rotation) + 4, 12, y + 1, 7, rotation, sbb);
        this.placeBlockRotated(world, aqz.bT.cF, 9, 13, y + 1, 7, rotation, sbb);
        this.placeBlockRotated(world, aqz.bT.cF, 9, 14, y + 1, 7, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(0 + rotation) + 4, 15, y + 1, 7, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(2 + rotation) + 4, 12, y + 1, 10, rotation, sbb);
        this.placeBlockRotated(world, aqz.bT.cF, 9, 13, y + 1, 10, rotation, sbb);
        this.placeBlockRotated(world, aqz.bT.cF, 9, 14, y + 1, 10, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(0 + rotation) + 4, 15, y + 1, 10, rotation, sbb);
        for (int x = 12; x <= 15; ++x) {
            this.placeRandomPlant(world, decoRNG, x, y + 2, 7, rotation, sbb);
            this.placeRandomPlant(world, decoRNG, x, y + 2, 10, rotation, sbb);
        }
        this.placeTreePlanter(world, decoRNG.nextInt(5), 6, y + 1, 12, rotation, sbb);
    }

    private void placeTreePlanter(abw world, int treeNum, int x, int y, int z2, int rotation, agf sbb) {
        this.placeBlockRotated(world, this.deco.pillarID, this.deco.pillarMeta, x + 1, y, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.pillarID, this.deco.pillarMeta, x + 1, y, z2 - 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.pillarID, this.deco.pillarMeta, x - 1, y, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.pillarID, this.deco.pillarMeta, x - 1, y, z2 - 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(0 + rotation), x - 1, y, z2 + 0, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(2 + rotation), x + 1, y, z2 + 0, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(3 + rotation), x + 0, y, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(1 + rotation), x + 0, y, z2 - 1, rotation, sbb);
        this.placeBlockRotated(world, aqz.A.cF, 0, x, y, z2, rotation, sbb);
        int dx = this.getXWithOffsetAsIfRotated(x, z2, rotation);
        int dy = this.a(y + 1);
        int dz = this.getZWithOffsetAsIfRotated(x, z2, rotation);
        if (sbb.b(dx, dy, dz)) {
            Object treeGen;
            switch (treeNum) {
                default: {
                    treeGen = new aga(false);
                    break;
                }
                case 1: {
                    treeGen = new aga(true, 3, 3, 3, false);
                    break;
                }
                case 2: {
                    treeGen = new aex(false);
                    break;
                }
                case 3: {
                    treeGen = new TFGenSmallTwilightOak(false);
                    break;
                }
                case 4: {
                    treeGen = new TFGenSmallRainboak(false);
                }
            }
            for (int i = 0; i < 100 && !treeGen.a(world, world.s, dx, dy, dz); ++i) {
            }
        }
    }

    private void placeRandomPlant(abw world, Random decoRNG, int x, int y, int z2, int rotation, agf sbb) {
        int potMeta = decoRNG.nextInt(12);
        this.placeBlockRotated(world, aqz.ch.cF, potMeta, x, y, z2, rotation, sbb);
    }

    private void makeBottomEntrance(abw world, Random decoRNG, agf sbb, int rotation, int y) {
        this.makeFirePit(world, this.deco, 13, y + 1, 3, rotation, sbb);
        this.makeFirePit(world, this.deco, 3, y + 1, 13, rotation, sbb);
        this.makeFirePit(world, this.deco, 13, y + 1, 13, rotation, sbb);
        this.makePillarFrame(world, sbb, this.deco, rotation, 7, y, 7, 3, 4, 3, false);
    }

    protected void addTimberMaze(abw world, Random rand, agf sbb, int bottom, int top) {
        int spacing = 5;
        int floorside = 0;
        if (bottom == 0) {
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            ++floorside;
            this.makeTimberBeams(world, rand, sbb, floorside %= 4, y, y == bottom && bottom != spacing, y >= top - spacing, top);
        }
    }

    protected void makeTimberBeams(abw world, Random rand, agf sbb, int rotation, int y, boolean isBottom, boolean isTop, int top) {
        int x;
        int z2;
        int beamID = TFBlocks.log.cF;
        int beamMetaBase = 3;
        int beamMetaNS = (this.g + rotation) % 2 == 0 ? 4 : 8;
        int beamMetaEW = beamMetaNS == 4 ? 8 : 4;
        int beamMetaUD = 0;
        for (z2 = 1; z2 < this.size - 1; ++z2) {
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaEW, 4, y, z2, rotation, sbb);
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaEW, 9, y, z2, rotation, sbb);
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaEW, 14, y, z2, rotation, sbb);
        }
        z2 = this.pickBetweenExcluding(3, this.size - 3, rand, 4, 9, 14);
        for (x = 5; x < 9; ++x) {
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaNS, x, y, z2, rotation, sbb);
        }
        z2 = this.pickBetweenExcluding(3, this.size - 3, rand, 4, 9, 14);
        for (x = 10; x < 14; ++x) {
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaNS, x, y, z2, rotation, sbb);
        }
        int x1 = 4;
        int z1 = this.pickFrom(rand, 4, 9, 14);
        int x2 = 9;
        int z22 = this.pickFrom(rand, 4, 9, 14);
        int x3 = 14;
        int z3 = this.pickFrom(rand, 4, 9, 14);
        for (int by2 = 1; by2 < 5; ++by2) {
            if (!isBottom || this.checkPost(world, x1, y - 5, z1, rotation, sbb)) {
                this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaUD, x1, y - by2, z1, rotation, sbb);
                this.placeBlockRotated(world, aqz.aK.cF, this.getLadderMeta(2, rotation), x1 + 1, y - by2, z1, rotation, sbb);
            }
            if (!isBottom || this.checkPost(world, x2, y - 5, z22, rotation, sbb)) {
                this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaUD, x2, y - by2, z22, rotation, sbb);
            }
            if (isBottom && !this.checkPost(world, x3, y - 5, z3, rotation, sbb)) continue;
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaUD, x3, y - by2, z3, rotation, sbb);
            this.placeBlockRotated(world, aqz.aK.cF, this.getLadderMeta(4, rotation), x3 - 1, y - by2, z3, rotation, sbb);
        }
        if (isTop) {
            int topFloorRotation = (this.f.b + top + 1) % 4;
            int ladderX = 4;
            int ladderZ = 10;
            int ladderMeta = 3;
            for (int by3 = 1; by3 < 5; ++by3) {
                this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaUD, ladderX, y + by3, 9, topFloorRotation, sbb);
                this.placeBlockRotated(world, aqz.aK.cF, this.getLadderMeta(ladderMeta, topFloorRotation), ladderX, y + by3, ladderZ, topFloorRotation, sbb);
            }
            this.placeBlockRotated(world, 0, 0, ladderX, y + 6, 9, topFloorRotation, sbb);
            this.placeBlockRotated(world, this.deco.fenceID, this.deco.fenceMeta, ladderX + 1, y + 5, ladderZ, topFloorRotation, sbb);
            this.placeBlockRotated(world, this.deco.fenceID, this.deco.fenceMeta, ladderX - 1, y + 5, ladderZ, topFloorRotation, sbb);
            this.placeBlockRotated(world, this.deco.fenceID, this.deco.fenceMeta, ladderX + 1, y + 6, ladderZ, topFloorRotation, sbb);
            this.placeBlockRotated(world, this.deco.fenceID, this.deco.fenceMeta, ladderX - 1, y + 6, ladderZ, topFloorRotation, sbb);
        }
        if (!isBottom && !isTop) {
            int sx = this.pickFrom(rand, 6, 7, 11);
            int sz = this.pickFrom(rand, 6, 11, 12);
            this.makeMiniGhastSpawner(world, rand, y, sx, sz, sbb);
        }
        int lx = this.pickFrom(rand, 2, 12, 16);
        int lz = 2 + rand.nextInt(15);
        this.placeBlockRotated(world, aqz.bQ.cF, 0, lx, y + 2, lz, rotation, sbb);
        this.placeBlockRotated(world, aqz.aO.cF, rand.nextBoolean() ? 0 : 7, lx, y + 1, lz, rotation, sbb);
    }

    private void makeMiniGhastSpawner(abw world, Random rand, int y, int sx, int sz, agf sbb) {
        asj spawner = this.placeSpawnerAtCurrentPosition(world, rand, sx, y + 2, sz, TFCreatures.getSpawnerNameFor("Mini Ghast"), sbb);
        if (spawner != null) {
            by tags = new by();
            spawner.b(tags);
            tags.a("SpawnRange", (short)16);
            tags.a("MaxNearbyEntities", (short)world.r);
            tags.a("SpawnCount", (short)1);
            spawner.a(tags);
        }
    }

    protected void addBuilderPlatforms(abw world, Random rand, agf sbb, int bottom, int top) {
        int y;
        int spacing = 5;
        int floorside = 0;
        if (bottom == 0) {
            bottom += spacing;
        }
        for (y = bottom; y < top - spacing; y += spacing) {
            this.makeBuilderPlatforms(world, rand, sbb, floorside, y, y == bottom && bottom != spacing, y >= top - spacing);
            floorside += 1 + rand.nextInt(3);
            floorside %= 4;
        }
        this.makeBuilderPlatform(world, rand, 1, bottom, 5, true, sbb);
        this.makeBuilderPlatform(world, rand, 3, bottom, 5, true, sbb);
        for (y = bottom - 4; y < bottom; ++y) {
            this.placeBlockRotated(world, aqz.aK.cF, this.getLadderMeta(2, 1), 1, y, 5, 1, sbb);
            this.placeBlockRotated(world, aqz.aK.cF, this.getLadderMeta(2, 3), 1, y, 5, 3, sbb);
        }
        this.addTopBuilderPlatform(world, rand, bottom, top, spacing, sbb);
    }

    protected void makeBuilderPlatforms(abw world, Random rand, agf sbb, int rotation, int y, boolean bottom, boolean top) {
        int z2 = this.size / 2 + rand.nextInt(5) - rand.nextInt(5);
        this.makeBuilderPlatform(world, rand, rotation, y, z2, false, sbb);
        this.placeBlockRotated(world, aqz.aK.cF, this.getLadderMeta(2, rotation), 1, y + 1, z2, rotation, sbb);
        this.placeBlockRotated(world, aqz.aK.cF, this.getLadderMeta(2, rotation), 1, y + 2, z2, rotation, sbb);
        this.placeBlockRotated(world, aqz.aK.cF, this.getLadderMeta(2, rotation), 1, y + 3, z2, rotation, sbb);
        this.placeBlockRotated(world, aqz.aK.cF, this.getLadderMeta(2, rotation), 1, y + 4, z2, rotation, sbb);
        this.makeBuilderPlatform(world, rand, rotation, y + 5, z2, true, sbb);
        if (y % 2 == 1) {
            int sx = this.pickFrom(rand, 5, 9, 13);
            int sz = sx == 9 ? (rand.nextBoolean() ? 5 : 13) : 9;
            this.placeBlockRotated(world, TFBlocks.towerDevice.cF, 9, sx, y + 2, sz, rotation, sbb);
        } else {
            int sx = rand.nextBoolean() ? 5 : 13;
            int sz = rand.nextBoolean() ? 5 : 13;
            this.makeLampCluster(world, rand, sx, y, sz, rotation, sbb);
        }
    }

    private void addTopBuilderPlatform(abw world, Random rand, int bottom, int top, int spacing, agf sbb) {
        int rotation = (this.f.b + top + 1) % 4;
        this.fillBlocksRotated(world, sbb, 5, top - spacing, 9, 7, top - spacing, 11, this.deco.accentID, this.deco.accentMeta, rotation);
        this.fillBlocksRotated(world, sbb, 6, top - spacing, 9, 6, top, 9, this.deco.accentID, this.deco.accentMeta, rotation);
        this.fillBlocksRotated(world, sbb, 6, top - spacing + 1, 10, 6, top - 1, 10, aqz.aK.cF, this.getLadderMeta(3, rotation), rotation);
        this.placeBlockRotated(world, 0, 0, 6, top + 1, 9, rotation, sbb);
        this.placeBlockRotated(world, this.deco.fenceID, this.deco.fenceMeta, 5, top + 0, 10, rotation, sbb);
        this.placeBlockRotated(world, this.deco.fenceID, this.deco.fenceMeta, 7, top + 0, 10, rotation, sbb);
        this.placeBlockRotated(world, this.deco.fenceID, this.deco.fenceMeta, 5, top + 1, 10, rotation, sbb);
        this.placeBlockRotated(world, this.deco.fenceID, this.deco.fenceMeta, 7, top + 1, 10, rotation, sbb);
        this.placeBlockRotated(world, TFBlocks.towerDevice.cF, 6, 7, top - spacing, 10, rotation, sbb);
        this.placeBlockRotated(world, aqz.aO.cF, rand.nextBoolean() ? 5 : 6, 7, top - spacing + 1, 11, rotation, sbb);
    }

    private void makeBuilderPlatform(abw world, Random rand, int rotation, int y, int z2, boolean hole, agf sbb) {
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 1, y, z2 - 1, rotation, sbb);
        if (!hole) {
            this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 1, y, z2 - 0, rotation, sbb);
        }
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 1, y, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 2, y, z2 - 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 2, y, z2 - 0, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, 2, y, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, TFBlocks.towerDevice.cF, 6, 2, y, hole ? z2 + 1 : z2 - 1, rotation, sbb);
        this.placeBlockRotated(world, aqz.aO.cF, rand.nextBoolean() ? 5 : 6, 2, y + 1, z2 + 0, rotation, sbb);
    }

    private void makeLampCluster(abw world, Random rand, int sx, int y, int sz, int rotation, agf sbb) {
        int lz;
        int ly;
        int lx;
        int i;
        int radius = 4;
        block0: for (i = 0; i < 5; ++i) {
            lx = sx;
            ly = y;
            lz = sz;
            for (int move = 0; move < 10; ++move) {
                this.placeBlockRotated(world, aqz.bQ.cF, 0, lx, ly, lz, rotation, sbb);
                int direction = rand.nextInt(8);
                if (direction > 5) {
                    direction -= 2;
                }
                if ((lx += s.b[direction]) > sx + radius || lx < sx - radius || (ly += s.c[direction]) > y + radius || ly < y - radius || (lz += s.d[direction]) > sz + radius || lz < sz - radius) continue block0;
            }
        }
        block2: for (i = 0; i < 5; ++i) {
            int direction;
            int move;
            lx = sx;
            ly = y;
            lz = sz;
            int[] directions = new int[10];
            for (move = 0; move < 10; ++move) {
                directions[move] = rand.nextInt(8);
                if (directions[move] <= 5) continue;
                int n = move;
                directions[n] = directions[n] - 2;
            }
            for (move = 0; move < 10 && (lx += s.b[direction = directions[move]]) <= sx + radius && lx >= sx - radius && (ly += s.c[direction]) <= y + radius && ly >= y - radius && (lz += s.d[direction]) <= sz + radius && lz >= sz - radius; ++move) {
                if (this.getBlockIDRotated(world, lx, ly, lz, rotation, sbb) == aqz.bQ.cF) continue;
                this.placeBlockRotated(world, aqz.aO.cF, this.getLeverMeta(rotation, direction), lx, ly, lz, rotation, sbb);
                continue block2;
            }
        }
    }
}

