/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.structures.ComponentTFHedgeMaze;
import twilightforest.structures.ComponentTFHillMaze;
import twilightforest.structures.ComponentTFHollowHill;
import twilightforest.structures.ComponentTFHydraLair;
import twilightforest.structures.ComponentTFNagaCourtyard;
import twilightforest.structures.ComponentTFQuestGrove;
import twilightforest.structures.darktower.ComponentTFDarkTowerMain;
import twilightforest.structures.darktower.TFDarkTowerPieces;
import twilightforest.structures.lichtower.ComponentTFTowerMain;
import twilightforest.structures.lichtower.TFLichTowerPieces;
import twilightforest.structures.minotaurmaze.ComponentTFMazeRuins;
import twilightforest.structures.minotaurmaze.TFMinotaurMazePieces;
import twilightforest.structures.stronghold.ComponentTFStrongholdEntrance;
import twilightforest.structures.stronghold.TFStrongholdPieces;
import twilightforest.world.TFWorld;
import twilightforest.world.TFWorldChunkManager;

public class StructureTFMajorFeatureStart
extends aiv {
    public TFFeature feature;
    public boolean isActive;

    public StructureTFMajorFeatureStart() {
    }

    public StructureTFMajorFeatureStart(abw world, Random rand, int chunkX, int chunkZ) {
        ahs.b();
        int x = (chunkX << 4) + 8;
        int z2 = (chunkZ << 4) + 8;
        int y = TFWorld.SEALEVEL + 1;
        this.feature = TFFeature.getFeatureDirectlyAt(chunkX, chunkZ, world);
        ait firstComponent = this.makeFirstComponent(world, rand, this.feature, x, y, z2);
        if (firstComponent != null) {
            this.a.add(firstComponent);
            firstComponent.a(firstComponent, (List)this.a, rand);
        }
        this.c();
        if (firstComponent instanceof aii) {
            List var6 = ((aii)firstComponent).c;
            while (!var6.isEmpty()) {
                int var7 = rand.nextInt(var6.size());
                ait var8 = (ait)var6.remove(var7);
                var8.a(firstComponent, (List)this.a, rand);
            }
            this.c();
            int offY = -33;
            this.b.a(0, offY, 0);
            for (ait com : this.b()) {
                com.c().a(0, offY, 0);
            }
        }
        if (firstComponent instanceof ComponentTFTowerMain || firstComponent instanceof ComponentTFDarkTowerMain) {
            this.moveToAvgGroundLevel(world, x, z2);
        }
    }

    public ait makeFirstComponent(abw world, Random rand, TFFeature feature, int x, int y, int z2) {
        if (feature == TFFeature.nagaLair) {
            return new ComponentTFNagaCourtyard(world, rand, 0, x, y, z2);
        }
        if (feature == TFFeature.hedgeMaze) {
            return new ComponentTFHedgeMaze(world, rand, 0, x, y, z2);
        }
        if (feature == TFFeature.hill1) {
            return new ComponentTFHollowHill(world, rand, 0, 1, x, y, z2);
        }
        if (feature == TFFeature.hill2) {
            return new ComponentTFHollowHill(world, rand, 0, 2, x, y, z2);
        }
        if (feature == TFFeature.hill3) {
            return new ComponentTFHollowHill(world, rand, 0, 3, x, y, z2);
        }
        if (feature == TFFeature.wizardTower) {
            return new ComponentTFTowerMain(world, rand, 0, x, y, z2);
        }
        if (feature == TFFeature.questGrove) {
            return new ComponentTFQuestGrove(world, rand, 0, x, y, z2);
        }
        if (feature == TFFeature.hydraLair) {
            return new ComponentTFHydraLair(world, rand, 0, x, y, z2);
        }
        if (feature == TFFeature.labyrinth) {
            return new ComponentTFMazeRuins(world, rand, 0, x, y, z2);
        }
        if (feature == TFFeature.darkTower) {
            return new ComponentTFDarkTowerMain(world, rand, 0, x, y - 1, z2);
        }
        if (feature == TFFeature.tfStronghold) {
            return new ComponentTFStrongholdEntrance(world, rand, 0, x, y, z2);
        }
        return null;
    }

    public boolean d() {
        return this.feature.structureEnabled;
    }

    protected void moveToAvgGroundLevel(abw world, int x, int z2) {
        if (world.u() instanceof TFWorldChunkManager) {
            acq biomeAt = world.a(x, z2);
            int offY = (int)((biomeAt.D + biomeAt.E) * 8.0f);
            if (biomeAt == TFBiomeBase.darkForest) {
                offY += 4;
            }
            if (offY > 0) {
                this.b.a(0, offY, 0);
                for (ait com : this.b()) {
                    com.c().a(0, offY, 0);
                }
            }
        }
    }

    public void a(abw par1World, Random par2Random, agf par3StructureBoundingBox) {
        if (this.b().getFirst() instanceof ComponentTFStrongholdEntrance) {
            for (ait component : this.b()) {
                if (!(this.isShieldable(component) ? this.isIntersectingLarger(par3StructureBoundingBox, component) : this.isIntersectingLarger(par3StructureBoundingBox, component))) continue;
                if (this.isShieldable(component)) {
                    this.addShieldFor(par1World, component, this.b(), par3StructureBoundingBox);
                }
                component.a(par1World, par2Random, par3StructureBoundingBox);
            }
        } else {
            super.a(par1World, par2Random, par3StructureBoundingBox);
        }
    }

    private boolean isIntersectingLarger(agf chunkBB, ait component) {
        agf compBB = component.c();
        return compBB.d + 1 >= chunkBB.a && compBB.a - 1 <= chunkBB.d && compBB.f + 1 >= chunkBB.c && compBB.c - 1 <= chunkBB.f;
    }

    private boolean isShieldable(ait component) {
        return component.c().e <= 32;
    }

    private void addShieldFor(abw world, ait component, List<ait> otherComponents, agf chunkBox) {
        agf shieldBox = new agf(component.c());
        --shieldBox.a;
        --shieldBox.b;
        --shieldBox.c;
        ++shieldBox.d;
        ++shieldBox.e;
        ++shieldBox.f;
        ArrayList<ait> intersecting = new ArrayList<ait>();
        for (ait other : otherComponents) {
            if (other == component || !shieldBox.a(other.c())) continue;
            intersecting.add(other);
        }
        for (int x = shieldBox.a; x <= shieldBox.d; ++x) {
            for (int y = shieldBox.b; y <= shieldBox.e; ++y) {
                for (int z2 = shieldBox.c; z2 <= shieldBox.f; ++z2) {
                    if (x != shieldBox.a && x != shieldBox.d && y != shieldBox.b && y != shieldBox.e && z2 != shieldBox.c && z2 != shieldBox.f || !chunkBox.b(x, y, z2)) continue;
                    boolean notIntersecting = true;
                    for (ait other : intersecting) {
                        if (!other.c().b(x, y, z2)) continue;
                        notIntersecting = false;
                    }
                    if (!notIntersecting) continue;
                    world.f(x, y, z2, TFBlocks.shield.cF, this.calculateShieldMeta(shieldBox, x, y, z2), 2);
                }
            }
        }
    }

    private int calculateShieldMeta(agf shieldBox, int x, int y, int z2) {
        int shieldMeta = 0;
        if (x == shieldBox.a) {
            shieldMeta = 5;
        }
        if (x == shieldBox.d) {
            shieldMeta = 4;
        }
        if (z2 == shieldBox.c) {
            shieldMeta = 3;
        }
        if (z2 == shieldBox.f) {
            shieldMeta = 2;
        }
        if (y == shieldBox.b) {
            shieldMeta = 1;
        }
        if (y == shieldBox.e) {
            shieldMeta = 0;
        }
        return shieldMeta;
    }

    public void a(by par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        par1NBTTagCompound.a("Active", this.isActive);
    }

    public void b(by nbttagcompound) {
        super.b(nbttagcompound);
        this.isActive = nbttagcompound.n("Active");
    }

    static {
        air.b(StructureTFMajorFeatureStart.class, (String)"TFFeature");
        TFStrongholdPieces.registerPieces();
        TFMinotaurMazePieces.registerPieces();
        TFDarkTowerPieces.registerPieces();
        TFLichTowerPieces.registerPieces();
        air.a(ComponentTFHedgeMaze.class, (String)"TFHedge");
        air.a(ComponentTFHillMaze.class, (String)"TFHillMaze");
        air.a(ComponentTFHollowHill.class, (String)"TFHill");
        air.a(ComponentTFHydraLair.class, (String)"TFHydra");
        air.a(ComponentTFNagaCourtyard.class, (String)"TFNaga");
        air.a(ComponentTFQuestGrove.class, (String)"TFQuest1");
    }
}

