/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.List;
import java.util.Random;
import twilightforest.TFTreasure;
import twilightforest.entity.TFCreatures;
import twilightforest.structures.StructureTFComponent;
import twilightforest.world.TFGenCaveStalactite;

public class ComponentTFHollowHill
extends StructureTFComponent {
    int hillSize;
    int radius;

    public ComponentTFHollowHill(abw world, Random rand, int i, int size, int x, int y, int z2) {
        super(i);
        this.setCoordBaseMode(0);
        this.hillSize = size;
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.f = StructureTFComponent.getComponentToAddBoundingBox(x, y, z2, -this.radius, -3, -this.radius, this.radius * 2, 10, this.radius * 2, 0);
    }

    public void a(ait structurecomponent, List list, Random random) {
        super.a(structurecomponent, list, random);
    }

    public boolean a(abw world, Random rand, agf sbb) {
        int[] dest;
        int i;
        int[] sna = new int[]{0, 128, 256, 512};
        int sn = sna[this.hillSize];
        int[] mga = new int[]{0, 1, 4, 9};
        int mg = mga[this.hillSize];
        int[] tca = new int[]{0, 2, 6, 12};
        int tc2 = tca[this.hillSize];
        for (i = 0; i < mg; ++i) {
            dest = this.getCoordsInHill2D(rand);
            String mobID = this.getMobID(rand);
            this.placeSpawnerAtCurrentPosition(world, rand, dest[0], rand.nextInt(4), dest[1], mobID, sbb);
        }
        for (i = 0; i < tc2; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateTreasureChest(world, dest[0], 0, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateOreStalactite(world, dest[0], 1, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateStoneStalactite(world, 1.0f, true, dest[0], 1, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateStoneStalactite(world, 0.9f, false, dest[0], 1, dest[1], sbb);
        }
        if (this.hillSize == 3) {
            // empty if block
        }
        return true;
    }

    protected void generateTreasureChest(abw world, int x, int y, int z2, agf sbb) {
        Random chestRNG = new Random(world.H() + (long)(x * z2));
        this.placeTreasureAtCurrentPosition(world, chestRNG, x, y, z2, this.hillSize == 3 ? TFTreasure.hill3 : (this.hillSize == 2 ? TFTreasure.hill2 : TFTreasure.hill1), sbb);
        this.b(world, aqz.B.cF, 0, x, y - 1, z2, sbb);
    }

    protected void generateOreStalactite(abw world, int x, int y, int z2, agf sbb) {
        int dz;
        int dy;
        int dx = this.a(x, z2);
        if (sbb.b(dx, dy = this.a(y), dz = this.b(x, z2)) && world.a(dx, dy, dz) != aqz.ax.cF) {
            Random stalRNG = new Random(world.H() + (long)(dx * dz));
            TFGenCaveStalactite stalag = TFGenCaveStalactite.makeRandomOreStalactite(stalRNG, this.hillSize);
            stalag.a(world, stalRNG, dx, dy, dz);
        }
    }

    protected void generateStoneStalactite(abw world, float length, boolean up, int x, int y, int z2, agf sbb) {
        int dz;
        int dy;
        int dx = this.a(x, z2);
        if (sbb.b(dx, dy = this.a(y), dz = this.b(x, z2)) && world.a(dx, dy, dz) != aqz.ax.cF) {
            Random stalRNG = new Random(world.H() + (long)(dx * dz));
            if (this.hillSize == 1) {
                length *= 1.9f;
            }
            new TFGenCaveStalactite(aqz.y.cF, length, up).a(world, stalRNG, dx, dy, dz);
        }
    }

    boolean isInHill(int cx, int cz) {
        int dx = this.radius - cx;
        int dz = this.radius - cz;
        int dist = (int)Math.sqrt(dx * dx + dz * dz);
        return dist < this.radius;
    }

    boolean isInHill(int mapX, int mapY, int mapZ) {
        int dx = this.f.a + this.radius - mapX;
        int dy = (this.f.b - mapY) * 2;
        int dz = this.f.c + this.radius - mapZ;
        int dist = dx * dx + dy * dy + dz * dz;
        return dist < this.radius * this.radius;
    }

    int[] getCoordsInHill2D(Random rand) {
        return this.getCoordsInHill2D(rand, this.radius);
    }

    int[] getCoordsInHill2D(Random rand, int rad) {
        int rz2;
        int rx;
        while (!this.isInHill(rx = rand.nextInt(2 * rad), rz2 = rand.nextInt(2 * rad))) {
        }
        int[] coords = new int[]{rx, rz2};
        return coords;
    }

    protected String getMobID(Random rand) {
        return this.getMobID(rand, this.hillSize);
    }

    protected String getMobID(Random rand, int level) {
        if (level == 1) {
            return this.getLevel1Mob(rand);
        }
        if (level == 2) {
            return this.getLevel2Mob(rand);
        }
        if (level == 3) {
            return this.getLevel3Mob(rand);
        }
        return "Spider";
    }

    public String getLevel1Mob(Random rand) {
        switch (rand.nextInt(10)) {
            case 0: 
            case 1: 
            case 2: {
                return TFCreatures.getSpawnerNameFor("Swarm Spider");
            }
            case 3: 
            case 4: 
            case 5: {
                return "Spider";
            }
            case 6: 
            case 7: {
                return "Zombie";
            }
            case 8: {
                return "Silverfish";
            }
            case 9: {
                return TFCreatures.getSpawnerNameFor("Redcap");
            }
        }
        return TFCreatures.getSpawnerNameFor("Swarm Spider");
    }

    public String getLevel2Mob(Random rand) {
        switch (rand.nextInt(10)) {
            case 0: 
            case 1: 
            case 2: {
                return TFCreatures.getSpawnerNameFor("Redcap");
            }
            case 3: 
            case 4: 
            case 5: {
                return "Zombie";
            }
            case 6: 
            case 7: {
                return "Skeleton";
            }
            case 8: {
                return TFCreatures.getSpawnerNameFor("Swarm Spider");
            }
            case 9: {
                return "CaveSpider";
            }
        }
        return TFCreatures.getSpawnerNameFor("Redcap");
    }

    public String getLevel3Mob(Random rand) {
        switch (rand.nextInt(11)) {
            case 0: {
                return TFCreatures.getSpawnerNameFor("Slime Beetle");
            }
            case 1: {
                return TFCreatures.getSpawnerNameFor("Fire Beetle");
            }
            case 2: {
                return TFCreatures.getSpawnerNameFor("Pinch Beetle");
            }
            case 3: 
            case 4: 
            case 5: {
                return "Skeleton";
            }
            case 6: 
            case 7: 
            case 8: {
                return "CaveSpider";
            }
            case 9: {
                return "Creeper";
            }
        }
        return TFCreatures.getSpawnerNameFor("Twilight Wraith");
    }
}

