/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.List;
import twilightforest.TwilightForestMod;
import twilightforest.entity.EntityTFHydra;
import twilightforest.entity.EntityTFHydraHead;
import twilightforest.entity.EntityTFHydraMortar;
import twilightforest.entity.EntityTFHydraNeck;
import twilightforest.entity.EntityTFHydraPart;

public class HydraHeadContainer {
    private static int FLAME_BURN_FACTOR = 3;
    private static int FLAME_DAMAGE = 19;
    private static int BITE_DAMAGE = 48;
    private static double FLAME_BREATH_TRACKING_SPEED = 0.04;
    private static boolean FLAME_BREATH_BREAKS_BLOCKS = false;
    public static final int NEXT_AUTOMATIC = -1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_BITE_BEGINNING = 1;
    public static final int STATE_BITE_READY = 2;
    public static final int STATE_BITE_BITING = 3;
    public static final int STATE_BITE_ENDING = 4;
    public static final int STATE_FLAME_BEGINNING = 5;
    public static final int STATE_FLAME_BREATHING = 6;
    public static final int STATE_FLAME_ENDING = 7;
    public static final int STATE_MORTAR_BEGINNING = 8;
    public static final int STATE_MORTAR_LAUNCH = 9;
    public static final int STATE_MORTAR_ENDING = 10;
    public static final int STATE_DYING = 11;
    public static final int STATE_DEAD = 12;
    public static final int STATE_ATTACK_COOLDOWN = 13;
    public static final int STATE_BORN = 14;
    public static final int STATE_ROAR_START = 15;
    public static final int STATE_ROAR_RAWR = 16;
    public static final int NUM_STATES = 17;
    public EntityTFHydraHead headEntity;
    public EntityTFHydraNeck necka;
    public EntityTFHydraNeck neckb;
    public EntityTFHydraNeck neckc;
    public EntityTFHydraNeck neckd;
    public EntityTFHydraNeck necke;
    public nn targetEntity;
    public double targetX;
    public double targetY;
    public double targetZ;
    public int prevState;
    public int currentState;
    public int nextState = -1;
    public boolean didRoar;
    public boolean isSecondaryAttacking;
    public int ticksNeeded;
    public int ticksProgress;
    public final int headNum;
    public int damageTaken;
    public int respawnCounter;
    public final EntityTFHydra hydraObj;
    public int[] nextStates;
    public int[] stateDurations;
    public float[][] stateNeckLength;
    public float[][] stateXRotations;
    public float[][] stateYRotations;
    public float[][] stateMouthOpen;

    public HydraHeadContainer(EntityTFHydra hydra, int number, boolean startActive) {
        this.headNum = number;
        this.hydraObj = hydra;
        this.damageTaken = 0;
        this.respawnCounter = -1;
        this.didRoar = false;
        this.necka = new EntityTFHydraNeck(this.hydraObj, "neck" + this.headNum + "a", 2.0f, 2.0f);
        this.neckb = new EntityTFHydraNeck(this.hydraObj, "neck" + this.headNum + "b", 2.0f, 2.0f);
        this.neckc = new EntityTFHydraNeck(this.hydraObj, "neck" + this.headNum + "c", 2.0f, 2.0f);
        this.neckd = new EntityTFHydraNeck(this.hydraObj, "neck" + this.headNum + "d", 2.0f, 2.0f);
        this.necke = new EntityTFHydraNeck(this.hydraObj, "neck" + this.headNum + "e", 2.0f, 2.0f);
        this.nextStates = new int[17];
        this.nextStates[0] = 0;
        this.nextStates[1] = 2;
        this.nextStates[2] = 3;
        this.nextStates[3] = 4;
        this.nextStates[4] = 13;
        this.nextStates[5] = 6;
        this.nextStates[6] = 7;
        this.nextStates[7] = 13;
        this.nextStates[8] = 9;
        this.nextStates[9] = 10;
        this.nextStates[10] = 13;
        this.nextStates[13] = 0;
        this.nextStates[11] = 12;
        this.nextStates[12] = 12;
        this.nextStates[14] = 15;
        this.nextStates[15] = 16;
        this.nextStates[16] = 0;
        this.stateDurations = new int[17];
        this.setupStateDurations();
        this.stateNeckLength = new float[this.hydraObj.numHeads][17];
        this.stateXRotations = new float[this.hydraObj.numHeads][17];
        this.stateYRotations = new float[this.hydraObj.numHeads][17];
        this.stateMouthOpen = new float[this.hydraObj.numHeads][17];
        this.setupStateRotations();
        if (startActive) {
            this.prevState = 0;
            this.currentState = 0;
            this.nextState = -1;
            this.ticksNeeded = 60;
            this.ticksProgress = 60;
        } else {
            this.prevState = 12;
            this.currentState = 12;
            this.nextState = -1;
            this.ticksNeeded = 20;
            this.ticksProgress = 20;
        }
    }

    protected void setupStateDurations() {
        this.stateDurations[0] = 10;
        this.stateDurations[1] = 40;
        this.stateDurations[2] = 80;
        this.stateDurations[3] = 7;
        this.stateDurations[4] = 40;
        this.stateDurations[5] = 40;
        this.stateDurations[6] = 100;
        this.stateDurations[7] = 30;
        this.stateDurations[8] = 40;
        this.stateDurations[9] = 25;
        this.stateDurations[10] = 30;
        this.stateDurations[13] = 80;
        this.stateDurations[11] = 70;
        this.stateDurations[12] = 20;
        this.stateDurations[14] = 20;
        this.stateDurations[15] = 10;
        this.stateDurations[16] = 50;
    }

    protected void setupStateRotations() {
        this.setAnimation(0, 0, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, 0, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, 0, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, 0, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, 0, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, 0, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, 0, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, 13, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, 13, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, 13, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, 13, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, 13, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, 13, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, 13, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, 5, 50.0f, 0.0f, 8.0f, 0.75f);
        this.setAnimation(1, 5, 30.0f, 45.0f, 9.0f, 0.75f);
        this.setAnimation(2, 5, 30.0f, -45.0f, 9.0f, 0.75f);
        this.setAnimation(3, 5, 50.0f, 90.0f, 8.0f, 0.75f);
        this.setAnimation(4, 5, 50.0f, -90.0f, 8.0f, 0.75f);
        this.setAnimation(5, 5, -10.0f, 90.0f, 9.0f, 0.75f);
        this.setAnimation(6, 5, -10.0f, -90.0f, 9.0f, 0.75f);
        this.setAnimation(0, 6, 45.0f, 0.0f, 8.0f, 1.0f);
        this.setAnimation(1, 6, 30.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, 6, 30.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(3, 6, 50.0f, 90.0f, 8.0f, 1.0f);
        this.setAnimation(4, 6, 50.0f, -90.0f, 8.0f, 1.0f);
        this.setAnimation(5, 6, -10.0f, 90.0f, 9.0f, 1.0f);
        this.setAnimation(6, 6, -10.0f, -90.0f, 9.0f, 1.0f);
        this.setAnimation(0, 7, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, 7, 10.0f, 45.0f, 9.0f, 0.0f);
        this.setAnimation(2, 7, 10.0f, -45.0f, 9.0f, 0.0f);
        this.setAnimation(3, 7, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, 7, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, 7, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, 7, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, 1, -5.0f, 60.0f, 5.0f, 0.25f);
        this.setAnimation(1, 1, -10.0f, 60.0f, 9.0f, 0.25f);
        this.setAnimation(2, 1, -10.0f, -60.0f, 9.0f, 0.25f);
        this.setAnimation(0, 2, -5.0f, 60.0f, 5.0f, 1.0f);
        this.setAnimation(1, 2, -10.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, 2, -10.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(0, 3, -5.0f, -30.0f, 5.0f, 0.2f);
        this.setAnimation(1, 3, -10.0f, -30.0f, 5.0f, 0.2f);
        this.setAnimation(2, 3, -10.0f, 30.0f, 5.0f, 0.2f);
        this.setAnimation(0, 4, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, 4, -10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, 4, -10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(0, 8, 50.0f, 0.0f, 8.0f, 0.75f);
        this.setAnimation(1, 8, 30.0f, 45.0f, 9.0f, 0.75f);
        this.setAnimation(2, 8, 30.0f, -45.0f, 9.0f, 0.75f);
        this.setAnimation(3, 8, 50.0f, 90.0f, 8.0f, 0.75f);
        this.setAnimation(4, 8, 50.0f, -90.0f, 8.0f, 0.75f);
        this.setAnimation(5, 8, -10.0f, 90.0f, 9.0f, 0.75f);
        this.setAnimation(6, 8, -10.0f, -90.0f, 9.0f, 0.75f);
        this.setAnimation(0, 9, 45.0f, 0.0f, 8.0f, 1.0f);
        this.setAnimation(1, 9, 30.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, 9, 30.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(3, 9, 50.0f, 90.0f, 8.0f, 1.0f);
        this.setAnimation(4, 9, 50.0f, -90.0f, 8.0f, 1.0f);
        this.setAnimation(5, 9, -10.0f, 90.0f, 9.0f, 1.0f);
        this.setAnimation(6, 9, -10.0f, -90.0f, 9.0f, 1.0f);
        this.setAnimation(0, 10, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, 10, 10.0f, 45.0f, 9.0f, 0.0f);
        this.setAnimation(2, 10, 10.0f, -45.0f, 9.0f, 0.0f);
        this.setAnimation(3, 10, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, 10, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, 10, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, 10, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, 11, -20.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, 11, -20.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, 11, -20.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, 11, -20.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, 11, -20.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, 11, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, 11, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, 12, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(1, 12, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(2, 12, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(3, 12, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(4, 12, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(5, 12, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(6, 12, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(0, 14, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, 14, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, 14, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, 14, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, 14, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, 14, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, 14, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, 15, 60.0f, 0.0f, 7.0f, 0.25f);
        this.setAnimation(1, 15, 10.0f, 60.0f, 9.0f, 0.25f);
        this.setAnimation(2, 15, 10.0f, -60.0f, 9.0f, 0.25f);
        this.setAnimation(3, 15, 50.0f, 90.0f, 8.0f, 0.25f);
        this.setAnimation(4, 15, 50.0f, -90.0f, 8.0f, 0.25f);
        this.setAnimation(5, 15, -10.0f, 90.0f, 9.0f, 0.25f);
        this.setAnimation(6, 15, -10.0f, -90.0f, 9.0f, 0.25f);
        this.setAnimation(0, 16, 60.0f, 0.0f, 9.0f, 1.0f);
        this.setAnimation(1, 16, 10.0f, 60.0f, 11.0f, 1.0f);
        this.setAnimation(2, 16, 10.0f, -60.0f, 11.0f, 1.0f);
        this.setAnimation(3, 16, 50.0f, 90.0f, 10.0f, 1.0f);
        this.setAnimation(4, 16, 50.0f, -90.0f, 10.0f, 1.0f);
        this.setAnimation(5, 16, -10.0f, 90.0f, 11.0f, 1.0f);
        this.setAnimation(6, 16, -10.0f, -90.0f, 11.0f, 1.0f);
    }

    protected void setAnimation(int head, int state, float xRotation, float yRotation, float neckLength, float mouthOpen) {
        this.stateXRotations[head][state] = xRotation;
        this.stateYRotations[head][state] = yRotation;
        this.stateNeckLength[head][state] = neckLength;
        this.stateMouthOpen[head][state] = mouthOpen;
    }

    public EntityTFHydraNeck[] getNeckArray() {
        return new EntityTFHydraNeck[]{this.necka, this.neckb, this.neckc, this.neckd, this.necke};
    }

    public void onUpdate() {
        this.necka.l_();
        this.neckb.l_();
        this.neckc.l_();
        this.neckd.l_();
        this.necke.l_();
        if (this.headEntity == null) {
            this.headEntity = this.findNearbyHead("head" + this.headNum);
        }
        this.setDifficultyVariables();
        if (this.headEntity != null) {
            this.headEntity.P = this.isActive() ? 4.0f : 1.0f;
            this.headEntity.O = this.headEntity.P;
            if (!this.hydraObj.q.I) {
                this.advanceRespawnCounter();
                this.advanceHeadState();
                this.setHeadPosition();
                this.setHeadFacing();
                this.executeAttacks();
            } else {
                this.clientAnimateHeadDeath();
            }
            this.setNeckPosition();
            this.addMouthParticles();
            this.playSounds();
        }
    }

    protected void advanceRespawnCounter() {
        if (this.currentState == 12 && this.respawnCounter > -1 && --this.respawnCounter <= 0) {
            this.setNextState(14);
            this.damageTaken = 0;
            this.endCurrentAction();
            this.respawnCounter = -1;
        }
    }

    protected void clientAnimateHeadDeath() {
        if (this.headEntity.getState() == 11) {
            ++this.headEntity.aB;
            if (this.headEntity.aB > 0) {
                if (this.headEntity.aB < 20) {
                    this.doExplosionOn(this.headEntity, true);
                } else if (this.headEntity.aB < 30) {
                    this.doExplosionOn(this.necka, false);
                } else if (this.headEntity.aB < 40) {
                    this.doExplosionOn(this.neckb, false);
                } else if (this.headEntity.aB < 50) {
                    this.doExplosionOn(this.neckc, false);
                } else if (this.headEntity.aB < 60) {
                    this.doExplosionOn(this.neckd, false);
                } else if (this.headEntity.aB < 70) {
                    this.doExplosionOn(this.necke, false);
                }
            }
            this.necka.ay = 20;
            this.neckb.ay = 20;
            this.neckc.ay = 20;
            this.neckd.ay = 20;
            this.necke.ay = 20;
        } else {
            this.headEntity.aB = 0;
            this.headEntity.g((float)this.headEntity.a(tp.a).b());
        }
    }

    private void doExplosionOn(EntityTFHydraPart part, boolean large) {
        for (int i = 0; i < 10; ++i) {
            double var8 = part.aD().nextGaussian() * 0.02;
            double var4 = part.aD().nextGaussian() * 0.02;
            double var6 = part.aD().nextGaussian() * 0.02;
            String particle = large && part.aD().nextInt(5) == 0 ? "largeexplode" : "explode";
            part.q.a(particle, part.u + (double)(part.aD().nextFloat() * part.O * 2.0f) - (double)part.O, part.v + (double)(part.aD().nextFloat() * part.P), part.w + (double)(part.aD().nextFloat() * part.O * 2.0f) - (double)part.O, var8, var4, var6);
        }
    }

    protected void advanceHeadState() {
        if (++this.ticksProgress >= this.ticksNeeded) {
            int myNext;
            if (this.nextState == -1) {
                myNext = this.nextStates[this.currentState];
                if (myNext != this.currentState && this.isSecondaryAttacking && myNext == 13) {
                    this.isSecondaryAttacking = false;
                    myNext = 0;
                }
            } else {
                myNext = this.nextState;
                this.nextState = -1;
            }
            this.ticksNeeded = this.ticksProgress = this.stateDurations[myNext];
            this.ticksProgress = 0;
            this.prevState = this.currentState;
            this.currentState = myNext;
        }
        if (this.headEntity.getState() != this.currentState) {
            this.headEntity.setState(this.currentState);
        }
    }

    protected void setHeadFacing() {
        if (this.currentState == 2) {
            float yawOffOffset;
            this.faceEntity(this.targetEntity, 5.0f, this.hydraObj.bp());
            float biteMaxYaw = -60.0f;
            float biteMinYaw = -90.0f;
            if (this.headNum == 2) {
                biteMaxYaw = 60.0f;
                biteMinYaw = 90.0f;
            }
            if ((yawOffOffset = ls.g((float)(this.headEntity.A - this.hydraObj.aN))) > biteMaxYaw) {
                this.headEntity.A = this.hydraObj.aN + biteMaxYaw;
            }
            if (yawOffOffset < biteMinYaw) {
                this.headEntity.A = this.hydraObj.aN + biteMinYaw;
            }
            atc look = this.headEntity.aa();
            double distance = 16.0;
            this.targetX = this.headEntity.u + look.c * distance;
            this.targetY = this.headEntity.v + 1.5 + look.d * distance;
            this.targetZ = this.headEntity.w + look.e * distance;
        } else if (this.currentState == 3 || this.currentState == 4) {
            this.faceEntity(this.targetEntity, 5.0f, this.hydraObj.bp());
            this.headEntity.B = (float)((double)this.headEntity.B + 0.7853981633974483);
        } else if (this.currentState == 16) {
            this.faceVec(this.targetX, this.targetY, this.targetZ, 10.0f, this.hydraObj.bp());
        } else if (this.currentState == 6 || this.currentState == 5) {
            this.moveTargetCoordsTowardsTargetEntity(FLAME_BREATH_TRACKING_SPEED);
            this.faceVec(this.targetX, this.targetY, this.targetZ, 5.0f, this.hydraObj.bp());
        } else if (this.isActive()) {
            if (this.targetEntity != null) {
                this.faceEntity(this.targetEntity, 5.0f, this.hydraObj.bp());
            } else {
                this.faceIdle(1.5f, this.hydraObj.bp());
            }
        }
    }

    protected void moveTargetCoordsTowardsTargetEntity(double distance) {
        if (this.targetEntity != null) {
            atc vect = this.headEntity.q.V().a(this.targetEntity.u - this.targetX, this.targetEntity.v - this.targetY, this.targetEntity.w - this.targetZ);
            vect = vect.a();
            this.targetX += vect.c * distance;
            this.targetY += vect.d * distance;
            this.targetZ += vect.e * distance;
        }
    }

    protected void addMouthParticles() {
        atc vector = this.headEntity.aa();
        double dist = 3.5;
        double px2 = this.headEntity.u + vector.c * dist;
        double py = this.headEntity.v + 1.0 + vector.d * dist;
        double pz = this.headEntity.w + vector.e * dist;
        if (this.headEntity.getState() == 5) {
            this.headEntity.q.a("flame", px2 + this.headEntity.aD().nextDouble() - 0.5, py + this.headEntity.aD().nextDouble() - 0.5, pz + this.headEntity.aD().nextDouble() - 0.5, 0.0, 0.0, 0.0);
            this.headEntity.q.a("smoke", px2 + this.headEntity.aD().nextDouble() - 0.5, py + this.headEntity.aD().nextDouble() - 0.5, pz + this.headEntity.aD().nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.headEntity.getState() == 6) {
            atc look = this.headEntity.aa();
            for (int i = 0; i < 5; ++i) {
                double dx = look.c;
                double dy = look.d;
                double dz = look.e;
                double spread = 5.0 + this.headEntity.aD().nextDouble() * 2.5;
                double velocity = 1.0 + this.headEntity.aD().nextDouble();
                dx += this.headEntity.aD().nextGaussian() * (double)0.0075f * spread;
                dy += this.headEntity.aD().nextGaussian() * (double)0.0075f * spread;
                dz += this.headEntity.aD().nextGaussian() * (double)0.0075f * spread;
                TwilightForestMod.proxy.spawnParticle("largeflame", px2, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
        if (this.headEntity.getState() == 1 || this.headEntity.getState() == 2) {
            this.headEntity.q.a("splash", px2 + this.headEntity.aD().nextDouble() - 0.5, py + this.headEntity.aD().nextDouble() - 0.5, pz + this.headEntity.aD().nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.headEntity.getState() == 8) {
            this.headEntity.q.a("largesmoke", px2 + this.headEntity.aD().nextDouble() - 0.5, py + this.headEntity.aD().nextDouble() - 0.5, pz + this.headEntity.aD().nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void playSounds() {
        if (this.headEntity.getState() == 6 && this.headEntity.ac % 5 == 0) {
            this.headEntity.q.a(this.headEntity.u + 0.5, this.headEntity.v + 0.5, this.headEntity.w + 0.5, "mob.ghast.fireball", 0.5f + this.headEntity.aD().nextFloat(), this.headEntity.aD().nextFloat() * 0.7f + 0.3f);
        }
        if (this.headEntity.getState() == 16) {
            this.headEntity.q.a(this.headEntity.u + 0.5, this.headEntity.v + 0.5, this.headEntity.w + 0.5, "TwilightForest:mob.hydra.roar", 1.25f, this.headEntity.aD().nextFloat() * 0.3f + 0.7f);
        }
        if (this.headEntity.getState() == 2 && this.ticksProgress == 60) {
            this.headEntity.q.a(this.headEntity.u + 0.5, this.headEntity.v + 0.5, this.headEntity.w + 0.5, "TwilightForest:mob.hydra.warn", 2.0f, this.headEntity.aD().nextFloat() * 0.3f + 0.7f);
        }
        if (this.headEntity.getState() == 0) {
            this.didRoar = false;
        }
    }

    protected void setNeckPosition() {
        atc vector = null;
        float neckRotation = 0.0f;
        if (this.headNum == 0) {
            vector = this.headEntity.q.V().a(0.0, 3.0, -1.0);
            neckRotation = 0.0f;
        }
        if (this.headNum == 1) {
            vector = this.headEntity.q.V().a(-1.0, 3.0, 3.0);
            neckRotation = 90.0f;
        }
        if (this.headNum == 2) {
            vector = this.headEntity.q.V().a(1.0, 3.0, 3.0);
            neckRotation = -90.0f;
        }
        if (this.headNum == 3) {
            vector = this.headEntity.q.V().a(-1.0, 3.0, 3.0);
            neckRotation = 135.0f;
        }
        if (this.headNum == 4) {
            vector = this.headEntity.q.V().a(1.0, 3.0, 3.0);
            neckRotation = -135.0f;
        }
        if (this.headNum == 5) {
            vector = this.headEntity.q.V().a(-1.0, 3.0, 5.0);
            neckRotation = 135.0f;
        }
        if (this.headNum == 6) {
            vector = this.headEntity.q.V().a(1.0, 3.0, 5.0);
            neckRotation = -135.0f;
        }
        vector.b(-(this.hydraObj.aN + neckRotation) * 3.141593f / 180.0f);
        this.setNeckPositon(this.hydraObj.u + vector.c, this.hydraObj.v + vector.d, this.hydraObj.w + vector.e, this.hydraObj.aN, 0.0f);
    }

    protected void setHeadPosition() {
        float periodX;
        this.setupStateDurations();
        this.setupStateRotations();
        float neckLength = this.getCurrentNeckLength();
        float xRotation = this.getCurrentHeadXRotation();
        float yRotation = this.getCurrentHeadYRotation();
        float f = this.headNum == 0 || this.headNum == 3 ? 20.0f : (periodX = this.headNum == 1 || this.headNum == 4 ? 5.0f : 7.0f);
        float periodY = this.headNum == 0 || this.headNum == 4 ? 10.0f : (this.headNum == 1 || this.headNum == 6 ? 6.0f : 5.0f);
        float xSwing = ls.a((float)((float)this.hydraObj.ac / periodX)) * 3.0f;
        float ySwing = ls.a((float)((float)this.hydraObj.ac / periodY)) * 5.0f;
        if (!this.isActive()) {
            ySwing = 0.0f;
            xSwing = 0.0f;
        }
        atc vector = this.headEntity.q.V().a(0.0, 0.0, (double)neckLength);
        vector.a((xRotation * 3.141593f + xSwing) / 180.0f);
        vector.b(-(this.hydraObj.aN + yRotation + ySwing) * 3.141593f / 180.0f);
        double dx = this.hydraObj.u + vector.c;
        double dy = this.hydraObj.v + vector.d + 3.0;
        double dz = this.hydraObj.w + vector.e;
        this.headEntity.b(dx, dy, dz);
        this.headEntity.setMouthOpen(this.getCurrentMouthOpen());
    }

    protected void executeAttacks() {
        nn target;
        if (this.currentState == 9 && this.ticksProgress % 10 == 0) {
            nn lookTarget = this.getHeadLookTarget();
            if (lookTarget != null && (lookTarget instanceof EntityTFHydraPart || lookTarget instanceof si)) {
                this.endCurrentAction();
            } else {
                EntityTFHydraMortar mortar = new EntityTFHydraMortar(this.headEntity.q, (of)this.headEntity);
                atc vector = this.headEntity.aa();
                double dist = 3.5;
                double px2 = this.headEntity.u + vector.c * dist;
                double py = this.headEntity.v + 1.0 + vector.d * dist;
                double pz = this.headEntity.w + vector.e * dist;
                mortar.b(px2, py, pz, 0.0f, 0.0f);
                if (this.targetEntity != null && !this.headEntity.o(this.targetEntity)) {
                    mortar.setToBlasting();
                }
                this.headEntity.q.a((uf)null, 1008, (int)this.headEntity.u, (int)this.headEntity.v, (int)this.headEntity.w, 0);
                this.headEntity.q.d((nn)mortar);
            }
        }
        if (this.headEntity.getState() == 3) {
            List nearbyList = this.headEntity.q.b((nn)this.headEntity, this.headEntity.E.b(0.0, 1.0, 0.0));
            for (nn nearby : nearbyList) {
                if (!(nearby instanceof of) || nearby instanceof EntityTFHydraPart || nearby instanceof EntityTFHydra || nearby instanceof si) continue;
                nearby.a(nb.a((of)this.hydraObj), (float)BITE_DAMAGE);
            }
        }
        if (this.headEntity.getState() == 6 && (target = this.getHeadLookTarget()) != null) {
            if (target instanceof EntityTFHydraPart || target instanceof si) {
                this.endCurrentAction();
            } else if (!target.F() && target.a(nb.a, (float)FLAME_DAMAGE)) {
                target.d(FLAME_BURN_FACTOR);
            }
        }
    }

    protected void setDifficultyVariables() {
        if (this.hydraObj.q.r < 3) {
            FLAME_BREATH_TRACKING_SPEED = 0.04;
            FLAME_BREATH_BREAKS_BLOCKS = false;
        } else {
            FLAME_BREATH_TRACKING_SPEED = 0.1;
            FLAME_BREATH_BREAKS_BLOCKS = true;
        }
    }

    private nn getHeadLookTarget() {
        nn pointedEntity = null;
        double range = 30.0;
        atc srcVec = this.headEntity.q.V().a(this.headEntity.u, this.headEntity.v + 1.0, this.headEntity.w);
        atc lookVec = this.headEntity.j(1.0f);
        atc destVec = srcVec.c(lookVec.c * range, lookVec.d * range, lookVec.e * range);
        float var9 = 3.0f;
        List possibleList = this.headEntity.q.b((nn)this.headEntity, this.headEntity.E.a(lookVec.c * range, lookVec.d * range, lookVec.e * range).b((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (nn possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.L() || possibleEntity == this.headEntity || possibleEntity == this.necka || possibleEntity == this.neckb || possibleEntity == this.neckc) continue;
            float borderSize = possibleEntity.Z();
            asx collisionBB = possibleEntity.E.b((double)borderSize, (double)borderSize, (double)borderSize);
            ata interceptPos = collisionBB.a(srcVec, destVec);
            if (collisionBB.a(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (interceptPos == null || !((possibleDist = srcVec.d(interceptPos.f)) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    private float calcMortarVelocity() {
        float dist = this.headEntity.d(this.targetEntity);
        return dist > 20.0f ? 1.0f : 0.75f;
    }

    public void setNextState(int next) {
        this.nextState = next;
    }

    public void endCurrentAction() {
        this.ticksProgress = this.ticksNeeded;
    }

    private EntityTFHydraHead findNearbyHead(String string) {
        List nearbyHeads = this.hydraObj.q.a(EntityTFHydraHead.class, asx.a().a(this.hydraObj.u, this.hydraObj.v, this.hydraObj.w, this.hydraObj.u + 1.0, this.hydraObj.v + 1.0, this.hydraObj.w + 1.0).b(16.0, 16.0, 16.0));
        for (EntityTFHydraHead nearbyHead : nearbyHeads) {
            if (!nearbyHead.getPartName().equals(string)) continue;
            nearbyHead.hydraObj = this.hydraObj;
            return nearbyHead;
        }
        return null;
    }

    protected float getCurrentNeckLength() {
        float prevLength = this.stateNeckLength[this.headNum][this.prevState];
        float curLength = this.stateNeckLength[this.headNum][this.currentState];
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return prevLength + (curLength - prevLength) * progress;
    }

    protected float getCurrentHeadXRotation() {
        float prevRotation = this.stateXRotations[this.headNum][this.prevState];
        float currentRotation = this.stateXRotations[this.headNum][this.currentState];
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return prevRotation + (currentRotation - prevRotation) * progress;
    }

    protected float getCurrentHeadYRotation() {
        float prevRotation = this.stateYRotations[this.headNum][this.prevState];
        float currentRotation = this.stateYRotations[this.headNum][this.currentState];
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return prevRotation + (currentRotation - prevRotation) * progress;
    }

    protected float getCurrentMouthOpen() {
        float prevOpen = this.stateMouthOpen[this.headNum][this.prevState];
        float curOpen = this.stateMouthOpen[this.headNum][this.currentState];
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return prevOpen + (curOpen - prevOpen) * progress;
    }

    protected void setNeckPositon(double startX, double startY, double startZ, float startYaw, float startPitch) {
        atc vector;
        double endX = this.headEntity.u;
        double endY = this.headEntity.v;
        double endZ = this.headEntity.w;
        float endYaw = this.headEntity.A;
        float endPitch = this.headEntity.B;
        while (startYaw - endYaw < -180.0f) {
            endYaw -= 360.0f;
        }
        while (startYaw - endYaw >= 180.0f) {
            endYaw += 360.0f;
        }
        while (startPitch - endPitch < -180.0f) {
            endPitch -= 360.0f;
        }
        while (startPitch - endPitch >= 180.0f) {
            endPitch += 360.0f;
        }
        if (endPitch > 0.0f) {
            vector = this.headEntity.q.V().a(0.0, 0.0, -1.0);
            vector.b(-endYaw * 3.141593f / 180.0f);
            endX += vector.c;
            endY += vector.d;
            endZ += vector.e;
        } else {
            vector = this.headEntity.aa();
            float dist = 1.0f;
            endX -= vector.c * (double)dist;
            endY -= vector.d * (double)dist;
            endZ -= vector.e * (double)dist;
        }
        float factor = 0.0f;
        factor = 0.0f;
        this.necka.b(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.necka.A = endYaw + (startYaw - endYaw) * factor;
        this.necka.B = endPitch + (startPitch - endPitch) * factor;
        factor = 0.25f;
        this.neckb.b(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckb.A = endYaw + (startYaw - endYaw) * factor;
        this.neckb.B = endPitch + (startPitch - endPitch) * factor;
        factor = 0.5f;
        this.neckc.b(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckc.A = endYaw + (startYaw - endYaw) * factor;
        this.neckc.B = endPitch + (startPitch - endPitch) * factor;
        factor = 0.75f;
        this.neckd.b(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckd.A = endYaw + (startYaw - endYaw) * factor;
        this.neckd.B = endPitch + (startPitch - endPitch) * factor;
        factor = 1.0f;
        this.necke.b(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.necke.A = endYaw + (startYaw - endYaw) * factor;
        this.necke.B = endPitch + (startPitch - endPitch) * factor;
    }

    protected void faceIdle(float yawConstraint, float pitchConstraint) {
        float angle = this.hydraObj.A * 3.141593f / 180.0f;
        float distance = 30.0f;
        double dx = this.hydraObj.u - (double)(ls.a((float)angle) * distance);
        double dy = this.hydraObj.v + 3.0;
        double dz = this.hydraObj.w + (double)(ls.b((float)angle) * distance);
        this.faceVec(dx, dy, dz, yawConstraint, pitchConstraint);
    }

    public void faceEntity(nn entity, float yawConstraint, float pitchConstraint) {
        double yTarget;
        if (entity instanceof of) {
            of entityliving = (of)entity;
            yTarget = entityliving.v + (double)entityliving.f();
        } else {
            yTarget = (entity.E.b + entity.E.e) / 2.0;
        }
        this.faceVec(entity.u, yTarget, entity.w, yawConstraint, pitchConstraint);
        this.targetX = entity.u;
        this.targetY = entity.v;
        this.targetZ = entity.w;
    }

    public void faceVec(double xCoord, double yCoord, double zCoord, float yawConstraint, float pitchConstraint) {
        double xOffset = xCoord - this.headEntity.u;
        double zOffset = zCoord - this.headEntity.w;
        double yOffset = this.headEntity.v + 1.0 - yCoord;
        double distance = ls.a((double)(xOffset * xOffset + zOffset * zOffset));
        float xyAngle = (float)(Math.atan2(zOffset, xOffset) * 180.0 / Math.PI) - 90.0f;
        float zdAngle = (float)(-(Math.atan2(yOffset, distance) * 180.0 / Math.PI));
        this.headEntity.B = -this.updateRotation(this.headEntity.B, zdAngle, pitchConstraint);
        this.headEntity.A = this.updateRotation(this.headEntity.A, xyAngle, yawConstraint);
    }

    private float updateRotation(float current, float intended, float increment) {
        float delta = ls.g((float)(intended - current));
        if (delta > increment) {
            delta = increment;
        }
        if (delta < -increment) {
            delta = -increment;
        }
        return ls.g((float)(current + delta));
    }

    public nn getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(nn targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void setHurtTime(int hurtTime) {
        if (this.headEntity != null) {
            this.headEntity.ay = hurtTime;
        }
        this.necka.ay = hurtTime;
        this.neckb.ay = hurtTime;
        this.neckc.ay = hurtTime;
        this.neckd.ay = hurtTime;
        this.necke.ay = hurtTime;
    }

    public boolean shouldRenderHead() {
        return this.headEntity.getState() != 12 && this.headEntity.aB < 20;
    }

    public boolean shouldRenderNeck(int neckNum) {
        int time = 30 + 10 * neckNum;
        return this.headEntity.getState() != 12 && this.headEntity.aB < time;
    }

    public boolean isActive() {
        return this.currentState != 11 && this.currentState != 12;
    }

    public void addDamage(float damageAmount) {
        this.damageTaken = (int)((float)this.damageTaken + damageAmount);
    }

    public int getDamageTaken() {
        return this.damageTaken;
    }

    public void setRespawnCounter(int count) {
        this.respawnCounter = count;
    }
}

