/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.entity.EntityTFBlockGoblin;
import twilightforest.entity.EntityTFDeathTome;
import twilightforest.entity.EntityTFFireBeetle;
import twilightforest.entity.EntityTFGoblinKnightLower;
import twilightforest.entity.EntityTFHelmetCrab;
import twilightforest.entity.EntityTFKobold;
import twilightforest.entity.EntityTFMazeSlime;
import twilightforest.entity.EntityTFMiniGhast;
import twilightforest.entity.EntityTFMinotaur;
import twilightforest.entity.EntityTFPinchBeetle;
import twilightforest.entity.EntityTFRedcap;
import twilightforest.entity.EntityTFRedcapSapper;
import twilightforest.entity.EntityTFSlimeBeetle;
import twilightforest.entity.EntityTFSwarmSpider;
import twilightforest.entity.EntityTFTowerBroodling;
import twilightforest.entity.EntityTFTowerGhast;
import twilightforest.entity.EntityTFTowerGolem;
import twilightforest.entity.EntityTFWraith;
import twilightforest.world.TFWorld;
import twilightforest.world.TFWorldChunkManager;

public class TFFeature {
    public static final TFFeature[] featureList = new TFFeature[256];
    public static final TFFeature nothing = new TFFeature(0, 0, "No Feature").enableDecorations().disableStructure();
    public static final TFFeature hill1 = new TFFeature(1, 1, "Small Hollow Hill").enableDecorations();
    public static final TFFeature hill2 = new TFFeature(2, 2, "Medium Hollow Hill").enableDecorations();
    public static final TFFeature hill3 = new TFFeature(3, 3, "Large Hollow Hill").enableDecorations();
    public static final TFFeature hedgeMaze = new TFFeature(4, 2, "Hedge Maze");
    public static final TFFeature nagaLair = new TFFeature(5, 3, "Naga Courtyard");
    public static final TFFeature wizardTower = new TFFeature(6, 1, "Wizard Tower");
    public static final TFFeature glacierMaze = new TFFeature(7, 2, "Glacier Maze").disableStructure();
    public static final TFFeature questIsland = new TFFeature(8, 1, "Quest Island").disableStructure();
    public static final TFFeature questGrove = new TFFeature(9, 1, "Quest Grove");
    public static final TFFeature druidGrove = new TFFeature(10, 1, "Druid Grove").disableStructure();
    public static final TFFeature floatRuins = new TFFeature(11, 3, "Floating Ruins").disableStructure();
    public static final TFFeature hydraLair = new TFFeature(12, 2, "Hydra Lair");
    public static final TFFeature labyrinth = new TFFeature(13, 3, "Labyrinth").enableDecorations();
    public static final TFFeature darkTower = new TFFeature(14, 1, "Dark Tower");
    public static final TFFeature tfStronghold = new TFFeature(15, 3, "Knight Stronghold").enableDecorations();
    public static final TFFeature worldTree = new TFFeature(16, 3, "World Tree").disableStructure();
    public static final TFFeature yetiCave = new TFFeature(17, 2, "Yeti Lairs").disableStructure().enableDecorations();
    public static final TFFeature trollCave = new TFFeature(18, 2, "Troll Lairs").disableStructure().enableDecorations();
    public static final TFFeature finalCastle = new TFFeature(19, 2, "Final Castle").disableStructure();
    public static final TFFeature underground = new TFFeature(255, 0, "Underground");
    ArrayList emptyList = new ArrayList();
    public int featureID;
    public int size;
    public String name;
    public boolean chunkDecorationsEnabled;
    public boolean structureEnabled;
    protected List<List<acr>> spawnableMonsterLists;
    protected List<acr> ambientCreatureList;
    protected List<acr> waterCreatureList;

    public TFFeature(int parID, int parSize, String parName) {
        this.featureID = parID;
        TFFeature.featureList[parID] = this;
        this.size = parSize;
        this.name = parName;
        this.chunkDecorationsEnabled = false;
        this.structureEnabled = true;
        this.spawnableMonsterLists = new ArrayList<List<acr>>();
        this.ambientCreatureList = new ArrayList<acr>();
        this.waterCreatureList = new ArrayList<acr>();
        this.ambientCreatureList.add(new acr(ro.class, 10, 8, 8));
    }

    public TFFeature enableDecorations() {
        this.chunkDecorationsEnabled = true;
        return this;
    }

    public TFFeature disableStructure() {
        this.structureEnabled = false;
        return this;
    }

    public TFFeature addMonster(Class monsterClass, int weight, int minGroup, int maxGroup) {
        this.addMonster(0, monsterClass, weight, minGroup, maxGroup);
        return this;
    }

    public TFFeature addMonster(int listIndex, Class monsterClass, int weight, int minGroup, int maxGroup) {
        List<Object> monsterList;
        if (this.spawnableMonsterLists.size() > listIndex) {
            monsterList = this.spawnableMonsterLists.get(listIndex);
        } else {
            monsterList = new ArrayList();
            this.spawnableMonsterLists.add(listIndex, monsterList);
        }
        monsterList.add(new acr(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public TFFeature addWaterCreature(Class monsterClass, int weight, int minGroup, int maxGroup) {
        this.waterCreatureList.add(new acr(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public static TFFeature getFeatureDirectlyAt(int chunkX, int chunkZ, abw world) {
        if (world != null && world.u() instanceof TFWorldChunkManager) {
            TFWorldChunkManager tfManager = (TFWorldChunkManager)world.u();
            if (tfManager.isInFeatureChunk(chunkX << 4, chunkZ << 4)) {
                return tfManager.getFeatureAt(chunkX << 4, chunkZ << 4, world);
            }
            return nothing;
        }
        return nothing;
    }

    public static TFFeature generateFeatureFor(int chunkX, int chunkZ, abw world) {
        acq biomeAt = world.a((chunkX << 4) + 8, (chunkZ << 4) + 8);
        Random hillRNG = new Random(world.H() + (long)(chunkX * 25117) + (long)(chunkZ * 151121));
        int randnum = hillRNG.nextInt(16);
        if (biomeAt == TFBiomeBase.glacier) {
            return glacierMaze;
        }
        if (biomeAt == TFBiomeBase.tfLake) {
            return questIsland;
        }
        if (biomeAt == TFBiomeBase.enchantedForest) {
            return questGrove;
        }
        if (biomeAt == TFBiomeBase.fireSwamp) {
            return hydraLair;
        }
        if (biomeAt == TFBiomeBase.clearing || biomeAt == TFBiomeBase.clearingBorder) {
            return labyrinth;
        }
        if (biomeAt == TFBiomeBase.darkForest) {
            switch (randnum % 3) {
                case 0: {
                    break;
                }
                case 1: {
                    return darkTower;
                }
                case 2: {
                    return tfStronghold;
                }
            }
        }
        switch (randnum) {
            default: {
                return hill1;
            }
            case 7: 
            case 8: 
            case 9: {
                return hill2;
            }
            case 10: {
                return hill3;
            }
            case 11: 
            case 12: {
                return hedgeMaze;
            }
            case 13: {
                return biomeAt != TFBiomeBase.swamp ? nagaLair : hydraLair;
            }
            case 14: 
            case 15: 
        }
        return wizardTower;
    }

    public static TFFeature generateFeaturePreset5x5(int chunkX, int chunkZ, abw world) {
        int cf = 16;
        if (chunkX % cf != 0 || chunkZ % cf != 0) {
            return nothing;
        }
        int mx = chunkX / cf + 4;
        int mz = chunkZ / cf + 4;
        int[][] map = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 19, 18, 8, 15, 14, 0}, {0, 0, 18, 18, 2, 3, 15, 0}, {0, 0, 4, 4, 5, 16, 9, 0}, {0, 0, 13, 6, 1, 2, 17, 0}, {0, 0, 12, 13, 3, 17, 7, 0}, {0, 0, 0, 0, 0, 0, 0, 0}};
        if (mx >= 0 && mx < 8 && mz >= 0 && mz < 8) {
            return featureList[map[mz][mx]];
        }
        return nothing;
    }

    public static TFFeature generateFeaturePreset6x6(int chunkX, int chunkZ, abw world) {
        int cf = 16;
        if (chunkX % cf != 0 || chunkZ % cf != 0) {
            return nothing;
        }
        int mx = chunkX / cf + 3;
        int mz = chunkZ / cf + 3;
        int[][] map = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {0, 19, 19, 18, 15, 0, 0, 0}, {0, 18, 18, 18, 0, 14, 0, 0}, {0, 0, 4, 1, 2, 3, 15, 0}, {0, 4, 1, 5, 16, 9, 17, 0}, {0, 0, 13, 2, 3, 17, 17, 0}, {0, 0, 12, 13, 6, 17, 7, 0}, {0, 0, 0, 0, 0, 0, 0, 0}};
        if (mx >= 0 && mx < 8 && mz >= 0 && mz < 8) {
            return featureList[map[mz][mx]];
        }
        return nothing;
    }

    public static TFFeature getNearestFeature(int cx, int cz, abw world) {
        for (int rad = 1; rad <= 3; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z2 = -rad; z2 <= rad; ++z2) {
                    TFFeature directlyAt = TFFeature.getFeatureDirectlyAt(x + cx, z2 + cz, world);
                    if (directlyAt.size != rad) continue;
                    return directlyAt;
                }
            }
        }
        return nothing;
    }

    public static TFFeature getNearestFeatureIncludeMore(int chunkX, int chunkZ, abw world) {
        int featureZ;
        int featureX = Math.round((float)chunkX / 16.0f) * 16;
        TFFeature directlyAt = TFFeature.getFeatureDirectlyAt(featureX, featureZ = Math.round((float)chunkZ / 16.0f) * 16, world);
        if (directlyAt != nothing) {
            return directlyAt;
        }
        return nothing;
    }

    public static int[] getNearestCenter(int cx, int cz, abw world) {
        for (int rad = 1; rad <= 3; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z2 = -rad; z2 <= rad; ++z2) {
                    if (TFFeature.getFeatureDirectlyAt((int)(x + cx), (int)(z2 + cz), (abw)world).size != rad) continue;
                    int[] center = new int[]{x * 16 + 8, z2 * 16 + 8};
                    return center;
                }
            }
        }
        int[] no = new int[]{0, 0};
        return no;
    }

    public static t getNearestCenterXYZ(int cx, int cz, abw world) {
        int fx = (int)(Math.round((double)cx / 256.0) * 256L + 8L);
        int fz = (int)(Math.round((double)cz / 256.0) * 256L + 8L);
        return new t(fx, TFWorld.SEALEVEL, fz);
    }

    public List<acr> getSpawnableList(oh par1EnumCreatureType) {
        if (par1EnumCreatureType == oh.a) {
            return this.getSpawnableList(oh.a, 0);
        }
        if (par1EnumCreatureType == oh.c) {
            return this.ambientCreatureList;
        }
        if (par1EnumCreatureType == oh.d) {
            return this.waterCreatureList;
        }
        return this.emptyList;
    }

    public List<acr> getSpawnableList(oh par1EnumCreatureType, int index) {
        if (par1EnumCreatureType == oh.a) {
            if (index >= 0 && index < this.spawnableMonsterLists.size()) {
                return this.spawnableMonsterLists.get(index);
            }
            return this.emptyList;
        }
        return this.getSpawnableList(par1EnumCreatureType);
    }

    static {
        wizardTower.addMonster(tw.class, 10, 4, 4);
        wizardTower.addMonster(tr.class, 10, 4, 4);
        wizardTower.addMonster(tf.class, 1, 4, 4);
        wizardTower.addMonster(tg.class, 1, 1, 4);
        wizardTower.addMonster(EntityTFDeathTome.class, 10, 4, 4);
        hill1.addMonster(tt.class, 10, 4, 4);
        hill1.addMonster(tw.class, 10, 4, 4);
        hill1.addMonster(EntityTFRedcap.class, 10, 4, 4);
        hill1.addMonster(EntityTFSwarmSpider.class, 10, 4, 4);
        hill1.addMonster(EntityTFKobold.class, 10, 4, 8);
        hill2.addMonster(EntityTFRedcap.class, 10, 4, 4);
        hill3.addMonster(EntityTFRedcapSapper.class, 1, 1, 4);
        hill2.addMonster(EntityTFKobold.class, 10, 4, 8);
        hill2.addMonster(tr.class, 10, 4, 4);
        hill2.addMonster(EntityTFSwarmSpider.class, 10, 4, 4);
        hill2.addMonster(tt.class, 10, 4, 4);
        hill2.addMonster(tf.class, 10, 4, 4);
        hill2.addMonster(EntityTFFireBeetle.class, 5, 4, 4);
        hill3.addMonster(EntityTFSlimeBeetle.class, 5, 4, 4);
        hill3.addMonster(EntityTFRedcap.class, 10, 4, 4);
        hill3.addMonster(EntityTFRedcapSapper.class, 2, 1, 4);
        hill3.addMonster(tr.class, 10, 4, 4);
        hill3.addMonster(te.class, 10, 4, 4);
        hill3.addMonster(tf.class, 10, 4, 4);
        hill3.addMonster(tg.class, 1, 1, 4);
        hill3.addMonster(EntityTFWraith.class, 2, 1, 4);
        hill3.addMonster(EntityTFFireBeetle.class, 10, 4, 4);
        hill3.addMonster(EntityTFSlimeBeetle.class, 10, 4, 4);
        hill3.addMonster(EntityTFPinchBeetle.class, 10, 2, 4);
        labyrinth.addMonster(EntityTFMinotaur.class, 20, 2, 4);
        labyrinth.addMonster(te.class, 10, 4, 4);
        labyrinth.addMonster(tf.class, 10, 4, 4);
        labyrinth.addMonster(EntityTFMazeSlime.class, 10, 4, 4);
        labyrinth.addMonster(tg.class, 1, 1, 4);
        labyrinth.addMonster(EntityTFFireBeetle.class, 10, 4, 4);
        labyrinth.addMonster(EntityTFSlimeBeetle.class, 10, 4, 4);
        labyrinth.addMonster(EntityTFPinchBeetle.class, 10, 2, 4);
        underground.addMonster(tt.class, 10, 4, 4);
        underground.addMonster(tw.class, 10, 4, 4);
        underground.addMonster(tr.class, 10, 4, 4);
        underground.addMonster(tf.class, 1, 4, 4);
        underground.addMonster(ts.class, 10, 4, 4);
        underground.addMonster(tg.class, 1, 1, 4);
        underground.addMonster(EntityTFKobold.class, 10, 4, 8);
        darkTower.addMonster(EntityTFTowerGolem.class, 10, 4, 4);
        darkTower.addMonster(tr.class, 10, 4, 4);
        darkTower.addMonster(tf.class, 10, 4, 4);
        darkTower.addMonster(tg.class, 2, 1, 4);
        darkTower.addMonster(EntityTFMiniGhast.class, 10, 1, 4);
        darkTower.addMonster(EntityTFTowerBroodling.class, 10, 8, 8);
        darkTower.addMonster(EntityTFPinchBeetle.class, 10, 2, 4);
        darkTower.addMonster(1, EntityTFTowerGhast.class, 10, 1, 4);
        darkTower.addWaterCreature(sc.class, 10, 4, 4);
        tfStronghold.addMonster(EntityTFBlockGoblin.class, 10, 4, 4);
        tfStronghold.addMonster(EntityTFGoblinKnightLower.class, 5, 1, 2);
        tfStronghold.addMonster(EntityTFHelmetCrab.class, 10, 4, 4);
        tfStronghold.addMonster(EntityTFSlimeBeetle.class, 10, 4, 4);
        tfStronghold.addMonster(EntityTFRedcapSapper.class, 2, 1, 4);
        tfStronghold.addMonster(EntityTFKobold.class, 10, 4, 8);
        tfStronghold.addMonster(tf.class, 10, 4, 4);
        tfStronghold.addMonster(ts.class, 5, 4, 4);
    }
}

