/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Hooks {
    private Map<String, Class> classHooks = new HashMap<String, Class>();
    private Map<String, Method> methodHooks = new HashMap<String, Method>();
    private Map<String, String> classPackages = new HashMap<String, String>();

    private void checkClassPackages() {
        if (this.classPackages.size() < 1) {
            this.classPackages.put("MetalInfoDatabase", "rebelkeithy.mods.metallurgy.core");
            this.classPackages.put("MetalSet", "rebelkeithy.mods.metallurgy.core.metalsets");
            this.classPackages.put("OreInfo", "rebelkeithy.mods.metallurgy.core.metalsets");
            this.classPackages.put("CrusherRecipes", "rebelkeithy.mods.metallurgy.machines.crusher");
            this.classPackages.put("MetallurgyMetals", "rebelkeithy.mods.metallurgy.metals");
            this.classPackages.put("MetallurgyMachines", "rebelkeithy.mods.metallurgy.machines");
            this.classPackages.put("BasicComponents", "basiccomponents.common");
            this.classPackages.put("Mekanism", "mekanism.common");
            this.classPackages.put("ElectricExpansionItems", "electricexpansion.api");
            this.classPackages.put("FluidMech", "fluidmech.common");
            this.classPackages.put("BOPBlocks", "tdwp_ftw.biomesop.configuration");
            this.classPackages.put("BOPItems", "tdwp_ftw.biomesop.configuration");
        }
    }

    private Class hookClass(String className) throws ClassNotFoundException {
        this.checkClassPackages();
        if (this.classHooks.get(className) == null) {
            this.classHooks.put(className, Class.forName(this.classPackages.get(className) + "." + className));
        } else if (this.classHooks.get(className) == null) {
            this.classHooks.put(className, Class.forName("net.minecraft.src." + this.classPackages.get(className) + "." + className));
        }
        return this.classHooks.get(className);
    }

    private Method hookMethod(String methodName) {
        return this.methodHooks.get(methodName);
    }

    private void checkMethodHook(String methodName, String className, Class ... methodParameters) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        Class classRef = this.hookClass(className);
        if (this.methodHooks.get(methodName) == null) {
            this.methodHooks.put(methodName, classRef.getDeclaredMethod(methodName, methodParameters));
        }
    }

    private void checkMethodHook(String methodName, String className) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        Class classRef = this.hookClass(className);
        if (this.methodHooks.get(methodName) == null) {
            this.methodHooks.put(methodName, classRef.getDeclaredMethod(methodName, new Class[0]));
        }
    }

    public Map<String, Map<String, String>> metallurgyGetMetalsetData(String setName, String path) {
        try {
            this.checkMethodHook("readMetalDataFromJar", "MetalInfoDatabase", String.class, String.class);
            Object output = this.hookMethod("readMetalDataFromJar").invoke((Object)this.hookClass("MetalInfoDatabase"), setName + ".csv", path);
            return (Map)output;
        }
        catch (Exception e) {
            System.out.println("[MetalMech] There was a problem with the Metalset Data Info hook:");
            System.out.println("The MetalMech Metal Set Database (csv file) or Metallurgy 3 Core may be missing.");
            e.printStackTrace();
            return null;
        }
    }

    public Object metallurgyNewMetalset(String setName, wv creativeTab) {
        try {
            this.checkMethodHook("getSpreadsheetDataForSet", "MetalInfoDatabase", String.class);
            Map setData = (Map)this.hookMethod("getSpreadsheetDataForSet").invoke((Object)this.hookClass("MetalInfoDatabase"), setName);
            Constructor newMetalSet = this.hookClass("MetalSet").getDeclaredConstructor(String.class, Map.class, wv.class);
            newMetalSet.setAccessible(true);
            return newMetalSet.newInstance(setName, setData, creativeTab);
        }
        catch (Exception e) {
            System.out.println("[MetalMech] There was a problem with the Metalset hook:");
            System.out.println("The MetalMech Metal Set Database (csv file) or Metallurgy 3 Core may be missing.");
            e.printStackTrace();
            return null;
        }
    }

    public yd metallurgyGetCrushingResult(yd item) {
        try {
            this.checkMethodHook("smelting", "CrusherRecipes");
            this.checkMethodHook("getCrushingResult", "CrusherRecipes", yd.class);
            Object instance = this.hookMethod("smelting").invoke((Object)this.hookClass("CrusherRecipes"), new Object[0]);
            Object result = this.hookMethod("getCrushingResult").invoke(instance, item);
            if (result == null) {
                return null;
            }
            return (yd)result;
        }
        catch (Exception e) {
            System.out.println("[MetalMech] There was a problem with the Metallurgy Crusher Recipes hook:");
            e.printStackTrace();
            return null;
        }
    }

    public yd getItemStack(String name, int amount, int metadata, String className) {
        try {
            Field field = this.hookClass(className).getDeclaredField(name);
            field.setAccessible(true);
            Object result = field.get(null);
            if (result instanceof yd) {
                return (yd)result;
            }
            if (result instanceof yb) {
                return new yd((yb)result, amount, metadata);
            }
            if (result instanceof aqw) {
                return new yd((aqw)result, amount, metadata);
            }
            throw new Exception("An error occurred when trying to get " + name + " from Basic Components (probably a bad name).");
        }
        catch (Exception e) {
            if (className == "BasicComponents") {
                System.out.println("[MetalMech] Unable to get " + name + " from " + className + ":");
                System.out.println("This will disable some recipes, make sure you have " + className + " installed.");
                e.printStackTrace();
            }
            return null;
        }
    }

    public yd getItemStack(String name, String className) {
        return this.getItemStack(name, 1, 0, className);
    }
}

