/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.event.ForgeSubscribe;

public class AssetManager {
    public static Map<String, bjl> textures = new HashMap<String, bjl>();
    public static Map<String, mr> icons = new HashMap<String, mr>();
    public static Map<String, mr[]> iconGroups = new HashMap<String, mr[]>();
    public static Map<String, String[]> sounds = new HashMap<String, String[]>();
    public static Map<String, bbl> models = new HashMap<String, bbl>();
    public static Map<String, IModelCustom> objModels = new HashMap<String, IModelCustom>();

    public static void addTexture(String name, String domain, String path) {
        textures.put(name, new bjl(domain, path));
    }

    public static void addIcon(String name, mr icon) {
        icons.put(name, icon);
    }

    public static void addIcon(String name, String domain, String path, ms iconRegister) {
        icons.put(name, iconRegister.a(domain + ":" + path));
    }

    public static void addIconGroup(String name, String domain, String[] paths, ms iconRegister) {
        mr[] iconGroup = new mr[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            iconGroup[i] = iconRegister.a(domain + ":" + paths[i]);
        }
        iconGroups.put(name, iconGroup);
    }

    public static void addSound(String name, String domain, String path) {
        sounds.put(name, new String[]{domain + ":" + path, domain + ":" + path.replaceAll("/", ".").substring(0, path.length() - 4)});
    }

    public static void addModel(String name, bbl model) {
        models.put(name, model);
    }

    public static void addObjModel(String name, String domain, String path) {
        objModels.put(name, AdvancedModelLoader.loadModel((String)("/assets/" + domain + "/models/" + path + ".obj")));
    }

    public static bjl getTexture(String name) {
        return textures.get(name);
    }

    public static mr getIcon(String name) {
        return icons.get(name);
    }

    public static mr[] getIconGroup(String name) {
        return iconGroups.get(name);
    }

    public static String getSound(String name) {
        return sounds.get(name)[1];
    }

    public static bbl getModel(String name) {
        return models.get(name);
    }

    public static IModelCustom getObjModel(String name) {
        return objModels.get(name);
    }

    public static IModelCustom getObjModel(String name, String domain, String path) {
        if (!objModels.containsKey(name)) {
            AssetManager.addObjModel(name, domain, path);
        }
        return objModels.get(name);
    }

    @ForgeSubscribe
    public void onLoadSoundSettings(SoundLoadEvent soundLoadEvent) {
        for (String[] sound : sounds.values()) {
            soundLoadEvent.manager.a(sound[0]);
        }
    }
}

