/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.forge;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.forge.DefaultSlotClickHandler;
import codechicken.nei.forge.IContainerDrawHandler;
import codechicken.nei.forge.IContainerInputHandler;
import codechicken.nei.forge.IContainerObjectHandler;
import codechicken.nei.forge.IContainerSlotClickHandler;
import codechicken.nei.forge.IContainerTooltipHandler;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiContainerManager {
    public awy window;
    public static bgw drawItems = new bgw();
    public static final LinkedList<IContainerTooltipHandler> tooltipHandlers = new LinkedList();
    public static final LinkedList<IContainerInputHandler> inputHandlers = new LinkedList();
    public static final LinkedList<IContainerDrawHandler> drawHandlers = new LinkedList();
    public static final LinkedList<IContainerObjectHandler> objectHandlers = new LinkedList();
    public static final LinkedList<IContainerSlotClickHandler> slotClickHandlers = new LinkedList();
    private static boolean flag;
    private static HashSet<String> stackTraces;

    static {
        try {
            flag = "2.9.0".equals(Sys.getVersion());
        }
        catch (Throwable t) {
            System.err.println(String.format("Error getting lwjgl version: %s", t.toString()));
            flag = false;
        }
        GuiContainerManager.addSlotClickHandler(new DefaultSlotClickHandler());
        stackTraces = new HashSet();
    }

    public GuiContainerManager(awy screen) {
        this.window = screen;
    }

    public static GuiContainerManager getManager(awy gui) {
        return gui.manager;
    }

    public static void addTooltipHandler(IContainerTooltipHandler handler) {
        tooltipHandlers.add(handler);
    }

    public static void addInputHandler(IContainerInputHandler handler) {
        inputHandlers.add(handler);
    }

    public static void addDrawHandler(IContainerDrawHandler handler) {
        drawHandlers.add(handler);
    }

    public static void addObjectHandler(IContainerObjectHandler handler) {
        objectHandlers.add(handler);
    }

    public static void addSlotClickHandler(IContainerSlotClickHandler handler) {
        slotClickHandlers.addFirst(handler);
    }

    public ye getStackMouseOver() {
        Point mousePos = GuiDraw.getMousePosition();
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            ye item = objectHandler.getStackUnderMouse(this.window, mousePos.x, mousePos.y);
            if (item == null) continue;
            return item;
        }
        we slot = this.getSlotMouseOver();
        if (slot != null) {
            return slot.d();
        }
        return null;
    }

    public we getSlotMouseOver() {
        Point mousePos = GuiDraw.getMousePosition();
        if (this.objectUnderMouse(mousePos.x, mousePos.y)) {
            return null;
        }
        return this.window.c(mousePos.x, mousePos.y);
    }

    public static List<String> itemDisplayNameMultiline(ye itemstack, awy gui, boolean includeHandlers) {
        List<String> namelist = null;
        try {
            namelist = itemstack.a((uf)atv.w().h, includeHandlers && atv.w().u.x);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<String>();
        }
        if (namelist.size() == 0) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).equals("")) {
            namelist.set(0, "Unnamed");
        }
        if (includeHandlers) {
            for (IContainerTooltipHandler handler : tooltipHandlers) {
                namelist = handler.handleItemTooltip(gui, itemstack, namelist);
            }
        }
        namelist.set(0, "\u00a7" + Integer.toHexString(itemstack.w().e) + (String)namelist.get(0));
        int i = 1;
        while (i < namelist.size()) {
            namelist.set(i, "\u00a77" + namelist.get(i));
            ++i;
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ye itemstack) {
        List<String> list = GuiContainerManager.itemDisplayNameMultiline(itemstack, null, false);
        return list.get(0);
    }

    public static String concatenatedDisplayName(ye itemstack, boolean includeHandlers) {
        int pos;
        List<String> list = GuiContainerManager.itemDisplayNameMultiline(itemstack, null, includeHandlers);
        StringBuilder sb2 = new StringBuilder();
        boolean first = true;
        for (String name : list) {
            if (first) {
                first = false;
            } else {
                sb2.append("#");
            }
            sb2.append(name);
        }
        String s = sb2.toString();
        while ((pos = s.indexOf(167)) != -1) {
            s = String.valueOf(s.substring(0, pos)) + s.substring(pos + 2);
        }
        return s;
    }

    public static avi getFontRenderer(ye stack) {
        avi f;
        if (stack != null && stack.b() != null && (f = stack.b().getFontRenderer(stack)) != null) {
            return f;
        }
        return GuiDraw.fontRenderer;
    }

    public static void drawItem(int i, int j, ye itemstack) {
        GuiContainerManager.drawItem(i, j, itemstack, GuiContainerManager.getFontRenderer(itemstack));
    }

    public static void drawItem(int i, int j, ye itemstack, avi fontRenderer) {
        GuiContainerManager.enable3DRender();
        GuiContainerManager.drawItems.f += 100.0f;
        try {
            drawItems.b(fontRenderer, GuiDraw.renderEngine, itemstack, i, j);
            drawItems.c(fontRenderer, GuiDraw.renderEngine, itemstack, i, j);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackTrace = itemstack + sw.toString();
            if (!stackTraces.contains(stackTrace)) {
                System.err.println("Error while rendering: " + itemstack);
                e.printStackTrace();
                stackTraces.add(stackTrace);
            }
            if (bfq.a.z) {
                bfq.a.a();
            }
            drawItems.a(fontRenderer, GuiDraw.renderEngine, new ye(51, 1, 0), i, j);
        }
        GuiContainerManager.drawItems.f -= 100.0f;
        GuiContainerManager.enable2DRender();
        if (bfq.a.z) {
            bfq.a.a();
        }
    }

    public static void setColouredItemRender(boolean enable) {
        GuiContainerManager.drawItems.a = !enable;
    }

    public static void enable3DRender() {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public static void enable2DRender() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    public void load() {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.load(this.window);
        }
    }

    public void refresh() {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.guiTick(this.window);
        }
    }

    public void guiTick() {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.guiTick(this.window);
        }
    }

    public boolean lastKeyTyped(int keyID, char keyChar) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.lastKeyTyped(this.window, keyChar, keyID)) continue;
            return true;
        }
        return false;
    }

    public boolean firstKeyTyped(int keyID, char keyChar) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onKeyTyped(this.window, keyChar, keyID);
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.keyTyped(this.window, keyChar, keyID)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(int mousex, int mousey, int button) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseClicked(this.window, mousex, mousey, button);
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.mouseClicked(this.window, mousex, mousey, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(int scrolled) {
        Point mousepos = GuiDraw.getMousePosition();
        for (IContainerInputHandler inputHandler : inputHandlers) {
            inputHandler.onMouseScrolled(this.window, mousepos.x, mousepos.y, scrolled);
        }
        for (IContainerInputHandler inputHandler : inputHandlers) {
            if (!inputHandler.mouseScrolled(this.window, mousepos.x, mousepos.y, scrolled)) continue;
            return true;
        }
        return false;
    }

    public void mouseUp(int mousex, int mousey, int button) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseUp(this.window, mousex, mousey, button);
        }
    }

    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseDragged(this.window, mousex, mousey, button, heldTime);
        }
    }

    public void preDraw() {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.onPreDraw(this.window);
        }
    }

    public void renderObjects(int mousex, int mousey) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderObjects(this.window, mousex, mousey);
        }
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.postRenderObjects(this.window, mousex, mousey);
        }
    }

    public void renderToolTips(int mousex, int mousey) {
        List<String> tooltip = this.window.handleTooltip(mousex, mousey, new LinkedList<String>());
        for (IContainerTooltipHandler handler : tooltipHandlers) {
            tooltip = handler.handleTooltipFirst(this.window, mousex, mousey, tooltip);
        }
        if (tooltip.isEmpty() && this.shouldShowTooltip()) {
            ye stack = this.getStackMouseOver();
            if (stack != null) {
                tooltip = GuiContainerManager.itemDisplayNameMultiline(stack, this.window, true);
            }
            tooltip = this.window.handleItemTooltip(stack, mousex, mousey, tooltip);
        }
        if (tooltip.size() > 0) {
            tooltip.set(0, String.valueOf(tooltip.get(0)) + "\u00a7h");
        }
        GuiDraw.drawMultilineTip((int)(mousex + 12), (int)(mousey - 12), tooltip);
    }

    public boolean shouldShowTooltip() {
        for (IContainerObjectHandler handler : objectHandlers) {
            if (handler.shouldShowTooltip(this.window)) continue;
            return false;
        }
        return this.window.f.h.bn.o() == null;
    }

    public void renderSlotUnderlay(we slot) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderSlotUnderlay(this.window, slot);
        }
    }

    public void renderSlotOverlay(we slot) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderSlotOverlay(this.window, slot);
        }
    }

    public boolean objectUnderMouse(int mousex, int mousey) {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            if (!objectHandler.objectUnderMouse(this.window, mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    public void handleMouseClick(we slot, int slotIndex, int button, int modifier) {
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            handler.beforeSlotClick(this.window, slotIndex, button, slot, modifier);
        }
        boolean eventHandled = false;
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            eventHandled = handler.handleSlotClick(this.window, slotIndex, button, slot, modifier, eventHandled);
        }
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            handler.afterSlotClick(this.window, slotIndex, button, slot, modifier);
        }
    }

    public void fixhandleKeyboardInput() {
        if (flag) {
            int k = Keyboard.getEventKey();
            char c = Keyboard.getEventCharacter();
            if (Keyboard.getEventKeyState()) {
                this.window.keyPress(k, c);
            }
        } else if (Keyboard.getEventKeyState()) {
            int k = Keyboard.getEventKey();
            char c = Keyboard.getEventCharacter();
            if (c > '\u007f' && c <= '\u00ff' && Keyboard.next()) {
                int k2 = Keyboard.getEventKey();
                char c2 = Keyboard.getEventCharacter();
                try {
                    c2 = new String(new byte[]{(byte)c, (byte)c2}).charAt(0);
                    this.window.keyPress(k, c2);
                }
                catch (Throwable t) {
                    this.window.keyPress(k, c);
                    this.window.keyPress(k2, c2);
                }
            } else {
                this.window.keyPress(k, c);
            }
        }
    }
}

