/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.core.inventory.ItemKey;
import codechicken.nei.DropDownFile;
import codechicken.nei.KeyManager;
import codechicken.nei.LayoutManager;
import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.OffsetPositioner;
import codechicken.nei.SubSetRangeTag;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.INEIModeHandler;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.api.LayoutStyle;
import codechicken.nei.api.NEIInfo;
import codechicken.nei.config.Option;
import codechicken.nei.config.OptionKeyBind;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeInfo;
import java.util.ArrayList;
import java.util.Collection;

public class API {
    public static void registerRecipeHandler(ICraftingHandler handler) {
        GuiCraftingRecipe.registerRecipeHandler(handler);
    }

    public static void registerUsageHandler(IUsageHandler handler) {
        GuiUsageRecipe.registerUsageHandler(handler);
    }

    public static void registerGuiOverlay(Class<? extends awy> class1, String string) {
        API.registerGuiOverlay(class1, string, 5, 11);
    }

    public static void registerGuiOverlay(Class<? extends awy> class1, String string, int x, int y) {
        API.registerGuiOverlay(class1, string, new OffsetPositioner(x, y));
    }

    public static void registerGuiOverlay(Class<? extends awy> classz, String ident, IStackPositioner positioner) {
        RecipeInfo.registerGuiOverlay(classz, ident, positioner);
    }

    public static void registerGuiOverlayHandler(Class<? extends awy> classz, IOverlayHandler handler, String ident) {
        RecipeInfo.registerOverlayHandler(classz, handler, ident);
    }

    public static void setGuiOffset(Class<? extends awy> classz, int x, int y) {
        RecipeInfo.setGuiOffset(classz, x, y);
    }

    public static void registerNEIGuiHandler(INEIGuiHandler handler) {
        GuiInfo.guiHandlers.add(handler);
    }

    public static void hideItem(int itemID) {
        ItemInfo.excludeIds.add(itemID);
    }

    public static void hideItems(Collection<Integer> items) {
        ItemInfo.excludeIds.addAll(items);
    }

    public static void setOverrideName(int itemID, int itemDamage, String name) {
        ItemInfo.fallbackNames.put(new ItemKey(itemID, itemDamage), name);
    }

    public static void setItemDamageVariants(int itemID, ArrayList<int[]> ranges) {
        ItemInfo.damageVariants.put(itemID, ranges);
    }

    public static void setItemDamageVariants(int itemID, Collection<Integer> damages) {
        API.setItemDamageVariants(itemID, NEIClientUtils.concatIntegersToRanges(new ArrayList<Integer>(damages)));
    }

    public static void setMaxDamageException(int itemID, int maxDamage) {
        ArrayList<int[]> damageset = new ArrayList<int[]>();
        int[] nArray = new int[2];
        nArray[1] = maxDamage;
        damageset.add(nArray);
        API.setItemDamageVariants(itemID, damageset);
    }

    public static void addNBTItem(ye item) {
        ArrayList<Object> datalist = ItemInfo.itemcompounds.get(item.d);
        if (datalist == null) {
            datalist = new ArrayList();
            ItemInfo.itemcompounds.put(item.d, datalist);
        }
        datalist.add(item);
    }

    public static void addSetRange(String setname, MultiItemRange range) {
        SubSetRangeTag tag = DropDownFile.dropDownInstance.getTag(setname);
        tag.saveTag = false;
        tag.setRange(range);
        DropDownFile.dropDownInstance.updateState();
    }

    public static SubSetRangeTag getRangeTag(String tagname) {
        return DropDownFile.dropDownInstance.getTag(tagname);
    }

    public static void addToRange(String setname, MultiItemRange range) {
        SubSetRangeTag tag = DropDownFile.dropDownInstance.getTag(setname);
        if (tag.validranges == null) {
            tag.setRange(range);
        } else {
            tag.validranges.add(range);
        }
    }

    public static void addKeyBind(String ident, int defaultKey) {
        NEIClientConfig.setDefaultKeyBinding(ident, defaultKey);
        KeyManager.keyStates.put(ident, new KeyManager.KeyState());
        API.addOption(new OptionKeyBind(ident));
    }

    public static void addOption(Option option) {
        NEIClientConfig.getOptionList().addOption(option);
    }

    public static void addLayoutStyle(int styleID, LayoutStyle style) {
        LayoutManager.layoutStyles.put(styleID, style);
    }

    public static void addInfiniteItemHandler(IInfiniteItemHandler handler) {
        ItemInfo.infiniteHandlers.addFirst(handler);
    }

    public static void registerHighlightIdentifier(int blockID, IHighlightHandler handler) {
        ArrayList<IHighlightHandler> handlers = ItemInfo.highlightIdentifiers.get(blockID);
        if (handlers == null) {
            handlers = new ArrayList();
            ItemInfo.highlightIdentifiers.put(blockID, handlers);
        }
        handlers.add(handler);
    }

    public static void addFastTransferExemptSlot(Class<? extends we> slotClass) {
        ItemInfo.fastTransferExemptions.add(slotClass);
    }

    public static void registerHighlightHandler(IHighlightHandler handler, ItemInfo.Layout ... layout) {
        ItemInfo.registerHighlightHandler(handler, layout);
    }

    public static void registerModeHandler(INEIModeHandler handler) {
        NEIInfo.modeHandlers.add(handler);
    }
}

