/*
 * Decompiled with CFR 0.152.
 */
package simcraft.core.rendermodels;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import simcraft.core.rendermodels.GLAllocation;

public class RenderEngine {
    private HashMap textureMap = new HashMap();
    private HashMap textureContentsMap = new HashMap();
    private ll textureNameToImageMap = new ll();
    private IntBuffer imageData = GLAllocation.createDirectIntBuffer(0x400000);
    private Map urlToImageDataMap = new HashMap();
    private aui options;
    private BufferedImage missingTextureImage = new BufferedImage(64, 64, 2);
    private int boundTexture;

    private int[] getImageContentsAndAllocate(BufferedImage par1BufferedImage) {
        return this.getImageContents(par1BufferedImage, new int[par1BufferedImage.getWidth() * par1BufferedImage.getHeight()]);
    }

    private int[] getImageContents(BufferedImage par1BufferedImage, int[] par2ArrayOfInteger) {
        int var3 = par1BufferedImage.getWidth();
        int var4 = par1BufferedImage.getHeight();
        par1BufferedImage.getRGB(0, 0, var3, var4, par2ArrayOfInteger, 0, var3);
        return par2ArrayOfInteger;
    }

    public void bindTexture(String par1Str) {
        this.bindTexture(this.getTexture(par1Str));
    }

    private void bindTexture(int par1) {
        if (par1 != this.boundTexture) {
            GL11.glBindTexture((int)3553, (int)par1);
            this.boundTexture = par1;
        }
    }

    public void resetBoundTexture() {
        this.boundTexture = -1;
    }

    private int getTexture(String par1Str) {
        Integer var2 = (Integer)this.textureMap.get(par1Str);
        if (var2 != null) {
            return var2;
        }
        String var8 = par1Str;
        try {
            boolean var5;
            int var3 = GLAllocation.generateTextureNames();
            boolean var9 = par1Str.startsWith("%blur%");
            if (var9) {
                par1Str = par1Str.substring(6);
            }
            if (var5 = par1Str.startsWith("%clamp%")) {
                par1Str = par1Str.substring(7);
            }
            this.textureMap.put(var8, var3);
            return var3;
        }
        catch (Exception var7) {
            var7.printStackTrace();
            int var4 = GLAllocation.generateTextureNames();
            this.setupTexture(this.missingTextureImage, var4);
            this.textureMap.put(par1Str, var4);
            return var4;
        }
    }

    public int allocateAndSetupTexture(BufferedImage par1BufferedImage) {
        int var2 = GLAllocation.generateTextureNames();
        this.setupTexture(par1BufferedImage, var2);
        this.textureNameToImageMap.a(var2, (Object)par1BufferedImage);
        return var2;
    }

    public void setupTexture(BufferedImage par1BufferedImage, int par2) {
        this.setupTextureExt(par1BufferedImage, par2, false, false);
    }

    public void setupTextureExt(BufferedImage par1BufferedImage, int par2, boolean par3, boolean par4) {
        this.bindTexture(par2);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        if (par3) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (par4) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        int var5 = par1BufferedImage.getWidth();
        int var6 = par1BufferedImage.getHeight();
        int[] var7 = new int[var5 * var6];
        par1BufferedImage.getRGB(0, 0, var5, var6, var7, 0, var5);
        if (this.options != null && this.options.g) {
            var7 = this.colorToAnaglyph(var7);
        }
        this.imageData.clear();
        this.imageData.put(var7);
        this.imageData.position(0).limit(var7.length);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)var5, (int)var6, (int)0, (int)32993, (int)33639, (IntBuffer)this.imageData);
    }

    private int[] colorToAnaglyph(int[] par1ArrayOfInteger) {
        int[] var2 = new int[par1ArrayOfInteger.length];
        for (int var3 = 0; var3 < par1ArrayOfInteger.length; ++var3) {
            int var4 = par1ArrayOfInteger[var3] >> 24 & 0xFF;
            int var5 = par1ArrayOfInteger[var3] >> 16 & 0xFF;
            int var6 = par1ArrayOfInteger[var3] >> 8 & 0xFF;
            int var7 = par1ArrayOfInteger[var3] & 0xFF;
            int var8 = (var5 * 30 + var6 * 59 + var7 * 11) / 100;
            int var9 = (var5 * 30 + var6 * 70) / 100;
            int var10 = (var5 * 30 + var7 * 70) / 100;
            var2[var3] = var4 << 24 | var8 << 16 | var9 << 8 | var10;
        }
        return var2;
    }

    public void createTextureFromBytes(int[] par1ArrayOfInteger, int par2, int par3, int par4) {
        this.bindTexture(par4);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        if (this.options != null && this.options.g) {
            par1ArrayOfInteger = this.colorToAnaglyph(par1ArrayOfInteger);
        }
        this.imageData.clear();
        this.imageData.put(par1ArrayOfInteger);
        this.imageData.position(0).limit(par1ArrayOfInteger.length);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)par2, (int)par3, (int)32993, (int)33639, (IntBuffer)this.imageData);
    }

    public void deleteTexture(int par1) {
        this.textureNameToImageMap.d(par1);
        GL11.glDeleteTextures((int)par1);
    }

    public boolean hasImageData(String par1Str) {
        return this.urlToImageDataMap.containsKey(par1Str);
    }

    private BufferedImage readTextureImage(InputStream par1InputStream) throws IOException {
        BufferedImage var2 = ImageIO.read(par1InputStream);
        par1InputStream.close();
        return var2;
    }
}

