/*
 * Decompiled with CFR 0.152.
 */
package simcraft.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import simcraft.core.CommonProxy;
import simcraft.core.EntityMountableBlock;
import simcraft.core.ExplosionSimCraft;
import simcraft.core.GlobalConfig;
import simcraft.core.GlobalFunctions;
import simcraft.core.GuiHandler;
import simcraft.core.Keyboard;
import simcraft.core.Property;
import simcraft.core.RegBlocks;
import simcraft.core.RegEntity;
import simcraft.core.RegItems;
import simcraft.core.WorldData;
import simcraft.core.WorldGenerators;
import simcraft.core.dimension.WorldProviderSimCraft;
import simcraft.core.network.NetworkManager;
import simcraft.core.network.NetworkManagerClient;
import simcraft.core.power.PowerGrid;
import simcraft.core.power.TickCallback;
import simcraft.core.recipes.RegRecipes;
import simcraft.core.sound.SoundsManager;
import simcraft.core.world.VillageManagerBanker;
import simcraft.core.world.VillageManagerChef;
import simcraft.core.world.VillageManagerFarmer;
import simcraft.core.world.VillageManagerMerchant;
import simcraft.crops.CropArtichokeEvent;
import simcraft.crops.CropBarleyEvent;
import simcraft.crops.CropCanolaEvent;
import simcraft.crops.CropCarrotEvent;
import simcraft.crops.CropCottonEvent;
import simcraft.crops.CropEggplantEvent;
import simcraft.crops.CropMaizeEvent;
import simcraft.crops.CropOatsEvent;
import simcraft.crops.CropPotatoEvent;
import simcraft.crops.CropRadishEvent;
import simcraft.crops.CropRiceEvent;
import simcraft.crops.CropRyeEvent;
import simcraft.crops.CropSoybeansEvent;
import simcraft.crops.CropSugarBeetEvent;
import simcraft.crops.CropSunFlowerEvent;
import simcraft.crops.CropTomatoEvent;
import simcraft.liquids.DstWaterBucketFiller;
import simcraft.liquids.OilBucketFiller;

@Mod(modid="simcraft", name="SimCraft", version="1.6d", useMetadata=true)
@NetworkMod(clientSideRequired=true, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"simcraft"}, packetHandler=NetworkManagerClient.class), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"simcraft"}, packetHandler=NetworkManager.class))
public class SimCraft
implements IConnectionHandler,
ITickHandler,
IPlayerTracker {
    public static final String VERSION = "1.6d";
    public static final String modid = "simcraft";
    @Mod.Instance(value="simcraft")
    public static SimCraft instance;
    public static int LightOpacity;
    public static GlobalConfig config;
    public static Logger log;
    public static FluidStack OilLiquid;
    public static FluidStack DstWaterLiquid;
    private static Map singleTickCallbacks;
    private static Map continuousTickCallbacks;
    private static Map continuousTickCallbacksInUse;
    private static Map continuousTickCallbacksToAdd;
    private static Map continuousTickCallbacksToRemove;
    public static yc materialSteel;
    public static Logger logger;
    public static int dimensionID;
    public static String MineSeed;
    public static int SimPremClient;
    public static int KEY_ACC;
    public static int KEY_DEC;
    public static int KEY_TURNRIGHT;
    public static int KEY_TURNLEFT;
    public static int KEY_GETOUT;
    public static int KEY_INV;
    public static int KEY_SPECIAL;
    public static int KEY_HORN;
    public static int KEY_LIGHTS;
    public static int KEY_SHIFT;
    public static int KEY_SPACE;
    public static boolean OptifineInstalled;
    public static int renderPass;
    public static int SlopesRenderID;
    public static int IntCornersRenderID;
    public static int CornersRenderID;
    public static int BlockPanesID;
    public static int BlockFencesID;
    public static int BlockStairsID;
    public static int BlockWallID;
    public static int BlockWireID;
    public static int BlockConveyorbeltID;
    public static int BlockGenT100ID;
    public static int BlockCrusherRenderID;
    public static int BlockIronWorkBenchID;
    public static int BlockIronWorkBenchAddonID;
    public static int BlockWorkBenchID;
    public static int BlockCarpentersWorkBenchID;
    public static int BlockCarpentersAddonID;
    public static int BlockMasonryWorkBenchID;
    public static int BlockMasonryWorkBenchAddonID;
    public static int BlockElectronicWorkBenchID;
    public static int BlockElectronicAddonID;
    public static int BlockSmallContainerID;
    public static int BlockConveyorfilterID;
    public static int BlockOreShakerZSG100ID;
    public static int BlockIronForgeID;
    public static int BlockOrePanID;
    public static int BlockInductionFurnaceID;
    public static int BlockMachinePressBottomID;
    public static int BlockMachinePressTopID;
    public static int BlockIndustrialContainer1ID;
    public static int BlockIndustrialContainer2ID;
    public static int AlderchairID;
    public static int GranadilochairID;
    public static int MaplechairID;
    public static int WalnutchairID;
    public static int WhiteAshchairID;
    public static int AldertableID;
    public static int GranadilotableID;
    public static int WalnuttableID;
    public static int MapletableID;
    public static int WhiteAshtableID;
    public static int BlockFishTankID;
    public static int BlockDistilleryID;
    public static int BlockAlcoholBarrelID;
    public static int BlockFoodBarrelID;
    public static int BlockOakBarrelID;
    public static int BlockWineBarrelID;
    public static int CampFireID;
    public static int BlockDisplayCaseID;
    public static int DisplayCase2ID;
    public static int DisplayCase3ID;
    public static int BlockFermenterID;
    public static int BlockRefineryID;
    public static int BlockGrapeParserID;
    public static int BlockOreCollectorID;
    public static int BlockBandSawID;
    public static int BlockLaserCutterID;
    public static int BlockGenT500ID;
    public static int BlockCokeOvenID;
    public static int BlockIronPressAddonID;
    public static int StainedWindowPanesID;
    public static int BlockLightID;
    public static int BlockCahorsStonePillarID;
    public static int BlockCahorsSquareStonePillarID;
    public static int BlockSylacaugaMarblePillarID;
    public static int BlockMountedLampID;
    public static int BlockLCDtvID;
    public static int BlockFluorescentID;
    public static int EntityFarmerID;
    public static int EntityMerchantID;
    public static int EntityBankerID;
    public static int EntityChefID;
    @SidedProxy(clientSide="simcraft.core.GlobalFunctionsClient", serverSide="simcraft.core.GlobalFunctions")
    public static GlobalFunctions globalFunctions;
    @SidedProxy(clientSide="simcraft.core.network.NetworkManagerClient", serverSide="simcraft.core.network.NetworkManager")
    public static NetworkManager network;
    @SidedProxy(clientSide="simcraft.core.KeyboardClient", serverSide="simcraft.core.Keyboard")
    public static Keyboard keyboard;
    @SidedProxy(clientSide="simcraft.core.sound.SoundsManagerClient", serverSide="simcraft.core.sound.SoundsManager")
    public static SoundsManager soundsManager;
    @SidedProxy(clientSide="simcraft.core.CommonProxyClient", serverSide="simcraft.core.CommonProxy")
    public static CommonProxy proxy;

    public SimCraft() {
        instance = this;
        LightOpacity = 0;
    }

    public static SimCraft getInstance() {
        return instance;
    }

    public boolean checkVersion(String var1) {
        String[] var2 = "1.6".split("\\.");
        String[] var3 = var1.split("\\.");
        return var2.length >= 2 && var3.length >= 2 && var2[0].equals(var3[0]) && var2[1].equals(var3[1]);
    }

    @Mod.EventHandler
    public void loadConfiguration(FMLPreInitializationEvent evt) {
        GlobalConfig config;
        ModLoader.getLogger().fine("Starting SimCraft ");
        ModLoader.getLogger().fine("Copyright (c) IE Technology, 2012");
        ModLoader.getLogger().fine("http://www.simcraft.co.za");
        System.out.println("Starting SimCraft ");
        System.out.println("Copyright (c) IE Technology, 2012");
        System.out.println("http://www.simcraft.co.za");
        System.out.println("[SimCraft] Registered 112 Bricks & Tiles");
        System.out.println("[SimCraft] Registered 32 Wooden Planks");
        System.out.println("[SimCraft] Registered 112 New Fences");
        System.out.println("[SimCraft] Registered 176 Brick Slabs");
        System.out.println("[SimCraft] Registered 167 New Stairs");
        System.out.println("[SimCraft] Registered 167 New Brick Slopes");
        System.out.println("[SimCraft] Registered 167 New Brick Inv Slope");
        System.out.println("[SimCraft] Registered 167 New Brick Corners");
        System.out.println("[SimCraft] Registered 135 New Brick Walls");
        System.out.println("[SimCraft] Registered 119 New Brick Panes");
        System.out.println("[SimCraft] Registered 342 New Blocks");
        System.out.println("[SimCraft] Registered 64 New Carpet Blocks");
        System.out.println("[SimCraft] Registered 16 New Windows");
        System.out.println("[SimCraft] Registered 48 New Glass Blocks");
        System.out.println("[SimCraft] Registered 16 New Tainted Glowstone");
        System.out.println("[SimCraft] Registered 16 New Doors");
        System.out.println("[SimCraft] Registered 458 New Items");
        System.out.println("[SimCraft] Registered 82 Common Recipes");
        System.out.println("[SimCraft] Registered 195 Iron Bench Recipes");
        System.out.println("[SimCraft] Registered 436 Carpenters Bench Recipes");
        System.out.println("[SimCraft] Registered 1502 Masonry Bench Recipes");
        System.out.println("[SimCraft] Registered 69 Electronic Bench Recipes");
        System.out.println("[SimCraft] Registered 105 Stone Crusher Recipes");
        System.out.println("[SimCraft] Registered 48 Ore Shaker Recipes");
        System.out.println("[SimCraft] Registered 48 Ore Pan Recipes");
        System.out.println("[SimCraft] Registered 26 Iron Forge Recipes");
        System.out.println("[SimCraft] Registered 46 Induction Furnace Recipes");
        System.out.println("[SimCraft] Registered 121 Coke Oven Recipes");
        System.out.println("[SimCraft] Registered 33 Machine Press Recipes");
        System.out.println("[SimCraft] Registered 11 Iron Press Recipes");
        System.out.println("[SimCraft] Registered 272 Band Saw Recipes");
        System.out.println("[SimCraft] Registered 17 Furniture Models");
        System.out.println("[SimCraft] Registered 30 Machine Models");
        System.out.println("[SimCraft] Registered 19 New Crops");
        System.out.println("[SimCraft] Populated World with 80 New Ores and Stones");
        System.out.println("[SimCraft] Populated World with 16 Fruit Trees");
        System.out.println("[SimCraft] Populated World with 48 Flowers");
        System.out.println("[SimCraft] Populated World with 16 Ocean Reefs");
        System.out.println("[SimCraft] Populated World with 32 Ocean Fish Types");
        System.out.println("[SimCraft] Total Number of Usable Blocks 2229");
        try {
            config = new GlobalConfig(new File(globalFunctions.getMinecraftDir(), "/config/SimCraft/SimCraft.cfg"));
            config.load();
        }
        catch (Exception exception) {
            System.out.println("[SimCraft Texture Manager] Error while trying to access configuration!");
            config = null;
        }
        if (config != null) {
            Property var7 = config.getOrCreateIntProperty("dimensionID", 0, dimensionID);
            Property var8 = config.getOrCreateProperty("MineSeed", 0, MineSeed);
            var7.comment = "Dimension ID:";
            var8.comment = "World Seed:";
            dimensionID = Integer.parseInt(var7.value);
            MineSeed = var8.value;
            config.save();
        }
    }

    @Mod.EventHandler
    public void modsLoaded(FMLInitializationEvent event) {
        RegBlocks.initialize();
        RegItems.initialize();
        proxy.registerBlockModel();
        proxy.registerTileEntities();
        RegRecipes.initialize();
        RegEntity.initialize(this);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenerators());
        TickRegistry.registerTickHandler((ITickHandler)this, (Side)Side.SERVER);
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        NetworkRegistry.instance().registerConnectionHandler((IConnectionHandler)this);
        DimensionManager.registerProviderType((int)dimensionID, WorldProviderSimCraft.class, (boolean)false);
        DimensionManager.registerDimension((int)dimensionID, (int)dimensionID);
        if (RegBlocks.BlockRawOilFlowing.cF + 1 != RegBlocks.BlockRawOilStationer.cF) {
            throw new RuntimeException("Oil Stationer id must be Oil Moving id + 1");
        }
        MinecraftForge.EVENT_BUS.register((Object)new OilBucketFiller());
        Fluid simOil = new Fluid("scOil").setBlockID(RegBlocks.BlockRawOilStationer.cF).setLuminosity(15).setDensity(3000).setViscosity(6000);
        FluidRegistry.registerFluid((Fluid)simOil);
        if (RegBlocks.BlockRawDstWaterFlowing.cF + 1 != RegBlocks.BlockRawDstWaterStationer.cF) {
            throw new RuntimeException("Distilled Water Stationer id must be Distilled Water Moving id + 1");
        }
        MinecraftForge.EVENT_BUS.register((Object)new DstWaterBucketFiller());
        Fluid dstWater = new Fluid("Distilled Water").setBlockID(RegBlocks.BlockRawDstWaterStationer.cF);
        FluidRegistry.registerFluid((Fluid)dstWater);
        soundsManager.initialize(config);
        MinecraftForge.EVENT_BUS.register((Object)new CropArtichokeEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropBarleyEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropCanolaEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropCarrotEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropCottonEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropEggplantEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropMaizeEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropOatsEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropPotatoEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropRadishEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropRiceEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropRyeEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropSoybeansEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropSugarBeetEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropSunFlowerEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CropTomatoEvent());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent var1) {
        instance = this;
        EntityRegistry.registerModEntity(EntityMountableBlock.class, (String)"EntityMountableBlock", (int)1, (Object)this, (int)400, (int)5, (boolean)false);
        VillageManagerFarmer var2 = new VillageManagerFarmer();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)var2);
        VillagerRegistry.instance().registerVillageTradeHandler(EntityFarmerID, (VillagerRegistry.IVillageTradeHandler)var2);
        VillagerRegistry.instance().registerVillagerId(EntityFarmerID);
        VillagerRegistry.instance();
        VillagerRegistry.getRegisteredVillagers();
        VillageManagerMerchant var3 = new VillageManagerMerchant();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)var3);
        VillagerRegistry.instance().registerVillageTradeHandler(EntityMerchantID, (VillagerRegistry.IVillageTradeHandler)var3);
        VillagerRegistry.instance().registerVillagerId(EntityMerchantID);
        VillagerRegistry.instance();
        VillagerRegistry.getRegisteredVillagers();
        VillageManagerBanker var4 = new VillageManagerBanker();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)var4);
        VillagerRegistry.instance().registerVillageTradeHandler(EntityBankerID, (VillagerRegistry.IVillageTradeHandler)var4);
        VillagerRegistry.instance().registerVillagerId(EntityBankerID);
        VillagerRegistry.instance();
        VillagerRegistry.getRegisteredVillagers();
        VillageManagerChef var5 = new VillageManagerChef();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)var5);
        VillagerRegistry.instance().registerVillageTradeHandler(EntityChefID, (VillagerRegistry.IVillageTradeHandler)var5);
        VillagerRegistry.instance().registerVillagerId(EntityChefID);
        VillagerRegistry.instance();
        VillagerRegistry.getRegisteredVillagers();
        proxy.registerEntities();
        proxy.registerRenderInformation();
    }

    public String getLabel() {
        return "SimCraft";
    }

    public int getLevelFromExperience(int xp) {
        if (xp < 25) {
            return 0;
        }
        if (xp < 75) {
            return 1;
        }
        if (xp < 175) {
            return 2;
        }
        if (xp < 375) {
            return 3;
        }
        if (xp < 775) {
            return 4;
        }
        if (xp < 1575) {
            return 5;
        }
        return 6;
    }

    public void tickStart(EnumSet var1, Object ... var2) {
        if (var1.contains(TickType.WORLD)) {
            TickCallback var5;
            Queue var4;
            assert (var2[0] instanceof abv);
            abv var3 = (abv)var2[0];
            globalFunctions.profilerStartSection("Init");
            if (!singleTickCallbacks.containsKey(var3)) {
                singleTickCallbacks.put(var3, new ArrayDeque());
                continuousTickCallbacks.put(var3, new HashSet());
                continuousTickCallbacksInUse.put(var3, false);
                continuousTickCallbacksToRemove.put(var3, new Vector());
            }
            globalFunctions.profilerEndStartSection("PowerGrid");
            PowerGrid.onTick(var3);
            globalFunctions.profilerStartSection("SoundsManager");
            soundsManager.onTick();
            globalFunctions.profilerEndSection();
            globalFunctions.profilerEndStartSection("Networking");
            network.onTick(var3);
            globalFunctions.profilerEndStartSection("SingleTickCallback");
            if (singleTickCallbacks.containsKey(var3)) {
                var4 = (Queue)singleTickCallbacks.get(var3);
                while ((var5 = (TickCallback)var4.poll()) != null) {
                    globalFunctions.profilerStartSection(var5.getClass().getName());
                    var5.tickCallback(var3);
                    globalFunctions.profilerEndSection();
                }
            }
            if (singleTickCallbacks.containsKey(null)) {
                var4 = (Queue)singleTickCallbacks.get(null);
                while ((var5 = (TickCallback)var4.poll()) != null) {
                    globalFunctions.profilerStartSection(var5.getClass().getName());
                    var5.tickCallback(var3);
                    globalFunctions.profilerEndSection();
                }
            }
            globalFunctions.profilerEndStartSection("ContTickCallback");
            if (continuousTickCallbacks.containsKey(var3)) {
                Set var27 = (Set)continuousTickCallbacks.get(var3);
                continuousTickCallbacksInUse.put(var3, true);
                for (TickCallback var6 : var27) {
                    globalFunctions.profilerStartSection(var6.getClass().getName());
                    var6.tickCallback(var3);
                    globalFunctions.profilerEndSection();
                }
                continuousTickCallbacksInUse.put(var3, false);
                if (continuousTickCallbacksToAdd.containsKey(var3)) {
                    var27.addAll((Collection)continuousTickCallbacksToAdd.get(var3));
                    ((List)continuousTickCallbacksToAdd.get(var3)).clear();
                }
                if (continuousTickCallbacksToRemove.containsKey(var3)) {
                    var27.removeAll((Collection)continuousTickCallbacksToRemove.get(var3));
                    ((List)continuousTickCallbacksToRemove.get(var3)).clear();
                }
            }
            this.processTickCallbacks(var3);
            globalFunctions.profilerEndSection();
        }
    }

    public void processTickCallbacks(abv var1) {
        WorldData var2 = WorldData.get(var1);
        globalFunctions.profilerStartSection("SingleTickCallback");
        TickCallback var3 = (TickCallback)var2.singleTickCallbacks.poll();
        while (var3 != null) {
            globalFunctions.profilerStartSection(var3.getClass().getName());
            var3.tickCallback(var1);
            globalFunctions.profilerEndSection();
            var3 = (TickCallback)var2.singleTickCallbacks.poll();
        }
        globalFunctions.profilerEndStartSection("ContTickCallback");
        var2.continuousTickCallbacksInUse = true;
        for (TickCallback var4 : var2.continuousTickCallbacks) {
            globalFunctions.profilerStartSection(var4.getClass().getName());
            var4.tickCallback(var1);
            globalFunctions.profilerEndSection();
        }
        var2.continuousTickCallbacksInUse = false;
        var2.continuousTickCallbacks.addAll(var2.continuousTickCallbacksToAdd);
        var2.continuousTickCallbacksToAdd.clear();
        var2.continuousTickCallbacks.removeAll(var2.continuousTickCallbacksToRemove);
        var2.continuousTickCallbacksToRemove.clear();
        globalFunctions.profilerEndSection();
    }

    public void tickEnd(EnumSet var1, Object ... var2) {
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.WORLD, TickType.WORLDLOAD, TickType.PLAYER);
    }

    public static void addSingleTickCallback(abv var0, TickCallback var1) {
        if (!singleTickCallbacks.containsKey(var0)) {
            singleTickCallbacks.put(var0, new ArrayDeque());
        }
        ((Queue)singleTickCallbacks.get(var0)).add(var1);
    }

    public static void addContinuousTickCallback(abv var0, TickCallback var1) {
        if (var0 == null) {
            log.warning("addContinuousTickCallback with world = null, callback = " + var1);
            Thread.dumpStack();
        } else if (continuousTickCallbacksInUse.containsKey(var0) && ((Boolean)continuousTickCallbacksInUse.get(var0)).booleanValue()) {
            if (continuousTickCallbacksToRemove.containsKey(var0)) {
                ((List)continuousTickCallbacksToRemove.get(var0)).remove(var1);
            }
            if (!continuousTickCallbacksToAdd.containsKey(var0)) {
                continuousTickCallbacksToAdd.put(var0, new Vector());
            }
            ((List)continuousTickCallbacksToAdd.get(var0)).add(var1);
        } else {
            if (!continuousTickCallbacks.containsKey(var0)) {
                continuousTickCallbacks.put(var0, new HashSet());
            }
            ((Set)continuousTickCallbacks.get(var0)).add(var1);
        }
    }

    public static void removeContinuousTickCallback(abv var0, TickCallback var1) {
        if (continuousTickCallbacksInUse.containsKey(var0) && ((Boolean)continuousTickCallbacksInUse.get(var0)).booleanValue()) {
            if (continuousTickCallbacksToAdd.containsKey(var0)) {
                ((List)continuousTickCallbacksToAdd.get(var0)).remove(var1);
            }
            if (!continuousTickCallbacksToRemove.containsKey(var0)) {
                continuousTickCallbacksToRemove.put(var0, new Vector());
            }
            ((List)continuousTickCallbacksToRemove.get(var0)).add(var1);
        } else if (continuousTickCallbacks.containsKey(var0)) {
            ((Set)continuousTickCallbacks.get(var0)).remove(var1);
        }
    }

    public static void explodeMachineAt(abv var0, int var1, int var2, int var3) {
        var0.c(var1, var2, var3, 0);
        ExplosionSimCraft var4 = new ExplosionSimCraft(var0, null, 0.5 + (double)var1, 0.5 + (double)var2, 0.5 + (double)var3, 2.5f, 0.75f, 0.75f);
        var4.doExplosion();
    }

    public static int getWorldHeight(abv var1) {
        return 256;
    }

    public void playerLoggedIn(Player player, ey netHandler, cl manager) {
    }

    public String connectionReceived(jx netHandler, cl manager) {
        return null;
    }

    public void connectionOpened(ey netClientHandler, String server, int port, cl manager) {
    }

    public void connectionOpened(ey netClientHandler, MinecraftServer server, cl manager) {
    }

    public void connectionClosed(cl manager) {
    }

    public void clientLoggedIn(ey clientHandler, cl manager, eo login) {
        network.sendLoginData();
    }

    public void onPlayerLogout(ue var1) {
        if (globalFunctions.isSimulating()) {
            keyboard.removePlayerReferences(var1);
        }
    }

    public void onPlayerLogin(ue var1) {
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload var1) {
        WorldData.onWorldUnload(var1.world);
    }

    public static boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    public void onPlayerChangedDimension(ue player) {
    }

    public void onPlayerRespawn(ue player) {
    }

    static {
        materialSteel = EnumHelper.addToolMaterial((String)"Steel", (int)3, (int)2500, (float)10.0f, (float)4.0f, (int)8);
        logger = Logger.getLogger("Minecraft");
        dimensionID = 13;
        MineSeed = "-8307681269462186282";
        SimPremClient = 220;
        KEY_ACC = 17;
        KEY_DEC = 31;
        KEY_TURNRIGHT = 32;
        KEY_TURNLEFT = 30;
        KEY_GETOUT = 34;
        KEY_INV = 19;
        KEY_SPECIAL = 33;
        KEY_HORN = 35;
        KEY_LIGHTS = 38;
        KEY_SHIFT = 42;
        KEY_SPACE = 57;
        OptifineInstalled = false;
        EntityFarmerID = 401;
        EntityMerchantID = 402;
        EntityBankerID = 403;
        EntityChefID = 404;
        singleTickCallbacks = new HashMap();
        continuousTickCallbacks = new HashMap();
        continuousTickCallbacksInUse = new HashMap();
        continuousTickCallbacksToAdd = new HashMap();
        continuousTickCallbacksToRemove = new HashMap();
    }
}

