/*
 * Decompiled with CFR 0.152.
 */
package simcraft.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TreeMap;
import net.minecraftforge.common.Configuration;
import simcraft.core.Property;

public class GlobalConfig {
    private boolean[] configBlocks = null;
    public static final int GENERAL_PROPERTY = 0;
    public static final int BLOCK_PROPERTY = 1;
    public static final int ITEM_PROPERTY = 2;
    public static final String ALLOWED_CHARS = "._-";
    public static final String DEFAULT_ENCODING = "UTF-8";
    File file;
    public TreeMap<String, Property> blockProperties = new TreeMap();
    public TreeMap<String, Property> itemProperties = new TreeMap();
    public TreeMap<String, Property> generalProperties = new TreeMap();
    public String defaultEncoding = "UTF-8";

    public GlobalConfig(File file) {
        this.file = file;
    }

    public Property getOrCreateBlockIdProperty(String key, int defaultId) {
        if (this.configBlocks == null) {
            this.configBlocks = new boolean[aqw.s.length];
            for (int i = 0; i < this.configBlocks.length; ++i) {
                this.configBlocks[i] = false;
            }
        }
        if (this.blockProperties.containsKey(key)) {
            Property property = this.getOrCreateIntProperty(key, 1, defaultId);
            this.configBlocks[Integer.parseInt((String)property.value)] = true;
            return property;
        }
        Property property = new Property();
        this.blockProperties.put(key, property);
        property.name = key;
        if (aqw.s[defaultId] == null && !this.configBlocks[defaultId]) {
            property.value = Integer.toString(defaultId);
            this.configBlocks[defaultId] = true;
            return property;
        }
        for (int j = aqw.s.length - 1; j >= 0; --j) {
            if (aqw.s[j] != null || this.configBlocks[j]) continue;
            property.value = Integer.toString(j);
            this.configBlocks[j] = true;
            return property;
        }
        throw new RuntimeException("No more block ids available for " + key);
    }

    public Property getOrCreateIntProperty(String key, int kind, int defaultValue) {
        Property prop = this.getOrCreateProperty(key, kind, Integer.toString(defaultValue));
        try {
            Integer.parseInt(prop.value);
            return prop;
        }
        catch (NumberFormatException e) {
            prop.value = Integer.toString(defaultValue);
            return prop;
        }
    }

    public Property getOrCreateBooleanProperty(String key, int kind, boolean defaultValue) {
        Property prop = this.getOrCreateProperty(key, kind, Boolean.toString(defaultValue));
        if ("true".equals(prop.value.toLowerCase()) || "false".equals(prop.value.toLowerCase())) {
            return prop;
        }
        prop.value = Boolean.toString(defaultValue);
        return prop;
    }

    public Property getOrCreateProperty(String key, int kind, String defaultValue) {
        TreeMap<String, Property> source = null;
        switch (kind) {
            case 0: {
                source = this.generalProperties;
                break;
            }
            case 1: {
                source = this.blockProperties;
                break;
            }
            case 2: {
                source = this.itemProperties;
            }
        }
        if (source.containsKey(key)) {
            return source.get(key);
        }
        if (defaultValue != null) {
            Property property = new Property();
            source.put(key, property);
            property.name = key;
            property.value = defaultValue;
            return property;
        }
        return null;
    }

    public void load() {
        BufferedReader buffer = null;
        Configuration.UnicodeInputStreamReader input = null;
        try {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            if (!this.file.exists() && !this.file.createNewFile()) {
                return;
            }
            if (this.file.canRead()) {
                String line;
                input = new Configuration.UnicodeInputStreamReader((InputStream)new FileInputStream(this.file), this.defaultEncoding);
                this.defaultEncoding = input.getEncoding();
                buffer = new BufferedReader((Reader)input);
                TreeMap<String, Property> currentMap = null;
                while ((line = buffer.readLine()) != null) {
                    int nameStart = -1;
                    int nameEnd = -1;
                    boolean skip = false;
                    block9: for (int i = 0; i < line.length() && !skip; ++i) {
                        if (Character.isLetterOrDigit(line.charAt(i)) || ALLOWED_CHARS.indexOf(line.charAt(i)) != -1) {
                            if (nameStart == -1) {
                                nameStart = i;
                            }
                            nameEnd = i;
                            continue;
                        }
                        if (Character.isWhitespace(line.charAt(i))) continue;
                        switch (line.charAt(i)) {
                            case '#': {
                                skip = true;
                                continue block9;
                            }
                            case '{': {
                                String scopeName = line.substring(nameStart, nameEnd + 1);
                                if (scopeName.equals("general")) {
                                    currentMap = this.generalProperties;
                                    continue block9;
                                }
                                if (scopeName.equals("block")) {
                                    currentMap = this.blockProperties;
                                    continue block9;
                                }
                                if (scopeName.equals("item")) {
                                    currentMap = this.itemProperties;
                                    continue block9;
                                }
                                throw new RuntimeException("unknown section " + scopeName);
                            }
                            case '}': {
                                currentMap = null;
                                continue block9;
                            }
                            case '=': {
                                String propertyName = line.substring(nameStart, nameEnd + 1);
                                if (currentMap == null) {
                                    throw new RuntimeException("property " + propertyName + " has no scope");
                                }
                                Property prop = new Property();
                                prop.name = propertyName;
                                prop.value = line.substring(i + 1);
                                i = line.length();
                                currentMap.put(propertyName, prop);
                                continue block9;
                            }
                            default: {
                                throw new RuntimeException("unknown character " + line.charAt(i));
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            if (!this.file.exists() && !this.file.createNewFile()) {
                return;
            }
            if (this.file.canWrite()) {
                FileOutputStream fos = new FileOutputStream(this.file);
                BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "8859_1"));
                buffer.write("# Configuration file\r\n");
                buffer.write("# Generated on " + DateFormat.getInstance().format(new Date()) + "\r\n");
                buffer.write("\r\n");
                buffer.write("###########\r\n");
                buffer.write("# General #\r\n");
                buffer.write("###########\r\n\r\n");
                buffer.write("# Block and Item Id's used:\r\n\r\n");
                buffer.write("general {\r\n");
                this.writeProperties(buffer, this.generalProperties.values());
                buffer.write("}\r\n\r\n");
                buffer.write("#########\r\n");
                buffer.write("# Block #\r\n");
                buffer.write("#########\r\n\r\n");
                buffer.write("block {\r\n");
                this.writeProperties(buffer, this.blockProperties.values());
                buffer.write("}\r\n\r\n");
                buffer.write("########\r\n");
                buffer.write("# Item #\r\n");
                buffer.write("########\r\n\r\n");
                buffer.write("item {\r\n");
                this.writeProperties(buffer, this.itemProperties.values());
                buffer.write("}\r\n\r\n");
                buffer.close();
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeProperties(BufferedWriter buffer, Collection<Property> props) throws IOException {
        for (Property property : props) {
            if (property.comment != null) {
                buffer.write("   # " + property.comment + "\r\n");
            }
            buffer.write("   " + property.name + "=" + property.value);
            buffer.write("\r\n");
        }
    }
}

