/*
 * Decompiled with CFR 0.152.
 */
package simcraft.core.rendermodels;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import simcraft.core.rendermodels.EnumOS;
import simcraft.core.rendermodels.EnumOSHelper;
import simcraft.core.rendermodels.ModelPoolEntry;
import simcraft.core.rendermodels.ModelPoolObjEntry;
import simcraft.core.rendermodels.TextureGrp;
import simcraft.core.rendermodels.TransformGrp;
import simcraft.core.rendermodels.TransformGrpBone;

public class ModelPool {
    private static Map<String, ModelPoolEntry> modelMap = new HashMap<String, ModelPoolEntry>();
    private static String[] resourceDir = new String[]{"minecraft/resources/models/", "minecraft/resources/mod/models/"};
    public static final Class OBJ = ModelPoolObjEntry.class;

    public static ModelPoolEntry addFile(String file, Class modelClass, Map<String, TransformGrp> group, Map<String, TextureGrp> textureGroup) {
        ModelPoolEntry entry = null;
        if (modelMap.containsKey(file)) {
            entry = modelMap.get(file);
            entry.applyGroups(group, textureGroup);
            return entry;
        }
        try {
            entry = (ModelPoolEntry)modelClass.newInstance();
        }
        catch (Exception e) {
            System.out.println("A new " + entry.getClass().getName() + " could not be initialized.");
            System.out.println(e.getMessage());
            return null;
        }
        File modelFile = null;
        for (int i = 0; !(i >= resourceDir.length || modelFile != null && modelFile.exists()); ++i) {
            String absPath = ModelPool.getAppDir(resourceDir[i]).getAbsolutePath();
            if (!absPath.endsWith("/") || !absPath.endsWith("\\")) {
                absPath = absPath + "/";
            }
            modelFile = entry.checkValidPath(absPath + file);
        }
        if (modelFile == null || !modelFile.exists()) {
            System.out.println("The model with the name " + file + " does not exist.");
            return null;
        }
        entry.groups = new HashMap<String, TransformGrpBone>();
        entry.textures = new HashMap<String, TextureGrp>();
        entry.name = file;
        entry.setGroup("0");
        entry.setTextureGroup("0");
        entry.getModel(modelFile);
        entry.applyGroups(group, textureGroup);
        modelMap.put(file, entry);
        return entry;
    }

    public static File getAppDir(String par0Str) {
        File var2;
        String var1 = System.getProperty("user.home", ".");
        switch (EnumOSHelper.field_90049_a[ModelPool.getOs().ordinal()]) {
            case 1: 
            case 2: {
                var2 = new File(var1, '.' + par0Str + '/');
                break;
            }
            case 3: {
                String var3 = System.getenv("APPDATA");
                if (var3 != null) {
                    var2 = new File(var3, "." + par0Str + '/');
                    break;
                }
                var2 = new File(var1, '.' + par0Str + '/');
                break;
            }
            case 4: {
                var2 = new File(var1, "Library/Application Support/" + par0Str);
                break;
            }
            default: {
                var2 = new File(var1, par0Str + '/');
            }
        }
        if (!var2.exists() && !var2.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + var2);
        }
        return var2;
    }

    public static EnumOS getOs() {
        String var0 = System.getProperty("os.name").toLowerCase();
        return var0.contains("win") ? EnumOS.WINDOWS : (var0.contains("mac") ? EnumOS.MACOS : (var0.contains("solaris") ? EnumOS.SOLARIS : (var0.contains("sunos") ? EnumOS.SOLARIS : (var0.contains("linux") ? EnumOS.LINUX : (var0.contains("unix") ? EnumOS.LINUX : EnumOS.UNKNOWN)))));
    }
}

