/*
 * Decompiled with CFR 0.152.
 */
package simcraft.core.power;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import simcraft.core.Direction;
import simcraft.core.power.PowerAcceptor;
import simcraft.core.power.PowerConductor;
import simcraft.core.power.PowerReceive;
import simcraft.core.power.PowerSource;
import simcraft.core.power.PowerTile;
import simcraft.core.power.PowerTransmit;

public final class PowerGrid {
    public static final double minConductionLoss = 1.0E-4;
    private static Map worldToPowerNetMap = new HashMap();
    private abv world;
    private static Map entityLivingToShockPowerMap = new HashMap();
    private Map powerSourceToPowerPathMap = new HashMap();

    public static PowerGrid getForWorld(abv world1) {
        if (world1 == null) {
            return null;
        }
        if (!worldToPowerNetMap.containsKey(world1)) {
            worldToPowerNetMap.put(world1, new PowerGrid(world1));
        }
        return (PowerGrid)worldToPowerNetMap.get(world1);
    }

    public static void onTick(abv var0) {
        for (Map.Entry entry : entityLivingToShockPowerMap.entrySet()) {
            of entityliving = (of)entry.getKey();
            int i = ((Integer)entry.getValue() + 63) / 64;
            if (!entityliving.S()) continue;
        }
        entityLivingToShockPowerMap.clear();
    }

    private PowerGrid(abv world1) {
        this.world = world1;
    }

    public void addTileEntity(asm tileentity) {
        if (!(tileentity instanceof PowerTile) || ((PowerTile)tileentity).isAddedToPowerGrid()) {
            return;
        }
        if (tileentity instanceof PowerAcceptor) {
            List list = this.discover(tileentity, true, Integer.MAX_VALUE);
            for (PowerPath powerpath : list) {
                PowerSource powersource = (PowerSource)powerpath.target;
                if (!this.powerSourceToPowerPathMap.containsKey(powersource) || !((double)powersource.getMaxPower() > powerpath.loss)) continue;
                this.powerSourceToPowerPathMap.remove(powersource);
            }
        }
        if (!(tileentity instanceof PowerSource)) {
            // empty if block
        }
    }

    public void removeTileEntity(asm tileentity) {
        if (!(tileentity instanceof PowerTile) || !((PowerTile)tileentity).isAddedToPowerGrid()) {
            return;
        }
        if (tileentity instanceof PowerAcceptor) {
            List list = this.discover(tileentity, true, Integer.MAX_VALUE);
            block0: for (PowerPath powerpath : list) {
                PowerSource powersource = (PowerSource)powerpath.target;
                if (!this.powerSourceToPowerPathMap.containsKey(powersource) || (double)powersource.getMaxPower() <= powerpath.loss) continue;
                if (tileentity instanceof PowerConductor) {
                    this.powerSourceToPowerPathMap.remove(powersource);
                    continue;
                }
                Iterator iterator1 = ((List)this.powerSourceToPowerPathMap.get(powersource)).iterator();
                while (iterator1.hasNext()) {
                    if (((PowerPath)iterator1.next()).target != tileentity) continue;
                    iterator1.remove();
                    continue block0;
                }
            }
        }
        if (tileentity instanceof PowerSource) {
            this.powerSourceToPowerPathMap.remove((PowerSource)tileentity);
        }
    }

    public int emitPowerFrom(PowerSource powersource, int i) {
        if (!powersource.isAddedToPowerGrid()) {
            return i;
        }
        if (!this.powerSourceToPowerPathMap.containsKey(powersource)) {
            this.powerSourceToPowerPathMap.put(powersource, this.discover((asm)powersource, false, powersource.getMaxPower()));
        }
        Vector<PowerPath> vector = new Vector<PowerPath>();
        double d = 0.0;
        for (PowerPath powerpath : (List)this.powerSourceToPowerPathMap.get(powersource)) {
            assert (powerpath.target instanceof PowerReceive);
            PowerReceive powersink = (PowerReceive)powerpath.target;
            if (!powersink.demandspower() || powerpath.loss >= (double)i) continue;
            d += 1.0 / powerpath.loss;
            vector.add(powerpath);
        }
        Collections.shuffle(vector);
        for (int j = vector.size() - i; j > 0; --j) {
            PowerPath powerpath1 = (PowerPath)vector.remove(vector.size() - 1);
            d -= 1.0 / powerpath1.loss;
        }
        HashMap<PowerPath, Integer> j = new HashMap<PowerPath, Integer>();
        Vector vector1 = new Vector();
        while (!vector.isEmpty() && i > 0) {
            int k = 0;
            double d1 = 0.0;
            Vector<PowerPath> vector2 = vector;
            vector = new Vector();
            Iterator iterator1 = vector.iterator();
            for (PowerPath powerpath4 : vector2) {
                int k1;
                PowerReceive powersink1 = (PowerReceive)powerpath4.target;
                int j1 = (int)Math.floor((double)Math.round((double)i / d / powerpath4.loss * 100000.0) / 100000.0);
                if (j1 > (k1 = (int)Math.floor(powerpath4.loss))) {
                    int l1 = powersink1.injectPower(powerpath4.targetDirection, j1 - k1);
                    if (l1 == 0) {
                        vector.add(powerpath4);
                        d1 += 1.0 / powerpath4.loss;
                    } else if (l1 == j1 - k1) {
                        System.out.println("[SimCraft] WARNING: " + powersink1 + " didn't implement demandsPower() properly, no power from injectPower accepted although demandsPower() returned true.");
                    }
                    k += j1 - l1;
                    int i2 = j1 - k1 - l1;
                    if (!j.containsKey(powerpath4)) {
                        j.put(powerpath4, i2);
                        continue;
                    }
                    j.put(powerpath4, i2 + (Integer)j.get(powerpath4));
                    continue;
                }
                vector.add(powerpath4);
                d1 += 1.0 / powerpath4.loss;
            }
            if (k == 0 && !vector.isEmpty()) {
                PowerPath powerpath3 = (PowerPath)vector.remove(vector.size() - 1);
                d1 -= 1.0 / powerpath3.loss;
            }
            d = d1;
            i -= k;
        }
        for (Map.Entry entry : j.entrySet()) {
            PowerPath powerpath2 = (PowerPath)entry.getKey();
            int l = (Integer)entry.getValue();
            powerpath2.totalPowerConducted += (long)l;
            if (l > powerpath2.minInsulationPowerAbsorption) {
                List list = this.world.a(of.class, asu.a((double)(powerpath2.minX - 1), (double)(powerpath2.minY - 1), (double)(powerpath2.minZ - 1), (double)(powerpath2.maxX + 2), (double)(powerpath2.maxY + 2), (double)(powerpath2.maxZ + 2)));
                for (of entityliving : list) {
                    int i1 = 0;
                    Iterator iterator6 = powerpath2.conductors.iterator();
                    PowerConductor powerconductor2 = null;
                    while (true) {
                        if (iterator6.hasNext()) {
                            powerconductor2 = (PowerConductor)iterator6.next();
                            asm tileentity = (asm)powerconductor2;
                            if (!entityliving.E.b(asu.a((double)(tileentity.l - 1), (double)(tileentity.m - 1), (double)(tileentity.n - 1), (double)(tileentity.l + 2), (double)(tileentity.m + 2), (double)(tileentity.n + 2)))) continue;
                        }
                        int j2 = l - powerconductor2.getInsulationPowerAbsorption();
                        if (j2 > i1) {
                            i1 = j2;
                        }
                        if (powerconductor2.getInsulationPowerAbsorption() == powerpath2.minInsulationPowerAbsorption) break;
                    }
                    if (entityLivingToShockPowerMap.containsKey(entityliving)) {
                        entityLivingToShockPowerMap.put(entityliving, (Integer)entityLivingToShockPowerMap.get(entityliving) + i1);
                        continue;
                    }
                    entityLivingToShockPowerMap.put(entityliving, i1);
                }
                if (l >= powerpath2.minInsulationBreakdownPower) {
                    for (PowerConductor powerconductor1 : powerpath2.conductors) {
                        if (l < powerconductor1.getInsulationBreakdownPower()) continue;
                        powerconductor1.removeInsulation();
                        if (powerconductor1.getInsulationPowerAbsorption() >= powerpath2.minInsulationPowerAbsorption) continue;
                        powerpath2.minInsulationPowerAbsorption = powerconductor1.getInsulationPowerAbsorption();
                    }
                }
            }
            if (l < powerpath2.minConductorBreakdownPower) continue;
            for (PowerConductor powerconductor : powerpath2.conductors) {
                if (l < powerconductor.getConductorBreakdownPower()) continue;
                powerconductor.removeConductor();
            }
        }
        return i;
    }

    public long getTotalPowerConducted(asm tileentity) {
        long l = 0L;
        if (tileentity instanceof PowerConductor || tileentity instanceof PowerReceive) {
            List list = this.discover(tileentity, true, Integer.MAX_VALUE);
            for (PowerPath powerpath1 : list) {
                PowerSource powersource = (PowerSource)powerpath1.target;
                if (!this.powerSourceToPowerPathMap.containsKey(powersource) || !((double)powersource.getMaxPower() > powerpath1.loss)) continue;
                for (PowerPath powerpath2 : (List)this.powerSourceToPowerPathMap.get(powersource)) {
                    if ((!(tileentity instanceof PowerReceive) || powerpath2.target != tileentity) && (!(tileentity instanceof PowerConductor) || !powerpath2.conductors.contains((PowerConductor)tileentity))) continue;
                    l += powerpath2.totalPowerConducted;
                }
            }
        }
        if (tileentity instanceof PowerSource && this.powerSourceToPowerPathMap.containsKey((PowerSource)tileentity)) {
            for (PowerPath powerpath : (List)this.powerSourceToPowerPathMap.get((PowerSource)tileentity)) {
                l += powerpath.totalPowerConducted;
            }
        }
        return l;
    }

    private List discover(asm tileentity, boolean flag, int i) {
        HashMap<asm, PowerBlockLink> hashmap = new HashMap<asm, PowerBlockLink>();
        LinkedList<asm> linkedlist = new LinkedList<asm>();
        linkedlist.add(tileentity);
        while (!linkedlist.isEmpty()) {
            asm tileentity1 = (asm)linkedlist.remove();
            if (tileentity1.r()) continue;
            double d = 0.0;
            if (tileentity1 != tileentity) {
                d = ((PowerBlockLink)hashmap.get((Object)tileentity1)).loss;
            }
            List list = this.getValidReceivers(tileentity1, flag);
            for (PowerTarget powertarget : list) {
                if (powertarget.tileEntity == tileentity) continue;
                double d1 = 0.0;
                if (powertarget.tileEntity instanceof PowerConductor) {
                    d1 = ((PowerConductor)powertarget.tileEntity).getConductionLoss();
                    if (d1 < 1.0E-4) {
                        d1 = 1.0E-4;
                    }
                    if (d + d1 >= (double)i) continue;
                }
                if (hashmap.containsKey(powertarget.tileEntity) && ((PowerBlockLink)hashmap.get((Object)powertarget.tileEntity)).loss <= d + d1) continue;
                hashmap.put(powertarget.tileEntity, new PowerBlockLink(powertarget.direction, d + d1));
                if (!(powertarget.tileEntity instanceof PowerConductor)) continue;
                linkedlist.remove(powertarget.tileEntity);
                linkedlist.add(powertarget.tileEntity);
            }
        }
        LinkedList<PowerPath> linkedlist1 = new LinkedList<PowerPath>();
        for (Map.Entry entry : hashmap.entrySet()) {
            asm tileentity2 = (asm)entry.getKey();
            if (!(!flag && tileentity2 instanceof PowerReceive || flag && tileentity2 instanceof PowerSource)) continue;
            PowerBlockLink powerblocklink = (PowerBlockLink)entry.getValue();
            PowerPath powerpath = new PowerPath();
            powerpath.loss = powerblocklink.loss > 0.1 ? powerblocklink.loss : 0.1;
            powerpath.target = tileentity2;
            powerpath.targetDirection = powerblocklink.direction;
            if (!flag && tileentity instanceof PowerSource) {
                while (true) {
                    if ((tileentity2 = powerblocklink.direction.applyToTileEntity(tileentity2)) == tileentity) {
                        continue;
                    }
                    if (!(tileentity2 instanceof PowerConductor)) break;
                    PowerConductor powerconductor = (PowerConductor)tileentity2;
                    if (tileentity2.l < powerpath.minX) {
                        powerpath.minX = tileentity2.l;
                    }
                    if (tileentity2.m < powerpath.minY) {
                        powerpath.minY = tileentity2.m;
                    }
                    if (tileentity2.n < powerpath.minZ) {
                        powerpath.minZ = tileentity2.n;
                    }
                    if (tileentity2.l > powerpath.maxX) {
                        powerpath.maxX = tileentity2.l;
                    }
                    if (tileentity2.m > powerpath.maxY) {
                        powerpath.maxY = tileentity2.m;
                    }
                    if (tileentity2.n > powerpath.maxZ) {
                        powerpath.maxZ = tileentity2.n;
                    }
                    powerpath.conductors.add(powerconductor);
                    if (powerconductor.getInsulationPowerAbsorption() < powerpath.minInsulationPowerAbsorption) {
                        powerpath.minInsulationPowerAbsorption = powerconductor.getInsulationPowerAbsorption();
                    }
                    if (powerconductor.getInsulationBreakdownPower() < powerpath.minInsulationBreakdownPower) {
                        powerpath.minInsulationBreakdownPower = powerconductor.getInsulationBreakdownPower();
                    }
                    if (powerconductor.getConductorBreakdownPower() < powerpath.minConductorBreakdownPower) {
                        powerpath.minConductorBreakdownPower = powerconductor.getConductorBreakdownPower();
                    }
                    if ((powerblocklink = (PowerBlockLink)hashmap.get(tileentity2)) != null) continue;
                    System.out.println("An power network pathfinding entry is corrupted.\nThis could happen due to incorrect Minecraft behavior or a bug.\n\n(Technical information: powerBlockLink, tile entities below)\nE: " + tileentity + " (" + tileentity.l + "," + tileentity.m + "," + tileentity.n + ")\n" + "C: " + tileentity2 + " (" + tileentity2.l + "," + tileentity2.m + "," + tileentity2.n + ")\n" + "R: " + powerpath.target + " (" + powerpath.target.l + "," + powerpath.target.m + "," + powerpath.target.n + ")");
                }
                if (tileentity2 != null) {
                    System.out.println("PowerGrid: PowerBlockLink corrupted (" + powerpath.target + " [" + powerpath.target.l + " " + powerpath.target.m + " " + powerpath.target.n + "] -> " + tileentity2 + " [" + tileentity2.l + " " + tileentity2.m + " " + tileentity2.n + "] -> " + tileentity + " [" + tileentity.l + " " + tileentity.m + " " + tileentity.n + "])");
                }
            }
            linkedlist1.add(powerpath);
        }
        return linkedlist1;
    }

    public List discoverTargets(asm tileentity, boolean flag, int i) {
        List list = this.discover(tileentity, flag, i);
        LinkedList<asm> linkedlist = new LinkedList<asm>();
        for (PowerPath powerpath : list) {
            linkedlist.add(powerpath.target);
        }
        return linkedlist;
    }

    private List getValidReceivers(asm tileentity, boolean flag) {
        LinkedList<PowerTarget> linkedlist = new LinkedList<PowerTarget>();
        for (Direction direction : Direction.values()) {
            asm tileentity1 = direction.applyToTileEntity(tileentity);
            if (!(tileentity1 instanceof PowerTile) || !((PowerTile)tileentity1).isAddedToPowerGrid()) continue;
            Direction direction1 = direction.getInverse();
            if (!(!flag && tileentity instanceof PowerTransmit && ((PowerTransmit)tileentity).emitsPowerTo(tileentity1, direction) || flag && tileentity instanceof PowerAcceptor && ((PowerAcceptor)tileentity).acceptsPowerFrom(tileentity1, direction) && (!flag && tileentity1 instanceof PowerAcceptor && ((PowerAcceptor)tileentity1).acceptsPowerFrom(tileentity, direction1) || flag && tileentity1 instanceof PowerTransmit && ((PowerTransmit)tileentity1).emitsPowerTo(tileentity, direction1)))) continue;
            linkedlist.add(new PowerTarget(tileentity1, direction1));
        }
        return linkedlist;
    }

    static {
        worldToPowerNetMap = new HashMap();
    }

    static class PowerPath {
        asm target = null;
        Direction targetDirection;
        Set conductors = new HashSet();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        double loss = 0.0;
        int minInsulationPowerAbsorption = Integer.MAX_VALUE;
        int minInsulationBreakdownPower = Integer.MAX_VALUE;
        int minConductorBreakdownPower = Integer.MAX_VALUE;
        long totalPowerConducted = 0L;

        PowerPath() {
        }
    }

    static class PowerBlockLink {
        Direction direction;
        double loss;

        PowerBlockLink(Direction direction, double loss) {
            this.direction = direction;
            this.loss = loss;
        }
    }

    static class PowerTarget {
        asm tileEntity;
        Direction direction;

        PowerTarget(asm tileentity, Direction direction) {
            this.tileEntity = tileentity;
            this.direction = direction;
        }
    }
}

