/*
 * Decompiled with CFR 0.152.
 */
package simcraft.core;

import java.util.ArrayList;
import java.util.List;
import simcraft.core.Orientations;

public class BlockPosition {
    public int x;
    public int y;
    public int z;
    public Orientations orientation;

    public BlockPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = Orientations.Unknown;
    }

    public BlockPosition(int x, int y, int z, Orientations corientation) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = corientation;
    }

    public BlockPosition(BlockPosition p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        this.orientation = p.orientation;
    }

    public BlockPosition(bx nbttagcompound) {
        this.x = nbttagcompound.e("i");
        this.y = nbttagcompound.e("j");
        this.z = nbttagcompound.e("k");
        this.orientation = Orientations.Unknown;
    }

    public BlockPosition(asm tile) {
        this.x = tile.l;
        this.y = tile.m;
        this.z = tile.n;
    }

    public void moveRight(int step) {
        switch (this.orientation) {
            case ZPos: {
                this.x -= step;
                break;
            }
            case ZNeg: {
                this.x += step;
                break;
            }
            case XPos: {
                this.z += step;
                break;
            }
            case XNeg: {
                this.z -= step;
            }
        }
    }

    public void moveLeft(int step) {
        this.moveRight(-step);
    }

    public void moveForwards(int step) {
        switch (this.orientation) {
            case YPos: {
                this.y += step;
                break;
            }
            case YNeg: {
                this.y -= step;
                break;
            }
            case ZPos: {
                this.z += step;
                break;
            }
            case ZNeg: {
                this.z -= step;
                break;
            }
            case XPos: {
                this.x += step;
                break;
            }
            case XNeg: {
                this.x -= step;
            }
        }
    }

    public void moveBackwards(int step) {
        this.moveForwards(-step);
    }

    public void moveUp(int step) {
        switch (this.orientation) {
            case ZPos: 
            case ZNeg: 
            case XPos: 
            case XNeg: {
                this.y += step;
            }
        }
    }

    public void moveDown(int step) {
        this.moveUp(-step);
    }

    public void writeToNBT(bx nbttagcompound) {
        nbttagcompound.a("i", (double)this.x);
        nbttagcompound.a("j", (double)this.y);
        nbttagcompound.a("k", (double)this.z);
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + ", " + this.z + "}";
    }

    public BlockPosition min(BlockPosition p) {
        return new BlockPosition(p.x > this.x ? this.x : p.x, p.y > this.y ? this.y : p.y, p.z > this.z ? this.z : p.z);
    }

    public BlockPosition max(BlockPosition p) {
        return new BlockPosition(p.x < this.x ? this.x : p.x, p.y < this.y ? this.y : p.y, p.z < this.z ? this.z : p.z);
    }

    public List<BlockPosition> getAdjacent(boolean includeVertical) {
        ArrayList<BlockPosition> a = new ArrayList<BlockPosition>();
        a.add(new BlockPosition(this.x + 1, this.y, this.z));
        a.add(new BlockPosition(this.x - 1, this.y, this.z));
        a.add(new BlockPosition(this.x, this.y, this.z + 1));
        a.add(new BlockPosition(this.x, this.y, this.z - 1));
        if (includeVertical) {
            a.add(new BlockPosition(this.x, this.y + 1, this.z));
            a.add(new BlockPosition(this.x, this.y - 1, this.z));
        }
        return a;
    }
}

