/*
 * Decompiled with CFR 0.152.
 */
package crowley.skyblock.blocks.tileentities;

import crowley.skyblock.blocks.BlockData;
import crowley.skyblock.registries.ColorRegistry;
import crowley.skyblock.utility.Color;
import crowley.skyblock.utility.Compostable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBarrel
extends TileEntity
implements IFluidHandler {
    private static final float MIN_RENDER_CAPACITY = 0.1f;
    private static final float MAX_RENDER_CAPACITY = 0.9f;
    private static final int MAX_COMPOSTING_TIME = 1000;
    private static final int MAX_FLUID = 8000;
    private static final int UPDATE_INTERVAL = 10;
    public FluidStack fluid;
    private float volume = 0.0f;
    private int timer = 0;
    public BarrelMode mode;
    public Color color;
    private Color colorBase = this.color = ColorRegistry.color("white");
    public Icon icon;
    private boolean needsUpdate = false;
    private int updateTimer = 0;

    public TileEntityBarrel() {
        this.mode = BarrelMode.EMPTY;
        this.fluid = new FluidStack(FluidRegistry.WATER, 0);
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K && this.field_70331_k.func_72896_J() && this.field_70331_k.func_72937_j(this.field_70329_l, this.field_70330_m, this.field_70327_n) && this.field_70331_k.func_72807_a((int)this.field_70329_l, (int)this.field_70327_n).field_76751_G > 0.0f) {
            if (this.mode == BarrelMode.EMPTY) {
                this.fluid = new FluidStack(FluidRegistry.WATER, 0);
                this.mode = BarrelMode.FLUID;
            }
            if (this.mode == BarrelMode.FLUID && this.volume < 1.0f && this.fluid.fluidID == FluidRegistry.WATER.getID()) {
                this.volume += this.field_70331_k.func_72807_a((int)this.field_70329_l, (int)this.field_70327_n).field_76751_G / 1000.0f;
                if (this.volume > 1.0f) {
                    this.volume = 1.0f;
                }
                this.fluid.amount = (int)(8000.0f * this.volume);
                this.needsUpdate = true;
            }
        }
        if (this.mode == BarrelMode.COMPOST && this.volume >= 1.0f) {
            ++this.timer;
            float percentage = (float)this.timer / 1000.0f;
            Color dirt = ColorRegistry.color("dirt");
            float avgR = this.colorBase.r + (dirt.r - this.colorBase.r) * percentage;
            float avgG = this.colorBase.g + (dirt.g - this.colorBase.g) * percentage;
            float avgB = this.colorBase.b + (dirt.b - this.colorBase.b) * percentage;
            float avgA = this.colorBase.a + (dirt.a - this.colorBase.a) * percentage;
            this.color = new Color(avgR, avgG, avgB, avgA);
            if (this.timer >= 1000) {
                this.mode = BarrelMode.DIRT;
                this.timer = 0;
                this.color = ColorRegistry.color("white");
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
        if (this.field_70331_k.func_72803_f(this.field_70329_l, this.field_70330_m, this.field_70327_n).func_76217_h() && this.mode == BarrelMode.FLUID && this.fluid.fluidID == FluidRegistry.LAVA.getID()) {
            ++this.timer;
            if (this.timer % 30 == 0) {
                this.field_70331_k.func_72869_a("largesmoke", (double)this.field_70329_l + Math.random(), (double)this.field_70330_m + 1.2, (double)this.field_70327_n + Math.random(), 0.0, 0.0, 0.0);
            }
            if (this.timer % 5 == 0) {
                this.field_70331_k.func_72869_a("smoke", (double)this.field_70329_l + Math.random(), (double)this.field_70330_m + 1.2, (double)this.field_70327_n + Math.random(), 0.0, 0.0, 0.0);
            }
            if (this.timer >= 400) {
                if (this.fluid.amount < 1000) {
                    this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m + 2, this.field_70327_n, Block.field_72067_ar.field_71990_ca);
                } else {
                    this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, FluidRegistry.LAVA.getBlockID(), 0, 3);
                }
            }
        }
        if (this.updateTimer >= 10) {
            this.updateTimer = 0;
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        } else {
            ++this.updateTimer;
        }
    }

    public boolean addCompostItem(Compostable item) {
        if (this.mode == BarrelMode.EMPTY) {
            this.mode = BarrelMode.COMPOST;
            this.timer = 0;
        }
        if (this.mode == BarrelMode.COMPOST && this.volume < 1.0f) {
            this.volume += item.value;
            if (this.volume > 1.0f) {
                this.volume = 1.0f;
            }
            float weightA = item.value / this.volume;
            float weightB = 1.0f - weightA;
            float r = weightA * item.color.r + weightB * this.color.r;
            float g = weightA * item.color.g + weightB * this.color.g;
            float b = weightA * item.color.b + weightB * this.color.b;
            float a = weightA * item.color.a + weightB * this.color.a;
            this.color = new Color(r, g, b, a);
            if (this.volume == 1.0f) {
                this.colorBase = this.color;
            }
            this.needsUpdate = true;
            return true;
        }
        return false;
    }

    public boolean isFull() {
        return this.volume >= 1.0f;
    }

    public void giveDirt() {
        if (!this.field_70331_k.field_72995_K) {
            double x = (float)this.field_70329_l + 0.5f;
            double y = (float)this.field_70330_m + 1.5f;
            double z = (float)this.field_70327_n + 0.5f;
            EntityItem entityitem = new EntityItem(this.field_70331_k, x, y, z, new ItemStack(Block.field_71979_v));
            this.field_70331_k.func_72838_d((Entity)entityitem);
            this.volume = 0.0f;
            this.color = ColorRegistry.color("white");
            this.colorBase = ColorRegistry.color("white");
            this.mode = BarrelMode.EMPTY;
            this.needsUpdate = true;
        }
    }

    public void giveClay() {
        if (!this.field_70331_k.field_72995_K) {
            double x = (float)this.field_70329_l + 0.5f;
            double y = (float)this.field_70330_m + 1.5f;
            double z = (float)this.field_70327_n + 0.5f;
            EntityItem entityitem = new EntityItem(this.field_70331_k, x, y, z, new ItemStack(Block.field_72041_aW));
            this.field_70331_k.func_72838_d((Entity)entityitem);
            this.volume = 0.0f;
            this.color = ColorRegistry.color("white");
            this.colorBase = ColorRegistry.color("white");
            this.mode = BarrelMode.EMPTY;
            this.needsUpdate = true;
        }
    }

    public float getAdjustedVolume() {
        float capacity = 0.79999995f;
        float adjusted = this.volume * capacity;
        return adjusted += 0.1f;
    }

    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        switch (compound.func_74762_e("mode")) {
            case 0: {
                this.mode = BarrelMode.EMPTY;
                break;
            }
            case 1: {
                this.mode = BarrelMode.FLUID;
                break;
            }
            case 2: {
                this.mode = BarrelMode.COMPOST;
                break;
            }
            case 3: {
                this.mode = BarrelMode.DIRT;
                break;
            }
            case 4: {
                this.mode = BarrelMode.CLAY;
            }
        }
        this.volume = compound.func_74760_g("volume");
        this.timer = compound.func_74762_e("timer");
        this.color = new Color(compound.func_74762_e("color"));
        this.colorBase = new Color(compound.func_74762_e("colorBase"));
        this.fluid = new FluidStack(FluidRegistry.getFluid((int)compound.func_74765_d("fluid")), (int)(this.volume * 8000.0f));
        this.field_70325_p = compound.func_74762_e("meta");
        this.needsUpdate = true;
    }

    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        compound.func_74768_a("mode", this.mode.value);
        compound.func_74776_a("volume", this.volume);
        compound.func_74768_a("timer", this.timer);
        compound.func_74768_a("color", this.color.toInt());
        compound.func_74768_a("colorBase", this.colorBase.toInt());
        compound.func_74777_a("fluid", (short)this.fluid.fluidID);
        compound.func_74768_a("meta", this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, BlockData.BARREL_ID, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        NBTTagCompound tag = pkt.field_73331_e;
        this.func_70307_a(tag);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int capacity = 8000 - this.fluid.amount;
        if (!doFill) {
            if (this.mode == BarrelMode.EMPTY) {
                return resource.amount;
            }
            if (this.mode == BarrelMode.FLUID && resource.fluidID == this.fluid.fluidID) {
                if (capacity >= resource.amount) {
                    return resource.amount;
                }
                return capacity;
            }
        } else {
            if (this.mode == BarrelMode.EMPTY) {
                if (resource.fluidID != this.fluid.fluidID) {
                    this.fluid = new FluidStack(FluidRegistry.getFluid((int)resource.fluidID), resource.amount);
                } else {
                    this.fluid.amount = resource.amount;
                }
                this.mode = BarrelMode.FLUID;
                this.needsUpdate = true;
                return resource.amount;
            }
            if (this.mode == BarrelMode.FLUID && resource.fluidID == this.fluid.fluidID) {
                if (capacity >= resource.amount) {
                    this.fluid.amount += resource.amount;
                    this.volume = (float)this.fluid.amount / 8000.0f;
                    this.needsUpdate = true;
                    return resource.amount;
                }
                this.fluid.amount = 8000;
                this.volume = 1.0f;
                this.needsUpdate = true;
                return capacity;
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || this.mode != BarrelMode.FLUID || !resource.isFluidEqual(this.fluid)) {
            return null;
        }
        if (!doDrain) {
            if (this.fluid.amount >= resource.amount) {
                FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)resource.fluidID), resource.amount);
                return simulated;
            }
            FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)resource.fluidID), this.fluid.amount);
            return simulated;
        }
        if (this.fluid.amount > resource.amount) {
            FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)resource.fluidID), resource.amount);
            this.fluid.amount -= resource.amount;
            this.volume = (float)this.fluid.amount / 8000.0f;
            this.needsUpdate = true;
            return drained;
        }
        FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)resource.fluidID), this.fluid.amount);
        this.fluid.amount = 0;
        this.volume = 0.0f;
        this.mode = BarrelMode.EMPTY;
        this.timer = 0;
        this.needsUpdate = true;
        return drained;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.mode != BarrelMode.FLUID) {
            return null;
        }
        if (!doDrain) {
            if (this.fluid.amount >= maxDrain) {
                FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)this.fluid.fluidID), maxDrain);
                return simulated;
            }
            FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)this.fluid.fluidID), this.fluid.amount);
            return simulated;
        }
        if (this.fluid.amount > maxDrain) {
            FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)this.fluid.fluidID), maxDrain);
            this.fluid.amount -= maxDrain;
            this.volume = (float)this.fluid.amount / 8000.0f;
            this.needsUpdate = true;
            return drained;
        }
        FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)this.fluid.fluidID), this.fluid.amount);
        this.fluid.amount = 0;
        this.volume = 0.0f;
        this.mode = BarrelMode.EMPTY;
        this.timer = 0;
        this.needsUpdate = true;
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo info = new FluidTankInfo(this.fluid, 8000);
        FluidTankInfo[] array = new FluidTankInfo[]{info};
        return array;
    }

    public int getLightLevel() {
        if (this.mode == BarrelMode.FLUID) {
            return this.fluid.getFluid().getLuminosity();
        }
        return 0;
    }

    public static enum BarrelMode {
        EMPTY(0),
        FLUID(1),
        COMPOST(2),
        DIRT(3),
        CLAY(4);

        public int value;

        private BarrelMode(int v) {
            this.value = v;
        }
    }
}

