/*
 * Decompiled with CFR 0.152.
 */
package crowley.skyblock.blocks.renderers;

import crowley.skyblock.blocks.BlockBarrel;
import crowley.skyblock.blocks.models.ModelBarrel;
import crowley.skyblock.blocks.models.ModelBarrelInternal;
import crowley.skyblock.blocks.tileentities.TileEntityBarrel;
import crowley.skyblock.utility.Color;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class RenderBarrel
extends TileEntitySpecialRenderer {
    private ModelBarrel barrel;
    private ModelBarrelInternal internal;

    public RenderBarrel(ModelBarrel model) {
        this.barrel = model;
        this.internal = new ModelBarrelInternal();
    }

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        this.drawBarrel(tileentity, x, y, z, f);
        this.drawBarrelContents(tileentity, x, y, z, f);
    }

    private void drawBarrel(TileEntity tileentity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)-0.8f, (float)-1.0f, (float)0.8f);
        this.bindBarrelTexture(tileentity.field_70325_p);
        this.barrel.simpleRender(0.0625f);
        GL11.glPopMatrix();
    }

    private void drawBarrelContents(TileEntity tileentity, double x, double y, double z, float f) {
        TileEntityBarrel barrel = (TileEntityBarrel)tileentity;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + barrel.getAdjustedVolume()), (float)((float)z + 0.5f));
        GL11.glScalef((float)0.8f, (float)1.0f, (float)0.8f);
        this.bindInternalTexture();
        switch (barrel.mode) {
            case EMPTY: {
                break;
            }
            case COMPOST: {
                this.renderCompost(tileentity);
                break;
            }
            case FLUID: {
                this.renderFluid(tileentity);
                break;
            }
            case DIRT: {
                this.renderDirt(tileentity);
                break;
            }
            case CLAY: {
                this.renderClay(tileentity);
            }
        }
        GL11.glPopMatrix();
    }

    private void renderClay(TileEntity tileentity) {
        TileEntityBarrel barrel = (TileEntityBarrel)tileentity;
        Icon icon = Block.field_72041_aW.func_71858_a(0, 0);
        Color color = barrel.color;
        this.internal.render(color, icon, false);
    }

    private void renderCompost(TileEntity tileentity) {
        TileEntityBarrel barrel = (TileEntityBarrel)tileentity;
        Icon icon = BlockBarrel.iconCompost;
        Color color = barrel.color;
        this.internal.render(color, icon, false);
    }

    private void renderDirt(TileEntity tileentity) {
        TileEntityBarrel barrel = (TileEntityBarrel)tileentity;
        Icon icon = Block.field_71979_v.func_71858_a(0, 0);
        Color color = barrel.color;
        this.internal.render(color, icon, false);
    }

    private void renderFluid(TileEntity tileentity) {
        TileEntityBarrel barrel = (TileEntityBarrel)tileentity;
        Fluid content = barrel.fluid.getFluid();
        Icon icon = content.getIcon();
        Color color = new Color(content.getColor());
        this.internal.render(color, icon, true);
    }

    public void bindBarrelTexture(int meta) {
        if (meta >= 0) {
            this.func_110628_a(ModelBarrel.textures[meta]);
        }
    }

    public void bindInternalTexture() {
        ResourceLocation fluidTexture = TextureMap.field_110575_b;
        this.func_110628_a(fluidTexture);
    }
}

