/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases.core;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassWriter;

public class ClassWriterCircularityResolver
extends ClassWriter {
    private Map<String, Class> predefinedClasses = new HashMap<String, Class>();

    public ClassWriterCircularityResolver(int flags) {
        super(flags);
        this.predefinedClasses.put("net/minecraft/entity/player/EntityPlayer", ue.class);
        this.predefinedClasses.put("net/minecraft/entity/EntityLivingBase", oe.class);
    }

    protected String getCommonSuperClass(String type1, String type2) {
        Class<?> c = this.predefinedClasses.get(type1);
        Class<?> d = this.predefinedClasses.get(type2);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            if (c == null) {
                c = Class.forName(type1.replace('/', '.'), false, classLoader);
            }
            if (d == null) {
                d = Class.forName(type2.replace('/', '.'), false, classLoader);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        if (c.isAssignableFrom(d)) {
            return type1;
        }
        if (d.isAssignableFrom(c)) {
            return type2;
        }
        if (c.isInterface() || d.isInterface()) {
            return "java/lang/Object";
        }
        while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
        }
        return c.getName().replace('.', '/');
    }
}

