/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import glenn.gases.BlockGas;
import glenn.gases.BlockGasElectric;
import glenn.gases.BlockGasHazard;
import glenn.gases.BlockGasVoid;
import glenn.gases.BlockLantern;
import glenn.gases.CommonProxy;
import glenn.gases.DamageSourceLightning;
import glenn.gases.EntityGlowstoneShard;
import glenn.gases.EntitySmallLightning;
import glenn.gases.ItemGlowstoneShard;
import glenn.gases.WorldGeneratorGases;
import glenn.gases.client.RenderBlockGas;
import glenn.gases.client.RenderBlockLantern;
import glenn.gases.client.SoundBus;
import glenn.gases.reaction.Reaction;
import glenn.gases.reaction.ReactionCorrosion;
import glenn.gases.reaction.ReactionEmpty;
import glenn.gases.reaction.ReactionGlowstoneShard;
import glenn.gases.reaction.ReactionIgnition;
import java.util.ArrayList;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="Gases", name="Gases", version="1.3.2")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class Gases {
    @Mod.Instance(value="GlennsGases")
    public static Gases instance;
    @SidedProxy(clientSide="glenn.gases.client.ClientProxy", serverSide="glenn.gases.CommonProxy")
    public static CommonProxy proxy;
    private static Configuration config;
    public static boolean generateGreenGas;
    public static boolean generateRedGas;
    public static boolean generateElectricGas;
    public static boolean generateCorrosiveGas;
    public static float maxHardnessForCorrosion;
    public static float gasExplosionFactor;
    public static int renderBlockGasID;
    public static int renderBlockLanternID;
    public static final ajz gasMaterial;
    public static final na lightningDamageSource;
    private static boolean[] gasReactives;
    private static int[] lanternRecipes;
    private static ArrayList<Reaction> reactions;
    public static yb gasBottle;
    public static yb glowstoneShard;
    public static aqw gasSmoke;
    public static aqw gasSteam;
    public static aqw gasRisingFlammable;
    public static aqw gasFallingExplosive;
    public static aqw gasVoid;
    public static aqw gasElectric;
    public static aqw gasCorrosive;
    public static int lanternEmptyID;
    public static aqw lanternEmpty;
    public static aqw lanternTorch;
    public static aqw lanternGasEmpty;
    public static aqw lanternGas;
    public static aqw lanternGlowstone;

    private void initBlocksAndItems() {
        gasBottle = new yb(Gases.b("gasBottleID", 400)).b("gasBottle").a(wv.f).d("gases:bottle_gas");
        GameRegistry.registerItem((yb)gasBottle, (String)"gasBottle");
        glowstoneShard = new ItemGlowstoneShard(Gases.b("glowstoneShardID", 401)).b("glowstoneShard").a(wv.f).d("gases:glowstone_shard");
        GameRegistry.registerItem((yb)glowstoneShard, (String)"glowstoneShard");
        gasSmoke = new BlockGas(Gases.a("gasSmokeID", 500), 0x3F3F3F, 2, -16, 0).setEffectRates(4, 4, 0).c(0.0f).c("gasSmoke").a(wv.f).d("gases:gas");
        GameRegistry.registerBlock((aqw)gasSmoke, (String)"gasSmoke");
        gasSteam = new BlockGasHazard(Gases.a("gasSteamID", 501), 0xFFFFFF, 0, -8, 0, 2.0f).setEvaporation(4).c(0.0f).c("gasSteam").a(wv.f).d("gases:gas");
        GameRegistry.registerBlock((aqw)gasSteam, (String)"gasSteam");
        gasRisingFlammable = new BlockGas(Gases.a("gasRisingFlammableID", 502), 0x6F7F6F, 1, -12, 1).setEffectRates(2, 2, 0).c(0.0f).c("gasRisingFlammable").a(wv.f).d("gases:gas");
        GameRegistry.registerBlock((aqw)gasRisingFlammable, (String)"gasRisingFlammable");
        gasFallingExplosive = new BlockGas(Gases.a("gasFallingExplosiveID", 503), 0x7F4F4F, 3, 4, 2).setEffectRates(1, 2, 0).c(0.0f).c("gasFallingExplosive").a(wv.f).d("gases:gas");
        GameRegistry.registerBlock((aqw)gasFallingExplosive, (String)"gasFallingExplosive");
        gasVoid = new BlockGasVoid(Gases.a("gasVoidID", 504), 0x1F1F1F, 4, 8, 0, 1.0f).setEffectRates(20, 4, 0).c(0.0f).c("gasVoid").a(wv.f).d("gases:gas");
        GameRegistry.registerBlock((aqw)gasVoid, (String)"gasVoid");
        gasElectric = new BlockGasElectric(Gases.a("gasElectricID", 505), 0x1F7F7F, 0, 0, 0).setEffectRates(4, 2, 0).c(0.0f).c("gasElectric").a(wv.f).d("gases:gas_special");
        GameRegistry.registerBlock((aqw)gasElectric, (String)"gasElectric");
        gasCorrosive = new BlockGasHazard(Gases.a("gasCorrosiveID", 506), 0x1F1FFF, 0, 0, 0, 0.5f).setEffectRates(4, 2, 0).c(0.0f).c("gasCorrosive").a(wv.f).d("gases:gas_special");
        GameRegistry.registerBlock((aqw)gasCorrosive, (String)"gasCorrosive");
        lanternEmptyID = Gases.a("lanternEmptyID", 550);
        lanternEmpty = new BlockLantern(lanternEmptyID, 0, 0, 0, -1).c(0.0f).c("lanternEmpty").a(wv.c).d("gases:lantern_empty");
        GameRegistry.registerBlock((aqw)lanternEmpty, (String)"lanternEmpty");
        lanternTorch = new BlockLantern(Gases.a("lanternTorchID", 551), aqw.av.cF, aqw.av.cF, 0, -1).a(0.625f).c("lanternTorch").d("gases:lantern_torch");
        GameRegistry.registerBlock((aqw)lanternTorch, (String)"lanternTorch");
        lanternGasEmpty = new BlockLantern(Gases.a("lanternGasEmpty", 552), yb.bv.cv, yb.bv.cv, 0, -1).c("lanternGasEmpty").d("gases:lantern_gas0_off");
        GameRegistry.registerBlock((aqw)lanternGasEmpty, (String)"lanternGasEmpty");
        lanternGas = new BlockLantern(Gases.a("lanternGas", 553), Gases.gasBottle.cv, yb.bv.cv, 1, Gases.lanternGasEmpty.cF).a(1.0f).c("lanternGas").d("gases:lantern_gas0_on");
        GameRegistry.registerBlock((aqw)lanternGas, (String)"lanternGas");
        lanternGlowstone = new BlockLantern(Gases.a("lanternGlowstone", 554), yb.aV.cv, yb.aV.cv, 0, -1).a(1.0f).c("lanternGlowstone").d("gases:lantern_glowstone");
        GameRegistry.registerBlock((aqw)lanternGlowstone, (String)"lanternGlowstone");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.initBlocksAndItems();
        generateGreenGas = config.get("world", "generateGreenGas", true).getBoolean(true);
        generateRedGas = config.get("world", "generateRedGas", true).getBoolean(true);
        generateElectricGas = config.get("world", "generateElectricGas", true).getBoolean(true);
        generateCorrosiveGas = config.get("world", "generateCorrosiveGas", true).getBoolean(true);
        maxHardnessForCorrosion = Float.parseFloat(config.get("gases", "maxHardnessForCorrosion", 2.0).getString());
        gasExplosionFactor = Float.parseFloat(config.get("gases", "gasExplosionFactor", 2.5).getString());
        config.save();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new SoundBus());
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        renderBlockGasID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockGasID, (ISimpleBlockRenderingHandler)new RenderBlockGas());
        renderBlockLanternID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockLanternID, (ISimpleBlockRenderingHandler)new RenderBlockLantern());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorGases());
        GameRegistry.addRecipe((yd)new yd(lanternEmpty, 4), (Object[])new Object[]{"I", "G", Character.valueOf('I'), yb.q, Character.valueOf('G'), aqw.R});
        Gases.registerIgnitionBlock(aqw.av.cF);
        Gases.registerIgnitionBlock(aqw.aw.cF);
        Gases.registerReaction(new ReactionIgnition());
        Gases.registerReaction(new ReactionGlowstoneShard(gasElectric, gasCorrosive));
        Gases.registerReaction(new ReactionCorrosion((BlockGas)gasCorrosive));
        Gases.registerLanternRecipe(new yd(aqw.av), Gases.lanternTorch.cF);
        Gases.registerLanternRecipe(new yd(gasBottle), Gases.lanternGas.cF);
        Gases.registerLanternRecipe(new yd(yb.bv), Gases.lanternGasEmpty.cF);
        Gases.registerLanternRecipe(new yd(yb.aV), Gases.lanternGlowstone.cF);
        LanguageRegistry.addName((Object)gasBottle, (String)"Bottle of Gas");
        LanguageRegistry.addName((Object)glowstoneShard, (String)"Glowstone Shard");
        LanguageRegistry.addName((Object)gasSmoke, (String)"Smoke");
        LanguageRegistry.addName((Object)gasSteam, (String)"Steam");
        LanguageRegistry.addName((Object)gasRisingFlammable, (String)"Green Gas");
        LanguageRegistry.addName((Object)gasFallingExplosive, (String)"Red Gas");
        LanguageRegistry.addName((Object)gasVoid, (String)"Void Gas");
        LanguageRegistry.addName((Object)gasElectric, (String)"Electric Gas");
        LanguageRegistry.addName((Object)gasCorrosive, (String)"Corrosive Gas");
        LanguageRegistry.addName((Object)lanternEmpty, (String)"Lantern");
        LanguageRegistry.addName((Object)lanternTorch, (String)"Lantern with Torch");
        LanguageRegistry.addName((Object)lanternGasEmpty, (String)"Empty Gas Lantern");
        LanguageRegistry.addName((Object)lanternGas, (String)"Gas Lantern");
        LanguageRegistry.addName((Object)lanternGlowstone, (String)"Lantern with Glowstone");
        EntityRegistry.registerGlobalEntityID(EntitySmallLightning.class, (String)"smallLightning", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntitySmallLightning.class, (String)"smallLightning", (int)127, (Object)this, (int)20, (int)1, (boolean)false);
        EntityRegistry.registerGlobalEntityID(EntityGlowstoneShard.class, (String)"glowstoneShard", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntityGlowstoneShard.class, (String)"glowstoneShard", (int)126, (Object)this, (int)20, (int)1, (boolean)false);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    private static int a(String name, int def) {
        return config.getBlock(name, def).getInt();
    }

    private static int b(String name, int def) {
        return config.getItem(name, def).getInt();
    }

    public static void registerIgnitionBlock(int blockID) {
        Gases.gasReactives[blockID] = true;
    }

    public static void unregisterIgnitionBlock(int blockID) {
        Gases.gasReactives[blockID] = false;
    }

    public static boolean isIgnitionBlock(int blockID) {
        return gasReactives[blockID];
    }

    public static void registerLanternRecipe(yd placedItem, int lanternBlockID) {
        Gases.lanternRecipes[placedItem.d] = lanternBlockID;
        GameRegistry.addShapelessRecipe((yd)new yd(aqw.s[lanternBlockID]), (Object[])new Object[]{lanternEmpty, placedItem});
    }

    public static int getLanternForID(int id) {
        if (id > lanternRecipes.length) {
            return 0;
        }
        return lanternRecipes[id];
    }

    public static void registerReaction(Reaction reaction) {
        if (!reaction.isErroneous()) {
            reactions.add(reaction);
        }
    }

    public static Reaction getReactionForBlocks(int block1ID, int block2ID) {
        for (Reaction reaction : reactions) {
            if (!reaction.is(block1ID, block2ID)) continue;
            return reaction;
        }
        return new ReactionEmpty();
    }

    static {
        gasMaterial = new ajz(akb.b).i();
        lightningDamageSource = new DamageSourceLightning("lightning");
        gasReactives = new boolean[aqw.s.length];
        lanternRecipes = new int[yb.g.length];
        reactions = new ArrayList();
    }
}

