/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases;

import glenn.gases.Gases;
import glenn.gases.reaction.Reaction;
import glenn.gases.reaction.ReactionEmpty;
import java.util.Random;

public class BlockGas
extends aqw {
    public int color;
    public int opacity;
    public int density;
    public int evaporation;
    public int combustibility;
    public int blindnessRate;
    public int suffocationRate;
    public int slownessRate;
    private static final int[] ringsX = new int[]{1, 0, -1, 0, 1, -1, -1, 1, 2, 0, -2, 0};
    private static final int[] ringsZ = new int[]{0, 1, 0, -1, 1, 1, -1, -1, 0, 2, 0, -2};
    private static final int[] ringX = new int[]{0, 0, -1, 1, 0, 0};
    private static final int[] ringY = new int[]{-1, 1, 0, 0, 0, 0};
    private static final int[] ringZ = new int[]{0, 0, 0, 0, -1, 1};
    private static final int[] movesX = new int[]{1, 0, -1, 0, 1, -1, -1, 1, 1, 0, -1, 0};
    private static final int[] movesZ = new int[]{0, 1, 0, -1, 1, 1, -1, -1, 0, 1, 0, -1};

    public BlockGas(int id, int color, int opacity, int density, int combustibility) {
        super(id, Gases.gasMaterial);
        this.color = color;
        this.opacity = opacity;
        this.density = density;
        this.combustibility = combustibility;
        this.blindnessRate = 0;
        this.suffocationRate = 0;
        this.slownessRate = 0;
        this.b(true);
        this.k(opacity);
        this.C();
        if (combustibility > 0) {
            BlockGas.setBurnProperties((int)id, (int)1000, (int)1000);
        }
    }

    public BlockGas setEvaporation(int evaporation) {
        this.evaporation = evaporation;
        return this;
    }

    public BlockGas setEffectRates(int blindness, int suffocation, int slowness) {
        this.blindnessRate = blindness;
        this.suffocationRate = suffocation;
        this.slownessRate = slowness;
        return this;
    }

    public int c(ace par1IBlockAccess, int par2, int par3, int par4) {
        return this.color;
    }

    public int b(int metadata) {
        return this.color;
    }

    public boolean b() {
        return false;
    }

    public boolean c() {
        return false;
    }

    public boolean a(int par1, boolean par2) {
        return par2 && par1 == 0;
    }

    public boolean a_(ace par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return false;
    }

    public boolean a(ace par1IBlockAccess, int par2, int par3, int par4, int par5) {
        int yDirection;
        int xDirection;
        int n = par5 == 4 ? 1 : (xDirection = par5 == 5 ? -1 : 0);
        int n2 = par5 == 0 ? 1 : (yDirection = par5 == 1 ? -1 : 0);
        int zDirection = par5 == 2 ? 1 : (par5 == 3 ? -1 : 0);
        int metadata = par1IBlockAccess.h(par2, par3, par4);
        int directionBlockID = par1IBlockAccess.a(par2 + xDirection, par3 + yDirection, par4 + zDirection);
        int directionBlockMetadata = par1IBlockAccess.h(par2 + xDirection, par3 + yDirection, par4 + zDirection);
        if (par5 == 1) {
            aqw block = aqw.s[directionBlockID];
            if (block instanceof BlockGas) {
                double maxY = ((BlockGas)block).getMaxY(directionBlockMetadata);
                return maxY - 1.0 != this.getMinY(metadata);
            }
            return true;
        }
        if (par5 == 0) {
            aqw block = aqw.s[directionBlockID];
            if (block instanceof BlockGas) {
                double minY = ((BlockGas)block).getMinY(directionBlockMetadata);
                return minY != this.getMaxY(metadata) - 1.0;
            }
            return true;
        }
        return directionBlockID == this.cF & metadata < directionBlockMetadata | directionBlockID != this.cF;
    }

    public double sideIndent(ace par1IBlockAccess, int par2, int par3, int par4) {
        return par1IBlockAccess.t(par2, par3, par4) ? 0.001 : 0.0;
    }

    public double getMinY(int metadata) {
        if (this.density > 0) {
            return 0.0;
        }
        if (this.density < 0) {
            return (double)metadata / 16.0;
        }
        double d = 0.5 - (double)(16 - metadata) / 8.0;
        return d < 0.0 ? 0.0 : d;
    }

    public double getMaxY(int metadata) {
        if (this.density > 0) {
            return 1.0 - (double)metadata / 16.0;
        }
        if (this.density < 0) {
            return 1.0;
        }
        double d = 0.5 + (double)(16 - metadata) / 8.0;
        return d > 1.0 ? 1.0 : d;
    }

    public asu b(abv par1World, int par2, int par3, int par4) {
        return null;
    }

    public int d() {
        return Gases.renderBlockGasID;
    }

    public int a(int par1, Random par2Random, int par3) {
        return 0;
    }

    public int a(Random par1Random) {
        return 0;
    }

    public int a(abv par1World) {
        return 5;
    }

    public int n() {
        return 1;
    }

    public boolean onFire(abv par1World, int par2, int par3, int par4, Random par5Random) {
        if (this.combustibility == 1) {
            par1World.c(par2, par3, par4, aqw.aw.cF);
            int xDirection = par5Random.nextInt(3) - 1;
            int yDirection = par5Random.nextInt(3) - 1;
            int zDirection = par5Random.nextInt(3) - 1;
            if (par1World.c(par2 + xDirection, par3 + yDirection, par4 + zDirection)) {
                par1World.c(par2 + xDirection, par3 + yDirection, par4 + zDirection, Gases.gasSmoke.cF);
            }
            return true;
        }
        if (this.combustibility == 2) {
            if (!par1World.I) {
                par1World.c(par2, par3, par4, 0);
                par1World.a(null, (double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, Gases.gasExplosionFactor, true);
            }
            return true;
        }
        return false;
    }

    private void mixEqualSortedValues(Random rand, int[] valueList, int[] indexList) {
        int i = 0;
        block0: while (i < valueList.length) {
            int value = valueList[i];
            int j = 1;
            while (j + i <= valueList.length) {
                if (j + i >= valueList.length || valueList[i + j] != value) {
                    int amountOfSwaps = (j - 1) * (j - 1) * 2;
                    for (int k = 0; k < amountOfSwaps; ++k) {
                        int pos2;
                        int pos1 = rand.nextInt(j);
                        if (pos1 == (pos2 = rand.nextInt(j))) continue;
                        int temp = indexList[i + pos1];
                        indexList[i + pos1] = indexList[i + pos2];
                        indexList[i + pos2] = temp;
                    }
                    i += j;
                    continue block0;
                }
                ++j;
            }
        }
    }

    private void fillArrayWithIndices(Random rand, int[] indices, int length, int start, int arrayTranslate) {
        for (int i = 0; i < length; ++i) {
            int index;
            while (indices[index = arrayTranslate + rand.nextInt(length)] != 0) {
            }
            indices[index] = start + i;
        }
    }

    private void reactionsWithSurroundingBlocks(abv world, int x, int y, int z, Reaction[] reactions, int[] reactionIndices, Random random) {
        int[] indices = new int[6];
        this.fillArrayWithIndices(random, indices, 6, 0, 0);
        block0: for (int index = 0; index < reactions.length; ++index) {
            int i = indices[index];
            int xDirection = i < 2 ? i * 2 - 1 : 0;
            int yDirection = i < 4 & i >= 2 ? i * 2 - 5 : 0;
            int zDirection = i >= 4 ? i * 2 - 9 : 0;
            int directionBlockID = world.a(x + xDirection, y + yDirection, z + zDirection);
            Reaction reaction = Gases.getReactionForBlocks(this.cF, directionBlockID);
            for (int j = 0; j < reactions.length; ++j) {
                Reaction reaction2 = reactions[j];
                if (reaction2 == null) {
                    reactions[j] = reaction;
                    reactionIndices[j] = i;
                    continue block0;
                }
                if (reaction2.priority >= reaction.priority) continue;
                for (int k = index - 1; k >= j; --k) {
                    reactions[k + 1] = reactions[k];
                    reactionIndices[k + 1] = reactionIndices[k];
                }
                reactions[j] = reaction;
                reactionIndices[j] = i;
                continue block0;
            }
        }
    }

    private int getDelayForUpdate(abv world, int x, int y, int z) {
        Reaction reaction = new ReactionEmpty();
        for (int i = 0; i < 6; ++i) {
            int xDirection = i < 2 ? i * 2 - 1 : 0;
            int yDirection = i < 4 & i >= 2 ? i * 2 - 5 : 0;
            int zDirection = i >= 4 ? i * 2 - 9 : 0;
            int directionBlockID = world.a(x + xDirection, y + yDirection, z + zDirection);
            Reaction reaction2 = Gases.getReactionForBlocks(this.cF, directionBlockID);
            if (!((Reaction)reaction).isErroneous() && reaction2.priority >= reaction.priority) continue;
            reaction = reaction2;
        }
        int delay = Reaction.getDelay();
        if (delay == -1) {
            delay = this.density > 0 ? (int)(128.0f / (float)this.density) : (this.density < 0 ? (int)(-128.0f / (float)this.density) : 8);
        }
        return delay;
    }

    public void a(abv par1World, int par2, int par3, int par4, Random par5Random) {
        boolean requiresTick;
        Reaction[] reactions = new Reaction[6];
        int[] reactionIndices = new int[6];
        this.reactionsWithSurroundingBlocks(par1World, par2, par3, par4, reactions, reactionIndices, par5Random);
        for (int i = 0; i < reactions.length; ++i) {
            int zDirection;
            int index = reactionIndices[i];
            int xDirection = index < 2 ? index * 2 - 1 : 0;
            int yDirection = index < 4 & index >= 2 ? index * 2 - 5 : 0;
            int n = zDirection = index >= 4 ? index * 2 - 9 : 0;
            if (!reactions[i].reactIfPossible(par1World, par5Random, par2, par3, par4, par2 + xDirection, par3 + yDirection, par4 + zDirection)) continue;
            return;
        }
        int metadata = 16 - par1World.h(par2, par3, par4) - this.getGasDecay(par1World, par2, par3, par4, par5Random);
        boolean bl = requiresTick = this.evaporation > 0;
        if (this.density == 0) {
            int i;
            int[] metadataList = new int[6];
            int[] priorityList = new int[6];
            int surroundingAirBlocks = 0;
            block1: for (i = 0; i < 6; ++i) {
                int xDirection = ringX[i];
                int yDirection = ringY[i];
                int zDirection = ringZ[i];
                int direction2BlockID = par1World.a(par2 + xDirection, par3 + yDirection, par4 + zDirection);
                int direction2BlockMetadata = 16 - par1World.h(par2 + xDirection, par3 + yDirection, par4 + zDirection);
                if (direction2BlockID == 0) {
                    direction2BlockMetadata = -1;
                    ++surroundingAirBlocks;
                } else if (direction2BlockID != this.cF) {
                    direction2BlockMetadata = 17;
                }
                for (int j = 0; j < 6; ++j) {
                    if (metadataList[j] <= direction2BlockMetadata & j != i) continue;
                    for (int k = 4; k >= j; --k) {
                        metadataList[k + 1] = metadataList[k];
                        priorityList[k + 1] = priorityList[k];
                    }
                    metadataList[j] = direction2BlockMetadata;
                    priorityList[j] = i;
                    continue block1;
                }
            }
            this.mixEqualSortedValues(par5Random, metadataList, priorityList);
            i = 0;
            while (i < 6 & metadata > 1) {
                int j = priorityList[i];
                int direction2BlockMetadata = metadataList[i];
                int xDirection = ringX[j];
                int yDirection = ringY[j];
                int zDirection = ringZ[j];
                if (direction2BlockMetadata != 17) {
                    if (direction2BlockMetadata == -1) {
                        par1World.f(par2 + xDirection, par3 + yDirection, par4 + zDirection, this.cF, 15, 3);
                        requiresTick = false;
                        --metadata;
                    } else if (direction2BlockMetadata < 16 & direction2BlockMetadata + 1 < metadata) {
                        par1World.b(par2 + xDirection, par3 + yDirection, par4 + zDirection, 15 - direction2BlockMetadata, 3);
                        requiresTick = false;
                        --metadata;
                    }
                }
                ++i;
            }
            if (metadata > 0) {
                par1World.b(par2, par3, par4, 16 - metadata, 3);
            } else {
                par1World.c(par2, par3, par4, 0);
            }
            if (requiresTick) {
                par1World.a(par2, par3, par4, this.cF, (int)(-128.0f / (float)this.density));
            }
            return;
        }
        int yDirection = this.density > 0 ? -1 : 1;
        int directionBlockID = par1World.a(par2, par3 + yDirection, par4);
        int directionBlockMetadata = 16 - par1World.h(par2, par3 + yDirection, par4);
        int reverseDirectionBlockID = par1World.a(par2, par3 - yDirection, par4);
        int reverseDirectionBlockMetadata = 16 - par1World.h(par2, par3 - yDirection, par4);
        if (directionBlockID == 0) {
            if (metadata > 0) {
                par1World.f(par2, par3 + yDirection, par4, this.cF, 16 - metadata, 3);
            }
            par1World.c(par2, par3, par4, 0);
        } else if (directionBlockID != this.cF && aqw.s[directionBlockID] instanceof BlockGas) {
            int directionBlockDensity;
            if (this.density > 0 & this.density > (directionBlockDensity = ((BlockGas)aqw.s[directionBlockID]).density) | this.density < 0 & this.density < directionBlockDensity) {
                par1World.f(par2, par3, par4, directionBlockID, 16 - directionBlockMetadata, 3);
                par1World.f(par2, par3 + yDirection, par4, this.cF, 16 - metadata, 3);
                return;
            }
        } else {
            if (directionBlockID == this.cF && directionBlockMetadata < 16) {
                if (directionBlockMetadata + metadata < 16) {
                    par1World.c(par2, par3, par4, 0);
                    par1World.b(par2, par3 + yDirection, par4, 16 - directionBlockMetadata - metadata, 3);
                    return;
                }
                par1World.b(par2, par3, par4, 32 - directionBlockMetadata - metadata, 3);
                par1World.b(par2, par3 + yDirection, par4, 0, 3);
                metadata -= 16 - directionBlockMetadata;
            }
            if (reverseDirectionBlockID == this.cF) {
                metadata += reverseDirectionBlockMetadata;
            }
            int[] metadataList = new int[4];
            int[] priorityList = new int[4];
            int surroundingAirBlocks = 0;
            block5: for (int i = 0; i < 4; ++i) {
                int xDirection = ringsX[i];
                int zDirection = ringsZ[i];
                int direction2BlockID = par1World.a(par2 + xDirection, par3, par4 + zDirection);
                int direction2BlockMetadata = 16 - par1World.h(par2 + xDirection, par3, par4 + zDirection);
                if (direction2BlockID == 0) {
                    direction2BlockMetadata = -1;
                    ++surroundingAirBlocks;
                } else if (direction2BlockID != this.cF) {
                    direction2BlockMetadata = 17;
                }
                for (int j = 0; j < 4; ++j) {
                    if (metadataList[j] <= direction2BlockMetadata & j != i) continue;
                    for (int k = 2; k >= j; --k) {
                        metadataList[k + 1] = metadataList[k];
                        priorityList[k + 1] = priorityList[k];
                    }
                    metadataList[j] = direction2BlockMetadata;
                    priorityList[j] = i;
                    continue block5;
                }
            }
            this.mixEqualSortedValues(par5Random, metadataList, priorityList);
            if (metadata < surroundingAirBlocks + 2) {
                int[] indices = new int[ringsX.length];
                this.fillArrayWithIndices(par5Random, indices, 4, 0, 0);
                this.fillArrayWithIndices(par5Random, indices, 4, 4, 4);
                this.fillArrayWithIndices(par5Random, indices, 4, 8, 8);
                for (int index = 0; index < indices.length; ++index) {
                    int direction3BlockID;
                    int i = indices[index];
                    int x = par2 + ringsX[i];
                    int z = par4 + ringsZ[i];
                    int direction2BlockID = par1World.a(x, par3, z);
                    if (direction2BlockID != 0 || (direction3BlockID = par1World.a(x, par3 + yDirection, z)) != 0 && (direction3BlockID != this.cF || metadata - par1World.h(x, par3 + yDirection, z) > 0) || (i >= 8 ? par1World.a(par2 + movesX[i], par3, par4 + movesZ[i]) != 0 : i >= 4 && par1World.a(par2 + movesX[i], par3, par4) != 0 && par1World.a(par2, par3, par4 + movesZ[i]) != 0)) continue;
                    par1World.c(par2, par3, par4, 0);
                    if (metadata > 0) {
                        par1World.f(par2 + movesX[i], par3, par4 + movesZ[i], this.cF, 16 - metadata, 3);
                    }
                    return;
                }
            }
            int i = 0;
            while (i < 4 & metadata > 1) {
                int j = priorityList[i];
                int direction2BlockMetadata = metadataList[i];
                int xDirection = ringsX[j];
                int zDirection = ringsZ[j];
                if (direction2BlockMetadata != 17) {
                    if (direction2BlockMetadata == -1) {
                        par1World.f(par2 + xDirection, par3, par4 + zDirection, this.cF, 15, 3);
                        requiresTick = false;
                        --metadata;
                    } else if (direction2BlockMetadata < 16 & direction2BlockMetadata + 1 < metadata) {
                        par1World.b(par2 + xDirection, par3, par4 + zDirection, 15 - direction2BlockMetadata, 3);
                        requiresTick = false;
                        --metadata;
                    }
                }
                ++i;
            }
            if (metadata > 16) {
                par1World.b(par2, par3, par4, 0, 3);
                if (reverseDirectionBlockID == this.cF) {
                    par1World.b(par2, par3 - yDirection, par4, 32 - metadata, 3);
                }
            } else {
                if (reverseDirectionBlockID == this.cF) {
                    par1World.c(par2, par3 - yDirection, par4, 0);
                }
                if (metadata > 0) {
                    par1World.b(par2, par3, par4, 16 - metadata, 3);
                } else {
                    par1World.c(par2, par3, par4, 0);
                }
            }
        }
        if (requiresTick) {
            par1World.a(par2, par3, par4, this.cF, (int)(-128.0f / (float)this.density));
        }
    }

    protected int getGasDecay(abv par1World, int par2, int par3, int par4, Random par5Random) {
        return this.evaporation > 0 && par5Random.nextInt(this.evaporation) == 0 ? 1 : 0;
    }

    public void a(abv par1World, int par2, int par3, int par4) {
        par1World.a(par2, par3, par4, this.cF, this.getDelayForUpdate(par1World, par2, par3, par4));
    }

    public void a(abv par1World, int par2, int par3, int par4, int par5) {
        this.a(par1World, par2, par3, par4);
    }

    public void a(abv par1World, int par2, int par3, int par4, abq par5Explosion) {
        this.onFire(par1World, par2, par3, par4, par1World.s);
    }

    public boolean l() {
        return false;
    }

    public yd getBottledItem() {
        return new yd(Gases.gasBottle);
    }

    public boolean canCombustNormally() {
        return this.combustibility > 0;
    }
}

