/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.textformatting.asm;

import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscatedClassName;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscatedMethod;
import com.spacechase0.minecraft.textformatting.TextFormattingLog;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class GuiOpeningTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.client.entity.EntityPlayerSP")) {
            TextFormattingLog.info("Text Formatting using ASM to make sure our GUI is used...");
            bytes = this.transformClass(name, transformedName, bytes);
        }
        return bytes;
    }

    private byte[] transformClass(String obfName, String name, byte[] bytes) {
        TextFormattingLog.info("Using class " + name);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            this.transformMethod(obfName, method);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void transformMethod(String obfClassName, MethodNode method) {
        int i = 0;
        while (i < method.instructions.size()) {
            TypeInsnNode node;
            AbstractInsnNode ins = method.instructions.get(i);
            if (ins.getOpcode() == 187) {
                node = (TypeInsnNode)ins;
                ObfuscatedClassName type = new ObfuscatedClassName(node.desc);
                if (type.deobfName.equals("net/minecraft/client/gui/inventory/GuiEditSign")) {
                    TextFormattingLog.info("Found vanilla sign GUI class, changing to ours...");
                    node.desc = "com/spacechase0/minecraft/textformatting/gui/SignGui";
                } else if (type.deobfName.equals("net/minecraft/client/gui/GuiCommandBlock")) {
                    TextFormattingLog.info("Found vanilla command block GUI class, changing to ours...");
                    node.desc = "com/spacechase0/minecraft/textformatting/gui/CommandBlockGui";
                } else if (type.deobfName.equals("net/minecraft/client/gui/GuiScreenBook")) {
                    TextFormattingLog.info("Found vanilla book GUI class, changing to ours...");
                    node.desc = "com/spacechase0/minecraft/textformatting/gui/BookGui";
                }
            } else if (ins.getOpcode() == 183) {
                node = (MethodInsnNode)ins;
                ObfuscatedMethod meth = new ObfuscatedMethod(node.owner, node.name, node.desc);
                if (meth.deobfType.equals("net/minecraft/client/gui/inventory/GuiEditSign")) {
                    TextFormattingLog.info("Found vanilla sign GUI <init>, changing to ours...");
                    node.owner = "com/spacechase0/minecraft/textformatting/gui/SignGui";
                } else if (meth.deobfType.equals("net/minecraft/client/gui/GuiCommandBlock")) {
                    TextFormattingLog.info("Found vanilla command block GUI <init>, changing to ours...");
                    node.owner = "com/spacechase0/minecraft/textformatting/gui/CommandBlockGui";
                } else if (meth.deobfType.equals("net/minecraft/client/gui/GuiScreenBook")) {
                    TextFormattingLog.info("Found vanilla book GUI <init>, changing to ours...");
                    node.owner = "com/spacechase0/minecraft/textformatting/gui/BookGui";
                }
            }
            ++i;
        }
    }
}

