/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.textformatting.asm;

import com.spacechase0.minecraft.textformatting.TextFormattingLog;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class BookGuiTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.client.gui.GuiScreenBook")) {
            TextFormattingLog.info("Text Formatting using ASM to remove the 50-page book limit...");
            bytes = this.transformClass(transformedName, bytes);
        }
        return bytes;
    }

    private byte[] transformClass(String name, byte[] bytes) {
        TextFormattingLog.info("Using class " + name);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            this.transformMethod(method);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void transformMethod(MethodNode method) {
        int i = 0;
        while (i < method.instructions.size()) {
            AbstractInsnNode ins = method.instructions.get(i);
            if (ins.getOpcode() == 16) {
                IntInsnNode node = (IntInsnNode)ins;
                if (node.operand == 50) {
                    TextFormattingLog.info("Found value 50, assuming it to be the page limit.");
                    node.setOpcode(17);
                    node.operand = Short.MAX_VALUE;
                }
            }
            ++i;
        }
    }
}

