/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.textformatting.asm;

import com.spacechase0.minecraft.textformatting.TextFormattingLog;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class AllowedCharactersTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.util.ChatAllowedCharacters")) {
            TextFormattingLog.info("Text Formatting using ASM to allow the format symbol...");
            bytes = this.transformClass(transformedName, bytes);
        }
        return bytes;
    }

    private byte[] transformClass(String name, byte[] bytes) {
        TextFormattingLog.info("Using class " + name);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            this.transformMethod(method);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void transformMethod(MethodNode method) {
        MethodInsnNode node;
        AbstractInsnNode ins;
        boolean foundClose = false;
        int i = 0;
        while (i < method.instructions.size()) {
            ins = method.instructions.get(i);
            if (ins.getOpcode() == 182) {
                node = (MethodInsnNode)ins;
                if (node.owner.equals("java/io/BufferedReader") && node.name.equals("close")) {
                    foundClose = true;
                }
            } else if (ins.getOpcode() == 25 && foundClose) {
                node = (VarInsnNode)ins;
                if (node.var == 0) {
                    this.injectFormatSymbol(method, i);
                    foundClose = false;
                }
            }
            ++i;
        }
        i = 0;
        while (i < method.instructions.size()) {
            ins = method.instructions.get(i);
            if (ins.getOpcode() == 17) {
                node = (IntInsnNode)ins;
                if (node.operand == 167) {
                    TextFormattingLog.info("Found value 167, assuming it to be the formatting symbol.");
                    node.operand = 0;
                }
            }
            ++i;
        }
    }

    private void injectFormatSymbol(MethodNode method, int index) {
        TextFormattingLog.info("Injecting at index " + index);
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new TypeInsnNode(187, "java/lang/StringBuilder"));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)"Adding format symbol to allowed characters list..."));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "com/spacechase0/minecraft/textformatting/TextFormattingLog", "info", "(Ljava/lang/String;)V"));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V"));
        list.add((AbstractInsnNode)new FieldInsnNode(178, "com/spacechase0/minecraft/textformatting/ColorData", "formatSymbol", "Ljava/lang/String;"));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;"));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;"));
        list.add((AbstractInsnNode)new VarInsnNode(58, 0));
        method.instructions.insertBefore(method.instructions.get(index), list);
    }
}

