/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.textformatting;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public class ColorData {
    public static int[] colors;
    public static char[] colorCodes;
    public static String[] formats;
    public static char[] formatCodes;
    public static int posX;
    public static int posY;
    public static int buttonWidth;
    public static int buttonHeight;
    public static int padding;
    public static String formatButtonStr;
    public static int formatButtonId;
    public static String formatSymbol;

    public static char getClickedCode(int x, int y, int width) {
        int loopY = posY;
        int colorLoop = 0;
        while (colorLoop < 16) {
            int px;
            if (x >= posX && y >= loopY && x < posX + buttonWidth && y < loopY + buttonHeight) {
                return colorCodes[colorLoop];
            }
            if (colorLoop < 6 && x >= (px = width - buttonWidth - padding) && y >= loopY && x < px + buttonWidth && y < loopY + buttonHeight) {
                return formatCodes[colorLoop];
            }
            ++colorLoop;
            loopY += buttonHeight + padding;
        }
        return 'z';
    }

    public static void calculateColorHeight(int height) {
        buttonHeight = height - posY * 2;
        buttonHeight -= 15 * padding;
        buttonHeight /= 16;
    }

    public static String getLengthStr(int length, int max, int col) {
        String str = formatSymbol;
        str = str + colorCodes[col];
        str = str + "(";
        str = str + length;
        str = str + "/" + max + ")";
        return str;
    }

    public static void drawGui(GuiScreen gui, FontRenderer fontRenderer) {
        int loopY = posY;
        int colorLoop = 0;
        while (colorLoop < 16) {
            GuiScreen.func_73734_a((int)posX, (int)loopY, (int)(posX + buttonWidth), (int)(loopY + buttonHeight), (int)colors[colorLoop]);
            if (colorLoop < 6) {
                int x = gui.field_73880_f - buttonWidth - padding;
                String str = formatSymbol;
                str = str + formatCodes[colorLoop];
                str = str + formats[colorLoop];
                GuiScreen.func_73734_a((int)x, (int)loopY, (int)(x + buttonWidth), (int)(loopY + buttonHeight), (int)colors[15]);
                fontRenderer.func_78276_b(str, x + (buttonWidth - fontRenderer.func_78256_a(formats[colorLoop])) / 2, loopY + (buttonHeight - 8) / 2, 0);
            }
            ++colorLoop;
            loopY += buttonHeight + padding;
        }
    }

    static {
        posX = 5;
        posY = 5;
        buttonWidth = 50;
        buttonHeight = 20;
        padding = 3;
        formatButtonStr = "Insert Format Symbol";
        formatButtonId = 10;
        formatSymbol = new String(new char[]{'\u00a7'});
        colors = new int[16];
        ColorData.colors[0] = -16777216;
        ColorData.colors[1] = -16777025;
        ColorData.colors[2] = -16728320;
        ColorData.colors[3] = -16728129;
        ColorData.colors[4] = -4259840;
        ColorData.colors[5] = -4259649;
        ColorData.colors[6] = -22016;
        ColorData.colors[7] = -4210753;
        ColorData.colors[8] = -12566464;
        ColorData.colors[9] = -12566273;
        ColorData.colors[10] = -11927744;
        ColorData.colors[11] = -12517377;
        ColorData.colors[12] = -49088;
        ColorData.colors[13] = -48897;
        ColorData.colors[14] = -192;
        ColorData.colors[15] = -1;
        colorCodes = new char[16];
        for (int i = 0; i < 16; ++i) {
            ColorData.colorCodes[i] = i < 10 ? (char)(48 + i) : (char)(97 + (i - 10));
        }
        formats = new String[6];
        ColorData.formats[0] = "Random";
        ColorData.formats[1] = "Bold";
        ColorData.formats[2] = "Strike";
        ColorData.formats[3] = "Underline";
        ColorData.formats[4] = "Italics";
        ColorData.formats[5] = "Reset";
        formatCodes = new char[6];
        ColorData.formatCodes[0] = 107;
        ColorData.formatCodes[1] = 108;
        ColorData.formatCodes[2] = 109;
        ColorData.formatCodes[3] = 110;
        ColorData.formatCodes[4] = 111;
        ColorData.formatCodes[5] = 114;
        posX = 5;
        posY = 5;
        buttonWidth = 50;
        buttonHeight = 20;
        padding = 3;
        formatButtonStr = "Insert Format Symbol";
        formatButtonId = 10;
    }
}

