package Kabo.ShowMonsters.common;

import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;

/**
 * @author KaboPC
 * @version v0.3.3.162
 */
@Mod(modid="Kabo_ShowMonsters", name = "ShowMonsters", version ="v3.3.162")
@NetworkMod(clientSideRequired = false, serverSideRequired = false, 
		channels={"KaboShowMonTN","KaboShowMonTC","KaboShowMonMD"}, packetHandler=ShowMonstersPacketHandler.class)
public class ShowMonsters 
{
	@Instance("Kabo_ShowMonsters")
	public static ShowMonsters instance;
	
	private long tickTime;

	@SidedProxy(clientSide="Kabo.ShowMonsters.common.ShowMonstersClientProxy", serverSide="Kabo.ShowMonsters.common.ShowMonstersCommonProxy")
	public static ShowMonstersCommonProxy proxy;
	
	public static Boolean configCreativeOnly;
	public static int configServerTickTime;
	
	@PreInit
	public void preInit(FMLPreInitializationEvent event)
	{
		Configuration config = new Configuration(event.getSuggestedConfigurationFile());
		config.load();
		configCreativeOnly = config.get(Configuration.CATEGORY_GENERAL,  "serverOption_CreativeOnly", false).getBoolean(false);
		configServerTickTime = config.get(Configuration.CATEGORY_GENERAL, "serverOption_TickTime", 250).getInt(250);
		config.save();
	}
	
	@Init
	public void load(FMLInitializationEvent event)
	{
        MinecraftForge.EVENT_BUS.register(proxy);
        TickRegistry.registerTickHandler(new ShowMonstersTickHandler(), Side.SERVER);
        proxy.clientBindHotkeys();
	}
	
	public void tick()
	{
		tickTime = System.currentTimeMillis();
		
		if(proxy instanceof ShowMonstersClientProxy){}
		else
		{
			proxy.onTickUpdatePositionsAndSendData(tickTime);
		}
	}
	
}
