package Kabo.ShowMonsters.common;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

/**
 * Choose a method by assigning methodToUse
 * <br>Override the method in your class and return a result 0, 1, or 2;
 * <br>0 = Cannot Spawn; 
 * <br>1 = Can Spawn; 
 * <br>2 = Not Sure
 */
public interface IShowMonstersCheck 
{
	/**
	 * Set up your interface to return an int 0 or 1 for the method to use; (i.e. whether you need the player or not)
	 * @return an int 0 or 1
	 */
	public int getMethodToUse();
	
	/**
	 * methodToUse = 0;
	 * Takes the world and block position x, y, and z
	 * @param theWorld 
	 * @return an int 0, 1, or 2 representing whether the mob can spawn, cannot spawn, or is uncertain, respectively
	 */
	public int performCheckAtPosition(World theWorld, int x,int y,int z);
	
	
	/**
	 * methodToUse = 1;
	 * Takes the player, world, and block position x, y, and z
	 * @param theWorld 
	 * @return an int 0, 1, or 2 representing whether the mob can spawn, cannot spawn, or is uncertain, respectively
	 */
	public int performCheckAtPositionWithPlayer(EntityPlayer player, World theWorld, int x,int y,int z);

	/**
	 * Return true if you want the bounding box checked to be performed by the ShowMonsters proxy 
	 */
	public boolean shouldCheckBB();
}
