/*
 * Decompiled with CFR 0.152.
 */
package sanandreasp.core.manpack.transformer;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.common.asm.transformers.deobf.LZMAInputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import sanandreasp.core.manpack.transformer.InstructionComparator;

public class ASMHelper {
    private static Map<String, Map<String, String>> methods = Maps.newHashMap();
    private static Map<String, Map<String, String>> fields = Maps.newHashMap();
    public static boolean isMCP = false;

    public static void setup(File mcDir, LaunchClassLoader classLoader, String deobfFileName) {
        try {
            InputStream classData = ASMHelper.class.getResourceAsStream(deobfFileName);
            LZMAInputSupplier zis = new LZMAInputSupplier(classData);
            InputSupplier srgSupplier = CharStreams.newReaderSupplier((InputSupplier)zis, (Charset)Charsets.UTF_8);
            List srgList = CharStreams.readLines((InputSupplier)srgSupplier);
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            ImmutableBiMap.Builder mcpBuilder = ImmutableBiMap.builder();
            Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)": ")).omitEmptyStrings().trimResults();
            for (String line : srgList) {
                String[] parts = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)line), String.class);
                String typ = parts[0];
                if ("MD".equals(typ)) {
                    ASMHelper.parseMethod(parts);
                    continue;
                }
                if (!"FD".equals(typ)) continue;
                ASMHelper.parseField(parts);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void parseMethod(String[] parts) {
        String oldSrg = parts[1];
        int lastOld = oldSrg.lastIndexOf(47);
        String cl = oldSrg.substring(0, lastOld);
        String oldName = oldSrg.substring(lastOld + 1);
        String sig = parts[2];
        String newSrg = parts[3];
        int lastNew = newSrg.lastIndexOf(47);
        String newName = newSrg.substring(lastNew + 1);
        if (!methods.containsKey(cl)) {
            methods.put(cl, Maps.newHashMap());
        }
        methods.get(cl).put(newName, oldName);
    }

    private static void parseField(String[] parts) {
        String oldSrg = parts[1];
        int lastOld = oldSrg.lastIndexOf(47);
        String cl = oldSrg.substring(0, lastOld);
        String oldName = oldSrg.substring(lastOld + 1);
        String newSrg = parts[2];
        int lastNew = newSrg.lastIndexOf(47);
        String newName = newSrg.substring(lastNew + 1);
        if (!fields.containsKey(cl)) {
            fields.put(cl, Maps.newHashMap());
        }
        fields.get(cl).put(newName, oldName);
    }

    public static ClassNode createClassNode(byte[] bytes) {
        ClassNode cnode = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)cnode, 8);
        return cnode;
    }

    public static byte[] createBytes(ClassNode cnode, int i) {
        ClassWriter cw = new ClassWriter(i);
        cnode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public static MethodNode findMethod(String name, String desc, ClassNode cnode) {
        for (MethodNode mnode : cnode.methods) {
            if (!name.equals(mnode.name) || !desc.equals(mnode.desc)) continue;
            return mnode;
        }
        return null;
    }

    public static String getNotchedMethod(String MCP, String SRG) {
        if (isMCP) {
            return MCP;
        }
        String clazz = ASMHelper.getNotchedClassName(SRG.substring(0, SRG.lastIndexOf(47)));
        SRG = SRG.substring(SRG.lastIndexOf(47) + 1);
        if (methods.containsKey(clazz) && methods.get(clazz).containsKey(SRG)) {
            return methods.get(clazz).get(SRG);
        }
        return SRG;
    }

    public static String getNotchedField(String MCP, String SRG) {
        if (isMCP) {
            return MCP;
        }
        String clazz = ASMHelper.getNotchedClassName(SRG.substring(0, SRG.lastIndexOf(47)));
        SRG = SRG.substring(SRG.lastIndexOf(47) + 1);
        if (fields.containsKey(clazz) && fields.get(clazz).containsKey(SRG)) {
            return fields.get(clazz).get(SRG);
        }
        return SRG;
    }

    public static String getRemappedMF(String MCP, String SRG) {
        if (isMCP) {
            return MCP;
        }
        return SRG;
    }

    public static String getNotchedClassName(String SRG) {
        return FMLDeobfuscatingRemapper.INSTANCE.unmap(SRG);
    }

    public static AbstractInsnNode findLastNodeFromNeedle(InsnList haystack, InsnList needle) {
        List<AbstractInsnNode> ret = InstructionComparator.insnListFindEnd(haystack, needle);
        if (ret.size() < 1) {
            throw new RuntimeException("Needle not found in Haystack!");
        }
        if (ret.size() > 1) {
            throw new RuntimeException("Multiple Needles found in Haystack!");
        }
        return ret.get(0);
    }

    public static void remLastNodeFromNeedle(InsnList haystack, InsnList needle) {
        haystack.remove(ASMHelper.findLastNodeFromNeedle(haystack, needle));
    }
}

