/*
 * Decompiled with CFR 0.152.
 */
package sanandreasp.core.manpack.managers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;

public class UnicodeInputStreamReader
extends Reader {
    private final InputStreamReader input;
    private final String defaultEnc;

    public UnicodeInputStreamReader(InputStream source, String encoding) throws IOException {
        this.defaultEnc = encoding;
        String enc = encoding;
        byte[] data = new byte[4];
        PushbackInputStream pbStream = new PushbackInputStream(source, data.length);
        int read = pbStream.read(data, 0, data.length);
        int size = 0;
        int bom16 = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        int bom24 = bom16 << 8 | data[2] & 0xFF;
        int bom32 = bom24 << 8 | data[3] & 0xFF;
        if (bom24 == 0xEFBBBF) {
            enc = "UTF-8";
            size = 3;
        } else if (bom16 == 65279) {
            enc = "UTF-16BE";
            size = 2;
        } else if (bom16 == 65534) {
            enc = "UTF-16LE";
            size = 2;
        } else if (bom32 == 65279) {
            enc = "UTF-32BE";
            size = 4;
        } else if (bom32 == -131072) {
            enc = "UTF-32LE";
            size = 4;
        }
        if (size < read) {
            pbStream.unread(data, size, read - size);
        }
        this.input = new InputStreamReader((InputStream)pbStream, enc);
    }

    public String getEncoding() {
        return this.input.getEncoding();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.input.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

