/*
 * Decompiled with CFR 0.152.
 */
package sanandreasp.core.manpack.managers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;

public class SAPUpdateManager {
    private boolean checkedForUpdate = false;
    private int majNmbr;
    private int minNmbr;
    private int revNmbr;
    private String updateURL;
    private String modName;
    private String modURL;
    public static List<SAPUpdateManager> updMgrs = new ArrayList<SAPUpdateManager>();

    public SAPUpdateManager(String md, int mj, int mn, int rev, String updURL, String mdURL) {
        this.modName = md;
        this.majNmbr = mj;
        this.minNmbr = mn;
        this.revNmbr = rev;
        this.updateURL = updURL;
        this.modURL = mdURL;
        updMgrs.add(this);
    }

    public String getFormattedVersion() {
        Formatter form = new Formatter();
        String ver = form.format("%1$d.%2$02d_%3$02d", this.majNmbr, this.minNmbr, this.revNmbr).toString();
        form.close();
        return ver;
    }

    private void addMessage(String s, Level level) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            Minecraft.func_71410_x().field_71439_g.func_71035_c(s);
        }
        FMLLog.log((String)"SAP-UpdateManager", (Level)level, (String)s.replaceAll("\u00a7.", ""), (Object[])new Object[0]);
    }

    private void check() {
        final String mName = this.modName;
        final String mUrl = this.modURL;
        final String udUrl = this.updateURL;
        final int maj = this.majNmbr;
        final int min = this.minNmbr;
        final int rev = this.revNmbr;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FMLLog.log((String)"SAP-UpdateManager", (Level)Level.INFO, (String)"Checking for %s Update", (Object[])new Object[]{mName});
                    URL url = new URL(udUrl);
                    BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                    String str = in.readLine();
                    in.close();
                    if (str == null || str.length() < 1) {
                        return;
                    }
                    Pattern pattern = Pattern.compile("major:(\\d+);minor:(\\d+);revision:(\\d+)");
                    Matcher matches = pattern.matcher(str);
                    int[] webVer = new int[]{0, 0, 0};
                    if (matches.find()) {
                        webVer[0] = Integer.valueOf(matches.group(1));
                        webVer[1] = Integer.valueOf(matches.group(2));
                        webVer[2] = Integer.valueOf(matches.group(3));
                    }
                    Formatter form = new Formatter();
                    String newVer = form.format("%1$d.%2$02d_%3$02d", webVer[0], webVer[1], webVer[2]).toString();
                    form.close();
                    if (webVer[0] > maj) {
                        SAPUpdateManager.this.addMessage(String.format("\u00a7cNew major update (%s) for \u00a76%s \u00a7cis out:", newVer, SAPUpdateManager.this.modName), Level.WARNING);
                        SAPUpdateManager.this.addMessage("\u00a7c" + mUrl, Level.WARNING);
                    } else if (webVer[0] == maj && webVer[1] > min) {
                        SAPUpdateManager.this.addMessage(String.format("\u00a7eNew feature update (%s) for \u00a76%s \u00a7eis out:", newVer, SAPUpdateManager.this.modName), Level.INFO);
                        SAPUpdateManager.this.addMessage("\u00a7e" + mUrl, Level.INFO);
                    } else if (webVer[0] == maj && webVer[1] == min && webVer[2] > rev) {
                        SAPUpdateManager.this.addMessage(String.format("\u00a7bNew bugfix update (%s) for \u00a76%s \u00a7bis out:", newVer, SAPUpdateManager.this.modName), Level.INFO);
                        SAPUpdateManager.this.addMessage("\u00a7b" + mUrl, Level.INFO);
                    } else {
                        FMLLog.log((String)"SAP-UpdateManager", (Level)Level.INFO, (String)"No new update for %s available. Everything is fine.", (Object[])new Object[]{mName});
                    }
                }
                catch (MalformedURLException e) {
                    FMLLog.log((String)"SAP-UpdateManager", (Level)Level.WARNING, (String)"Update Check for %s failed - Malformed URL: >>%s<<", (Object[])new Object[]{mName, udUrl});
                }
                catch (IOException e) {
                    FMLLog.log((String)"SAP-UpdateManager", (Level)Level.WARNING, (String)"Update Check for %s failed - Not accessible: >>%s<<", (Object[])new Object[]{mName, udUrl});
                }
            }
        }).start();
    }

    public void checkForUpdate() {
        if (!this.checkedForUpdate) {
            this.check();
            this.checkedForUpdate = true;
        }
    }
}

