/*
 * Decompiled with CFR 0.152.
 */
package sanandreasp.core.manpack.managers;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import sanandreasp.core.manpack.helpers.CommonUsedStuff;
import sanandreasp.core.manpack.managers.UnicodeInputStreamReader;

public class SAPLanguageManager {
    private HashMap<String, File> langFiles = Maps.newHashMap();
    private File path;
    private String version;
    private String modname;
    private List<String> localizations = new ArrayList<String>();

    public SAPLanguageManager(String par1Path, String par2LangVer, String par3Mod) {
        try {
            String cfgpath = "config/langs" + par1Path;
            this.path = CommonUsedStuff.getMCDir(cfgpath);
            if (!this.path.exists()) {
                this.path.mkdirs();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.version = par2LangVer;
        this.modname = par3Mod;
        File[] files = this.path.listFiles(new LangFileFilter());
        if (files == null) {
            return;
        }
        for (File langFile : files) {
            String lang = langFile.getName().replaceAll(".(txt|lang|SAPlang)", "");
            this.langFiles.put(lang, langFile);
        }
    }

    public void addLangPropS(String property, String defName) {
        LanguageRegistry.instance().addStringLocalization(property, "en_US", defName);
        this.localizations.add(property);
    }

    public void loadLangs() {
        String[] langs;
        for (String cLang : langs = this.langFiles.keySet().toArray(new String[this.langFiles.size()])) {
            File cFile = this.langFiles.get(cLang);
            if (!cFile.canRead() || this.localizations.isEmpty()) continue;
            try {
                FileInputStream fis = new FileInputStream(cFile);
                UnicodeInputStreamReader input = new UnicodeInputStreamReader(fis, "UTF-8");
                BufferedReader in = new BufferedReader(input);
                do {
                    Matcher matcher;
                    String s;
                    if ((s = in.readLine()) == null || s.isEmpty() || !s.matches("[ ]{0,}.*?[ ]{0,}=[ ]{0,}.*") || !(matcher = Pattern.compile("[ ]{0,}(.*?)[ ]{0,}=[ ]{0,}(.*)").matcher(s)).find()) continue;
                    String prop = matcher.group(1);
                    String value = matcher.group(2);
                    if (!this.localizations.contains(prop)) continue;
                    LanguageRegistry.instance().addStringLocalization(prop, cLang, value);
                } while (in.ready());
                in.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.writeDefaultLFile();
    }

    private void writeDefaultLFile() {
        try {
            FileOutputStream defLangFile = new FileOutputStream(new File(this.path, "DEF_LANG.txt"));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)defLangFile, Charset.forName("UTF-8").newEncoder()));
            out.write(65279);
            String title = String.format(" %s Language File example, made by SanAndreasPs Language Manager", this.modname);
            String line = "";
            for (int i = 0; i < title.length() + 1; ++i) {
                line = line + "-";
            }
            out.write(line + "\n");
            out.write(title + "\n");
            out.write(line + "\n");
            out.write("// This is an example of the language file for the default language set by the\n// mod (english (US)) which is used as default in all Minecraft languages.\n");
            out.write("// To make your own translation based on an other language (for example spanish)\n// copy this file, rename it into the language localization you want\n");
            out.write("// (for example \"es_ES.txt\") and change the values after the 'equal'-sign (=) to\n// anything you seem it's fitting.\n");
            out.write("// Supported file extensions for the language files are '.txt',\n");
            out.write("// '.lang' and '.SAPlang'.\n// A list of all available language localizations supported by Minecraft can be found here:\n// https://dl.dropbox.com/u/56920617/languages.txt\n");
            out.write("// WARNING: This file cannot be used as language file, because it'll be overridden!\n");
            out.write("// NOTE: The %s in the localization values are variables! Keep them and place this variable somewhere you see it's fitting\n\n");
            for (String prop : this.localizations) {
                if (prop.isEmpty()) continue;
                String value = SAPLanguageManager.getTranslated(prop, "en_US");
                out.write(String.format("%s = %s\n", prop, value));
            }
            out.close();
            defLangFile.close();
        }
        catch (IOException e) {
            FMLLog.log((String)"SAP-LanguageManager", (Level)Level.WARNING, (String)"An error occured during creating %s default lang file!", (Object[])new Object[]{this.modname});
            e.printStackTrace();
        }
    }

    public void addLangProp(Object obj, String defName) {
        String objectName;
        if (obj == null) {
            throw new IllegalArgumentException(String.format("[SAP-LanguageManager] Illegal object for naming %s", obj));
        }
        if (obj instanceof String) {
            this.addLangPropS((String)obj, defName);
            return;
        }
        if (obj instanceof Item) {
            objectName = ((Item)obj).func_77658_a();
        } else if (obj instanceof Block) {
            objectName = ((Block)obj).func_71917_a();
        } else if (obj instanceof ItemStack) {
            objectName = ((ItemStack)obj).func_77973_b().func_77667_c((ItemStack)obj);
        } else if (obj instanceof Class && Entity.class.isAssignableFrom((Class)obj)) {
            objectName = "entity." + (String)EntityList.field_75626_c.get((Class)obj);
        } else {
            throw new IllegalArgumentException(String.format("[SAP-LanguageManager] Illegal object for naming %s", obj));
        }
        objectName = objectName + ".name";
        this.addLangPropS(objectName, defName);
    }

    public static String getTranslatedEn(String key) {
        return LanguageRegistry.instance().getStringLocalization(key, "en_US");
    }

    public static String getTranslated(String key) {
        return StatCollector.func_74838_a((String)key);
    }

    public static String getTranslated(String key, String lang) {
        return LanguageRegistry.instance().getStringLocalization(key, lang);
    }

    public static class LangFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".txt") || name.endsWith(".SAPlang") || name.endsWith(".lang");
        }
    }
}

