/*
 * Decompiled with CFR 0.152.
 */
package sanandreasp.core.manpack.managers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import sanandreasp.core.manpack.helpers.CommonUsedStuff;
import sanandreasp.core.manpack.managers.UnicodeInputStreamReader;

public class SAPConfigManager {
    private static boolean[] registeredItems = new boolean[Item.field_77698_e.length];
    private static boolean[] registeredBlocks = new boolean[Block.field_71973_m.length];
    private static boolean[] preRegisteredItems = new boolean[Item.field_77698_e.length];
    private static boolean[] preRegisteredBlocks = new boolean[Block.field_71973_m.length];
    private Map<String, SAPGroup> groups = new HashMap<String, SAPGroup>();
    private File configFile;
    private String modName;
    private final Class<?>[] ARRAY_PRIMITIVE_TYPES = new Class[]{int[].class, float[].class, double[].class, boolean[].class, byte[].class, short[].class, long[].class, char[].class};

    public SAPConfigManager(String par1ModName, String par2Path) {
        this.initConfigManager(par1ModName, par2Path, par1ModName + ".txt");
    }

    public SAPConfigManager(String par1ModName, String par2ConfigName, String par3Path) {
        this.initConfigManager(par1ModName, par3Path, par2ConfigName);
    }

    private void initConfigManager(String par1ModName, String par2Path, String par3FileName) {
        this.addGroup("Block IDs");
        this.addGroup("Item IDs");
        this.addGroup("Achievement IDs");
        this.addGroup("Enchantment IDs");
        this.modName = par1ModName;
        this.configFile = CommonUsedStuff.getMCDir("/config" + par2Path);
        this.configFile.mkdirs();
        this.configFile = new File(this.configFile, par3FileName);
        if (!(this.configFile.canRead() && this.configFile.canWrite() || !this.configFile.exists())) {
            throw new RuntimeException(String.format("[SAP-ConfigMan] Can't read or write File for %s!", this.modName));
        }
    }

    public void addGroup(String par1Name) {
        if (this.groups.containsKey(par1Name)) {
            FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Group %s already exists for %s! Skipping.", (Object[])new Object[]{par1Name, this.modName});
        } else {
            this.groups.put(par1Name, new SAPGroup(par1Name));
        }
    }

    public void addProperty(String par1PropName, String par2GroupName, Object par3Value) {
        if (!this.groups.containsKey(par2GroupName)) {
            FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Group %s cannot be found for %s!", (Object[])new Object[]{par2GroupName, this.modName});
            return;
        }
        this.groups.get(par2GroupName).addProp(par1PropName, par3Value);
    }

    public void addProperties(String[] par1PropNames, String par2GroupName, Object par3Values) {
        this.addProperties(par1PropNames, par2GroupName, this.getArray(par3Values));
    }

    public void addProperties(String[] par1PropNames, String par2GroupName, Object[] par3Values) {
        if (par3Values == null) {
            FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Values array is null in %s for %s!", (Object[])new Object[]{par2GroupName, this.modName});
            return;
        }
        if (par1PropNames.length != par3Values.length) {
            FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Property name and value lengths are not equal in %s for %s!", (Object[])new Object[]{par2GroupName, this.modName});
            return;
        }
        for (int i = 0; i < par1PropNames.length; ++i) {
            this.groups.get(par2GroupName).addProp(par1PropNames[i], par3Values[i]);
        }
    }

    private Object[] getArray(Object val) {
        Class<?> valKlass = val.getClass();
        Object[] outputArray = null;
        for (Class<?> arrKlass : this.ARRAY_PRIMITIVE_TYPES) {
            if (!valKlass.isAssignableFrom(arrKlass)) continue;
            int arrlength = Array.getLength(val);
            outputArray = new Object[arrlength];
            for (int i = 0; i < arrlength; ++i) {
                outputArray[i] = Array.get(val, i);
            }
            break;
        }
        if (outputArray == null) {
            outputArray = (Object[])val;
        }
        return outputArray;
    }

    public SAPProp getSAPProperty(String par1PropName, String par2GroupName) {
        if (!this.groups.containsKey(par2GroupName)) {
            FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Group %s cannot be found for %s!", (Object[])new Object[]{par2GroupName, this.modName});
            return null;
        }
        return this.groups.get(par2GroupName).getProp(par1PropName);
    }

    private SAPProp[] getSAPProperties(String[] par1PropNames, String par2GroupName) {
        if (!this.groups.containsKey(par2GroupName)) {
            FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Group %s cannot be found for %s!", (Object[])new Object[]{par2GroupName, this.modName});
            return null;
        }
        SAPProp[] values = new SAPProp[par1PropNames.length];
        for (int i = 0; i < par1PropNames.length; ++i) {
            values[i] = this.groups.get(par2GroupName).getProp(par1PropNames[i]);
        }
        return values;
    }

    public long[] getPropertiesLong(String[] par1PropNames, String par2GroupName) {
        SAPProp[] inArray = this.getSAPProperties(par1PropNames, par2GroupName);
        long[] retArray = new long[inArray.length];
        for (int i = 0; i < inArray.length; ++i) {
            retArray[i] = inArray[i].getLong();
        }
        return retArray;
    }

    public int[] getPropertiesInt(String[] par1PropNames, String par2GroupName) {
        SAPProp[] inArray = this.getSAPProperties(par1PropNames, par2GroupName);
        int[] retArray = new int[inArray.length];
        for (int i = 0; i < inArray.length; ++i) {
            retArray[i] = inArray[i].getInt();
        }
        return retArray;
    }

    public short[] getPropertiesShort(String[] par1PropNames, String par2GroupName) {
        SAPProp[] inArray = this.getSAPProperties(par1PropNames, par2GroupName);
        short[] retArray = new short[inArray.length];
        for (int i = 0; i < inArray.length; ++i) {
            retArray[i] = inArray[i].getShort();
        }
        return retArray;
    }

    public byte[] getPropertiesByte(String[] par1PropNames, String par2GroupName) {
        SAPProp[] inArray = this.getSAPProperties(par1PropNames, par2GroupName);
        byte[] retArray = new byte[inArray.length];
        for (int i = 0; i < inArray.length; ++i) {
            retArray[i] = inArray[i].getByte();
        }
        return retArray;
    }

    public float[] getPropertiesFloat(String[] par1PropNames, String par2GroupName) {
        SAPProp[] inArray = this.getSAPProperties(par1PropNames, par2GroupName);
        float[] retArray = new float[inArray.length];
        for (int i = 0; i < inArray.length; ++i) {
            retArray[i] = inArray[i].getFloat();
        }
        return retArray;
    }

    public double[] getPropertiesDouble(String[] par1PropNames, String par2GroupName) {
        SAPProp[] inArray = this.getSAPProperties(par1PropNames, par2GroupName);
        double[] retArray = new double[inArray.length];
        for (int i = 0; i < inArray.length; ++i) {
            retArray[i] = inArray[i].getDouble();
        }
        return retArray;
    }

    public char[] getPropertiesChar(String[] par1PropNames, String par2GroupName) {
        SAPProp[] inArray = this.getSAPProperties(par1PropNames, par2GroupName);
        char[] retArray = new char[inArray.length];
        for (int i = 0; i < inArray.length; ++i) {
            retArray[i] = inArray[i].getChar();
        }
        return retArray;
    }

    public boolean[] getPropertiesBool(String[] par1PropNames, String par2GroupName) {
        SAPProp[] inArray = this.getSAPProperties(par1PropNames, par2GroupName);
        boolean[] retArray = new boolean[inArray.length];
        for (int i = 0; i < inArray.length; ++i) {
            retArray[i] = inArray[i].getBool();
        }
        return retArray;
    }

    public String[] getPropertiesStr(String[] par1PropNames, String par2GroupName) {
        SAPProp[] inArray = this.getSAPProperties(par1PropNames, par2GroupName);
        String[] retArray = new String[inArray.length];
        for (int i = 0; i < inArray.length; ++i) {
            retArray[i] = inArray[i].getString();
        }
        return retArray;
    }

    public void addNewBlockIDs(String ... par1PropNames) {
        for (String name : par1PropNames) {
            this.addProperty(name, "Block IDs", this.getFreeBlockID());
        }
    }

    public void addNewItemIDs(String ... par1PropNames) {
        for (String name : par1PropNames) {
            this.addProperty(name, "Item IDs", this.getFreeItemID());
        }
    }

    public void addStaticBlockIDs(String[] par1PropNames, int[] par2Values) {
        if (par1PropNames.length == par2Values.length) {
            this.addProperties(par1PropNames, "Block IDs", (Object)par2Values);
        }
    }

    public void addStaticBlockIDs(String[] par1PropNames, Integer[] par2Values) {
        if (par1PropNames.length == par2Values.length) {
            this.addProperties(par1PropNames, "Block IDs", par2Values);
        }
    }

    public void addStaticItemIDs(String[] par1PropNames, int[] par2Values) {
        if (par1PropNames.length == par2Values.length) {
            this.addProperties(par1PropNames, "Item IDs", (Object)par2Values);
        }
    }

    public void addStaticItemIDs(String[] par1PropNames, Integer[] par2Values) {
        if (par1PropNames.length == par2Values.length) {
            this.addProperties(par1PropNames, "Item IDs", par2Values);
        }
    }

    public void addAchievementIDs(String[] par1PropNames, int[] par2Values) {
        if (par1PropNames.length == par2Values.length) {
            this.addProperties(par1PropNames, "Achievement IDs", (Object)par2Values);
        }
    }

    public void addAchievementIDs(String[] par1PropNames, Integer[] par2Values) {
        if (par1PropNames.length == par2Values.length) {
            this.addProperties(par1PropNames, "Achievement IDs", par2Values);
        }
    }

    public void addStaticBlockID(String par1PropName, int par2BlockID) {
        this.addProperty(par1PropName, "Block IDs", par2BlockID);
    }

    public void addStaticItemID(String par1PropName, int par2ItemID) {
        this.addProperty(par1PropName, "Item IDs", par2ItemID);
    }

    public void addAchievementID(String par1PropName, int par2AchievementID) {
        this.addProperty(par1PropName, "Achievement IDs", par2AchievementID);
    }

    public int getBlockID(String par1PropName) {
        return this.getSAPProperty(par1PropName, "Block IDs").getInt();
    }

    public int[] getBlockIDs(String ... par1PropNames) {
        return this.getPropertiesInt(par1PropNames, "Block IDs");
    }

    public int getItemID(String par1PropName) {
        return this.getSAPProperty(par1PropName, "Item IDs").getInt();
    }

    public int[] getItemIDs(String ... par1PropNames) {
        return this.getPropertiesInt(par1PropNames, "Item IDs");
    }

    public int getAchievementID(String par1PropName) {
        return this.getSAPProperty(par1PropName, "Achievement IDs").getInt();
    }

    public int[] getAchievementIDs(String ... par1PropNames) {
        return this.getPropertiesInt(par1PropNames, "Achievement IDs");
    }

    public int getFreeBlockID() {
        for (int i = Block.field_71973_m.length - 1; i >= 0; --i) {
            if (Block.field_71973_m[i] != null || registeredBlocks[i] || preRegisteredBlocks[i]) continue;
            SAPConfigManager.preRegisteredBlocks[i] = true;
            return i;
        }
        throw new RuntimeException(String.format("[SAP_ConfManII] No more free block IDs left for %s! Maybe too many mods installed?", this.modName));
    }

    public int getFreeItemID() {
        for (int i = Item.field_77698_e.length - 1; i >= 0; --i) {
            if (Item.field_77698_e[i] != null || registeredItems[i] || preRegisteredItems[i]) continue;
            SAPConfigManager.preRegisteredItems[i] = true;
            return i;
        }
        throw new RuntimeException(String.format("[SAP_ConfManII] No more free item IDs left for %s! Maybe too many mods installed?", this.modName));
    }

    private void writeNewFile(boolean update) {
        if (update) {
            FMLLog.log((String)"SAP-ConfigManager", (Level)Level.INFO, (String)"Updating %s config file!", (Object[])new Object[]{this.modName});
        } else {
            FMLLog.log((String)"SAP-ConfigManager", (Level)Level.INFO, (String)"Creating %s config file!", (Object[])new Object[]{this.modName});
        }
        if (this.configFile.exists()) {
            this.configFile.delete();
        }
        try {
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), "UTF-8");
            BufferedWriter out = new BufferedWriter(new FileWriter(this.configFile));
            String title = String.format(" %s Configuration File, made by SanAndreasPs ConfigManager", this.modName);
            String line = "";
            for (int i = 0; i < title.length() + 1; ++i) {
                line = line + "-";
            }
            out.write(line + "\n");
            out.write(title + "\n");
            out.write(line + "\n");
            for (SAPGroup group : this.groups.values()) {
                if (group.props.isEmpty()) continue;
                out.write(String.format("[ %s ]", group.groupName) + "\n");
                for (int i = 0; i < group.props.size(); ++i) {
                    SAPProp prop = (SAPProp)group.props.row((Object)i).values().iterator().next();
                    Object value = prop.value;
                    if (!update && group.groupName.equals("Block IDs") && (registeredBlocks[(Integer)value] || Block.field_71973_m[(Integer)value] != null)) {
                        FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Block ID %s already occupied! Reassign free one for %s", (Object[])new Object[]{value, this.modName});
                        value = new Integer(this.getFreeBlockID());
                    }
                    if (!update && group.groupName.equals("Item IDs") && (registeredItems[(Integer)value] || Item.field_77698_e[(Integer)value] != null)) {
                        FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Item ID %s already occupied! Reassign free one for %s", (Object[])new Object[]{value, this.modName});
                        value = new Integer(this.getFreeItemID());
                    }
                    out.write(String.format("#   %s = %s", prop.propName, value.toString()) + "\n");
                    if (group.groupName.equals("Block IDs") && !update) {
                        SAPConfigManager.registeredBlocks[((Integer)value).intValue()] = true;
                        continue;
                    }
                    if (!group.groupName.equals("Item IDs") || update) continue;
                    SAPConfigManager.registeredItems[((Integer)value).intValue()] = true;
                }
            }
            osr.close();
            out.close();
            if (update) {
                FMLLog.log((String)"SAP-ConfigManager", (Level)Level.INFO, (String)"%s config file successfully updated!", (Object[])new Object[]{this.modName});
            } else {
                FMLLog.log((String)"SAP-ConfigManager", (Level)Level.INFO, (String)"%s config file successfully created!", (Object[])new Object[]{this.modName});
            }
        }
        catch (IOException e) {
            if (update) {
                FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"An error occured during updating %s config file!", (Object[])new Object[]{this.modName});
            } else {
                FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"An error occured during creating %s config file!", (Object[])new Object[]{this.modName});
            }
            e.printStackTrace();
        }
    }

    private boolean isValueLegit(SAPProp par1Group, String par2Value) {
        try {
            switch (par1Group.dataType) {
                case STRING: {
                    return true;
                }
                case LONG: {
                    Long.decode(par2Value);
                }
                case INT: {
                    Integer.decode(par2Value);
                    break;
                }
                case SHORT: {
                    Short.decode(par2Value);
                    break;
                }
                case BYTE: {
                    Byte.decode(par2Value);
                    break;
                }
                case FLOAT: {
                    Float.parseFloat(par2Value);
                    break;
                }
                case DOUBLE: {
                    Double.parseDouble(par2Value);
                    break;
                }
                case CHAR: {
                    if (par2Value.length() != 1) break;
                    return true;
                }
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private <T> T getParsedValue(String par1Value, DataTypes par2DataType) {
        switch (par2DataType) {
            case LONG: {
                return (T)Long.decode(par1Value);
            }
            case INT: {
                return (T)Integer.decode(par1Value);
            }
            case SHORT: {
                return (T)Short.decode(par1Value);
            }
            case BYTE: {
                return (T)Byte.decode(par1Value);
            }
            case DOUBLE: {
                return (T)Double.valueOf(par1Value);
            }
            case FLOAT: {
                return (T)Float.valueOf(par1Value);
            }
            case BOOL: {
                return (T)Boolean.valueOf(par1Value);
            }
            case STRING: {
                return (T)par1Value;
            }
            case CHAR: {
                return (T)Character.valueOf(par1Value.charAt(0));
            }
        }
        return null;
    }

    public void loadConfig() {
        if (!this.configFile.exists()) {
            this.writeNewFile(false);
        } else {
            try {
                boolean updateFile = false;
                BufferedReader var1In = new BufferedReader(new UnicodeInputStreamReader(new FileInputStream(this.configFile), "UTF-8"));
                for (int i = 0; i < 3; ++i) {
                    var1In.readLine();
                }
                String currLine = "";
                String var2String = "";
                HashMap<String, Boolean> groupsMap = new HashMap<String, Boolean>();
                for (SAPGroup group : this.groups.values()) {
                    groupsMap.put(group.groupName, group.props.isEmpty());
                }
                while (var1In.ready()) {
                    String string = var2String = currLine.isEmpty() ? var1In.readLine() : currLine;
                    Matcher matcher = Pattern.compile("\\[ {0,}(.*?) {0,}\\]").matcher(var2String);
                    if (!matcher.find()) continue;
                    String var3GroupName = matcher.group(1);
                    if (this.groups.containsKey(var3GroupName)) {
                        SAPGroup var4Group = this.groups.get(var3GroupName);
                        HashMap<String, Boolean> var5Map = new HashMap<String, Boolean>();
                        for (SAPProp var6Prop : var4Group.props.values()) {
                            var5Map.put(var6Prop.propName, Boolean.FALSE);
                        }
                        boolean finishedGroup = false;
                        while (var1In.ready() && !finishedGroup) {
                            var2String = var1In.readLine();
                            matcher = Pattern.compile("# {0,}(.*?) {0,}= {0,}(.*)").matcher(var2String);
                            if (matcher.find()) {
                                String var8Key = matcher.group(1);
                                String var9Value = matcher.group(2);
                                if (var4Group.props.containsColumn((Object)var8Key)) {
                                    SAPProp prop = var4Group.getProp(var8Key);
                                    if (this.isValueLegit(prop, var9Value)) {
                                        Object value = this.getParsedValue(var9Value, prop.getDataType());
                                        if (var4Group.groupName.equals("Block IDs")) {
                                            if (Block.field_71973_m[(Integer)value] != null || registeredBlocks[(Integer)value]) {
                                                FMLLog.log((String)"SAP-ConfigManager", (Level)Level.SEVERE, (String)"Block ID conflict with property %s in %s config file! Change this block ID!", (Object[])new Object[]{var8Key, this.modName});
                                            }
                                            SAPConfigManager.registeredBlocks[((Integer)value).intValue()] = true;
                                        } else if (var4Group.groupName.equals("Item IDs")) {
                                            if (Item.field_77698_e[(Integer)value] != null || registeredItems[(Integer)value]) {
                                                FMLLog.log((String)"SAP-ConfigManager", (Level)Level.SEVERE, (String)"Item ID conflict with property %s in %s config file! Change this item ID!", (Object[])new Object[]{var8Key, this.modName});
                                            }
                                            SAPConfigManager.registeredItems[((Integer)value).intValue()] = true;
                                        }
                                        SAPProp var10Prop = new SAPProp(var8Key, value);
                                        var4Group.updateProp(var10Prop.propName, var10Prop);
                                        var5Map.put(prop.propName, Boolean.TRUE);
                                        continue;
                                    }
                                    FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Cannot assign value %s for property %s in %s config file! Invalid value!", (Object[])new Object[]{var9Value, var8Key, this.modName});
                                    var5Map.put(prop.propName, Boolean.FALSE);
                                    continue;
                                }
                                FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Cannot find property %s in group %s from %s config file! Skipping!", (Object[])new Object[]{var8Key, var4Group.groupName, this.modName});
                                continue;
                            }
                            finishedGroup = true;
                            currLine = var2String;
                        }
                        if (var5Map.containsValue(Boolean.FALSE)) {
                            FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"One or more properties are missing or invalid in %s config file!", (Object[])new Object[]{this.modName});
                            updateFile = true;
                        }
                        groupsMap.put(var3GroupName, Boolean.TRUE);
                        continue;
                    }
                    FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Cannot find group %s from %s config file! Skipping!", (Object[])new Object[]{var3GroupName, this.modName});
                    currLine = "";
                }
                if (groupsMap.containsValue(Boolean.FALSE)) {
                    FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"One or more groups are missing in %s config file!", (Object[])new Object[]{this.modName});
                    updateFile = true;
                }
                var1In.close();
                if (updateFile) {
                    this.writeNewFile(true);
                } else {
                    FMLLog.log((String)"SAP-ConfigManager", (Level)Level.INFO, (String)"%s config file successfully readed!", (Object[])new Object[]{this.modName});
                }
            }
            catch (FileNotFoundException e) {
                this.writeNewFile(false);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.writeNewFile(true);
            }
        }
    }

    public static class SAPProp {
        private final String propName;
        private final Object value;
        private final DataTypes dataType;

        public SAPProp(String par1PropName, Object par2Value, DataTypes par3DataType) {
            this.propName = par1PropName;
            this.value = par2Value;
            if (par3DataType == null) {
                FMLLog.log((String)"SAP-ConfigManager", (Level)Level.SEVERE, (String)"Value %s is not supported!", (Object[])new Object[]{par2Value.getClass()});
                throw new RuntimeException();
            }
            this.dataType = par3DataType;
        }

        public SAPProp(String par1PropName, Object par2Value) {
            this(par1PropName, par2Value, SAPProp.getDTFromClass(par2Value.getClass()));
        }

        public String getPropName() {
            return this.propName;
        }

        public DataTypes getDataType() {
            return this.dataType;
        }

        public <T> T getValue() {
            switch (this.dataType) {
                case LONG: {
                    return (T)new Long(this.getLong());
                }
                case INT: {
                    return (T)new Integer(this.getInt());
                }
                case SHORT: {
                    return (T)new Short(this.getShort());
                }
                case BYTE: {
                    return (T)new Byte(this.getByte());
                }
                case BOOL: {
                    return (T)new Boolean(this.getBool());
                }
                case FLOAT: {
                    return (T)new Float(this.getFloat());
                }
                case DOUBLE: {
                    return (T)new Double(this.getDouble());
                }
                case CHAR: {
                    return (T)new Character(this.getChar());
                }
                case STRING: {
                    return (T)new String(this.getString());
                }
            }
            return null;
        }

        public long getLong() {
            return (Long)this.value;
        }

        public int getInt() {
            return (Integer)this.value;
        }

        public short getShort() {
            return (Short)this.value;
        }

        public byte getByte() {
            return (Byte)this.value;
        }

        public float getFloat() {
            return ((Float)this.value).floatValue();
        }

        public double getDouble() {
            return (Double)this.value;
        }

        public boolean getBool() {
            return (Boolean)this.value;
        }

        public String getString() {
            return (String)this.value;
        }

        public char getChar() {
            return ((Character)this.value).charValue();
        }

        private static DataTypes getDTFromClass(Class clazz) {
            for (DataTypes dt : DataTypes.values()) {
                if (!dt.isDTClass(clazz)) continue;
                return dt;
            }
            return null;
        }
    }

    public static class SAPGroup {
        public final String groupName;
        public Table<Integer, String, SAPProp> props = HashBasedTable.create();

        public SAPGroup(String par1Name) {
            this.groupName = par1Name;
        }

        public void addProp(String par1PropName, Object par3Value) {
            if (par3Value == null) {
                FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Property value cannot be null for property %s in group %s!", (Object[])new Object[]{par1PropName, this.groupName});
            } else {
                this.props.put((Object)this.props.size(), (Object)par1PropName, (Object)new SAPProp(par1PropName, par3Value));
            }
        }

        public SAPProp getProp(String par1Name) {
            if (!this.props.containsColumn((Object)par1Name)) {
                FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Property %s cannot be found!", (Object[])new Object[]{par1Name});
                return null;
            }
            return (SAPProp)this.props.column((Object)par1Name).values().iterator().next();
        }

        public SAPProp getSortedProp(int id, String par1Name) {
            if (!this.props.row((Object)id).containsKey(par1Name)) {
                FMLLog.log((String)"SAP-ConfigManager", (Level)Level.WARNING, (String)"Property %s cannot be found!", (Object[])new Object[]{par1Name});
                return null;
            }
            return (SAPProp)this.props.row((Object)id).get(par1Name);
        }

        public void updateProp(String name, SAPProp value) {
            int row = (Integer)this.props.column((Object)name).keySet().iterator().next();
            this.props.row((Object)row).put(name, value);
        }
    }

    public static enum DataTypes {
        LONG(Long.class, Long.TYPE),
        INT(Integer.class, Integer.TYPE),
        SHORT(Short.class, Short.TYPE),
        BYTE(Byte.class, Byte.TYPE),
        DOUBLE(Double.class, Double.TYPE),
        FLOAT(Float.class, Float.TYPE),
        STRING(String.class),
        CHAR(Character.class, Character.TYPE),
        BOOL(Boolean.class, Boolean.TYPE);

        private final Class[] dtClass;

        private DataTypes(Class ... clazz) {
            this.dtClass = clazz;
        }

        public boolean isDTClass(Class clazz) {
            for (Class cls : this.dtClass) {
                if (clazz != cls) continue;
                return true;
            }
            return false;
        }
    }
}

