/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class TextureUtils {
    public static final String texGrassTop = "grass_top";
    public static final String texStone = "stone";
    public static final String texDirt = "dirt";
    public static final String texGrassSide = "grass_side";
    public static final String texStoneslabSide = "stone_slab_side";
    public static final String texStoneslabTop = "stone_slab_top";
    public static final String texBedrock = "bedrock";
    public static final String texSand = "sand";
    public static final String texGravel = "gravel";
    public static final String texLogOak = "log_oak";
    public static final String texLogOakTop = "log_oak_top";
    public static final String texGoldOre = "gold_ore";
    public static final String texIronOre = "iron_ore";
    public static final String texCoalOre = "coal_ore";
    public static final String texObsidian = "obsidian";
    public static final String texGrassSideOverlay = "grass_side_overlay";
    public static final String texSnow = "snow";
    public static final String texGrassSideSnowed = "grass_side_snowed";
    public static final String texMyceliumSide = "mycelium_side";
    public static final String texMyceliumTop = "mycelium_top";
    public static final String texDiamondOre = "diamond_ore";
    public static final String texRedstoneOre = "redstone_ore";
    public static final String texLapisOre = "lapis_ore";
    public static final String texLeavesOak = "leaves_oak";
    public static final String texLeavesOakOpaque = "leaves_oak_opaque";
    public static final String texLeavesJungle = "leaves_jungle";
    public static final String texLeavesJungleOpaque = "leaves_jungle_opaque";
    public static final String texCactusSide = "cactus_side";
    public static final String texClay = "clay";
    public static final String texFarmlandWet = "farmland_wet";
    public static final String texFarmlandDry = "farmland_dry";
    public static final String texNetherrack = "netherrack";
    public static final String texSoulSand = "soul_sand";
    public static final String texGlowstone = "glowstone";
    public static final String texLogSpruce = "log_spruce";
    public static final String texLogBirch = "log_birch";
    public static final String texLeavesSpruce = "leaves_spruce";
    public static final String texLeavesSpruceOpaque = "leaves_spruce_opaque";
    public static final String texLogJungle = "log_jungle";
    public static final String texEndStone = "end_stone";
    public static final String texSandstoneTop = "sandstone_top";
    public static final String texSandstoneBottom = "sandstone_bottom";
    public static final String texRedstoneLampOff = "redstone_lamp_off";
    public static final String texRedstoneLampOn = "redstone_lamp_on";
    public static final String texWaterStill = "water_still";
    public static final String texWaterFlow = "water_flow";
    public static final String texLavaStill = "lava_still";
    public static final String texLavaFlow = "lava_flow";
    public static final String texFireLayer0 = "fire_layer_0";
    public static final String texFireLayer1 = "fire_layer_1";
    public static final String texPortal = "portal";
    public static mr iconGrassTop;
    public static mr iconGrassSide;
    public static mr iconGrassSideOverlay;
    public static mr iconSnow;
    public static mr iconGrassSideSnowed;
    public static mr iconMyceliumSide;
    public static mr iconMyceliumTop;
    public static mr iconWaterStill;
    public static mr iconWaterFlow;
    public static mr iconLavaStill;
    public static mr iconLavaFlow;
    public static mr iconPortal;
    public static mr iconFireLayer0;
    public static mr iconFireLayer1;
    private static IntBuffer staticBuffer;

    private static Set makeAtlasNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("/terrain.png");
        set.add("/gui/items.png");
        set.add("/ctm.png");
        set.add("/eloraam/world/world1.png");
        set.add("/gfx/buildcraft/blocks/blocks.png");
        return set;
    }

    public static void update() {
        bih mapBlocks = bih.textureMapBlocks;
        if (mapBlocks == null) {
            return;
        }
        iconGrassTop = mapBlocks.getIconSafe(texGrassTop);
        iconGrassSide = mapBlocks.getIconSafe(texGrassSide);
        iconGrassSideOverlay = mapBlocks.getIconSafe(texGrassSideOverlay);
        iconSnow = mapBlocks.getIconSafe(texSnow);
        iconGrassSideSnowed = mapBlocks.getIconSafe(texGrassSideSnowed);
        iconMyceliumSide = mapBlocks.getIconSafe(texMyceliumSide);
        iconMyceliumTop = mapBlocks.getIconSafe(texMyceliumTop);
        iconWaterStill = mapBlocks.getIconSafe(texWaterStill);
        iconWaterFlow = mapBlocks.getIconSafe(texWaterFlow);
        iconLavaStill = mapBlocks.getIconSafe(texLavaStill);
        iconLavaFlow = mapBlocks.getIconSafe(texLavaFlow);
        iconFireLayer0 = mapBlocks.getIconSafe(texFireLayer0);
        iconFireLayer1 = mapBlocks.getIconSafe(texFireLayer1);
        iconPortal = mapBlocks.getIconSafe(texPortal);
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi2) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi2.getWidth()) == (height = bi2.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr2 = scaledImage.createGraphics();
            gr2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr2.drawImage(bi2, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi2;
    }

    public static bii getTextureAtlasSprite(mr icon) {
        if (icon instanceof bii) {
            return (bii)icon;
        }
        return null;
    }

    public static int ceilPowerOfTwo(int val) {
        int i2;
        for (i2 = 1; i2 < val; i2 *= 2) {
        }
        return i2;
    }

    public static int getPowerOfTwo(int val) {
        int i2 = 1;
        int po2 = 0;
        while (i2 < val) {
            i2 *= 2;
            ++po2;
        }
        return po2;
    }

    public static int twoToPower(int power) {
        int val = 1;
        for (int i2 = 0; i2 < power; ++i2) {
            val *= 2;
        }
        return val;
    }

    public static void refreshBlockTextures() {
        Config.dbg("*** Reloading block textures ***");
        bih.textureMapBlocks.loadTextureSafe(Config.getResourceManager());
        TextureUtils.update();
        NaturalTextures.update();
        bih.textureMapBlocks.c();
    }

    public static bil getTexture(String path) {
        return TextureUtils.getTexture(new bjl(path));
    }

    public static bil getTexture(bjl loc) {
        bil tex = Config.getTextureManager().b(loc);
        if (tex != null) {
            return tex;
        }
        if (!Config.hasResource(loc)) {
            return null;
        }
        tex = new bic(loc);
        Config.getTextureManager().a(loc, tex);
        return tex;
    }

    public static void resourcesReloaded(bjm rm2) {
        if (bih.textureMapBlocks == null) {
            return;
        }
        Config.dbg("*** Reloading custom textures ***");
        CustomSky.reset();
        TextureAnimations.reset();
        TextureUtils.update();
        NaturalTextures.update();
        TextureAnimations.update();
        CustomColorizer.update();
        CustomSky.update();
        RandomMobs.resetTextures();
        Config.updateTexturePackClouds();
        Config.getTextureManager().d();
    }

    public static void refreshTextureMaps(bjm rm2) {
        bih.textureMapBlocks.loadTextureSafe(rm2);
        bih.textureMapItems.loadTextureSafe(rm2);
        TextureUtils.update();
        NaturalTextures.update();
    }

    public static void registerResourceListener() {
        bjm rm2 = Config.getResourceManager();
        if (rm2 instanceof bjj) {
            bjj rrm = (bjj)rm2;
            bjn rl2 = new bjn(){

                @Override
                public void a(bjm var1) {
                    TextureUtils.resourcesReloaded(var1);
                }
            };
            rrm.a(rl2);
        }
        bio tto = new bio(){

            @Override
            public void d() {
                TextureAnimations.updateCustomAnimations();
            }

            @Override
            public void a(bjm var1) throws IOException {
            }

            @Override
            public int b() {
                return 0;
            }
        };
        bjl ttol = new bjl("optifine/TickableTextures");
        Config.getTextureManager().a(ttol, tto);
    }

    public static String fixResourcePath(String path, String basePath) {
        String strAssMc = "assets/minecraft/";
        if (path.startsWith(strAssMc)) {
            path = path.substring(strAssMc.length());
            return path;
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            path = basePath + path;
            return path;
        }
        String strMcpatcher = "mcpatcher/";
        if (path.startsWith("~/")) {
            path = path.substring(2);
            path = strMcpatcher + path;
            return path;
        }
        if (path.startsWith("/")) {
            path = strMcpatcher + path.substring(1);
            return path;
        }
        return path;
    }

    public static String getBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public static void setupTexture(int width, int height, int gridSize, boolean useMipmaps) {
        boolean mipmapsActive;
        int minFilter = 9728;
        int magFilter = 9728;
        boolean bl2 = mipmapsActive = useMipmaps && Config.isUseMipmaps();
        if (mipmapsActive) {
            minFilter = Config.getMipmapType();
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
        int wrapMode = 33071;
        GL11.glTexParameteri((int)3553, (int)10242, (int)wrapMode);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wrapMode);
        if (mipmapsActive) {
            TextureUtils.updateMaxMipmapLevel(width, height, gridSize);
            Mipmaps.allocateMipmapTextures(width, height, "");
        }
        TextureUtils.updateAnisotropicLevel();
    }

    public static void updateMaxMipmapLevel(int width, int height, int gridSize) {
        if (Config.getMipmapLevel() <= 0) {
            return;
        }
        if (GLContext.getCapabilities().OpenGL12) {
            GL11.glTexParameteri((int)3553, (int)33084, (int)0);
            int mipmapLevel = Config.getMipmapLevel();
            if (mipmapLevel >= 4) {
                int minDim = Math.min(width, height);
                mipmapLevel = TextureUtils.getMaxMipmapLevel(minDim);
                if (gridSize > 1) {
                    int gridSizePo2;
                    mipmapLevel = gridSizePo2 = TextureUtils.getPowerOfTwo(gridSize);
                }
                if (mipmapLevel < 0) {
                    mipmapLevel = 0;
                }
            }
            GL11.glTexParameteri((int)3553, (int)33085, (int)mipmapLevel);
        }
    }

    public static void updateAnisotropicLevel() {
        if (GLContext.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float maxLevel = GL11.glGetFloat((int)34047);
            float level = Config.getAnisotropicFilterLevel();
            level = Math.min(level, maxLevel);
            GL11.glTexParameterf((int)3553, (int)34046, (float)level);
        }
    }

    private static int getMaxMipmapLevel(int size) {
        int level = 0;
        while (size > 0) {
            size /= 2;
            ++level;
        }
        return level - 1;
    }

    public static IntBuffer getStaticBuffer(int w2, int h2) {
        int len = w2 * h2;
        if (staticBuffer == null || staticBuffer.capacity() < len) {
            len = TextureUtils.ceilPowerOfTwo(len);
            staticBuffer = atr.f(len);
        }
        return staticBuffer;
    }

    static {
        staticBuffer = atr.f(256);
    }
}

