/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ConnectedTextures {
    private static ConnectedProperties[][] blockProperties = null;
    private static ConnectedProperties[][] tileProperties = null;
    private static boolean multipass = false;
    private static boolean defaultGlassTexture = false;
    private static final int BOTTOM = 0;
    private static final int TOP = 1;
    private static final int EAST = 2;
    private static final int WEST = 3;
    private static final int NORTH = 4;
    private static final int SOUTH = 5;
    private static final String[] propSuffixes = new String[]{"", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static final int[] ctmIndexes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 0, 0, 0, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0, 0, 0, 0, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 0, 0, 0, 0, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 0, 0, 0, 0, 0};

    public static mr getConnectedTexture(ace blockAccess, aqw block, int x2, int y2, int z2, int side, mr icon) {
        mr newMpIcon;
        if (blockAccess == null) {
            return icon;
        }
        mr newIcon = ConnectedTextures.getConnectedTextureSingle(blockAccess, block, x2, y2, z2, side, icon, true);
        if (!multipass) {
            return newIcon;
        }
        if (newIcon == icon) {
            return newIcon;
        }
        mr mpIcon = newIcon;
        for (int i2 = 0; i2 < 3 && (newMpIcon = ConnectedTextures.getConnectedTextureSingle(blockAccess, block, x2, y2, z2, side, mpIcon, false)) != mpIcon; ++i2) {
            mpIcon = newMpIcon;
        }
        return mpIcon;
    }

    public static mr getConnectedTextureSingle(ace blockAccess, aqw block, int x2, int y2, int z2, int side, mr icon, boolean checkBlocks) {
        ConnectedProperties[] cps;
        int blockId;
        ConnectedProperties[] cps2;
        if (!(icon instanceof bii)) {
            return icon;
        }
        bii ts2 = (bii)icon;
        int iconId = ts2.getIndexInMap();
        int metadata = -1;
        if (tileProperties != null && bfn.a.defaultTexture && iconId >= 0 && iconId < tileProperties.length && (cps2 = tileProperties[iconId]) != null) {
            mr newIcon;
            if (metadata < 0) {
                metadata = blockAccess.h(x2, y2, z2);
            }
            if ((newIcon = ConnectedTextures.getConnectedTexture(cps2, blockAccess, block, x2, y2, z2, side, (mr)ts2, metadata)) != null) {
                return newIcon;
            }
        }
        if (blockProperties != null && checkBlocks && (blockId = block.cF) >= 0 && blockId < blockProperties.length && (cps = blockProperties[blockId]) != null) {
            mr newIcon;
            if (metadata < 0) {
                metadata = blockAccess.h(x2, y2, z2);
            }
            if ((newIcon = ConnectedTextures.getConnectedTexture(cps, blockAccess, block, x2, y2, z2, side, (mr)ts2, metadata)) != null) {
                return newIcon;
            }
        }
        return icon;
    }

    public static ConnectedProperties getConnectedProperties(ace blockAccess, aqw block, int x2, int y2, int z2, int side, mr icon) {
        ConnectedProperties[] cps;
        int blockId;
        ConnectedProperties[] cps2;
        if (blockAccess == null) {
            return null;
        }
        if (!(icon instanceof bii)) {
            return null;
        }
        bii ts2 = (bii)icon;
        int iconId = ts2.getIndexInMap();
        int metadata = -1;
        if (tileProperties != null && bfn.a.defaultTexture && iconId >= 0 && iconId < tileProperties.length && (cps2 = tileProperties[iconId]) != null) {
            ConnectedProperties cp2;
            if (metadata < 0) {
                metadata = blockAccess.h(x2, y2, z2);
            }
            if ((cp2 = ConnectedTextures.getConnectedProperties(cps2, blockAccess, block, x2, y2, z2, side, ts2, metadata)) != null) {
                return cp2;
            }
        }
        if (blockProperties != null && (blockId = block.cF) >= 0 && blockId < blockProperties.length && (cps = blockProperties[blockId]) != null) {
            ConnectedProperties cp3;
            if (metadata < 0) {
                metadata = blockAccess.h(x2, y2, z2);
            }
            if ((cp3 = ConnectedTextures.getConnectedProperties(cps, blockAccess, block, x2, y2, z2, side, ts2, metadata)) != null) {
                return cp3;
            }
        }
        return null;
    }

    private static mr getConnectedTexture(ConnectedProperties[] cps, ace blockAccess, aqw block, int x2, int y2, int z2, int side, mr icon, int metadata) {
        for (int i2 = 0; i2 < cps.length; ++i2) {
            mr newIcon;
            ConnectedProperties cp2 = cps[i2];
            if (cp2 == null || (newIcon = ConnectedTextures.getConnectedTexture(cp2, blockAccess, block, x2, y2, z2, side, icon, metadata)) == null) continue;
            return newIcon;
        }
        return null;
    }

    private static ConnectedProperties getConnectedProperties(ConnectedProperties[] cps, ace blockAccess, aqw block, int x2, int y2, int z2, int side, mr icon, int metadata) {
        for (int i2 = 0; i2 < cps.length; ++i2) {
            mr newIcon;
            ConnectedProperties cp2 = cps[i2];
            if (cp2 == null || (newIcon = ConnectedTextures.getConnectedTexture(cp2, blockAccess, block, x2, y2, z2, side, icon, metadata)) == null) continue;
            return cp2;
        }
        return null;
    }

    private static mr getConnectedTexture(ConnectedProperties cp2, ace blockAccess, aqw block, int x2, int y2, int z2, int side, mr icon, int metadata) {
        if (y2 < cp2.minHeight || y2 > cp2.maxHeight) {
            return null;
        }
        if (cp2.biomes != null) {
            acp blockBiome = blockAccess.a(x2, z2);
            boolean biomeOk = false;
            for (int i2 = 0; i2 < cp2.biomes.length; ++i2) {
                acp biome = cp2.biomes[i2];
                if (blockBiome != biome) continue;
                biomeOk = true;
                break;
            }
            if (!biomeOk) {
                return null;
            }
        }
        boolean blockWood = block instanceof arg;
        if (side >= 0 && cp2.faces != 63) {
            int checkSide = side;
            if (blockWood) {
                checkSide = ConnectedTextures.fixWoodSide(blockAccess, x2, y2, z2, side, metadata);
            }
            if ((1 << checkSide & cp2.faces) == 0) {
                return null;
            }
        }
        int checkMetadata = metadata;
        if (blockWood) {
            checkMetadata &= 3;
        }
        if (cp2.metadatas != null) {
            int[] mds = cp2.metadatas;
            boolean metadataFound = false;
            for (int i3 = 0; i3 < mds.length; ++i3) {
                if (mds[i3] != checkMetadata) continue;
                metadataFound = true;
                break;
            }
            if (!metadataFound) {
                return null;
            }
        }
        switch (cp2.method) {
            case 1: {
                return ConnectedTextures.getConnectedTextureCtm(cp2, blockAccess, block, x2, y2, z2, side, icon, metadata);
            }
            case 2: {
                return ConnectedTextures.getConnectedTextureHorizontal(cp2, blockAccess, block, x2, y2, z2, side, icon, metadata);
            }
            case 6: {
                return ConnectedTextures.getConnectedTextureVertical(cp2, blockAccess, block, x2, y2, z2, side, icon, metadata);
            }
            case 3: {
                return ConnectedTextures.getConnectedTextureTop(cp2, blockAccess, block, x2, y2, z2, side, icon, metadata);
            }
            case 4: {
                return ConnectedTextures.getConnectedTextureRandom(cp2, x2, y2, z2, side);
            }
            case 5: {
                return ConnectedTextures.getConnectedTextureRepeat(cp2, x2, y2, z2, side);
            }
            case 7: {
                return ConnectedTextures.getConnectedTextureFixed(cp2);
            }
        }
        return null;
    }

    private static int fixWoodSide(ace blockAccess, int x2, int y2, int z2, int side, int metadata) {
        int orient = (metadata & 0xC) >> 2;
        switch (orient) {
            case 0: {
                return side;
            }
            case 1: {
                switch (side) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 5;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 0;
                    }
                }
                break;
            }
            case 2: {
                switch (side) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                break;
            }
            case 3: {
                return 2;
            }
        }
        return side;
    }

    private static mr getConnectedTextureRandom(ConnectedProperties cp2, int x2, int y2, int z2, int side) {
        if (cp2.tileIcons.length == 1) {
            return cp2.tileIcons[0];
        }
        int face = side / cp2.symmetry * cp2.symmetry;
        int rand = Config.getRandom(x2, y2, z2, face) & Integer.MAX_VALUE;
        int index = 0;
        if (cp2.weights == null) {
            index = rand % cp2.tileIcons.length;
        } else {
            int randWeight = rand % cp2.sumAllWeights;
            int[] sumWeights = cp2.sumWeights;
            for (int i2 = 0; i2 < sumWeights.length; ++i2) {
                if (randWeight >= sumWeights[i2]) continue;
                index = i2;
                break;
            }
        }
        return cp2.tileIcons[index];
    }

    private static mr getConnectedTextureFixed(ConnectedProperties cp2) {
        return cp2.tileIcons[0];
    }

    private static mr getConnectedTextureRepeat(ConnectedProperties cp2, int x2, int y2, int z2, int side) {
        if (cp2.tileIcons.length == 1) {
            return cp2.tileIcons[0];
        }
        int nx2 = 0;
        int ny2 = 0;
        switch (side) {
            case 0: {
                nx2 = x2;
                ny2 = z2;
                break;
            }
            case 1: {
                nx2 = x2;
                ny2 = z2;
                break;
            }
            case 2: {
                nx2 = -x2 - 1;
                ny2 = -y2;
                break;
            }
            case 3: {
                nx2 = x2;
                ny2 = -y2;
                break;
            }
            case 4: {
                nx2 = z2;
                ny2 = -y2;
                break;
            }
            case 5: {
                nx2 = -z2 - 1;
                ny2 = -y2;
            }
        }
        ny2 %= cp2.height;
        if ((nx2 %= cp2.width) < 0) {
            nx2 += cp2.width;
        }
        if (ny2 < 0) {
            ny2 += cp2.height;
        }
        int index = ny2 * cp2.width + nx2;
        return cp2.tileIcons[index];
    }

    private static mr getConnectedTextureCtm(ConnectedProperties cp2, ace blockAccess, aqw block, int x2, int y2, int z2, int side, mr icon, int metadata) {
        boolean[] borders = new boolean[6];
        switch (side) {
            case 0: 
            case 1: {
                borders[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2, side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2, side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 + 1, side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 - 1, side, icon, metadata);
                break;
            }
            case 2: {
                borders[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2, side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2, side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2, side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, icon, metadata);
                break;
            }
            case 3: {
                borders[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2, side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2, side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2, side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, icon, metadata);
                break;
            }
            case 4: {
                borders[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 - 1, side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 + 1, side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2, side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, icon, metadata);
                break;
            }
            case 5: {
                borders[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 + 1, side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 - 1, side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2, side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, icon, metadata);
            }
        }
        int index = 0;
        if (borders[0] & !borders[1] & !borders[2] & !borders[3]) {
            index = 3;
        } else if (!borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 1;
        } else if (!borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 12;
        } else if (!borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 36;
        } else if (borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 2;
        } else if (!borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 24;
        } else if (borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 15;
        } else if (borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 39;
        } else if (!borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 13;
        } else if (!borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 37;
        } else if (!borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 25;
        } else if (borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 27;
        } else if (borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 38;
        } else if (borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 14;
        } else if (borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 26;
        }
        if (!Config.isConnectedTexturesFancy()) {
            return cp2.tileIcons[index];
        }
        boolean[] edges = new boolean[6];
        switch (side) {
            case 0: 
            case 1: {
                edges[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2 + 1, side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2 + 1, side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2 - 1, side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2 - 1, side, icon, metadata);
                break;
            }
            case 2: {
                edges[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2 - 1, z2, side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2 - 1, z2, side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2 + 1, z2, side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2 + 1, z2, side, icon, metadata);
                break;
            }
            case 3: {
                edges[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2 - 1, z2, side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2 - 1, z2, side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2 + 1, z2, side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2 + 1, z2, side, icon, metadata);
                break;
            }
            case 4: {
                edges[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2 + 1, side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2 - 1, side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2 + 1, side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2 - 1, side, icon, metadata);
                break;
            }
            case 5: {
                edges[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2 - 1, side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2 + 1, side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2 - 1, side, icon, metadata);
                boolean bl2 = edges[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2 + 1, side, icon, metadata);
            }
        }
        if (index == 13 && edges[0]) {
            index = 4;
        }
        if (index == 15 && edges[1]) {
            index = 5;
        }
        if (index == 37 && edges[2]) {
            index = 16;
        }
        if (index == 39 && edges[3]) {
            index = 17;
        }
        if (index == 14 && edges[0] && edges[1]) {
            index = 7;
        }
        if (index == 25 && edges[0] && edges[2]) {
            index = 6;
        }
        if (index == 27 && edges[3] && edges[1]) {
            index = 19;
        }
        if (index == 38 && edges[3] && edges[2]) {
            index = 18;
        }
        if (index == 14 && !edges[0] && edges[1]) {
            index = 31;
        }
        if (index == 25 && edges[0] && !edges[2]) {
            index = 30;
        }
        if (index == 27 && !edges[3] && edges[1]) {
            index = 41;
        }
        if (index == 38 && edges[3] && !edges[2]) {
            index = 40;
        }
        if (index == 14 && edges[0] && !edges[1]) {
            index = 29;
        }
        if (index == 25 && !edges[0] && edges[2]) {
            index = 28;
        }
        if (index == 27 && edges[3] && !edges[1]) {
            index = 43;
        }
        if (index == 38 && !edges[3] && edges[2]) {
            index = 42;
        }
        if (index == 26 && edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 46;
        }
        if (index == 26 && !edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 9;
        }
        if (index == 26 && edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 21;
        }
        if (index == 26 && edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 8;
        }
        if (index == 26 && edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 20;
        }
        if (index == 26 && edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 11;
        }
        if (index == 26 && !edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 22;
        }
        if (index == 26 && !edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 23;
        }
        if (index == 26 && edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 10;
        }
        if (index == 26 && edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 34;
        }
        if (index == 26 && !edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 35;
        }
        if (index == 26 && edges[0] && !edges[1] && !edges[2] && !edges[3]) {
            index = 32;
        }
        if (index == 26 && !edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 33;
        }
        if (index == 26 && !edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 44;
        }
        if (index == 26 && !edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 45;
        }
        return cp2.tileIcons[index];
    }

    private static boolean isNeighbour(ConnectedProperties cp2, ace iblockaccess, aqw block, int x2, int y2, int z2, int side, mr icon, int metadata) {
        int blockId = iblockaccess.a(x2, y2, z2);
        if (cp2.connect == 2) {
            aqw neighbourBlock = aqw.s[blockId];
            if (neighbourBlock == null) {
                return false;
            }
            mr neighbourIcon = neighbourBlock.b_(iblockaccess, x2, y2, z2, side);
            return neighbourIcon == icon;
        }
        if (cp2.connect == 3) {
            aqw neighbourBlock = aqw.s[blockId];
            if (neighbourBlock == null) {
                return false;
            }
            return neighbourBlock.cU == block.cU;
        }
        return blockId == block.cF && iblockaccess.h(x2, y2, z2) == metadata;
    }

    private static mr getConnectedTextureHorizontal(ConnectedProperties cp2, ace blockAccess, aqw block, int x2, int y2, int z2, int side, mr icon, int metadata) {
        if (side == 0 || side == 1) {
            return null;
        }
        boolean left = false;
        boolean right = false;
        switch (side) {
            case 2: {
                left = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2, side, icon, metadata);
                right = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2, side, icon, metadata);
                break;
            }
            case 3: {
                left = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2, side, icon, metadata);
                right = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2, side, icon, metadata);
                break;
            }
            case 4: {
                left = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 - 1, side, icon, metadata);
                right = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 + 1, side, icon, metadata);
                break;
            }
            case 5: {
                left = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 + 1, side, icon, metadata);
                right = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 - 1, side, icon, metadata);
            }
        }
        int index = 3;
        index = left ? (right ? 1 : 2) : (right ? 0 : 3);
        return cp2.tileIcons[index];
    }

    private static mr getConnectedTextureVertical(ConnectedProperties cp2, ace blockAccess, aqw block, int x2, int y2, int z2, int side, mr icon, int metadata) {
        if (side == 0 || side == 1) {
            return null;
        }
        boolean bottom = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2, side, icon, metadata);
        boolean top = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, icon, metadata);
        int index = 3;
        index = bottom ? (top ? 1 : 2) : (top ? 0 : 3);
        return cp2.tileIcons[index];
    }

    private static mr getConnectedTextureTop(ConnectedProperties cp2, ace blockAccess, aqw block, int x2, int y2, int z2, int side, mr icon, int metadata) {
        if (side == 0 || side == 1) {
            return null;
        }
        if (ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, icon, metadata)) {
            return cp2.tileIcons[0];
        }
        return null;
    }

    public static boolean isConnectedGlassPanes() {
        return Config.isConnectedTextures() && defaultGlassTexture;
    }

    public static void updateIcons(bih textureMap) {
        bjl loc;
        blockProperties = null;
        tileProperties = null;
        defaultGlassTexture = false;
        bjo rp2 = Config.getResourcePack();
        boolean tpHasGlass = rp2.b(loc = new bjl("textures/blocks/glass.png"));
        defaultGlassTexture = !tpHasGlass;
        Object[] names = ConnectedTextures.collectFiles(rp2, "mcpatcher/ctm/", ".properties");
        Arrays.sort(names);
        ArrayList tileList = new ArrayList();
        ArrayList blockList = new ArrayList();
        for (int i2 = 0; i2 < names.length; ++i2) {
            Object name = names[i2];
            Config.dbg("ConnectedTextures: " + (String)name);
            try {
                bjl locFile = new bjl((String)name);
                InputStream in2 = rp2.a(locFile);
                if (in2 == null) {
                    Config.warn("ConnectedTextures file not found: " + (String)name);
                    continue;
                }
                Properties props = new Properties();
                props.load(in2);
                ConnectedProperties cp2 = new ConnectedProperties(props, (String)name);
                if (!cp2.isValid((String)name)) continue;
                cp2.updateIcons(textureMap);
                ConnectedTextures.addToTileList(cp2, tileList);
                ConnectedTextures.addToBlockList(cp2, blockList);
                continue;
            }
            catch (FileNotFoundException e2) {
                Config.warn("ConnectedTextures file not found: " + (String)name);
                continue;
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        blockProperties = ConnectedTextures.propertyListToArray(blockList);
        tileProperties = ConnectedTextures.propertyListToArray(tileList);
        multipass = ConnectedTextures.detectMultipass();
        Config.dbg("Multipass connected textures: " + multipass);
    }

    private static boolean detectMultipass() {
        ConnectedProperties[] cps;
        int i2;
        ArrayList<ConnectedProperties> propList = new ArrayList<ConnectedProperties>();
        for (i2 = 0; i2 < tileProperties.length; ++i2) {
            cps = tileProperties[i2];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        for (i2 = 0; i2 < blockProperties.length; ++i2) {
            cps = blockProperties[i2];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        ConnectedProperties[] props = propList.toArray(new ConnectedProperties[propList.size()]);
        HashSet<mr> matchIconSet = new HashSet<mr>();
        HashSet<mr> tileIconSet = new HashSet<mr>();
        for (int i3 = 0; i3 < props.length; ++i3) {
            ConnectedProperties cp2 = props[i3];
            if (cp2.matchTileIcons != null) {
                matchIconSet.addAll(Arrays.asList(cp2.matchTileIcons));
            }
            if (cp2.tileIcons == null) continue;
            tileIconSet.addAll(Arrays.asList(cp2.tileIcons));
        }
        matchIconSet.retainAll(tileIconSet);
        return !matchIconSet.isEmpty();
    }

    private static ConnectedProperties[][] propertyListToArray(List list) {
        ConnectedProperties[][] propArr = new ConnectedProperties[list.size()][];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List subList = (List)list.get(i2);
            if (subList == null) continue;
            ConnectedProperties[] subArr = subList.toArray(new ConnectedProperties[subList.size()]);
            propArr[i2] = subArr;
        }
        return propArr;
    }

    private static void addToTileList(ConnectedProperties cp2, List tileList) {
        if (cp2.matchTileIcons == null) {
            return;
        }
        for (int i2 = 0; i2 < cp2.matchTileIcons.length; ++i2) {
            mr icon = cp2.matchTileIcons[i2];
            if (!(icon instanceof bii)) {
                Config.warn("Icon is not TextureAtlasSprite: " + icon + ", name: " + icon.g());
                continue;
            }
            bii ts2 = (bii)icon;
            int tileId = ts2.getIndexInMap();
            if (tileId < 0) {
                Config.warn("Invalid tile ID: " + tileId + ", icon: " + ts2.g());
                continue;
            }
            ConnectedTextures.addToList(cp2, tileList, tileId);
        }
    }

    private static void addToBlockList(ConnectedProperties cp2, List blockList) {
        if (cp2.matchBlocks == null) {
            return;
        }
        for (int i2 = 0; i2 < cp2.matchBlocks.length; ++i2) {
            int blockId = cp2.matchBlocks[i2];
            if (blockId < 0) {
                Config.warn("Invalid block ID: " + blockId);
                continue;
            }
            ConnectedTextures.addToList(cp2, blockList, blockId);
        }
    }

    private static void addToList(ConnectedProperties cp2, List list, int id2) {
        while (id2 >= list.size()) {
            list.add(null);
        }
        ArrayList<ConnectedProperties> subList = (ArrayList<ConnectedProperties>)list.get(id2);
        if (subList == null) {
            subList = new ArrayList<ConnectedProperties>();
            list.set(id2, subList);
        }
        subList.add(cp2);
    }

    private static String[] collectFiles(bjo rp2, String prefix, String suffix) {
        if (rp2 instanceof bjd) {
            return ConnectedTextures.collectFilesDefault(rp2);
        }
        if (!(rp2 instanceof bjc)) {
            return new String[0];
        }
        bjc arp2 = (bjc)rp2;
        File tpFile = arp2.b;
        if (tpFile == null) {
            return new String[0];
        }
        if (tpFile.isDirectory()) {
            return ConnectedTextures.collectFilesFolder(tpFile, "", prefix, suffix);
        }
        if (tpFile.isFile()) {
            return ConnectedTextures.collectFilesZIP(tpFile, prefix, suffix);
        }
        return new String[0];
    }

    private static String[] collectFilesDefault(bjo rp2) {
        ArrayList<String> list = new ArrayList<String>();
        String[] names = new String[]{"mcpatcher/ctm/default/bookshelf.properties", "mcpatcher/ctm/default/glass.properties", "mcpatcher/ctm/default/glasspane.properties", "mcpatcher/ctm/default/sandstone.properties"};
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            bjl loc = new bjl(name);
            if (!rp2.b(loc)) continue;
            list.add(name);
        }
        String[] nameArr = list.toArray(new String[list.size()]);
        return nameArr;
    }

    private static String[] collectFilesFolder(File tpFile, String basePath, String prefix, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        String prefixAssets = "assets/minecraft/";
        File[] files = tpFile.listFiles();
        if (files == null) {
            return new String[0];
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = files[i2];
            if (file.isFile()) {
                String name = basePath + file.getName();
                if (!name.startsWith(prefixAssets) || !(name = name.substring(prefixAssets.length())).startsWith(prefix) || !name.endsWith(suffix)) continue;
                list.add(name);
                continue;
            }
            if (!file.isDirectory()) continue;
            String dirPath = basePath + file.getName() + "/";
            String[] names = ConnectedTextures.collectFilesFolder(file, dirPath, prefix, suffix);
            for (int n2 = 0; n2 < names.length; ++n2) {
                String name = names[n2];
                list.add(name);
            }
        }
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }

    private static String[] collectFilesZIP(File tpFile, String prefix, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        String prefixAssets = "assets/minecraft/";
        try {
            ZipFile zf2 = new ZipFile(tpFile);
            Enumeration<? extends ZipEntry> en2 = zf2.entries();
            while (en2.hasMoreElements()) {
                ZipEntry ze = en2.nextElement();
                String name = ze.getName();
                if (!name.startsWith(prefixAssets) || !(name = name.substring(prefixAssets.length())).startsWith(prefix) || !name.endsWith(suffix)) continue;
                list.add(name);
            }
            zf2.close();
            String[] names = list.toArray(new String[list.size()]);
            return names;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return new String[0];
        }
    }

    public static int getPaneTextureIndex(boolean linkP, boolean linkN, boolean linkYp, boolean linkYn) {
        if (linkN && linkP) {
            if (linkYp) {
                if (linkYn) {
                    return 34;
                }
                return 50;
            }
            if (linkYn) {
                return 18;
            }
            return 2;
        }
        if (linkN && !linkP) {
            if (linkYp) {
                if (linkYn) {
                    return 35;
                }
                return 51;
            }
            if (linkYn) {
                return 19;
            }
            return 3;
        }
        if (!linkN && linkP) {
            if (linkYp) {
                if (linkYn) {
                    return 33;
                }
                return 49;
            }
            if (linkYn) {
                return 17;
            }
            return 1;
        }
        if (linkYp) {
            if (linkYn) {
                return 32;
            }
            return 48;
        }
        if (linkYn) {
            return 16;
        }
        return 0;
    }

    public static int getReversePaneTextureIndex(int texNum) {
        int col = texNum % 16;
        if (col == 1) {
            return texNum + 2;
        }
        if (col == 3) {
            return texNum - 2;
        }
        return texNum;
    }

    public static mr getCtmTexture(ConnectedProperties cp2, int ctmIndex, mr icon) {
        if (cp2.method != 1) {
            return icon;
        }
        if (ctmIndex < 0 || ctmIndex >= ctmIndexes.length) {
            return icon;
        }
        int index = ctmIndexes[ctmIndex];
        mr[] ctmIcons = cp2.tileIcons;
        if (index < 0 || index >= ctmIcons.length) {
            return icon;
        }
        return ctmIcons[index];
    }
}

