/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCNames;

public class SMCCTOpenGlHelper
implements IClassTransformer {
    public byte[] transform(String arg0, String arg1, byte[] arg2) {
        SMCLog.info("transforming %s %s", arg0, arg1);
        ClassReader cr = new ClassReader(arg2);
        ClassWriter cw = new ClassWriter(cr, 3);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVsetActiveTexture
    extends MethodVisitor {
        public MVsetActiveTexture(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitVarInsn(21, 0);
            this.mv.visitFieldInsn(179, "net/minecraft/client/renderer/OpenGlHelper", "activeTexUnit", "I");
            SMCLog.info("    set activeTexUnit", new Object[0]);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;
        boolean has_activeTexUnit = false;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (name.equals("activeTexUnit")) {
                this.has_activeTexUnit = true;
            }
            return this.cv.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String remappedName;
            if (!this.has_activeTexUnit) {
                this.has_activeTexUnit = true;
                FieldVisitor fv = this.cv.visitField(9, "activeTexUnit", "I", null, null);
                fv.visitEnd();
                SMCLog.info("    add field activeTexUnit", new Object[0]);
            }
            if ((remappedName = SMCNames.remapper.mapMethodName(this.classname, name, desc)).equals("func_77473_a")) {
                return new MVsetActiveTexture(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

