package net.minecraft.src;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class IFN_ItemFN5728 extends IFN_ItemFN5728Pre {
	
	/*
	 * [h̃V[PX
	 * 0x0000	:ˌ
	 * 0x1000	:[hJn
	 * 0x2000	:}KW[XA24bit̓[h̎ce
	 * 0x8000	:[h
	 */
	public static int IFNValFire		= 0x0000;
	public static int IFNValReloadTac	= 0x0010;
	public static int IFNValReloadStart	= 0x1000;
	public static int IFNValReleaseMag	= 0x2000;
	public static int IFNValReloadEnd	= 0x8000;



	public IFN_ItemFN5728(int i) {
		super(i);
		setMaxDamage(0);
		maxStackSize = 1;
	}

	@Override
	public boolean isFull3D() {
		return true;
	}

	@Override
	public ItemStack onEaten(ItemStack par1ItemStack, World par2World,
			EntityPlayer par3EntityPlayer) {
		// [h
		mod_IFN_FN5728Guns.Debug(String.format("onFoodEaten-remort:%b", par2World.isRemote));
		reloadMagazin(par1ItemStack, par2World, par3EntityPlayer);
		return par1ItemStack;
	}

	@Override
	public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
		// [h~
		mod_IFN_FN5728Guns.Debug(String.format("onPlayerStoppedUsing-remort:%b", world.isRemote));
		cancelReload(itemstack, IFNValReloadEnd);
	}

	@Override
	public ItemStack onItemRightClick(ItemStack itemstack, World world,	EntityPlayer entityplayer) {
		// gK[
		int li = getReload(itemstack);
		mod_IFN_FN5728Guns.Debug(String.format("onItemRightClick-remort:%b, val:%04x", world.isRemote, li));
		if (li <= IFNValFire) {
			if (canReload(itemstack, entityplayer)) {
				// m[}[h
				if (isEmpty(itemstack)) {
					mod_IFN_FN5728Guns.Debug(String.format("reloadNomal-remort:%b", world.isRemote));
					releaseMagazin(itemstack, world, entityplayer);
					MMM_Helper.updateCheckinghSlot(entityplayer, itemstack);
				}
			}
		}
		if (li == IFNValReloadTac) {
			if (canReload(itemstack, entityplayer)) {
				// ^NeBJ[h
				mod_IFN_FN5728Guns.Debug(String.format("reloadTac-remort:%b", world.isRemote));
				releaseMagazin(itemstack, world, entityplayer);
				MMM_Helper.updateCheckinghSlot(entityplayer, itemstack);
			}
		}
		entityplayer.setItemInUse(itemstack, getMaxItemUseDuration(itemstack));
		return itemstack;
	}

	@Override
	public void onUpdate(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
//		int li = getReload(itemstack);
//		if (li != 0 && entity instanceof EntityPlayer) {
//			EntityPlayer lep = (EntityPlayer)entity;
//			mod_IFN_FN5728Guns.Debug(String.format("onUpdate-remort:%b, val:%x, dam:%d, using:%b, dt:%d",
//					world.isRemote, li, itemstack.getItemDamage(), lep.getItemInUse() == itemstack, lep.getItemInUseDuration()));
//		}
		if (world.isRemote) {
			if (MMM_Helper.mc.thePlayer != entity) {
				// NCAg̕ێĂv[[ȊO͏KvȂ
				return;
			}
			if (isReload(itemstack)) {
				// [hłI
				return;
			}
			if (entity instanceof EntityPlayer) {
				EntityPlayer lep = (EntityPlayer)entity;
				if (lep.getCurrentEquippedItem() != itemstack) {
					// ɎĂȂΏI
					return;
				}
				if (lep.getItemInUse() == itemstack) {
					// gpłI
					return;
				}
				// }`p^NeBJ[h菈
				int li = getReload(itemstack);
				try {
					// NACAgpR[hȂ̂ForgeMPƃG[o
					// ƂŃ}`ModloaderׂEEEB
					if (MMM_Helper.mc.gameSettings.keyBindAttack.pressed) {
						if (li == IFNValFire) {
							mod_IFN_FN5728Guns.Debug("tacticalIFN");
							li = IFNValReloadTac;
							ModLoader.clientSendPacket(new Packet250CustomPayload("IFN", new byte[] {(byte)((li >>> 8) & 0xff), (byte)(li & 0xff)}));
						}
					} else {
						if (li == IFNValReloadTac) {
							mod_IFN_FN5728Guns.Debug("nomalIFN");
							li = IFNValFire;
							ModLoader.clientSendPacket(new Packet250CustomPayload("IFN", new byte[] {(byte)((li >>> 8) & 0xff), (byte)(li & 0xff)}));
						}
					}
				} catch (Error e) {
				} catch (Exception e) {
				}
			}
		}
	}

	@Override
	public int getMaxItemUseDuration(ItemStack itemstack) {
		// [h͎ԂύX
		int li = getReload(itemstack);
		if ((li >= IFNValReloadStart) && (li & 0xf000) < IFNValReloadEnd) {
			return reloadTime();
		} else {
			return super.getMaxItemUseDuration(itemstack);
		}
	}

	@Override
	public EnumAction getItemUseAction(ItemStack itemstack) {
		// [h͍\Ⴄ
		return isReload(itemstack) ? EnumAction.block : EnumAction.bow;
	}

	// Ǝ
	/**
	 * e̔ˁB
	 * eʃNXɂĂɈڂH
	 * @param f1:e萫B
	 * @param f2:
	 * @param f3:䗦
	 */
	protected void fireBullet(ItemStack itemstack, World world, EntityPlayer entityplayer, float f1, float f2, float f3) {
		// 
		ItemStack lis = getAmmo(itemstack, itemstack.getMaxDamage() - itemstack.getItemDamage());
		if (lis == null) {
			lis = new ItemStack(getBulletID(itemstack), 1, 0);
		}
		boolean lflag = true;
		if (lis.getItem() instanceof IFN_ItemSS190) {
			IFN_ItemSS190 lib = (IFN_ItemSS190)lis.getItem();
			lflag = lib.fireBullet(itemstack, world, entityplayer, lis.getItemDamage(), f1, f2, f3);
		}
		if (lflag) {
			clearAmmo(itemstack, itemstack.getMaxDamage() - itemstack.getItemDamage());
			itemstack.damageItem(1, entityplayer);
		}
	}

	protected void cancelReload(ItemStack itemstack, int force) {
		if (getReload(itemstack) >= force) {
			// [h̃LZ
			setReload(itemstack, IFNValFire);
		}
	}

	protected boolean canReload(ItemStack itemstack, EntityPlayer entityplayer) {
		// [h\ǂ̔iG`gΉj
		if (entityplayer.capabilities.isCreativeMode) return true;
		for (ItemStack is : entityplayer.inventory.mainInventory) {
			if (isConformityBullet(is)) return true;
		}
		return false;
	}

	protected boolean isEmpty(ItemStack itemstack) {
		// ce[H
		return itemstack.getItemDamage() >= getMaxDamage();
	}

	protected void releaseMagazin(ItemStack itemstack, World world, Entity entity) {
		// }KW[XƂ̓AceL^
		setReload(itemstack, (IFNValReleaseMag | (itemstack.getItemDamage() & 0x0fff)));
		itemstack.setItemDamage(getMaxDamage());
	}

	protected void reloadMagazin(ItemStack itemstack, World world, EntityPlayer entityplayer) {
		// }KWꂽƂ̓
//		if (!world.isRemote) 
		{
			// [h
			if (entityplayer == null || entityplayer.capabilities.isCreativeMode) {
				itemstack.setItemDamage(0);
			} else {
				// Cxge炷
				boolean linfinity = EnchantmentHelper.getEnchantmentLevel(Enchantment.infinity.effectId, itemstack) > 0;
				int lk = getReload(itemstack);
				lk = (lk > 0) ? lk & 0x0fff : 0;
				itemstack.setItemDamage(lk);
				for (int ll = 0; lk > 0 && ll < entityplayer.inventory.mainInventory.length; ll++) {
					ItemStack lis = entityplayer.inventory.mainInventory[ll];
					if (isConformityBullet(lis)) {
						for (;lk > 0 && lis.stackSize > 0;) {
							setAmmo(itemstack, lk--, lis);
							itemstack.setItemDamage(itemstack.getItemDamage() - 1);
							if (!linfinity) {
								// ӂtĂȂe炷B
								lis.stackSize--;
							}
							if (lis.stackSize <= 0) {
								entityplayer.inventory.mainInventory[ll] = null;
							}
						}
					}
				}
			}
		}
		mod_IFN_FN5728Guns.Debug(String.format("AmmoList."));
		for (int li = 0; li < itemstack.getMaxDamage(); li++) {
			ItemStack lis = getAmmo(itemstack, li);
			if (lis != null) {
				mod_IFN_FN5728Guns.Debug(String.format("Ammo:%03d=%s(%d, %d)", li, lis.getItemName(), lis.itemID, lis.getItemDamage()));
			}
		}
		setReload(itemstack, IFNValReloadEnd);
		clearBolt(itemstack);
		MMM_Helper.updateCheckinghSlot(entityplayer, itemstack);
	}

	// [hɂ鎞
	public abstract int reloadTime();

	public int getBulletID(ItemStack itemstack) {
		// e̎
		return mod_IFN_FN5728Guns.fn_SS190.itemID;
	}

	/**
	 * gpoe򂩂ǂ̔
	 */
	public boolean isConformityBullet(ItemStack pItemstack) {
		if (pItemstack != null && pItemstack.itemID == mod_IFN_FN5728Guns.fn_SS190.itemID) {
			return true;
		}
		return false;
	}

	// littleMaidMob͂̃\bhQƂēꓮs܂
	public boolean isWeaponReload(ItemStack itemstack, EntityPlayer entityplayer) {
		// [hsׂH
		cancelReload(itemstack, IFNValReloadEnd);
		return isEmpty(itemstack) && canReload(itemstack, entityplayer);
	}

	public boolean isWeaponFullAuto(ItemStack itemstack) {
		// tI[g킩H
		// iENbN_ŎˌJńj
		return false;
	}

	/**
	 * [hJE^ǂݎ
	 */
	public int getReload(ItemStack pItemstack) {
		checkTags(pItemstack);
		return pItemstack.getTagCompound().getInteger("Reload");
	}

	/**
	 * [hJE^̃Zbg
	 */
	public void setReload(ItemStack pItemstack, int pValue) {
		checkTags(pItemstack);
		NBTTagCompound lnbt = pItemstack.getTagCompound();
		lnbt.setInteger("Reload", pValue);
	}

	/**
	 * [hˁH
	 */
	public boolean isReload(ItemStack pItemstack) {
		return getReload(pItemstack) >= IFNValReloadStart;
	}

	// A˗p̃^C~OH
	/**
	 * A˃^C~O̐ݒB
	 * 1=50msA20=1000ms=1sB
	 */
	public byte getCycleCount(ItemStack pItemstack) {
		return (byte)1;
	}

	protected void resetBolt(ItemStack pItemstack) {
		checkTags(pItemstack);
		pItemstack.getTagCompound().setByte("Bolt", getCycleCount(pItemstack));
	}

	protected void clearBolt(ItemStack pItemstack) {
		checkTags(pItemstack);
		pItemstack.getTagCompound().setByte("Bolt", (byte)0);
	}

	/**
	 * ˃^C~O̊mF
	 */
	protected boolean cycleBolt(ItemStack pItemstack) {
		checkTags(pItemstack);
		NBTTagCompound lnbt = pItemstack.getTagCompound();
		byte lb = lnbt.getByte("Bolt");
		if (lb <= 0) {
//			if (pReset) resetBolt(pItemstack);
			return true;
		} else {
			lnbt.setByte("Bolt", --lb);
			return false;
		}
	}

	protected int getBolt(ItemStack pItemstack) {
		checkTags(pItemstack);
		NBTTagCompound lnbt = pItemstack.getTagCompound();
		return lnbt.getByte("Bolt");
	}

	/**
	 * }KWɒe߂
	 */
	public void setAmmo(ItemStack pGun, int pIndex, ItemStack pAmmo) {
		if (!pGun.getTagCompound().hasKey("Ammo")) {
			pGun.getTagCompound().setCompoundTag("Ammo", new NBTTagCompound());
		}
		NBTTagCompound lnbt = pGun.getTagCompound().getCompoundTag("Ammo");
		lnbt.setInteger(Integer.toString(pIndex) + "i", pAmmo.itemID);
		lnbt.setInteger(Integer.toString(pIndex) + "d", pAmmo.getItemDamage());
	}

	/**
	 * eĂeo
	 */
	public ItemStack getAmmo(ItemStack pGun, int pIndex) {
		NBTTagCompound lnbt = pGun.getTagCompound().getCompoundTag("Ammo");
		int lid = lnbt.getInteger(Integer.toString(pIndex) + "i");
		int ldam = lnbt.getInteger(Integer.toString(pIndex) + "d");
		return lid == 0 ? null : new ItemStack(lid, 1, ldam);
	}

	public void clearAmmo(ItemStack pGun, int pIndex) {
		NBTTagCompound lnbt = pGun.getTagCompound().getCompoundTag("Ammo");
		String ls = Integer.toString(pIndex);
		lnbt.removeTag(ls + "i");
		lnbt.removeTag(ls + "d");
	}

	public boolean checkTags(ItemStack pitemstack) {
		// NBTTag̏
		if (pitemstack.hasTagCompound()) {
			return true;
		}
		NBTTagCompound ltags = new NBTTagCompound();
		pitemstack.setTagCompound(ltags);
		ltags.setInteger("Reload", 0x0000);
		ltags.setByte("Bolt", (byte)0);
		NBTTagCompound lammo = new NBTTagCompound();
		for (int li = 0; li < getMaxDamage(); li++) {
			lammo.setLong(Integer.toString(li), 0L);
		}
		ltags.setCompoundTag("Ammo", lammo);
		return false;
	}

}
