/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.core.options;

import net.minecraftforge.common.Configuration;
import poersch.minecraft.core.options.Option;

public class OptionInterval
extends Option<Float> {
    public final float minValue;
    public final float maxValue;

    public OptionInterval(String id, String name, String description, String defaultValue) {
        super(id, name, description + " (0.0 - 1.0)", defaultValue);
        this.value = Float.valueOf(Option.getAllowedFloat(defaultValue, 0.0f, 1.0f));
        this.minValue = 0.0f;
        this.maxValue = 1.0f;
    }

    public OptionInterval(String id, String name, String description, String defaultValue, float minValue, float maxValue) {
        super(id, name, description + " (" + minValue + " - " + maxValue + ")", defaultValue);
        this.value = Float.valueOf(Option.getAllowedFloat(defaultValue, minValue, maxValue));
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public void read(Configuration config, String category) {
        this.value = Float.valueOf(Option.getAllowedFloat(this.getProperty(config, category), this.minValue, this.maxValue));
    }

    @Override
    public String getValueAsString() {
        return Float.toString(((Float)this.value).floatValue());
    }

    @Override
    public void setToNextValue() {
        float step = (this.maxValue - this.minValue) * 0.2f;
        this.value = ((Float)this.value).floatValue() + step > this.maxValue ? Float.valueOf(this.minValue) : Float.valueOf(((Float)this.value).floatValue() + step);
    }
}

