/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.core.options;

import net.minecraftforge.common.Configuration;
import poersch.minecraft.core.options.Option;

public class OptionBitList
extends Option<Boolean[]> {
    protected final boolean defaultBit;

    public OptionBitList(String id, String name, String description, String defaultValue, boolean defaultBit, int size) {
        super(id, name, description, defaultValue);
        this.value = new Boolean[size];
        for (int n = 0; n < ((Boolean[])this.value).length; ++n) {
            ((Boolean[])this.value)[n] = defaultBit;
        }
        this.defaultBit = defaultBit;
    }

    @Override
    public void read(Configuration config, String category) {
        boolean negativeBit = !this.defaultBit;
        String[] iDlist = this.getProperty(config, category).split(",");
        for (int n = 0; n < iDlist.length; ++n) {
            try {
                int bitID = Integer.parseInt(iDlist[n].trim());
                if (bitID < 0 || bitID >= ((Boolean[])this.value).length) continue;
                ((Boolean[])this.value)[bitID] = negativeBit;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    @Override
    public String getValueAsString() {
        return "";
    }

    @Override
    public void setToNextValue() {
    }
}

