/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.core.options;

import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public abstract class Option<T> {
    protected Property property;
    public final String id;
    public final String name;
    public final String description;
    public final String defaultValue;
    public T value;

    public Option(String id, String name, String description, String defaultValue) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
    }

    public abstract void read(Configuration var1, String var2);

    public void write() {
        if (this.property != null) {
            this.setProperty(this.getValueAsString());
        }
    }

    public abstract String getValueAsString();

    public abstract void setToNextValue();

    protected String getProperty(Configuration config, String category) {
        this.property = config.get(category, this.id, this.defaultValue, this.description);
        return this.property.getString();
    }

    protected void setProperty(String value) {
        this.property.set(value);
    }

    protected static int getAllowedInteger(String value, String[][] options) {
        value = value.trim();
        value = value.toLowerCase();
        for (int i = 0; i < options.length; ++i) {
            for (int n = 0; n < options[i].length; ++n) {
                if (!value.equals(options[i][n].toLowerCase())) continue;
                return i;
            }
        }
        return 0;
    }

    protected static float getAllowedFloat(String value, float min, float max) {
        return Math.max(min, Math.min(max, new Float(value).floatValue()));
    }
}

